/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.filesystem.ui.internal.wizards;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.DecoratingStyledCellLabelProvider;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.tcf.te.tcf.filesystem.ui.internal.wizards.NewNodeWizard;
import org.eclipse.tcf.te.tcf.filesystem.ui.internal.wizards.TargetPatternFilter;
import org.eclipse.tcf.te.tcf.filesystem.ui.nls.Messages;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.ILocatorModel;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.IPeerModel;
import org.eclipse.tcf.te.tcf.locator.interfaces.services.ILocatorModelPeerNodeQueryService;
import org.eclipse.tcf.te.tcf.locator.model.Model;
import org.eclipse.tcf.te.tcf.ui.navigator.ContentProviderDelegate;
import org.eclipse.tcf.te.tcf.ui.navigator.DelegatingLabelProvider;
import org.eclipse.tcf.te.ui.activator.UIPlugin;
import org.eclipse.tcf.te.ui.interfaces.IUIConstants;
import org.eclipse.tcf.te.ui.jface.interfaces.IValidatingContainer;
import org.eclipse.tcf.te.ui.wizards.pages.AbstractValidatingWizardPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;

public class TargetSelectionPage
extends AbstractValidatingWizardPage {
    private FilteredTree filteredTree;
    private PatternFilter filteredTreeFilter;
    private TreeViewer treeViewer;

    public TargetSelectionPage() {
        super(TargetSelectionPage.class.getSimpleName());
        this.setTitle(this.getDefaultTitle());
        this.setDescription(this.getDefaultDescription());
        this.initialize();
    }

    private void initialize() {
        ILocatorModel model = Model.getModel();
        Assert.isNotNull((Object)model);
        IPeerModel[] peers = model.getPeers();
        if (peers != null) {
            ILocatorModelPeerNodeQueryService service = (ILocatorModelPeerNodeQueryService)model.getService(ILocatorModelPeerNodeQueryService.class);
            IPeerModel[] iPeerModelArray = peers;
            int n = peers.length;
            int n2 = 0;
            while (n2 < n) {
                IPeerModel peer = iPeerModelArray[n2];
                service.queryRemoteServices(peer);
                ++n2;
            }
        }
    }

    public NewNodeWizard getWizard() {
        return (NewNodeWizard)super.getWizard();
    }

    protected String getDefaultTitle() {
        return Messages.TargetSelectionPage_Title;
    }

    protected String getDefaultDescription() {
        return Messages.TargetSelectionPage_Description;
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(1808));
        Label label = new Label(composite, 0);
        label.setLayoutData((Object)new GridData(768));
        label.setText(Messages.TargetSelectionPage_Targets);
        label.setLayoutData((Object)new GridData(768));
        this.filteredTreeFilter = new TargetPatternFilter();
        this.filteredTree = new FilteredTree(composite, 2820, this.filteredTreeFilter, true);
        this.filteredTree.setBackground(parent.getDisplay().getSystemColor(22));
        GridData layoutData = new GridData(1808);
        layoutData.heightHint = 250;
        layoutData.widthHint = 450;
        this.filteredTree.setLayoutData((Object)layoutData);
        this.treeViewer = this.filteredTree.getViewer();
        this.treeViewer.setContentProvider((IContentProvider)new ContentProviderDelegate());
        DecoratingStyledCellLabelProvider labelProvider = new DecoratingStyledCellLabelProvider((DelegatingStyledCellLabelProvider.IStyledLabelProvider)new TargetStyledLabelProvider(), (ILabelDecorator)new DelegatingLabelProvider(), null);
        this.treeViewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        this.treeViewer.setComparator((ViewerComparator)new TargetViewerComparator());
        ViewerFilter fsPeerFilter = new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (element instanceof IPeerModel) {
                    IPeerModel peer = (IPeerModel)element;
                    NewNodeWizard wizard = TargetSelectionPage.this.getWizard();
                    return wizard.hasFileSystem(peer);
                }
                return false;
            }
        };
        this.treeViewer.addFilter(fsPeerFilter);
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                TargetSelectionPage.this.onSelectionChanged();
            }
        });
        this.treeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                if (event.getSelection() instanceof IStructuredSelection) {
                    TreeViewer viewer;
                    IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                    Object element = selection.getFirstElement();
                    if (element instanceof IPeerModel) {
                        TargetSelectionPage.this.getWizard().getContainer().showPage(TargetSelectionPage.this.getNextPage());
                    } else if (event.getViewer() instanceof TreeViewer && (viewer = (TreeViewer)event.getViewer()).isExpandable(element)) {
                        viewer.setExpandedState(element, !viewer.getExpandedState(element));
                    }
                }
            }
        });
        this.treeViewer.setInput((Object)Model.getModel());
        NewNodeWizard wizard = this.getWizard();
        IPeerModel peer = wizard.getPeer();
        if (wizard.getPeer() != null) {
            this.treeViewer.setSelection((ISelection)new StructuredSelection((Object)peer), true);
        }
        Dialog.applyDialogFont((Control)composite);
        this.setControl((Control)composite);
        this.restoreWidgetValues();
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), IUIConstants.HELP_NEW_WIZARD_SELECTION_PAGE);
        this.setPageComplete(peer != null);
    }

    protected IValidatingContainer.ValidationResult doValidate() {
        IValidatingContainer.ValidationResult result = new IValidatingContainer.ValidationResult();
        boolean valid = true;
        ISelection selection = this.treeViewer.getSelection();
        if (selection.isEmpty()) {
            result.setResult(this.getDefaultDescription(), 3);
            result.setValid(valid);
        }
        return result;
    }

    protected void onSelectionChanged() {
        IWizardContainer container;
        if (this.filteredTree.getViewer().getSelection() instanceof IStructuredSelection) {
            IStructuredSelection filteredTreeSelection = (IStructuredSelection)this.filteredTree.getViewer().getSelection();
            NewNodeWizard wizard = this.getWizard();
            if (filteredTreeSelection.getFirstElement() instanceof IPeerModel) {
                wizard.setPeer((IPeerModel)filteredTreeSelection.getFirstElement());
            } else {
                wizard.setPeer(null);
            }
        }
        if ((container = this.getContainer()) != null && container.getCurrentPage() != null) {
            container.updateWindowTitle();
            container.updateTitleBar();
            container.updateButtons();
        }
        this.validate();
    }

    protected IDialogSettings getDialogSettings() {
        String sectionName;
        IDialogSettings settings = super.getDialogSettings();
        if (settings == null) {
            settings = UIPlugin.getDefault().getDialogSettings();
        }
        if (settings.getSection(sectionName = ((Object)((Object)this)).getClass().getName()) == null) {
            settings.addNewSection(sectionName);
        }
        settings = settings.getSection(sectionName);
        return settings;
    }

    static class TargetStyledLabelProvider
    extends DelegatingLabelProvider
    implements DelegatingStyledCellLabelProvider.IStyledLabelProvider {
        TargetStyledLabelProvider() {
        }

        public StyledString getStyledText(Object element) {
            return new StyledString(this.getText(element));
        }
    }

    static class TargetViewerComparator
    extends ViewerComparator {
        TargetViewerComparator() {
        }

        public boolean isSorterProperty(Object element, String property) {
            return property.equals("org.eclipse.jface.text");
        }
    }
}

