/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.locator;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.te.core.async.AsyncCallbackCollector;
import org.eclipse.tcf.te.runtime.callback.Callback;
import org.eclipse.tcf.te.runtime.interfaces.callback.ICallback;
import org.eclipse.tcf.te.tcf.core.async.CallbackInvocationDelegate;
import org.eclipse.tcf.te.tcf.locator.ScannerRunnable;
import org.eclipse.tcf.te.tcf.locator.activator.CoreBundleActivator;
import org.eclipse.tcf.te.tcf.locator.interfaces.IScanner;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.ILocatorModel;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.IPeerModel;
import org.eclipse.tcf.te.tcf.locator.model.Model;

public class Scanner
extends Job
implements IScanner {
    private final ILocatorModel parentModel;
    private final Map<String, Object> configuration = new HashMap<String, Object>();
    private AtomicBoolean terminated = new AtomicBoolean(false);

    public Scanner(ILocatorModel parentModel) {
        super(Scanner.class.getName());
        Assert.isNotNull((Object)parentModel);
        this.parentModel = parentModel;
        if (CoreBundleActivator.getTraceHandler().isSlotEnabled("trace/scanner")) {
            CoreBundleActivator.getTraceHandler().trace("Scanner created.", "trace/scanner", (Object)this);
        }
    }

    protected ILocatorModel getParentModel() {
        return this.parentModel;
    }

    @Override
    public void setConfiguration(Map<String, Object> configuration) {
        Assert.isNotNull(configuration);
        this.configuration.clear();
        this.configuration.putAll(configuration);
    }

    @Override
    public Map<String, Object> getConfiguration() {
        return this.configuration;
    }

    protected IStatus run(IProgressMonitor monitor) {
        IPeerModel[] peers;
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        if ((peers = this.getParentModel().getPeers()).length > 0) {
            try {
                Protocol.invokeLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        Scanner.this.setThread(Thread.currentThread());
                    }
                });
                final IProgressMonitor finMonitor = monitor;
                AsyncCallbackCollector collector = new AsyncCallbackCollector((ICallback)new Callback(){

                    protected void internalDone(Object caller, IStatus status) {
                        Long delay;
                        IStatus result;
                        IStatus iStatus = result = finMonitor.isCanceled() ? Status.CANCEL_STATUS : Status.OK_STATUS;
                        if (Scanner.this.getState() != 0) {
                            Scanner.this.done(result);
                        }
                        if (!Scanner.this.isTerminated() && (delay = (Long)Scanner.this.getConfiguration().get("schedule")) != null) {
                            Scanner.this.schedule(delay);
                        }
                    }
                }, (AsyncCallbackCollector.ICallbackInvocationDelegate)new CallbackInvocationDelegate());
                IPeerModel[] iPeerModelArray = peers;
                int n = peers.length;
                int n2 = 0;
                while (n2 < n) {
                    IPeerModel peer = iPeerModelArray[n2];
                    if (monitor.isCanceled() || this.isTerminated()) break;
                    this.doScan(peer, collector, monitor);
                    ++n2;
                }
                collector.initDone();
            }
            catch (IllegalStateException illegalStateException) {}
        }
        return peers.length > 0 ? ASYNC_FINISH : Status.OK_STATUS;
    }

    void doScan(final IPeerModel peer, final AsyncCallbackCollector collector, final IProgressMonitor monitor) {
        Assert.isNotNull((Object)peer);
        Assert.isNotNull((Object)collector);
        Assert.isNotNull((Object)monitor);
        if (monitor.isCanceled() || this.isTerminated()) {
            return;
        }
        if (CoreBundleActivator.getTraceHandler().isSlotEnabled("trace/scanner")) {
            CoreBundleActivator.getTraceHandler().trace("Schedule scanner runnable for peer '" + peer.getName() + "' (" + peer.getPeerId() + ")", "trace/scanner", (Object)this);
        }
        final AtomicBoolean isExcluded = new AtomicBoolean(false);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                isExcluded.set(peer.getBooleanProperty("scanner.exclude.silent"));
            }
        };
        if (Protocol.isDispatchThread()) {
            runnable.run();
        } else {
            Protocol.invokeAndWait((Runnable)runnable);
        }
        if (!isExcluded.get()) {
            Callback callback = new Callback(){

                protected void internalDone(Object caller, IStatus status) {
                    List<IPeerModel> candidates;
                    if (!monitor.isCanceled() && !Scanner.this.isTerminated() && (candidates = Model.getModel().getChildren(peer.getPeerId())) != null && candidates.size() > 0) {
                        for (IPeerModel candidate : candidates) {
                            Scanner.this.doScan(candidate, collector, monitor);
                        }
                    }
                    collector.removeCallback((ICallback)this);
                }
            };
            collector.addCallback((ICallback)callback);
            ScannerRunnable scannerRunnable = new ScannerRunnable(this, peer, (ICallback)callback);
            Protocol.invokeLater((Runnable)scannerRunnable);
        }
    }

    @Override
    public void terminate() {
        Assert.isTrue((boolean)Protocol.isDispatchThread(), (String)"Illegal Thread Access");
        if (this.terminated.get()) {
            return;
        }
        this.terminated.set(true);
        if (this.getState() != 0) {
            this.done(Status.CANCEL_STATUS);
        }
        if (CoreBundleActivator.getTraceHandler().isSlotEnabled("trace/scanner")) {
            CoreBundleActivator.getTraceHandler().trace("Scanner terminated.", "trace/scanner", (Object)this);
        }
    }

    @Override
    public final boolean isTerminated() {
        return this.terminated.get();
    }

    public boolean shouldRun() {
        return Platform.isRunning() && !this.getParentModel().isDisposed() && !this.isTerminated();
    }

    public boolean shouldSchedule() {
        return Platform.isRunning() && !this.getParentModel().isDisposed() && !this.isTerminated();
    }
}

