/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.locator.utils;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.te.runtime.callback.Callback;
import org.eclipse.tcf.te.runtime.interfaces.callback.ICallback;
import org.eclipse.tcf.te.runtime.services.ServiceManager;
import org.eclipse.tcf.te.runtime.services.interfaces.IService;
import org.eclipse.tcf.te.runtime.services.interfaces.ISimulatorService;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.IPeerModel;

public final class SimulatorUtils {
    public static Result getSimulatorService(final IPeerModel peerModel) {
        Assert.isNotNull((Object)peerModel);
        final AtomicBoolean isEnabled = new AtomicBoolean(false);
        final AtomicReference type = new AtomicReference();
        final AtomicReference properties = new AtomicReference();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                String value = (String)peerModel.getPeer().getAttributes().get("SimulatorEnabled");
                if (value != null) {
                    isEnabled.set(Boolean.parseBoolean(value));
                }
                type.set((String)peerModel.getPeer().getAttributes().get("SimulatorType"));
                properties.set((String)peerModel.getPeer().getAttributes().get("SimulatorProperties"));
            }
        };
        if (Protocol.isDispatchThread()) {
            runnable.run();
        } else {
            Protocol.invokeAndWait((Runnable)runnable);
        }
        Result result = null;
        if (isEnabled.get()) {
            IService[] services;
            IService[] iServiceArray = services = ServiceManager.getInstance().getServices((Object)peerModel, ISimulatorService.class, false);
            int n = services.length;
            int n2 = 0;
            while (n2 < n) {
                IService service = iServiceArray[n2];
                Assert.isTrue((boolean)(service instanceof ISimulatorService));
                String id = service.getId();
                if (id != null && id.equals(type.get())) {
                    result = new Result();
                    result.service = (ISimulatorService)service;
                    result.id = id;
                    result.settings = (String)properties.get();
                    break;
                }
                ++n2;
            }
        }
        return result;
    }

    public static void start(final IPeerModel peerModel, final IProgressMonitor monitor, final ICallback callback) {
        Assert.isNotNull((Object)peerModel);
        Assert.isNotNull((Object)callback);
        final Result result = SimulatorUtils.getSimulatorService(peerModel);
        if (result != null && result.service != null) {
            result.service.isRunning((Object)peerModel, result.settings, (ICallback)new Callback(){

                protected void internalDone(Object caller, IStatus status) {
                    Object cbResult = this.getResult();
                    if (cbResult instanceof Boolean && !((Boolean)cbResult).booleanValue()) {
                        result.service.start((Object)peerModel, result.settings, (ICallback)new Callback(){

                            protected void internalDone(Object caller, IStatus status) {
                                callback.setResult((Object)new Boolean(status.isOK()));
                                callback.done(caller, status);
                            }
                        }, monitor);
                    } else {
                        callback.setResult((Object)Boolean.FALSE);
                        callback.done((Object)this, Status.OK_STATUS);
                    }
                }
            });
        } else {
            callback.setResult((Object)Boolean.FALSE);
            callback.done(null, Status.OK_STATUS);
        }
    }

    public static void stop(final IPeerModel peerModel, final IProgressMonitor monitor, final ICallback callback) {
        Assert.isNotNull((Object)peerModel);
        Assert.isNotNull((Object)callback);
        final Result result = SimulatorUtils.getSimulatorService(peerModel);
        if (result != null && result.service != null) {
            result.service.isRunning((Object)peerModel, result.settings, (ICallback)new Callback(){

                protected void internalDone(Object caller, IStatus status) {
                    Object cbResult = this.getResult();
                    if (cbResult instanceof Boolean && ((Boolean)cbResult).booleanValue()) {
                        result.service.stop((Object)peerModel, result.settings, (ICallback)new Callback(callback){

                            protected void internalDone(Object caller, IStatus status) {
                                callback.done(caller, status);
                            }
                        }, monitor);
                    } else {
                        callback.done(null, Status.OK_STATUS);
                    }
                }
            });
        } else {
            callback.done(null, Status.OK_STATUS);
        }
    }

    public static class Result {
        public ISimulatorService service;
        public String id;
        public String settings;
    }
}

