/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.processes.core.model.runtime.services;

import org.eclipse.core.runtime.Assert;
import org.eclipse.tcf.protocol.IChannel;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.services.IProcesses;
import org.eclipse.tcf.services.IRunControl;
import org.eclipse.tcf.te.tcf.core.Tcf;
import org.eclipse.tcf.te.tcf.core.interfaces.IChannelManager;
import org.eclipse.tcf.te.tcf.core.model.interfaces.IModel;
import org.eclipse.tcf.te.tcf.core.model.interfaces.services.IModelChannelService;
import org.eclipse.tcf.te.tcf.core.model.services.AbstractModelService;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.IPeerModel;
import org.eclipse.tcf.te.tcf.processes.core.model.interfaces.runtime.IRuntimeModel;
import org.eclipse.tcf.te.tcf.processes.core.model.runtime.listener.RuntimeModelProcessServiceListener;
import org.eclipse.tcf.te.tcf.processes.core.model.runtime.listener.RuntimeModelRunControlServiceListener;

public class RuntimeModelChannelService
extends AbstractModelService<IRuntimeModel>
implements IModelChannelService {
    IChannel channel;
    IProcesses.ProcessesListener serviceListener;
    IRunControl.RunControlListener runControlListener;

    public RuntimeModelChannelService(IRuntimeModel model) {
        super((IModel)model);
    }

    public IChannel getChannel() {
        Assert.isTrue((boolean)Protocol.isDispatchThread(), (String)"Illegal Thread Access");
        return this.channel;
    }

    public void openChannel(final IModelChannelService.DoneOpenChannel done) {
        Assert.isTrue((boolean)Protocol.isDispatchThread(), (String)"Illegal Thread Access");
        if (this.channel != null && this.channel.getState() == 1) {
            done.doneOpenChannel(null, this.channel);
            return;
        }
        IPeerModel node = ((IRuntimeModel)this.getModel()).getPeerModel();
        if (node != null) {
            Tcf.getChannelManager().openChannel(node.getPeer(), null, new IChannelManager.DoneOpenChannel(){

                public void doneOpenChannel(Throwable error, IChannel channel) {
                    IProcesses service;
                    RuntimeModelChannelService.this.channel = channel;
                    if (error == null && RuntimeModelChannelService.this.serviceListener == null && (service = (IProcesses)channel.getRemoteService(IProcesses.class)) != null) {
                        RuntimeModelChannelService.this.serviceListener = new RuntimeModelProcessServiceListener((IRuntimeModel)RuntimeModelChannelService.this.getModel());
                        service.addListener(RuntimeModelChannelService.this.serviceListener);
                    }
                    if (error == null && RuntimeModelChannelService.this.runControlListener == null && (service = (IRunControl)channel.getRemoteService(IRunControl.class)) != null) {
                        RuntimeModelChannelService.this.runControlListener = new RuntimeModelRunControlServiceListener((IRuntimeModel)RuntimeModelChannelService.this.getModel());
                        service.addListener(RuntimeModelChannelService.this.runControlListener);
                    }
                    done.doneOpenChannel(error, channel);
                }
            });
        } else {
            done.doneOpenChannel((Throwable)new NullPointerException("Peer model node is null"), null);
        }
    }

    public void closeChannel() {
        Assert.isTrue((boolean)Protocol.isDispatchThread(), (String)"Illegal Thread Access");
        if (this.channel != null) {
            IProcesses service;
            if (this.serviceListener != null && (service = (IProcesses)this.channel.getRemoteService(IProcesses.class)) != null) {
                service.removeListener(this.serviceListener);
                this.serviceListener = null;
            }
            Tcf.getChannelManager().closeChannel(this.channel);
            this.channel = null;
        }
    }
}

