/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.processes.ui.handler;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.expressions.EvaluationContext;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.te.runtime.callback.Callback;
import org.eclipse.tcf.te.runtime.interfaces.callback.ICallback;
import org.eclipse.tcf.te.tcf.processes.core.model.interfaces.IProcessContextNode;
import org.eclipse.tcf.te.tcf.processes.core.model.steps.AttachStep;
import org.eclipse.tcf.te.tcf.processes.ui.activator.UIPlugin;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.handlers.IHandlerService;

public class AttachHandler
extends AbstractHandler {
    public Object execute(final ExecutionEvent event) throws ExecutionException {
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (selection instanceof IStructuredSelection && !selection.isEmpty()) {
            for (final Object candidate : (IStructuredSelection)selection) {
                if (!(candidate instanceof IProcessContextNode)) continue;
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        IProcessContextNode node = (IProcessContextNode)candidate;
                        AttachHandler.this.doAttach(event, node);
                    }
                };
                Protocol.invokeLater((Runnable)runnable);
            }
        }
        return null;
    }

    protected void doAttach(final ExecutionEvent event, IProcessContextNode node) {
        Assert.isTrue((boolean)Protocol.isDispatchThread(), (String)"Illegal Thread Access");
        Assert.isNotNull((Object)node);
        AttachStep step = new AttachStep();
        step.executeAttach(node, (ICallback)new Callback(){

            protected void internalDone(Object caller, IStatus status) {
                block4: {
                    Object launch;
                    if (status.getSeverity() == 0 && (launch = this.getProperty("launch")) != null) {
                        Command command;
                        ICommandService service = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
                        Command command2 = command = service != null ? service.getCommand("org.eclipse.tcf.te.launch.command.showInDebugView") : null;
                        if (command != null && command.isDefined() && command.isEnabled()) {
                            try {
                                IHandlerService handlerSvc = (IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class);
                                Assert.isNotNull((Object)handlerSvc);
                                ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
                                EvaluationContext ctx = new EvaluationContext(handlerSvc.getCurrentState(), (Object)selection);
                                ctx.addVariable("launch", launch);
                                ctx.addVariable("selection", (Object)selection);
                                ctx.addVariable("activeMenuSelection", (Object)selection);
                                ctx.setAllowPluginActivation(true);
                                ParameterizedCommand pCmd = ParameterizedCommand.generateCommand((Command)command, null);
                                Assert.isNotNull((Object)pCmd);
                                handlerSvc.executeCommandInContext(pCmd, null, (IEvaluationContext)ctx);
                            }
                            catch (Exception e) {
                                if (!Platform.inDebugMode()) break block4;
                                status = new Status(4, UIPlugin.getUniqueIdentifier(), e.getMessage(), (Throwable)e);
                                UIPlugin.getDefault().getLog().log(status);
                            }
                        }
                    }
                }
            }
        });
    }
}

