/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.processes.ui.internal.tabbed;

import org.eclipse.core.runtime.Assert;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.services.ISysMonitor;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.IPeerModelProvider;
import org.eclipse.tcf.te.tcf.processes.core.model.interfaces.IProcessContextNode;
import org.eclipse.tcf.te.tcf.processes.ui.nls.Messages;
import org.eclipse.tcf.te.tcf.ui.tabbed.BaseTitledSection;
import org.eclipse.tcf.te.ui.swt.SWTControlUtil;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class BasicContextSection
extends BaseTitledSection {
    ISysMonitor.SysMonitorContext context;
    private Text fileText;
    private Text workDirText;
    private Text rootText;
    private Text stateText;
    private Text userText;
    private Text groupText;

    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, aTabbedPropertySheetPage);
        this.fileText = this.createWrapTextField(null, Messages.BasicContextSection_File);
        this.workDirText = this.createWrapTextField((Control)this.fileText, Messages.BasicContextSection_WorkDir);
        this.rootText = this.createWrapTextField((Control)this.workDirText, Messages.BasicContextSection_Root);
        this.stateText = this.createTextField((Control)this.rootText, Messages.BasicContextSection_State);
        this.userText = this.createTextField((Control)this.stateText, Messages.BasicContextSection_User);
        this.groupText = this.createTextField((Control)this.userText, Messages.BasicContextSection_Group);
    }

    protected void updateInput(IPeerModelProvider input) {
        Assert.isTrue((boolean)(input instanceof IProcessContextNode));
        final IProcessContextNode node = (IProcessContextNode)input;
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                BasicContextSection.this.context = node.getSysMonitorContext();
            }
        };
        Assert.isTrue((!Protocol.isDispatchThread() ? 1 : 0) != 0);
        Protocol.invokeAndWait((Runnable)runnable);
    }

    public void refresh() {
        SWTControlUtil.setText((Control)this.fileText, (String)(this.context == null ? "" : (this.context.getFile() == null ? "" : this.context.getFile())));
        SWTControlUtil.setText((Control)this.workDirText, (String)(this.context == null ? "" : (this.context.getCurrentWorkingDirectory() == null ? "" : this.context.getCurrentWorkingDirectory())));
        SWTControlUtil.setText((Control)this.rootText, (String)(this.context == null ? "" : (this.context.getRoot() == null ? "" : this.context.getRoot())));
        SWTControlUtil.setText((Control)this.stateText, (String)(this.context == null ? "" : (this.context.getState() == null ? "" : this.context.getState())));
        SWTControlUtil.setText((Control)this.userText, (String)(this.context == null ? "" : (this.context.getUserName() == null ? "" : this.context.getUserName())));
        SWTControlUtil.setText((Control)this.groupText, (String)(this.context == null ? "" : (this.context.getGroupName() == null ? "" : this.context.getGroupName())));
        super.refresh();
    }

    protected String getText() {
        return Messages.BasicContextSection_Title;
    }
}

