/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.ui.handler;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.te.runtime.model.interfaces.IContainerModelNode;
import org.eclipse.tcf.te.runtime.persistence.interfaces.IURIPersistenceService;
import org.eclipse.tcf.te.runtime.services.ServiceManager;
import org.eclipse.tcf.te.runtime.statushandler.StatusHandlerUtil;
import org.eclipse.tcf.te.runtime.utils.StatusHelper;
import org.eclipse.tcf.te.tcf.core.peers.Peer;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.IPeerModel;
import org.eclipse.tcf.te.tcf.locator.interfaces.services.ILocatorModelRefreshService;
import org.eclipse.tcf.te.tcf.locator.interfaces.services.ILocatorModelUpdateService;
import org.eclipse.tcf.te.tcf.locator.model.Model;
import org.eclipse.tcf.te.tcf.locator.nodes.PeerRedirector;
import org.eclipse.tcf.te.tcf.ui.dialogs.RedirectAgentSelectionDialog;
import org.eclipse.tcf.te.tcf.ui.help.IContextHelpIds;
import org.eclipse.tcf.te.tcf.ui.nls.Messages;
import org.eclipse.tcf.te.ui.swt.DisplayUtil;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.navigator.CommonNavigator;

public class RedirectHandler
extends AbstractHandler {
    public Object execute(final ExecutionEvent event) throws ExecutionException {
        Object candidate;
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (selection instanceof IStructuredSelection && !selection.isEmpty() && (candidate = ((IStructuredSelection)selection).getFirstElement()) instanceof IPeerModel) {
            final IPeerModel peerModel = (IPeerModel)candidate;
            RedirectAgentSelectionDialog dialog = new RedirectAgentSelectionDialog(HandlerUtil.getActiveShell((ExecutionEvent)event), null){

                @Override
                protected void configureTableViewer(TableViewer viewer) {
                    Assert.isNotNull((Object)viewer);
                    ArrayList<ViewerFilter> filter = new ArrayList<ViewerFilter>();
                    if (viewer.getFilters() != null && viewer.getFilters().length > 0) {
                        filter.addAll(Arrays.asList(viewer.getFilters()));
                    }
                    filter.add(new ViewerFilter(){

                        public boolean select(Viewer viewer, Object parentElement, Object element) {
                            return !peerModel.equals(element);
                        }
                    });
                    viewer.setFilters(filter.toArray(new ViewerFilter[filter.size()]));
                }
            };
            if (dialog.open() == 0 && (selection = dialog.getSelection()) instanceof IStructuredSelection && !selection.isEmpty() && (candidate = ((IStructuredSelection)selection).getFirstElement()) instanceof IPeerModel) {
                final IPeerModel proxy = (IPeerModel)candidate;
                Protocol.invokeLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        RedirectHandler.this.redirect(peerModel, proxy);
                        DisplayUtil.safeAsyncExec((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                IWorkbenchPart part = HandlerUtil.getActivePart((ExecutionEvent)event);
                                if (part instanceof CommonNavigator) {
                                    CommonNavigator navigator = (CommonNavigator)part;
                                    navigator.selectReveal((ISelection)new StructuredSelection((Object)peerModel));
                                }
                            }
                        });
                    }
                });
            }
        }
        return null;
    }

    public void redirect(IPeerModel peerModel, IPeerModel proxy) {
        Assert.isNotNull((Object)peerModel);
        Assert.isNotNull((Object)proxy);
        Assert.isTrue((boolean)Protocol.isDispatchThread(), (String)"Illegal Thread Access");
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.putAll(peerModel.getPeer().getAttributes());
        attributes.put("redirect.proxy", proxy.getPeerId());
        try {
            IURIPersistenceService uRIPersistenceService = (IURIPersistenceService)ServiceManager.getInstance().getService(IURIPersistenceService.class);
            if (uRIPersistenceService == null) {
                throw new IOException("Persistence service instance unavailable.");
            }
            uRIPersistenceService.write((Object)new Peer(attributes), null);
            PeerRedirector redirector = new PeerRedirector(proxy.getPeer(), attributes);
            peerModel.setProperty("instance", (Object)redirector);
            peerModel.setParent((IContainerModelNode)proxy);
            ((ILocatorModelUpdateService)Model.getModel().getService(ILocatorModelUpdateService.class)).addChild(peerModel);
            Protocol.invokeLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    ((ILocatorModelRefreshService)Model.getModel().getService(ILocatorModelRefreshService.class)).refresh(null);
                }
            });
        }
        catch (IOException e) {
            String template = NLS.bind((String)Messages.RedirectHandler_error_redirectFailed, (Object)Messages.PossibleCause);
            StatusHandlerUtil.handleStatus((IStatus)StatusHelper.getStatus((Throwable)e), (Object)peerModel, (String)template, (String)Messages.RedirectHandler_error_title, (String)IContextHelpIds.MESSAGE_REDIRECT_FAILED, (Object)((Object)this), null);
        }
    }
}

