/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.ui.navigator;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ITreePathContentProvider;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.tcf.protocol.IPeer;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.te.runtime.concurrent.util.ExecutorsUtil;
import org.eclipse.tcf.te.tcf.locator.ScannerRunnable;
import org.eclipse.tcf.te.tcf.locator.interfaces.IModelListener;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.ILocatorModel;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.IPeerModel;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.IPeerRedirector;
import org.eclipse.tcf.te.tcf.locator.interfaces.services.ILocatorModelLookupService;
import org.eclipse.tcf.te.tcf.locator.interfaces.services.ILocatorModelRefreshService;
import org.eclipse.tcf.te.tcf.locator.model.Model;
import org.eclipse.tcf.te.tcf.ui.activator.UIPlugin;
import org.eclipse.tcf.te.tcf.ui.navigator.ModelListener;
import org.eclipse.tcf.te.tcf.ui.navigator.TreeViewerListener;
import org.eclipse.tcf.te.tcf.ui.navigator.nodes.PeerRedirectorGroupNode;
import org.eclipse.tcf.te.ui.swt.DisplayUtil;
import org.eclipse.tcf.te.ui.views.Managers;
import org.eclipse.tcf.te.ui.views.extensions.CategoriesExtensionPointManager;
import org.eclipse.tcf.te.ui.views.interfaces.ICategory;
import org.eclipse.tcf.te.ui.views.interfaces.IRoot;
import org.eclipse.tcf.te.ui.views.interfaces.categories.ICategorizable;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.internal.navigator.NavigatorFilterService;
import org.eclipse.ui.navigator.CommonViewer;
import org.eclipse.ui.navigator.ICommonContentExtensionSite;
import org.eclipse.ui.navigator.ICommonContentProvider;
import org.eclipse.ui.navigator.ICommonFilterDescriptor;
import org.eclipse.ui.navigator.INavigatorContentService;
import org.eclipse.ui.navigator.INavigatorFilterService;

public class ContentProviderDelegate
implements ICommonContentProvider,
ITreePathContentProvider {
    private static final Object[] NO_ELEMENTS = new Object[0];
    private static final String REDIRECT_PEERS_FILTER_ID = "org.eclipse.tcf.te.tcf.ui.navigator.RedirectPeersFilter";
    private static final String CURRENT_USER_FILTER_ID = "org.eclipse.tcf.te.tcf.ui.navigator.PeersByCurrentUserFilter";
    IModelListener modelListener = null;
    TreeViewerListener treeViewerListener = null;
    private final Map<String, PeerRedirectorGroupNode> roots = new HashMap<String, PeerRedirectorGroupNode>();
    private final boolean showInvisible;
    INavigatorFilterService navFilterService = null;

    public ContentProviderDelegate() {
        this(false);
    }

    public ContentProviderDelegate(boolean showInvisible) {
        this.showInvisible = showInvisible;
    }

    final boolean isValueAdd(IPeerModel peerModel) {
        Assert.isNotNull((Object)peerModel);
        String value = (String)peerModel.getPeer().getAttributes().get("ValueAdd");
        boolean isValueAdd = value != null && ("1".equals(value.trim()) || Boolean.parseBoolean(value.trim()));
        return isValueAdd;
    }

    final boolean isFiltered(IPeerModel peerModel) {
        Assert.isNotNull((Object)peerModel);
        boolean filtered = false;
        filtered |= this.isValueAdd(peerModel) && UIPlugin.getDefault().getPreferenceStore().getBoolean("te.tcf.ui.model.valueadds.hide");
        if (!this.showInvisible) {
            filtered |= !peerModel.isVisible();
        }
        return filtered;
    }

    public Object[] getChildren(Object parentElement) {
        List candidates;
        Object[] children = NO_ELEMENTS;
        ICategory category = parentElement instanceof ICategory ? (ICategory)parentElement : null;
        String catID = category != null ? category.getId() : null;
        boolean allHidden = false;
        ICategory myTargetsCat = CategoriesExtensionPointManager.getInstance().getCategory("org.eclipse.tcf.te.ui.views.category.mytargets", false);
        ICategory neighborhoodCat = CategoriesExtensionPointManager.getInstance().getCategory("org.eclipse.tcf.te.ui.views.category.neighborhood", false);
        boolean bl = allHidden = neighborhoodCat != null && !neighborhoodCat.isEnabled() && myTargetsCat != null && !myTargetsCat.isEnabled();
        if (parentElement instanceof ICategory) {
            parentElement = Model.getModel();
        }
        if (parentElement instanceof IRoot && allHidden) {
            parentElement = Model.getModel();
        }
        if (parentElement instanceof ILocatorModel) {
            ILocatorModel model = (ILocatorModel)parentElement;
            IPeerModel[] peers = model.getPeers();
            ArrayList<IPeerModel> candidates2 = new ArrayList<IPeerModel>();
            if ("org.eclipse.tcf.te.ui.views.category.favorites".equals(catID)) {
                IPeerModel[] iPeerModelArray = peers;
                int n = peers.length;
                int n2 = 0;
                while (n2 < n) {
                    IPeerModel peer = iPeerModelArray[n2];
                    ICategorizable categorizable = (ICategorizable)peer.getAdapter(ICategorizable.class);
                    if (categorizable == null) {
                        categorizable = (ICategorizable)Platform.getAdapterManager().getAdapter((Object)peer, ICategorizable.class);
                    }
                    Assert.isNotNull((Object)categorizable);
                    boolean isFavorite = Managers.getCategoryManager().belongsTo(catID, categorizable.getId());
                    if (isFavorite && !candidates2.contains(peer)) {
                        candidates2.add(peer);
                    }
                    ++n2;
                }
            } else if ("org.eclipse.tcf.te.ui.views.category.mytargets".equals(catID)) {
                IPeerModel[] iPeerModelArray = peers;
                int n = peers.length;
                int n3 = 0;
                while (n3 < n) {
                    IPeerModel peer = iPeerModelArray[n3];
                    if (!this.isFiltered(peer)) {
                        boolean isMyTargets;
                        ICategorizable categorizable = (ICategorizable)peer.getAdapter(ICategorizable.class);
                        if (categorizable == null) {
                            categorizable = (ICategorizable)Platform.getAdapterManager().getAdapter((Object)peer, ICategorizable.class);
                        }
                        Assert.isNotNull((Object)categorizable);
                        boolean isStatic = peer.isStatic();
                        boolean startedByCurrentUser = System.getProperty("user.name").equals(peer.getPeer().getUserName());
                        if (!startedByCurrentUser && neighborhoodCat != null && !neighborhoodCat.isEnabled()) {
                            startedByCurrentUser = true;
                        }
                        if (!(isMyTargets = Managers.getCategoryManager().belongsTo(catID, categorizable.getId())) && (isStatic || startedByCurrentUser)) {
                            Managers.getCategoryManager().addTransient(catID, categorizable.getId());
                            isMyTargets = true;
                        }
                        if (isMyTargets && !candidates2.contains(peer)) {
                            candidates2.add(peer);
                        }
                    }
                    ++n3;
                }
            } else if ("org.eclipse.tcf.te.ui.views.category.neighborhood".equals(catID)) {
                IPeerModel[] iPeerModelArray = peers;
                int n = peers.length;
                int n4 = 0;
                while (n4 < n) {
                    IPeerModel peer = iPeerModelArray[n4];
                    if (!this.isFiltered(peer)) {
                        boolean isNeighborhood;
                        ICategorizable categorizable = (ICategorizable)peer.getAdapter(ICategorizable.class);
                        if (categorizable == null) {
                            categorizable = (ICategorizable)Platform.getAdapterManager().getAdapter((Object)peer, ICategorizable.class);
                        }
                        Assert.isNotNull((Object)categorizable);
                        boolean isStatic = peer.isStatic();
                        boolean startedByCurrentUser = System.getProperty("user.name").equals(peer.getPeer().getUserName());
                        if (startedByCurrentUser && myTargetsCat != null && !myTargetsCat.isEnabled()) {
                            startedByCurrentUser = false;
                        }
                        if (!((isNeighborhood = Managers.getCategoryManager().belongsTo(catID, categorizable.getId())) || isStatic || startedByCurrentUser)) {
                            Managers.getCategoryManager().addTransient(catID, categorizable.getId());
                            isNeighborhood = true;
                        }
                        if (isNeighborhood && !candidates2.contains(peer)) {
                            candidates2.add(peer);
                        }
                    }
                    ++n4;
                }
            } else if (catID != null) {
                IPeerModel[] iPeerModelArray = peers;
                int n = peers.length;
                int n5 = 0;
                while (n5 < n) {
                    IPeerModel peer = iPeerModelArray[n5];
                    ICategorizable categorizable = (ICategorizable)peer.getAdapter(ICategorizable.class);
                    if (categorizable == null) {
                        categorizable = (ICategorizable)Platform.getAdapterManager().getAdapter((Object)peer, ICategorizable.class);
                    }
                    Assert.isNotNull((Object)categorizable);
                    boolean belongsTo = category.belongsTo((Object)peer);
                    if (belongsTo && !candidates2.contains(peer)) {
                        Managers.getCategoryManager().addTransient(catID, categorizable.getId());
                        candidates2.add(peer);
                    }
                    ++n5;
                }
            } else {
                IPeerModel[] iPeerModelArray = peers;
                int n = peers.length;
                int n6 = 0;
                while (n6 < n) {
                    IPeerModel peer = iPeerModelArray[n6];
                    if (!this.isFiltered(peer) && !candidates2.contains(peer)) {
                        candidates2.add(peer);
                    }
                    ++n6;
                }
            }
            children = candidates2.toArray(new IPeerModel[candidates2.size()]);
        } else if (parentElement instanceof IPeerModel) {
            String parentPeerId = ((IPeerModel)parentElement).getPeerId();
            List candidates3 = Model.getModel().getChildren(parentPeerId);
            if (candidates3 != null && candidates3.size() > 0) {
                PeerRedirectorGroupNode rootNode = this.roots.get(parentPeerId);
                if (rootNode == null) {
                    rootNode = new PeerRedirectorGroupNode(parentPeerId);
                    this.roots.put(parentPeerId, rootNode);
                }
                children = new Object[]{rootNode};
            } else {
                this.roots.remove(parentPeerId);
            }
        } else if (parentElement instanceof PeerRedirectorGroupNode && (candidates = Model.getModel().getChildren(((PeerRedirectorGroupNode)parentElement).peerId)) != null && candidates.size() > 0) {
            for (final IPeerModel candidate : candidates) {
                Protocol.invokeLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        candidate.setProperty("scanner.exclude.silent", false);
                        ScannerRunnable runnable = new ScannerRunnable(null, candidate);
                        runnable.run();
                    }
                });
            }
            children = candidates.toArray();
        }
        return children;
    }

    public Object[] getChildren(TreePath parentPath) {
        return parentPath != null ? this.getChildren(parentPath.getLastSegment()) : NO_ELEMENTS;
    }

    public Object getParent(final Object element) {
        if (element instanceof IPeerModel) {
            if (((IPeerModel)element).getPeer() instanceof IPeerRedirector) {
                IPeer parentPeer = ((IPeerRedirector)((IPeerModel)element).getPeer()).getParent();
                String parentPeerId = parentPeer.getID();
                if (!this.roots.containsKey(parentPeerId)) {
                    this.roots.put(parentPeer.getID(), new PeerRedirectorGroupNode(parentPeerId));
                }
                return this.roots.get(parentPeerId);
            }
            ILocatorModel category = null;
            String[] categoryIds = Managers.getCategoryManager().getCategoryIds(((IPeerModel)element).getPeerId());
            if (categoryIds != null && categoryIds.length > 0) {
                category = CategoriesExtensionPointManager.getInstance().getCategory(categoryIds[0], false);
            }
            return category != null ? category : ((IPeerModel)element).getModel();
        }
        if (element instanceof PeerRedirectorGroupNode) {
            final AtomicReference parent = new AtomicReference();
            final Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    parent.set(((ILocatorModelLookupService)Model.getModel().getService(ILocatorModelLookupService.class)).lkupPeerModelById(((PeerRedirectorGroupNode)element).peerId));
                }
            };
            Assert.isTrue((!Protocol.isDispatchThread() ? 1 : 0) != 0);
            ExecutorsUtil.executeWait((Runnable)new Runnable(){

                @Override
                public void run() {
                    Protocol.invokeAndWait((Runnable)runnable);
                }
            });
            return parent.get();
        }
        return null;
    }

    public TreePath[] getParents(Object element) {
        ArrayList<TreePath> pathes = new ArrayList<TreePath>();
        if (element instanceof IPeerModel) {
            Object parent;
            ICategory favCategory;
            if (Managers.getCategoryManager().belongsTo("org.eclipse.tcf.te.ui.views.category.favorites", ((IPeerModel)element).getPeerId()) && (favCategory = CategoriesExtensionPointManager.getInstance().getCategory("org.eclipse.tcf.te.ui.views.category.favorites", false)) != null) {
                pathes.add(new TreePath(new Object[]{favCategory}));
            }
            if ((parent = this.getParent(element)) != null) {
                pathes.add(new TreePath(new Object[]{parent}));
            }
        }
        return pathes.toArray(new TreePath[pathes.size()]);
    }

    public boolean hasChildren(Object element) {
        Object[] children = this.getChildren(element);
        if (children != null && children.length > 0 && this.navFilterService != null) {
            ViewerFilter[] viewerFilterArray = this.navFilterService.getVisibleFilters(true);
            int n = viewerFilterArray.length;
            int n2 = 0;
            while (n2 < n) {
                ViewerFilter filter = viewerFilterArray[n2];
                children = filter.filter(null, element, children);
                ++n2;
            }
        }
        return children != null && children.length > 0;
    }

    public boolean hasChildren(TreePath path) {
        return path != null ? this.hasChildren(path.getLastSegment()) : false;
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public void dispose() {
        if (this.modelListener != null) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    Model.getModel().removeListener(ContentProviderDelegate.this.modelListener);
                }
            };
            if (Protocol.isDispatchThread()) {
                runnable.run();
            } else {
                Protocol.invokeAndWait((Runnable)runnable);
            }
            this.modelListener = null;
        }
        if (this.treeViewerListener != null) {
            this.treeViewerListener.dispose();
            this.treeViewerListener = null;
        }
        this.roots.clear();
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        final ILocatorModel model = Model.getModel();
        if (this.modelListener == null && model != null && viewer instanceof CommonViewer) {
            this.modelListener = new ModelListener(model, (CommonViewer)viewer);
            Protocol.invokeLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    model.addListener(ContentProviderDelegate.this.modelListener);
                }
            });
        }
        if (this.treeViewerListener == null && viewer instanceof CommonViewer) {
            CommonViewer v = (CommonViewer)viewer;
            this.treeViewerListener = new TreeViewerListener(v);
            v.addTreeListener((ITreeViewerListener)this.treeViewerListener);
        }
        if (model != null && newInput instanceof IRoot) {
            Protocol.invokeLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    ((ILocatorModelRefreshService)model.getService(ILocatorModelRefreshService.class)).refresh(null);
                }
            });
        }
    }

    public void init(ICommonContentExtensionSite config) {
        Assert.isNotNull((Object)config);
        INavigatorContentService cs = config.getService();
        INavigatorFilterService iNavigatorFilterService = this.navFilterService = cs != null ? cs.getFilterService() : null;
        if (this.navFilterService instanceof NavigatorFilterService) {
            ICommonFilterDescriptor[] descriptors;
            final NavigatorFilterService filterService = (NavigatorFilterService)this.navFilterService;
            boolean activeFiltersChanged = false;
            ArrayList<String> activeFilderIds = new ArrayList<String>();
            ICommonFilterDescriptor[] iCommonFilterDescriptorArray = descriptors = filterService.getVisibleFilterDescriptors();
            int n = descriptors.length;
            int n2 = 0;
            while (n2 < n) {
                ICommonFilterDescriptor descriptor = iCommonFilterDescriptorArray[n2];
                if (descriptor.getId() != null && !"".equals(descriptor.getId()) && filterService.isActive(descriptor.getId())) {
                    activeFilderIds.add(descriptor.getId());
                }
                ++n2;
            }
            if (!activeFilderIds.contains(REDIRECT_PEERS_FILTER_ID)) {
                activeFilderIds.add(REDIRECT_PEERS_FILTER_ID);
                activeFiltersChanged = true;
            }
            if (UIPlugin.getDefault().getPreferenceStore().getBoolean("te.tcf.ui.model.currentUserFilter.activate") && !this.navFilterService.isActive(CURRENT_USER_FILTER_ID)) {
                IDialogSettings settings = UIPlugin.getDefault().getDialogSettings();
                IDialogSettings section = settings.getSection(this.getClass().getSimpleName());
                if (section == null) {
                    section = settings.addNewSection(this.getClass().getSimpleName());
                }
                if (!section.getBoolean("te.tcf.ui.model.currentUserFilter.activate.done")) {
                    activeFilderIds.add(CURRENT_USER_FILTER_ID);
                    activeFiltersChanged = true;
                    section.put("te.tcf.ui.model.currentUserFilter.activate.done", true);
                }
            }
            if (activeFiltersChanged) {
                final String[] finActiveFilterIds = activeFilderIds.toArray(new String[activeFilderIds.size()]);
                DisplayUtil.safeAsyncExec((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        filterService.activateFilterIdsAndUpdateViewer(finActiveFilterIds);
                    }
                });
            }
        }
    }

    public void restoreState(IMemento aMemento) {
    }

    public void saveState(IMemento aMemento) {
    }
}

