/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.ui.wizards.pages;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogPage;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.IMessageProvider;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.te.runtime.interfaces.properties.IPropertiesContainer;
import org.eclipse.tcf.te.runtime.properties.PropertiesContainer;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.IPeerModel;
import org.eclipse.tcf.te.tcf.locator.model.Model;
import org.eclipse.tcf.te.tcf.ui.controls.CustomTransportPanel;
import org.eclipse.tcf.te.tcf.ui.controls.PeerAttributesTablePart;
import org.eclipse.tcf.te.tcf.ui.controls.PeerNameControl;
import org.eclipse.tcf.te.tcf.ui.controls.PipeTransportPanel;
import org.eclipse.tcf.te.tcf.ui.controls.TcpTransportPanel;
import org.eclipse.tcf.te.tcf.ui.controls.TransportTypeControl;
import org.eclipse.tcf.te.tcf.ui.controls.TransportTypePanelControl;
import org.eclipse.tcf.te.tcf.ui.help.IContextHelpIds;
import org.eclipse.tcf.te.tcf.ui.nls.Messages;
import org.eclipse.tcf.te.ui.controls.BaseDialogPageControl;
import org.eclipse.tcf.te.ui.controls.interfaces.IWizardConfigurationPanel;
import org.eclipse.tcf.te.ui.forms.FormLayoutFactory;
import org.eclipse.tcf.te.ui.interfaces.data.IDataExchangeNode;
import org.eclipse.tcf.te.ui.jface.interfaces.IValidatingContainer;
import org.eclipse.tcf.te.ui.swt.SWTControlUtil;
import org.eclipse.tcf.te.ui.wizards.pages.AbstractValidatingWizardPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class NewTargetWizardPage
extends AbstractValidatingWizardPage
implements IDataExchangeNode {
    private PeerNameControl peerNameControl;
    TransportTypeControl transportTypeControl;
    TransportTypePanelControl transportTypePanelControl;
    private PeerAttributesTablePart tablePart;
    private FormToolkit toolkit = null;
    private final UUID uuid = UUID.randomUUID();
    final List<String> usedNames = new ArrayList<String>();

    public NewTargetWizardPage() {
        this(NewTargetWizardPage.class.getName());
    }

    public NewTargetWizardPage(String pageName) {
        super(pageName);
    }

    public void dispose() {
        if (this.peerNameControl != null) {
            this.peerNameControl.dispose();
            this.peerNameControl = null;
        }
        if (this.transportTypeControl != null) {
            this.transportTypeControl.dispose();
            this.transportTypeControl = null;
        }
        if (this.transportTypePanelControl != null) {
            this.transportTypePanelControl.dispose();
            this.transportTypePanelControl = null;
        }
        if (this.tablePart != null) {
            this.tablePart.dispose();
            this.tablePart = null;
        }
        if (this.toolkit != null) {
            this.toolkit.dispose();
            this.toolkit = null;
        }
        super.dispose();
    }

    public void createControl(Composite parent) {
        this.setTitle(Messages.NewTargetWizardPage_title);
        this.setDescription(Messages.NewTargetWizardPage_description);
        this.toolkit = new FormToolkit(parent.getDisplay());
        Composite mainPanel = this.toolkit.createComposite(parent);
        mainPanel.setLayout((Layout)FormLayoutFactory.createClearGridLayout((boolean)false, (int)1));
        mainPanel.setLayoutData((Object)new GridData(4, 4, true, true));
        mainPanel.setBackground(parent.getBackground());
        this.setControl((Control)mainPanel);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)mainPanel, IContextHelpIds.NEW_TARGET_WIZARD_PAGE);
        boolean changed = this.setValidationInProgress(true);
        this.createMainPanelControls(mainPanel, this.toolkit);
        if (changed) {
            this.setValidationInProgress(false);
        }
        Dialog.applyDialogFont((Control)mainPanel);
        this.validate();
    }

    protected void createMainPanelControls(Composite parent, FormToolkit toolkit) {
        Assert.isNotNull((Object)parent);
        Assert.isNotNull((Object)toolkit);
        Composite client = toolkit.createComposite(parent);
        client.setLayout((Layout)FormLayoutFactory.createSectionClientGridLayout((boolean)false, (int)2));
        client.setLayoutData((Object)new GridData(4, 4, true, true));
        client.setBackground(parent.getBackground());
        this.peerNameControl = new PeerNameControl((IDialogPage)this){

            public boolean isValid() {
                boolean valid = true;
                String name = this.getEditFieldControlTextForValidation();
                if (!"".equals(name) && this.getParentPage() instanceof NewTargetWizardPage) {
                    boolean bl = valid = !((NewTargetWizardPage)this.getParentPage()).usedNames.contains(name.trim().toUpperCase());
                    if (!valid) {
                        this.setMessage(Messages.NewTargetWizardPage_error_nameInUse, 3);
                    }
                }
                if (!valid && this.getControlDecoration() != null && this.isEnabled()) {
                    this.updateControlDecoration(this.getMessage(), this.getMessageType());
                }
                return valid ? super.isValid() : false;
            }
        };
        this.peerNameControl.setFormToolkit(toolkit);
        this.peerNameControl.setParentControlIsInnerPanel(true);
        this.peerNameControl.setupPanel(client);
        this.peerNameControl.getEditFieldControl().setFocus();
        this.createEmptySpace(client, 5, 2, toolkit);
        Section transportTypeSection = toolkit.createSection(client, 256);
        transportTypeSection.setText(Messages.NewTargetWizardPage_section_transportType);
        transportTypeSection.setLayout((Layout)FormLayoutFactory.createSectionClientGridLayout((boolean)false, (int)2));
        GridData layoutData = new GridData(4, 0x1000000, true, false);
        layoutData.horizontalSpan = 2;
        transportTypeSection.setLayoutData((Object)layoutData);
        transportTypeSection.setBackground(client.getBackground());
        Composite transportTypeClient = toolkit.createComposite((Composite)transportTypeSection);
        transportTypeClient.setLayout((Layout)new GridLayout());
        transportTypeClient.setBackground(transportTypeSection.getBackground());
        transportTypeSection.setClient((Control)transportTypeClient);
        this.transportTypeControl = new MyTransportTypeControl((IDialogPage)this);
        this.transportTypeControl.setFormToolkit(toolkit);
        this.transportTypeControl.setupPanel(transportTypeClient);
        this.transportTypePanelControl = new MyTransportTypePanelControl((IDialogPage)this);
        TcpTransportPanel tcpTransportPanel = new TcpTransportPanel((BaseDialogPageControl)this.transportTypePanelControl);
        this.transportTypePanelControl.addConfigurationPanel("TCP", (IWizardConfigurationPanel)tcpTransportPanel);
        this.transportTypePanelControl.addConfigurationPanel("SSL", (IWizardConfigurationPanel)tcpTransportPanel);
        this.transportTypePanelControl.addConfigurationPanel("PIPE", (IWizardConfigurationPanel)new PipeTransportPanel((BaseDialogPageControl)this.transportTypePanelControl));
        this.transportTypePanelControl.addConfigurationPanel("Custom", (IWizardConfigurationPanel)new CustomTransportPanel((BaseDialogPageControl)this.transportTypePanelControl));
        this.transportTypePanelControl.setupPanel(transportTypeClient, this.transportTypeControl.getTransportTypes(), toolkit);
        layoutData = new GridData(4, 4, true, true);
        layoutData.horizontalSpan = 2;
        this.transportTypePanelControl.getPanel().setLayoutData((Object)layoutData);
        toolkit.adapt(this.transportTypePanelControl.getPanel());
        this.transportTypePanelControl.showConfigurationPanel(this.transportTypeControl.getSelectedTransportType());
        this.createPeerAttributesTableControl(client, toolkit);
        this.restoreWidgetValues();
        this.initializeUsedNameList();
    }

    protected void createPeerAttributesTableControl(Composite parent, FormToolkit toolkit) {
        Assert.isNotNull((Object)parent);
        this.createEmptySpace(parent, 5, 2, toolkit);
        Section attributesSection = toolkit.createSection(parent, 256);
        attributesSection.setText(Messages.NewTargetWizardPage_section_attributes);
        attributesSection.setLayout((Layout)FormLayoutFactory.createSectionClientGridLayout((boolean)false, (int)2));
        GridData layoutData = new GridData(4, 0x1000000, true, false);
        layoutData.horizontalSpan = 2;
        attributesSection.setLayoutData((Object)layoutData);
        attributesSection.setBackground(parent.getBackground());
        Composite client = toolkit.createComposite((Composite)attributesSection);
        client.setLayout((Layout)new GridLayout(2, false));
        client.setBackground(attributesSection.getBackground());
        attributesSection.setClient((Control)client);
        this.tablePart = new PeerAttributesTablePart();
        this.tablePart.setMinSize(SWTControlUtil.convertWidthInCharsToPixels((Control)client, (int)20), SWTControlUtil.convertHeightInCharsToPixels((Control)client, (int)6));
        this.tablePart.setBannedNames(new String[]{"ID", "AgentID", "ServiceManagerID", "Name", "TransportName", "Host", "Port", "PipeName"});
        this.tablePart.createControl(client, 65540, 2, toolkit);
    }

    protected IValidatingContainer.ValidationResult doValidate() {
        IValidatingContainer.ValidationResult result = new IValidatingContainer.ValidationResult();
        boolean valid = true;
        if (this.peerNameControl != null) {
            valid &= this.peerNameControl.isValid();
            result.setResult((IMessageProvider)this.peerNameControl);
        }
        if (this.transportTypeControl != null) {
            valid &= this.transportTypeControl.isValid();
            result.setResult((IMessageProvider)this.transportTypeControl);
        }
        if (this.transportTypePanelControl != null) {
            valid &= this.transportTypePanelControl.isValid();
            result.setResult((IMessageProvider)this.transportTypePanelControl);
        }
        result.setValid(valid);
        return result;
    }

    public void setupData(IPropertiesContainer data) {
    }

    protected void updatePeerAttributes(IPropertiesContainer peerAttributes) {
        Map<String, String> additionalAttributes;
        IWizardConfigurationPanel panel;
        String value;
        Assert.isNotNull((Object)peerAttributes);
        if (this.getControl() == null) {
            return;
        }
        peerAttributes.setProperty("ID", (Object)this.uuid.toString());
        String string = value = this.peerNameControl != null ? this.peerNameControl.getEditFieldControlText() : null;
        if (value != null && !"".equals(value)) {
            peerAttributes.setProperty("Name", (Object)value);
        }
        String string2 = value = this.transportTypeControl != null ? this.transportTypeControl.getSelectedTransportType() : null;
        if (value != null && !"".equals(value) && !"Custom".equals(value)) {
            peerAttributes.setProperty("TransportName", (Object)value);
        }
        IWizardConfigurationPanel iWizardConfigurationPanel = panel = this.transportTypePanelControl != null ? this.transportTypePanelControl.getConfigurationPanel(value) : null;
        if (panel instanceof IDataExchangeNode) {
            PropertiesContainer data = new PropertiesContainer();
            ((IDataExchangeNode)panel).extractData((IPropertiesContainer)data);
            for (String key : data.getProperties().keySet()) {
                value = data.getStringProperty(key);
                if (value == null || "".equals(value)) continue;
                peerAttributes.setProperty(key, (Object)value);
            }
        }
        Map<String, String> map = additionalAttributes = this.tablePart != null ? this.tablePart.getAttributes() : null;
        if (additionalAttributes != null && !additionalAttributes.isEmpty()) {
            peerAttributes.addProperties(additionalAttributes);
        }
    }

    public void extractData(IPropertiesContainer data) {
        Assert.isNotNull((Object)data);
        this.updatePeerAttributes(data);
    }

    public void saveWidgetValues() {
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            if (this.peerNameControl != null) {
                this.peerNameControl.saveWidgetValues(settings, null);
            }
            if (this.transportTypeControl != null) {
                this.transportTypeControl.saveWidgetValues(settings, null);
            }
            if (this.transportTypePanelControl != null) {
                this.transportTypePanelControl.saveWidgetValues(settings, null);
            }
        }
    }

    public void restoreWidgetValues() {
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            if (this.peerNameControl != null) {
                this.peerNameControl.restoreWidgetValues(settings, null);
            }
            if (this.transportTypeControl != null) {
                this.transportTypeControl.restoreWidgetValues(settings, null);
            }
            if (this.transportTypePanelControl != null) {
                this.transportTypePanelControl.restoreWidgetValues(settings, null);
            }
        }
    }

    protected void initializeUsedNameList() {
        this.usedNames.clear();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                IPeerModel[] peers;
                IPeerModel[] iPeerModelArray = peers = Model.getModel().getPeers();
                int n = peers.length;
                int n2 = 0;
                while (n2 < n) {
                    IPeerModel peerModel = iPeerModelArray[n2];
                    if (peerModel.isStatic()) {
                        String name = peerModel.getPeer().getName();
                        Assert.isNotNull((Object)name);
                        if (!"".equals(name) && !NewTargetWizardPage.this.usedNames.contains(name)) {
                            NewTargetWizardPage.this.usedNames.add(name.trim().toUpperCase());
                        }
                    }
                    ++n2;
                }
            }
        };
        Assert.isTrue((!Protocol.isDispatchThread() ? 1 : 0) != 0);
        Protocol.invokeAndWait((Runnable)runnable);
    }

    private class MyTransportTypeControl
    extends TransportTypeControl {
        public MyTransportTypeControl(IDialogPage parentPage) {
            super(parentPage);
        }

        public void widgetSelected(SelectionEvent e) {
            if (NewTargetWizardPage.this.transportTypePanelControl != null) {
                NewTargetWizardPage.this.transportTypePanelControl.showConfigurationPanel(this.getSelectedTransportType());
                NewTargetWizardPage.this.validate();
            }
        }
    }

    private class MyTransportTypePanelControl
    extends TransportTypePanelControl {
        public MyTransportTypePanelControl(IDialogPage parentPage) {
            super(parentPage);
        }

        public boolean isValid() {
            IWizardConfigurationPanel panel;
            String transportType;
            boolean valid = super.isValid();
            if (!valid) {
                return false;
            }
            if (NewTargetWizardPage.this.transportTypeControl != null && (transportType = NewTargetWizardPage.this.transportTypeControl.getSelectedTransportType()) != null && (panel = this.getConfigurationPanel(transportType)) != null) {
                valid = panel.isValid();
                this.setMessage(panel.getMessage(), panel.getMessageType());
            }
            return valid;
        }
    }
}

