/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.core;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceRuleFactory;
import org.eclipse.core.resources.team.FileModificationValidator;
import org.eclipse.core.resources.team.IMoveDeleteHook;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.history.IFileHistoryProvider;
import org.eclipse.team.svn.core.IConnectedProjectInformation;
import org.eclipse.team.svn.core.SVNMessages;
import org.eclipse.team.svn.core.SVNTeamMoveDeleteHook;
import org.eclipse.team.svn.core.SVNTeamPlugin;
import org.eclipse.team.svn.core.connector.ISVNConnector;
import org.eclipse.team.svn.core.connector.SVNChangeStatus;
import org.eclipse.team.svn.core.connector.SVNConnectorException;
import org.eclipse.team.svn.core.connector.SVNEntryInfo;
import org.eclipse.team.svn.core.connector.SVNEntryRevisionReference;
import org.eclipse.team.svn.core.connector.SVNRevision;
import org.eclipse.team.svn.core.extension.CoreExtensionsManager;
import org.eclipse.team.svn.core.extension.crashrecovery.ErrorDescription;
import org.eclipse.team.svn.core.history.SVNFileHistoryProvider;
import org.eclipse.team.svn.core.operation.AbstractActionOperation;
import org.eclipse.team.svn.core.operation.CompositeOperation;
import org.eclipse.team.svn.core.operation.HiddenException;
import org.eclipse.team.svn.core.operation.SVNNullProgressMonitor;
import org.eclipse.team.svn.core.operation.SVNResourceRuleFactory;
import org.eclipse.team.svn.core.operation.UnreportableException;
import org.eclipse.team.svn.core.operation.local.management.DisconnectOperation;
import org.eclipse.team.svn.core.resource.IRepositoryLocation;
import org.eclipse.team.svn.core.resource.IRepositoryResource;
import org.eclipse.team.svn.core.resource.events.ResourceStatesChangedEvent;
import org.eclipse.team.svn.core.svnstorage.SVNRemoteStorage;
import org.eclipse.team.svn.core.utility.FileUtility;
import org.eclipse.team.svn.core.utility.ProgressMonitorUtility;
import org.eclipse.team.svn.core.utility.SVNUtility;

public class SVNTeamProvider
extends RepositoryProvider
implements IConnectedProjectInformation {
    public static final QualifiedName RESOURCE_PROPERTY = new QualifiedName("org.eclipse.team.svn", "resource");
    public static final QualifiedName LOCATION_PROPERTY = new QualifiedName("org.eclipse.team.svn", "location");
    public static final QualifiedName VERIFY_TAG_ON_COMMIT_PROPERTY = new QualifiedName("org.eclipse.team.svn", "verifyTagOnCommit");
    public static final boolean DEFAULT_VERIFY_TAG_ON_COMMIT = true;
    protected IRepositoryLocation location;
    protected IRepositoryResource resource;
    protected String relocatedTo;
    protected String locationId;
    protected int errorCode;
    protected int state = 0;

    public synchronized IRepositoryLocation getRepositoryLocation() throws HiddenException {
        if (this.state != 1) {
            this.restoreLocation();
        }
        return this.location;
    }

    public synchronized IRepositoryResource getRepositoryResource() throws HiddenException {
        if (this.state != 1) {
            this.connectToProject();
        }
        return this.resource;
    }

    public synchronized void switchResource(IRepositoryResource resource) throws CoreException {
        this.resource = SVNUtility.copyOf(resource);
        this.location = resource.getRepositoryLocation();
        SVNTeamProvider.setRepositoryLocation(this.getProject(), this.location);
    }

    public synchronized void relocateResource() throws CoreException {
        if (this.state != 1) {
            this.restoreLocation();
        }
        SVNTeamProvider.setRepositoryLocation(this.getProject(), this.location);
    }

    public static void map(IProject project, IRepositoryResource resource) throws CoreException {
        SVNTeamProvider.setRepositoryLocation(project, resource.getRepositoryLocation());
        RepositoryProvider.map((IProject)project, (String)"org.eclipse.team.svn.core.svnnature");
    }

    public String getID() {
        return "org.eclipse.team.svn.core.svnnature";
    }

    public void configureProject() {
        this.connectToProject();
        SVNRemoteStorage.instance().fireResourceStatesChangedEvent(new ResourceStatesChangedEvent(new IResource[]{this.getProject()}, 0, 0));
    }

    public void deconfigure() throws CoreException {
    }

    public IMoveDeleteHook getMoveDeleteHook() {
        return new SVNTeamMoveDeleteHook();
    }

    public FileModificationValidator getFileModificationValidator2() {
        return SVNTeamPlugin.instance().getOptionProvider().getFileModificationValidator();
    }

    public boolean canHandleLinkedResources() {
        return this.canHandleLinkedResourceURI();
    }

    public boolean canHandleLinkedResourceURI() {
        return true;
    }

    public IResourceRuleFactory getRuleFactory() {
        return SVNResourceRuleFactory.INSTANCE;
    }

    public IFileHistoryProvider getFileHistoryProvider() {
        return new SVNFileHistoryProvider();
    }

    protected void deconfigured() {
        IProject project = this.getProject();
        if (project != null) {
            try {
                project.setPersistentProperty(LOCATION_PROPERTY, null);
            }
            catch (Exception exception) {}
            try {
                project.setPersistentProperty(RESOURCE_PROPERTY, null);
            }
            catch (Exception exception) {}
        }
        SVNRemoteStorage.instance().fireResourceStatesChangedEvent(new ResourceStatesChangedEvent(new IResource[]{this.getProject()}, 0, 0));
        super.deconfigured();
    }

    protected static void setRepositoryLocation(IProject project, IRepositoryLocation location) throws CoreException {
        project.setPersistentProperty(LOCATION_PROPERTY, SVNRemoteStorage.instance().repositoryLocationAsReference(location, IRepositoryLocation.LocationReferenceTypeEnum.ONLY_REQUIRED_DATA));
    }

    protected void restoreLocation() throws HiddenException {
        if (this.state == 0) {
            this.location = null;
            this.locationId = null;
            this.errorCode = this.uploadRepositoryLocation();
            if (this.errorCode == ErrorDescription.SUCCESS || (this.errorCode = this.acquireResolution(false)) == ErrorDescription.SUCCESS) {
                return;
            }
            this.performDisconnect();
        }
        this.breakThreadExecution();
    }

    protected synchronized void connectToProject() throws HiddenException {
        if (this.state == 0) {
            this.location = null;
            this.locationId = null;
            this.resource = null;
            this.relocatedTo = null;
            this.errorCode = this.uploadRepositoryResource();
            if (this.errorCode == ErrorDescription.SUCCESS || (this.errorCode = this.acquireResolution(true)) == ErrorDescription.SUCCESS) {
                this.state = 1;
                return;
            }
            this.performDisconnect();
        }
        this.breakThreadExecution();
    }

    protected int acquireResolution(boolean full) {
        block1: {
            block2: {
                int newError;
                while (true) {
                    Object[] context = null;
                    context = this.errorCode == ErrorDescription.REPOSITORY_LOCATION_IS_DISCARDED ? new Object[]{this.getProject(), this.location} : (this.errorCode == ErrorDescription.PROJECT_IS_RELOCATED_OUTSIDE_PLUGIN ? new Object[]{this.getProject(), this.relocatedTo, this.location} : (this.errorCode == ErrorDescription.CANNOT_READ_LOCATION_DATA ? new Object[]{this.getProject(), this.relocatedTo, this.locationId} : this.getProject()));
                    if (!SVNTeamPlugin.instance().getErrorHandlingFacility().acquireResolution(new ErrorDescription(this.errorCode, context))) break block1;
                    int n = newError = full ? this.uploadRepositoryResource() : this.uploadRepositoryLocation();
                    if (newError == ErrorDescription.SUCCESS) break block2;
                    if (newError == this.errorCode) break;
                    this.errorCode = newError;
                }
                return newError;
            }
            return ErrorDescription.SUCCESS;
        }
        return this.errorCode;
    }

    protected void performDisconnect() {
        this.state = -1;
        CompositeOperation op = new CompositeOperation("Operation_OpenProject", SVNMessages.class);
        op.add(new DisconnectOperation(new IProject[]{this.getProject()}, false));
        op.add(new AbstractActionOperation(op.getId(), op.getMessagesClass()){

            protected void runImpl(IProgressMonitor monitor) throws Exception {
                throw new UnreportableException(SVNTeamProvider.this.getAutoDisconnectMessage());
            }
        });
        ProgressMonitorUtility.doTaskScheduled(op);
    }

    protected void breakThreadExecution() {
        throw new HiddenException(this.getAutoDisconnectMessage());
    }

    protected String getAutoDisconnectMessage() {
        return SVNMessages.formatErrorString("Error_AutoDisconnect", new String[]{this.getProject().getName()});
    }

    public static boolean requiresUpgrade(IProject project) {
        IPath location = FileUtility.getResourcePath((IResource)project);
        location = location.append(SVNUtility.getSVNFolderName());
        if (SVNUtility.isPriorToSVN17()) {
            return false;
        }
        if (location.toFile().exists() && !location.append("pristine").toFile().exists()) {
            return true;
        }
        IRepositoryLocation rLocation = SVNRemoteStorage.instance().getRepositoryLocation((IResource)project);
        ISVNConnector proxy = rLocation.acquireSVNProxy();
        try {
            try {
                SVNUtility.properties(proxy, new SVNEntryRevisionReference(FileUtility.getWorkingCopyPath((IResource)project), null, SVNRevision.WORKING), new SVNNullProgressMonitor());
            }
            catch (SVNConnectorException e) {
                boolean bl = e.getErrorId() == 155036;
                rLocation.releaseSVNProxy(proxy);
                return bl;
            }
        }
        finally {
            rLocation.releaseSVNProxy(proxy);
        }
        return false;
    }

    protected int uploadRepositoryResource() {
        int errorCode = this.uploadRepositoryLocation();
        IProject project = this.getProject();
        IPath location = FileUtility.getResourcePath((IResource)project);
        if (SVNUtility.isPriorToSVN17() && !location.append(SVNUtility.getSVNFolderName()).toFile().exists()) {
            return ErrorDescription.CANNOT_READ_PROJECT_METAINFORMATION;
        }
        ISVNConnector proxy = CoreExtensionsManager.instance().getSVNConnectorFactory().newInstance();
        try {
            SVNChangeStatus[] sts = SVNUtility.status(proxy, location.toString(), 2, 128L, new SVNNullProgressMonitor());
            if (sts != null && sts.length > 0) {
                this.relocatedTo = this.getProjectURL(location.toString(), sts);
                if (this.relocatedTo == null) {
                    SVNEntryInfo[] info = SVNUtility.info(proxy, new SVNEntryRevisionReference(location.toString()), 0, new SVNNullProgressMonitor());
                    if (info == null || info.length == 0 || info[0].url == null) {
                        int n = ErrorDescription.CANNOT_READ_PROJECT_METAINFORMATION;
                        return n;
                    }
                    this.relocatedTo = SVNUtility.decodeURL(info[0].url);
                }
                if (this.location != null) {
                    this.resource = this.location.asRepositoryContainer(this.relocatedTo, true);
                    if (this.resource == null) {
                        int n = ErrorDescription.PROJECT_IS_RELOCATED_OUTSIDE_PLUGIN;
                        return n;
                    }
                }
            }
        }
        catch (SVNConnectorException ex) {
            if (ex.getErrorId() == 155037) {
                int n = ErrorDescription.WORKING_COPY_REQUIRES_CLEANUP;
                return n;
            }
            if (ex.getErrorId() == 155036) {
                int n = ErrorDescription.WORKING_COPY_REQUIRES_UPGRADE;
                return n;
            }
            int n = ErrorDescription.CANNOT_READ_PROJECT_METAINFORMATION;
            return n;
        }
        finally {
            proxy.dispose();
        }
        return errorCode;
    }

    protected String getProjectURL(String projectPath, SVNChangeStatus[] sts) {
        SVNUtility.reorder(sts, true);
        SVNChangeStatus[] sVNChangeStatusArray = sts;
        int n = sts.length;
        int n2 = 0;
        while (n2 < n) {
            SVNChangeStatus st = sVNChangeStatusArray[n2];
            if (!(st.url == null || st.isFileExternal || st.isSwitched || st.isCopied)) {
                String url = SVNUtility.decodeURL(st.url);
                url = url.substring(0, url.length() - (st.path.length() - projectPath.length()));
                return url;
            }
            ++n2;
        }
        return null;
    }

    protected int uploadRepositoryLocation() {
        try {
            IProject project = this.getProject();
            String data = project.getPersistentProperty(LOCATION_PROPERTY);
            if (data != null) {
                this.location = SVNRemoteStorage.instance().newRepositoryLocation(data);
                this.locationId = this.location.getId();
                if (SVNRemoteStorage.instance().getRepositoryLocation(this.location.getId()) == null) {
                    return ErrorDescription.REPOSITORY_LOCATION_IS_DISCARDED;
                }
            } else {
                data = project.getPersistentProperty(RESOURCE_PROPERTY);
                if (data != null) {
                    this.locationId = SVNTeamProvider.extractLocationId(data);
                    if (this.locationId != null) {
                        this.location = SVNRemoteStorage.instance().getRepositoryLocation(this.locationId);
                        if (this.location != null) {
                            SVNTeamProvider.setRepositoryLocation(project, this.location);
                        }
                    }
                }
            }
            return this.location == null ? ErrorDescription.CANNOT_READ_LOCATION_DATA : ErrorDescription.SUCCESS;
        }
        catch (CoreException coreException) {
            return ErrorDescription.CANNOT_READ_LOCATION_DATA;
        }
    }

    protected static String extractLocationId(String resourceData) {
        String[] data;
        if (resourceData != null && (data = resourceData.split(";")).length >= 2) {
            return data[1];
        }
        return null;
    }

    public boolean isVerifyTagOnCommit() {
        String strProp;
        block3: {
            try {
                strProp = this.getProject().getPersistentProperty(VERIFY_TAG_ON_COMMIT_PROPERTY);
                if (strProp != null) break block3;
                return true;
            }
            catch (CoreException coreException) {
                return true;
            }
        }
        return Boolean.valueOf(strProp);
    }

    public void setVerifyTagOnCommit(boolean isVerifyTagOnCommit) throws CoreException {
        this.getProject().setPersistentProperty(VERIFY_TAG_ON_COMMIT_PROPERTY, String.valueOf(isVerifyTagOnCommit));
    }
}

