/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.core.operation.local;

import java.io.File;
import java.io.FileFilter;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.svn.core.SVNMessages;
import org.eclipse.team.svn.core.SVNTeamPlugin;
import org.eclipse.team.svn.core.operation.IUnprotectedOperation;
import org.eclipse.team.svn.core.operation.local.AbstractWorkingCopyOperation;
import org.eclipse.team.svn.core.resource.IResourceProvider;
import org.eclipse.team.svn.core.utility.FileUtility;
import org.eclipse.team.svn.core.utility.PatternProvider;
import org.eclipse.team.svn.core.utility.SVNUtility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SaveProjectMetaOperation
extends AbstractWorkingCopyOperation
implements IResourceProvider {
    protected static final String[] META_FILES = new String[]{".project", ".classpath"};
    protected HashMap<String, File> savedMetas = new HashMap();
    protected String startsWith;

    public SaveProjectMetaOperation(IResource[] resources) {
        this(resources, null);
    }

    public SaveProjectMetaOperation(IResource[] resources, String startsWith) {
        super("Operation_SaveMeta", SVNMessages.class, resources);
        this.startsWith = startsWith;
    }

    public SaveProjectMetaOperation(IResourceProvider provider) {
        this(provider, null);
    }

    public SaveProjectMetaOperation(IResourceProvider provider, String startsWith) {
        super("Operation_SaveMeta", SVNMessages.class, provider);
        this.startsWith = startsWith;
    }

    @Override
    public IResource[] getResources() {
        return this.operableData();
    }

    public Map<String, File> getSavedMetas() {
        return this.savedMetas;
    }

    @Override
    public int getOperationWeight() {
        return 0;
    }

    @Override
    protected void runImpl(IProgressMonitor monitor) throws Exception {
        IResource[] changeSet = this.operableData();
        int i = 0;
        while (i < changeSet.length && !monitor.isCanceled()) {
            final IResource change = changeSet[i];
            this.protectStep(new IUnprotectedOperation(){

                public void run(IProgressMonitor monitor) throws Exception {
                    IProject project = change.getProject();
                    IResource[] members = project.members();
                    int i = 0;
                    while (i < members.length && !monitor.isCanceled()) {
                        if (SaveProjectMetaOperation.this.shouldBeSaved(members[i])) {
                            try {
                                SaveProjectMetaOperation.this.saveMeta(members[i], monitor);
                            }
                            catch (Exception exception) {}
                        }
                        ++i;
                    }
                }
            }, monitor, changeSet.length);
            ++i;
        }
    }

    protected boolean shouldBeSaved(IResource resource) {
        String name = resource.getName();
        if (name.equals(SVNUtility.getSVNFolderName())) {
            return false;
        }
        if (this.startsWith != null) {
            return name.startsWith(this.startsWith);
        }
        int i = 0;
        while (i < META_FILES.length) {
            if (name.equalsIgnoreCase(META_FILES[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected void saveMeta(IResource resource, IProgressMonitor monitor) throws Exception {
        String sourceLocation;
        File source;
        if (resource != null && (source = new File(sourceLocation = PatternProvider.replaceAll(FileUtility.getWorkingCopyPath(resource), "\\\\", "/"))).exists()) {
            File target = SVNTeamPlugin.instance().getTemporaryFile(null, resource.getName());
            target.deleteOnExit();
            if (source.isDirectory()) {
                target.delete();
                FileUtility.copyAll(target, source, 0, new FileFilter(){

                    public boolean accept(File pathname) {
                        return !pathname.getName().equals(SVNUtility.getSVNFolderName());
                    }
                }, monitor);
            } else {
                FileUtility.copyFile(target, source, monitor);
            }
            this.savedMetas.put(sourceLocation, target);
        }
    }
}

