/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.core.svnstorage;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.internal.preferences.Base64;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.svn.core.IConnectedProjectInformation;
import org.eclipse.team.svn.core.IStateFilter;
import org.eclipse.team.svn.core.SVNMessages;
import org.eclipse.team.svn.core.connector.ISVNConnector;
import org.eclipse.team.svn.core.connector.ISVNEntryInfoCallback;
import org.eclipse.team.svn.core.connector.ISVNProgressMonitor;
import org.eclipse.team.svn.core.connector.SVNChangeStatus;
import org.eclipse.team.svn.core.connector.SVNConflictDescriptor;
import org.eclipse.team.svn.core.connector.SVNConflictVersion;
import org.eclipse.team.svn.core.connector.SVNConnectorException;
import org.eclipse.team.svn.core.connector.SVNEntryInfo;
import org.eclipse.team.svn.core.connector.SVNEntryRevisionReference;
import org.eclipse.team.svn.core.connector.SVNRevision;
import org.eclipse.team.svn.core.extension.CoreExtensionsManager;
import org.eclipse.team.svn.core.extension.options.IIgnoreRecommendations;
import org.eclipse.team.svn.core.operation.AbstractActionOperation;
import org.eclipse.team.svn.core.operation.SVNNullProgressMonitor;
import org.eclipse.team.svn.core.operation.UnreportableException;
import org.eclipse.team.svn.core.resource.IChangeStateProvider;
import org.eclipse.team.svn.core.resource.ILocalFolder;
import org.eclipse.team.svn.core.resource.ILocalResource;
import org.eclipse.team.svn.core.resource.IRemoteStorage;
import org.eclipse.team.svn.core.resource.IRepositoryLocation;
import org.eclipse.team.svn.core.resource.IRepositoryResource;
import org.eclipse.team.svn.core.resource.IResourceChange;
import org.eclipse.team.svn.core.resource.events.IResourceStatesListener;
import org.eclipse.team.svn.core.resource.events.ResourceStatesChangedEvent;
import org.eclipse.team.svn.core.svnstorage.AbstractSVNStorage;
import org.eclipse.team.svn.core.svnstorage.SVNFileChange;
import org.eclipse.team.svn.core.svnstorage.SVNFolderChange;
import org.eclipse.team.svn.core.svnstorage.SVNLocalFile;
import org.eclipse.team.svn.core.svnstorage.SVNLocalFolder;
import org.eclipse.team.svn.core.svnstorage.SVNLocalResource;
import org.eclipse.team.svn.core.svnstorage.SVNRepositoryLocationWrapper;
import org.eclipse.team.svn.core.utility.FileUtility;
import org.eclipse.team.svn.core.utility.ProgressMonitorUtility;
import org.eclipse.team.svn.core.utility.SVNUtility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SVNRemoteStorage
extends AbstractSVNStorage
implements IRemoteStorage {
    public static final String PREF_REPOSITORIES_NODE = "repositories";
    public static final String PREF_MIGRATE_FROM_AUTH_DB_NODE = "migrateFromAuthorizationDatabase";
    public static final String STATE_INFO_FILE_NAME = ".svnRepositories";
    private static SVNRemoteStorage instance = new SVNRemoteStorage();
    protected Map localResources;
    protected Map switchedToUrls;
    protected Map externalsLocations;
    protected Map parent2Children;
    protected Map<Class, List<IResourceStatesListener>> resourceStateListeners;
    protected LinkedList fetchQueue;
    protected ISchedulingRule notifyLock = new ISchedulingRule(){

        public boolean isConflicting(ISchedulingRule rule) {
            return rule == this;
        }

        public boolean contains(ISchedulingRule rule) {
            return rule == this;
        }
    };
    private static final IStateFilter SF_NONSVN = new IStateFilter.AbstractStateFilter(){

        protected boolean acceptImpl(ILocalResource local, IResource resource, String state, int mask) {
            return state == "Prereplaced" || state == "New" || state == "Ignored" || state == IStateFilter.ST_NOTEXISTS || state == "Linked" || state == "Obstructed";
        }

        protected boolean allowsRecursionImpl(ILocalResource local, IResource resource, String state, int mask) {
            return true;
        }
    };

    public static SVNRemoteStorage instance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addResourceStatesListener(Class eventClass, IResourceStatesListener listener) {
        Map<Class, List<IResourceStatesListener>> map = this.resourceStateListeners;
        synchronized (map) {
            List<IResourceStatesListener> listenersList = this.resourceStateListeners.get(eventClass);
            if (listenersList == null) {
                listenersList = new ArrayList<IResourceStatesListener>();
                this.resourceStateListeners.put(eventClass, listenersList);
            }
            if (!listenersList.contains(listener)) {
                listenersList.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeResourceStatesListener(Class eventClass, IResourceStatesListener listener) {
        Map<Class, List<IResourceStatesListener>> map = this.resourceStateListeners;
        synchronized (map) {
            List<IResourceStatesListener> listenersList = this.resourceStateListeners.get(eventClass);
            if (listenersList != null) {
                listenersList.remove(listener);
                if (listenersList.size() == 0) {
                    this.resourceStateListeners.remove(eventClass);
                }
            }
        }
    }

    @Override
    public void fireResourceStatesChangedEvent(final ResourceStatesChangedEvent event) {
        if (event.resources.length > 0) {
            ProgressMonitorUtility.doTaskScheduled(new AbstractActionOperation("Operation_SendNotifications", SVNMessages.class){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                protected void runImpl(IProgressMonitor monitor) throws Exception {
                    IResourceStatesListener[] listeners = null;
                    Map<Class, List<IResourceStatesListener>> map = SVNRemoteStorage.this.resourceStateListeners;
                    synchronized (map) {
                        List<IResourceStatesListener> listenersArray = SVNRemoteStorage.this.resourceStateListeners.get(event.getClass());
                        if (listenersArray == null) {
                            return;
                        }
                        listeners = listenersArray.toArray(new IResourceStatesListener[listenersArray.size()]);
                    }
                    int i = 0;
                    while (i < listeners.length) {
                        listeners[i].resourcesStateChanged(event);
                        ++i;
                    }
                }

                public ISchedulingRule getSchedulingRule() {
                    return SVNRemoteStorage.this.notifyLock;
                }
            }, true);
        }
    }

    @Override
    public void initialize(Map<String, Object> preferences) throws Exception {
        preferences.put("internal.stateInfoFile", STATE_INFO_FILE_NAME);
        preferences.put("internal.repoNodeName", PREF_REPOSITORIES_NODE);
        preferences.put("internal.authNodeName", PREF_MIGRATE_FROM_AUTH_DB_NODE);
        super.initialize(preferences);
    }

    @Override
    public IResourceChange asResourceChange(IChangeStateProvider changeState, boolean update) {
        int changeMask;
        IResource resource = null;
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        Path location = new Path(changeState.getLocalPath());
        int nodeKind = changeState.getNodeKind();
        int propKind = changeState.getPropertiesChangeType();
        int textKind = changeState.getTextChangeType();
        boolean isCopied = changeState.isCopied();
        boolean isSwitched = changeState.isSwitched();
        SVNRevision.Number remoteRevision = changeState.getChangeRevision();
        long revision = remoteRevision != null ? remoteRevision.getNumber() : -1L;
        SVNConflictDescriptor treeConflictDescriptor = changeState.getTreeConflictDescriptor();
        String textStatusStr = SVNRemoteStorage.getTextStatusString(propKind, textKind, update);
        String propStatusStr = SVNRemoteStorage.getPropStatusString(propKind);
        if (nodeKind == 2) {
            int changeMask2;
            resource = changeState.getExact((IResource[])root.findContainersForLocationURI(URIUtil.toURI((IPath)location.makeAbsolute())));
            if (resource == null) {
                return null;
            }
            if (!resource.getName().equals(location.lastSegment())) {
                resource = root.getContainerForLocation((IPath)location);
            }
            if (IStateFilter.SF_NOTEXISTS.accept(resource, textStatusStr, changeMask2 = SVNRemoteStorage.getChangeMask(textKind, propKind, isCopied, isSwitched, false))) {
                revision = -1L;
            }
            return new SVNFolderChange(resource, revision, textStatusStr, propStatusStr, changeMask2, changeState.getChangeAuthor(), changeState.getChangeDate(), treeConflictDescriptor, null, changeState.getComment());
        }
        resource = changeState.getExact((IResource[])root.findFilesForLocationURI(URIUtil.toURI((IPath)location.makeAbsolute())));
        if (resource == null) {
            return null;
        }
        if (!resource.getName().equals(location.lastSegment())) {
            resource = root.getFileForLocation((IPath)location);
        }
        if (IStateFilter.SF_NOTEXISTS.accept(resource, textStatusStr, changeMask = SVNRemoteStorage.getChangeMask(textKind, propKind, isCopied, isSwitched, false))) {
            revision = -1L;
        }
        return new SVNFileChange(resource, revision, textStatusStr, propStatusStr, changeMask, changeState.getChangeAuthor(), changeState.getChangeDate(), treeConflictDescriptor, null, changeState.getComment());
    }

    @Override
    public byte[] resourceChangeAsBytes(IResourceChange resource) {
        if (resource == null) {
            return null;
        }
        int kind = resource.getPegRevision().getKind();
        String originatorData = null;
        if (resource.getOriginator() != null) {
            byte[] data = this.repositoryResourceAsBytes(resource.getOriginator());
            originatorData = new String(Base64.encode((byte[])data));
        }
        long lastCommitDate = resource.getLastCommitDate();
        String comment = resource.getComment();
        String retVal = String.valueOf(String.valueOf(resource instanceof ILocalFolder)) + ";" + new String(Base64.encode((byte[])FileUtility.getWorkingCopyPath(resource.getResource()).getBytes())) + ";" + resource.getRevision() + ";" + resource.getTextStatus() + ";" + resource.getAuthor() + ";" + (lastCommitDate == 0L ? "null" : String.valueOf(lastCommitDate)) + ";" + String.valueOf(kind) + ";" + (kind == 1 ? String.valueOf(((SVNRevision.Number)resource.getPegRevision()).getNumber()) : String.valueOf(kind)) + ";" + (originatorData != null ? originatorData : "null") + ";" + (comment == null ? "null" : new String(Base64.encode((byte[])comment.getBytes()))) + ";" + resource.getChangeMask() + ";" + this.getTreeConflictDescriptorAsString(resource.getTreeConflictDescriptor()) + ";" + resource.getPropStatus();
        return retVal.getBytes();
    }

    protected String getTreeConflictDescriptorAsString(SVNConflictDescriptor conflictDescriptor) {
        String retVal = String.valueOf(conflictDescriptor == null ? "null" : String.valueOf(conflictDescriptor.action)) + ";" + (conflictDescriptor == null ? "null" : String.valueOf(conflictDescriptor.reason)) + ";" + (conflictDescriptor == null ? "null" : String.valueOf(conflictDescriptor.operation)) + ";" + this.getSVNConflictVersionAsString(conflictDescriptor == null ? null : conflictDescriptor.srcLeftVersion) + ";" + this.getSVNConflictVersionAsString(conflictDescriptor == null ? null : conflictDescriptor.srcRightVersion);
        return retVal;
    }

    protected String getSVNConflictVersionAsString(SVNConflictVersion conflictVersion) {
        String retVal = String.valueOf(conflictVersion == null ? "null" : String.valueOf(conflictVersion.nodeKind)) + ";" + (conflictVersion == null ? "null" : new String(Base64.encode((byte[])conflictVersion.pathInRepos.getBytes()))) + ";" + (conflictVersion == null ? "null" : String.valueOf(conflictVersion.pegRevision)) + ";" + (conflictVersion == null ? "null" : new String(Base64.encode((byte[])conflictVersion.reposURL.getBytes())));
        return retVal;
    }

    @Override
    public IResourceChange resourceChangeFromBytes(byte[] bytes) {
        SVNLocalResource change;
        long pegNum;
        if (bytes == null) {
            return null;
        }
        String[] data = new String(bytes).split(";");
        boolean isFolder = "true".equals(data[0]);
        String name = new String(Base64.decode((byte[])data[1].getBytes()));
        long revision = Long.parseLong(data[2]);
        String textStatus = this.deserializeStatus(data[3]);
        String author = "null".equals(data[4]) ? null : data[4];
        long lastCommitDate = "null".equals(data[5]) ? 0L : Long.parseLong(data[5]);
        int revisionKind = Integer.parseInt(data[6]);
        SVNRevision pegRevision = null;
        pegRevision = revisionKind == 1 ? ((pegNum = Long.parseLong(data[7])) == revision || revision == -1L ? null : SVNRevision.fromNumber(pegNum)) : SVNRevision.fromKind(revisionKind);
        String comment = "null".equals(data[9]) ? null : new String(Base64.decode((byte[])data[9].getBytes()));
        int changeMask = "null".equals(data[10]) ? 0 : Integer.parseInt(data[10]);
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        String propStatus = "Normal";
        if (data.length >= 23) {
            propStatus = this.deserializeStatus(data[22]);
        } else if ((changeMask & 2) != 0) {
            propStatus = "Modified";
            if ((changeMask & 1) == 0) {
                textStatus = "Normal";
            }
        }
        SVNConflictDescriptor treeConflict = this.getTreeConflictDescriptorFromString(name, data);
        SVNLocalResource sVNLocalResource = change = isFolder ? new SVNFolderChange((IResource)root.getContainerForLocation((IPath)new Path(name)), revision, textStatus, propStatus, changeMask, author, lastCommitDate, treeConflict, pegRevision, comment) : new SVNFileChange((IResource)root.getFileForLocation((IPath)new Path(name)), revision, textStatus, propStatus, changeMask, author, lastCommitDate, treeConflict, pegRevision, comment);
        if (!"null".equals(data[8])) {
            byte[] originatorData = Base64.decode((byte[])data[8].getBytes());
            change.setOriginator(this.repositoryResourceFromBytes(originatorData));
        }
        return change;
    }

    protected SVNConflictDescriptor getTreeConflictDescriptorFromString(String path, String[] data) {
        SVNConflictDescriptor conflictDescriptor = null;
        if (data.length >= 23 && !"null".equals(data[11])) {
            int action = "null".equals(data[11]) ? 0 : Integer.parseInt(data[11]);
            int reason = "null".equals(data[12]) ? 0 : Integer.parseInt(data[12]);
            int operation = "null".equals(data[13]) ? 0 : Integer.parseInt(data[13]);
            conflictDescriptor = new SVNConflictDescriptor(path, action, reason, operation, this.getSVNConflictVersionFromString(data, true), this.getSVNConflictVersionFromString(data, false));
        }
        return conflictDescriptor;
    }

    protected SVNConflictVersion getSVNConflictVersionFromString(String[] data, boolean isLeft) {
        int indexShift = isLeft ? 0 : 4;
        int nodeKind = "null".equals(data[14 + indexShift]) ? 0 : Integer.parseInt(data[14 + indexShift]);
        String pathInRepos = "null".equals(data[15 + indexShift]) ? null : new String(Base64.decode((byte[])data[15 + indexShift].getBytes()));
        long pegRevision = "null".equals(data[16 + indexShift]) ? 0L : Long.parseLong(data[16 + indexShift]);
        String reposUrl = "null".equals(data[17 + indexShift]) ? null : new String(Base64.decode((byte[])data[17 + indexShift].getBytes()));
        return new SVNConflictVersion(reposUrl, pegRevision, pathInRepos, nodeKind);
    }

    public synchronized IResource[] getRegisteredChildren(IContainer container) throws Exception {
        if (container == null || container.getProject() == null) {
            return null;
        }
        IResource[] members = FileUtility.resourceMembers(container, false);
        Set<Object> retVal = (HashSet<IResource>)this.parent2Children.get(container.getFullPath());
        if (retVal == null) {
            this.loadLocalResourcesSubTree((IResource)container, false);
            retVal = (Set)this.parent2Children.get(container.getFullPath());
        }
        if (retVal != null) {
            retVal = new HashSet<IResource>(retVal);
            retVal.addAll(Arrays.asList(members));
        }
        return retVal == null ? members : retVal.toArray(new IResource[retVal.size()]);
    }

    @Override
    public ILocalResource asLocalResourceDirty(IResource resource) {
        if (!CoreExtensionsManager.instance().getOptionProvider().isSVNCacheEnabled()) {
            return this.asLocalResource(resource);
        }
        if (resource == null || resource.getProject() == null) {
            return this.wrapUnexistingResource(resource, "InternalInvalid", 0);
        }
        ILocalResource retVal = (ILocalResource)this.localResources.get(resource.getFullPath());
        if (retVal == null) {
            ILocalResource parent = this.getFirstExistingParentLocal(resource);
            int mask = parent == null ? 0 : parent.getChangeMask() & 8;
            retVal = this.wrapUnexistingResource(resource, IStateFilter.ST_NOTEXISTS, mask);
        }
        return retVal;
    }

    @Override
    public ILocalResource asLocalResourceAccessible(IResource resource) {
        ILocalResource retVal = this.asLocalResource(resource);
        if (IStateFilter.SF_INTERNAL_INVALID.accept(retVal)) {
            throw new UnreportableException(SVNMessages.formatErrorString("Error_InaccessibleResource", new String[]{resource == null ? "" : FileUtility.getWorkingCopyPath(resource)}));
        }
        return retVal;
    }

    @Override
    public ILocalResource asLocalResource(IResource resource) {
        return this.asLocalResourceImpl(resource, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ILocalResource asLocalResourceImpl(IResource resource, boolean recurse) {
        if (resource == null || resource.getProject() == null || !resource.getProject().isAccessible()) {
            return this.wrapUnexistingResource(resource, "InternalInvalid", 0);
        }
        ILocalResource local = (ILocalResource)this.localResources.get(resource.getFullPath());
        if (local == null) {
            SVNRemoteStorage sVNRemoteStorage = this;
            synchronized (sVNRemoteStorage) {
                local = (ILocalResource)this.localResources.get(resource.getFullPath());
                if (local == null) {
                    try {
                        local = this.loadLocalResourcesSubTree(resource, recurse);
                    }
                    catch (RuntimeException ex) {
                        throw ex;
                    }
                    catch (SVNConnectorException sVNConnectorException) {
                        return this.wrapUnexistingResource(resource, "InternalInvalid", 0);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        }
        return local;
    }

    @Override
    public synchronized void refreshLocalResources(IResource[] resources, int depth) {
        if (depth == 2) {
            resources = FileUtility.shrinkChildNodes(resources);
        }
        int i = 0;
        while (i < resources.length) {
            this.refreshLocalResourceImpl(resources[i], depth);
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ILocalResource asLocalResource(IProject project, String url, int kind) {
        Map map = this.switchedToUrls;
        synchronized (map) {
            for (Map.Entry entry : this.switchedToUrls.entrySet()) {
                String cachedUrl = (String)entry.getValue();
                if (!SVNUtility.createPathForSVNUrl(cachedUrl).isPrefixOf(SVNUtility.createPathForSVNUrl(url))) continue;
                IPath target = ((IPath)entry.getKey()).append(url.substring(cachedUrl.length())).removeFirstSegments(1);
                return this.asLocalResource((IResource)(kind == 2 ? project.getFolder(target) : project.getFile(target)));
            }
        }
        String projectUrl = this.asRepositoryResource((IResource)project).getUrl();
        if (url.length() < projectUrl.length()) {
            return this.wrapUnexistingResource(null, "InternalInvalid", 0);
        }
        String pathInProject = url.substring(projectUrl.length());
        if (pathInProject.length() == 0) {
            return this.asLocalResource((IResource)project);
        }
        return this.asLocalResource((IResource)(kind == 2 ? project.getFolder(pathInProject) : project.getFile(pathInProject)));
    }

    @Override
    public IRepositoryResource asRepositoryResource(IResource resource) {
        IPath parentPath;
        ILocalResource parent;
        IProject project = resource.getProject();
        IRepositoryResource baseResource = this.getConnectedProjectInformation(project).getRepositoryResource();
        if (resource.equals((Object)project)) {
            return SVNUtility.copyOf(baseResource);
        }
        IRepositoryLocation location = baseResource.getRepositoryLocation();
        String url = (String)this.switchedToUrls.get(resource.getFullPath());
        if (url == null && (parent = this.getFirstExistingParentLocal(resource)) != null && (parent.getChangeMask() & 8) != 0 && this.switchedToUrls.containsKey(parentPath = parent.getResource().getFullPath())) {
            url = String.valueOf((String)this.switchedToUrls.get(parentPath)) + "/" + resource.getFullPath().removeFirstSegments(parentPath.segmentCount()).toString();
        }
        if (url == null) {
            url = this.makeUrl(resource, baseResource);
        } else if (!SVNUtility.createPathForSVNUrl(location.getRepositoryRootUrl()).isPrefixOf(SVNUtility.createPathForSVNUrl(url))) {
            location = this.wrapLocationIfRequired(location, url, resource.getType() == 1);
        }
        return resource instanceof IContainer ? location.asRepositoryContainer(url, false) : location.asRepositoryFile(url, false);
    }

    public IRepositoryResource asRepositoryResource(IRepositoryLocation location, SVNEntryRevisionReference reference, ISVNProgressMonitor monitor) throws SVNConnectorException {
        IRepositoryResource res = null;
        String url = reference.path;
        reference = new SVNEntryRevisionReference(SVNUtility.encodeURL(url), reference.pegRevision == null ? SVNRevision.HEAD : reference.pegRevision, reference.revision == null ? SVNRevision.HEAD : reference.revision);
        if (!SVNUtility.createPathForSVNUrl(location.getRepositoryRootUrl()).isPrefixOf(SVNUtility.createPathForSVNUrl(url))) {
            boolean isFile = false;
            location = this.wrapLocationIfRequired(location, url, isFile);
        }
        ISVNConnector proxy = location.acquireSVNProxy();
        try {
            SVNEntryInfo[] entriesInfo = SVNUtility.info(proxy, reference, 0, monitor);
            if (entriesInfo.length > 0) {
                SVNEntryInfo info = entriesInfo[0];
                if (info.kind == 1) {
                    res = location.asRepositoryFile(url, false);
                } else if (info.kind == 2) {
                    res = location.asRepositoryContainer(url, false);
                }
            }
        }
        finally {
            location.releaseSVNProxy(proxy);
        }
        return res;
    }

    @Override
    public IRepositoryResource asRepositoryResource(IRepositoryLocation location, String url, boolean isFile) {
        String rootURL = location.getRepositoryRootUrl();
        if (rootURL == null) {
            rootURL = location.getUrl();
        }
        if (rootURL == null || !SVNUtility.createPathForSVNUrl(rootURL).isPrefixOf(SVNUtility.createPathForSVNUrl(url))) {
            location = this.wrapLocationIfRequired(location, url, isFile);
        }
        return !isFile ? location.asRepositoryContainer(url, false) : location.asRepositoryFile(url, false);
    }

    @Override
    public IRepositoryLocation getRepositoryLocation(IResource resource) {
        return this.getConnectedProjectInformation(resource.getProject()).getRepositoryLocation();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected IRepositoryLocation wrapLocationIfRequired(IRepositoryLocation location, String url, boolean isFile) {
        if (!SVNUtility.createPathForSVNUrl(location.getRepositoryRootUrl()).isPrefixOf(SVNUtility.createPathForSVNUrl(url))) {
            Map map = this.externalsLocations;
            synchronized (map) {
                ArrayList<IRepositoryLocation> locations = (ArrayList<IRepositoryLocation>)this.externalsLocations.get(location);
                if (locations == null) {
                    locations = new ArrayList<IRepositoryLocation>();
                    this.externalsLocations.put(location, locations);
                }
                boolean found = false;
                for (IRepositoryLocation tmp : locations) {
                    if (!url.startsWith(tmp.getUrl()) && !tmp.getUrl().startsWith(url)) continue;
                    location = tmp;
                    found = true;
                    break;
                }
                if (!found) {
                    location = new SVNRepositoryLocationWrapper(location, isFile ? url.substring(0, url.lastIndexOf(47)) : url);
                    locations.add(location);
                }
            }
        }
        return location;
    }

    protected ILocalResource wrapUnexistingResource(IResource resource, String state, int mask) {
        return resource == null || resource.getType() == 1 ? new SVNLocalFile(resource, -1L, -1L, state, "Normal", mask, null, 0L, null) : new SVNLocalFolder(resource, -1L, -1L, state, "Normal", mask, null, 0L, null);
    }

    protected String makeUrl(IResource resource, IRepositoryResource baseResource) {
        if (resource.getType() == 4) {
            return baseResource.getUrl();
        }
        IProject project = resource.getProject();
        String url = resource.getFullPath().toString();
        return String.valueOf(baseResource.getUrl()) + "/" + url.substring(project.getFullPath().toString().length() + 1);
    }

    protected IConnectedProjectInformation getConnectedProjectInformation(IProject project) {
        RepositoryProvider provider = RepositoryProvider.getProvider((IProject)project);
        if (provider == null) {
            String errMessage = SVNMessages.formatErrorString("Error_NotConnectedProject", new String[]{project.getName()});
            throw new UnreportableException(errMessage);
        }
        if (!(provider instanceof IConnectedProjectInformation)) {
            String errMessage = SVNMessages.formatErrorString("Error_AnotherProvider", new String[]{project.getName(), provider.getID()});
            throw new UnreportableException(errMessage);
        }
        return (IConnectedProjectInformation)provider;
    }

    protected void refreshLocalResourceImpl(IResource resource, int depth) {
        IConnectedProjectInformation info;
        if (resource.getType() == 4 && (info = (IConnectedProjectInformation)RepositoryProvider.getProvider((IProject)resource.getProject(), (String)"org.eclipse.team.svn.core.svnnature")) != null) {
            try {
                info.relocateResource();
            }
            catch (CoreException ex) {
                throw new RuntimeException(ex);
            }
        }
        IPath rootPath = resource.getFullPath();
        Iterator it = this.localResources.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            ILocalResource local = (ILocalResource)entry.getValue();
            IPath currentPath = (IPath)entry.getKey();
            if (!IStateFilter.SF_NOTEXISTS.accept(local) && !rootPath.isPrefixOf(currentPath)) continue;
            it.remove();
            this.switchedToUrls.remove(currentPath);
            this.parent2Children.remove(currentPath);
            this.parent2Children.remove(currentPath.removeLastSegments(1));
        }
    }

    protected ILocalResource loadLocalResourcesSubTree(IResource resource, boolean recurse) throws Exception {
        ILocalResource parentLocal;
        boolean parentExists;
        IConnectedProjectInformation provider = (IConnectedProjectInformation)RepositoryProvider.getProvider((IProject)resource.getProject(), (String)"org.eclipse.team.svn.core.svnnature");
        if (provider == null || FileUtility.isSVNInternals(resource)) {
            return this.wrapUnexistingResource(resource, "InternalInvalid", 0);
        }
        boolean isCacheEnabled = CoreExtensionsManager.instance().getOptionProvider().isSVNCacheEnabled();
        if (!isCacheEnabled) {
            this.localResources.clear();
        }
        recurse &= isCacheEnabled;
        ILocalResource retVal = null;
        boolean isLinked = FileUtility.isLinked(resource);
        IContainer parent = resource.getParent();
        boolean bl = parentExists = parent != null && parent.isAccessible();
        if (parentExists && !isLinked && ((parentLocal = this.asLocalResourceImpl((IResource)parent, false)) == null || !SF_NONSVN.accept(parentLocal) || IStateFilter.SF_UNVERSIONED_EXTERNAL.accept(parentLocal))) {
            retVal = this.loadLocalResourcesSubTreeSVNImpl(provider, resource, recurse);
        }
        return retVal == null || IStateFilter.SF_UNVERSIONED.accept(retVal) && !IStateFilter.SF_IGNORED.accept(retVal) ? this.loadUnversionedSubtree(resource, isLinked, recurse) : retVal;
    }

    protected ILocalResource loadUnversionedSubtree(final IResource resource, boolean isLinked, boolean recurse) throws Exception {
        String status;
        final String fStatus = status = this.calculateUnversionedStatus(resource, isLinked);
        final ILocalResource parent = this.getFirstExistingParentLocal(resource);
        final int parentCM = parent != null ? parent.getChangeMask() & 8 | parent.getChangeMask() & 0x40 : 0;
        final ILocalResource[] tmp = new ILocalResource[1];
        final boolean[] isUnversionedExternalParent = new boolean[1];
        FileUtility.visitNodes(resource, new IResourceVisitor(){

            public boolean visit(IResource child) throws CoreException {
                if (FileUtility.isSVNInternals(child)) {
                    return false;
                }
                String path = FileUtility.getWorkingCopyPath(child);
                if (new File(String.valueOf(path) + "/" + SVNUtility.getSVNFolderName()).exists() && SVNUtility.getSVNInfoForNotConnected(child) != null) {
                    return false;
                }
                String textState = child == resource ? fStatus : SVNRemoteStorage.this.getDelegatedStatus(child, fStatus, 0);
                int changeMask = parentCM;
                if ((parent != null && !IStateFilter.SF_IGNORED_BUT_NOT_EXTERNAL.accept(parent) || parent == null) && textState == "Ignored" && (changeMask & 0x40) == 0 && (isUnversionedExternalParent[0] || SVNRemoteStorage.this.containsSVNMetaInChildren(resource))) {
                    changeMask |= 0x40;
                    if (!isUnversionedExternalParent[0] && child.equals((Object)resource)) {
                        isUnversionedExternalParent[0] = true;
                    }
                }
                ILocalResource retVal = SVNRemoteStorage.this.registerResource(child, -1L, -1L, textState, "Normal", changeMask, null, -1L, null);
                if (tmp[0] == null) {
                    tmp[0] = retVal;
                }
                return true;
            }
        }, recurse ? 2 : 1, false);
        return tmp[0] != null ? tmp[0] : this.wrapUnexistingResource(resource, "InternalInvalid", 0);
    }

    protected String calculateUnversionedStatus(IResource resource, boolean isLinked) {
        String status = IStateFilter.ST_NOTEXISTS;
        if (isLinked) {
            status = "Linked";
        } else {
            IPath location = resource.getLocation();
            if (location != null && SVNRemoteStorage.isFileExists(location)) {
                status = "Ignored";
                if (!SVNUtility.isIgnored(resource)) {
                    ILocalResource local = (ILocalResource)this.localResources.get(resource.getFullPath());
                    if (local != null) {
                        return local.getStatus();
                    }
                    status = this.getTopLevelStatus(resource, "New", 0);
                }
            }
        }
        return status;
    }

    public static boolean isFileExists(IPath location) {
        File file = location.toFile();
        if (file.exists()) {
            if (FileUtility.isWindows()) {
                try {
                    return file.getName().equals(file.getCanonicalFile().getName());
                }
                catch (IOException iOException) {
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    protected ILocalResource loadLocalResourcesSubTreeSVNImpl(IConnectedProjectInformation provider, IResource resource, boolean recurse) throws Exception {
        IProject project = resource.getProject();
        IResource target = resource.getType() == 1 ? resource.getParent() : resource;
        IPath wcPath = project.getLocation();
        IPath resourcePath = target.getLocation();
        IPath requestedPath = resource.getLocation();
        if (wcPath == null || resourcePath == null || requestedPath == null) {
            return null;
        }
        String projectPath = wcPath.toString();
        int subPathStart = projectPath.length();
        boolean hasSVNMeta = true;
        if (SVNUtility.isPriorToSVN17()) {
            while (!this.canFetchStatuses(resourcePath)) {
                if (target == null || target.getType() == 4) {
                    return null;
                }
                hasSVNMeta = false;
                resourcePath = resourcePath.removeLastSegments(1);
                target = target.getParent();
            }
        }
        IRepositoryResource baseResource = provider.getRepositoryResource();
        SVNChangeStatus[] statuses = this.getStatuses(resourcePath.toString());
        String desiredUrl = this.makeUrl(target, baseResource);
        ILocalResource retVal = this.fillCache(statuses, desiredUrl, resource, subPathStart, requestedPath);
        if (statuses.length == 1 || statuses.length > 1 && this.parent2Children.get(target.getFullPath()) == null) {
            this.parent2Children.put(target.getFullPath(), new HashSet());
        }
        if (retVal != null && hasSVNMeta && statuses.length > 1 && recurse && CoreExtensionsManager.instance().getOptionProvider().isSVNCacheEnabled()) {
            this.scheduleStatusesFetch(statuses, target);
        }
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void scheduleStatusesFetch(SVNChangeStatus[] st, IResource target) {
        LinkedList linkedList = this.fetchQueue;
        synchronized (linkedList) {
            this.fetchQueue.add(new Object[]{st, target});
            if (this.fetchQueue.size() == 1) {
                ProgressMonitorUtility.doTaskScheduledDefault(new AbstractActionOperation("Operation_UpdateSVNCache", SVNMessages.class){

                    public ISchedulingRule getSchedulingRule() {
                        return null;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    protected void runImpl(IProgressMonitor monitor) throws Exception {
                        Thread.currentThread().setPriority(1);
                        while (true) {
                            IResource target;
                            SVNChangeStatus[] st;
                            LinkedList linkedList = SVNRemoteStorage.this.fetchQueue;
                            synchronized (linkedList) {
                                if (monitor.isCanceled() || !CoreExtensionsManager.instance().getOptionProvider().isSVNCacheEnabled() || SVNRemoteStorage.this.fetchQueue.size() == 0) {
                                    SVNRemoteStorage.this.fetchQueue.clear();
                                    break;
                                }
                                Object[] entry = (Object[])SVNRemoteStorage.this.fetchQueue.get(0);
                                st = (SVNChangeStatus[])entry[0];
                                target = (IResource)entry[1];
                            }
                            this.processEntry(monitor, st, target);
                            linkedList = SVNRemoteStorage.this.fetchQueue;
                            synchronized (linkedList) {
                                SVNRemoteStorage.this.fetchQueue.remove(0);
                                if (SVNRemoteStorage.this.fetchQueue.size() == 0) {
                                    break;
                                }
                            }
                        }
                    }

                    protected void processEntry(IProgressMonitor monitor, SVNChangeStatus[] st, IResource target) {
                        IProject prj = target.getProject();
                        IPath location = prj.getLocation();
                        if (location != null) {
                            SVNUtility.reorder(st, false);
                            int projectEnd = location.toString().length();
                            int i = 0;
                            while (i < st.length && !monitor.isCanceled() && CoreExtensionsManager.instance().getOptionProvider().isSVNCacheEnabled()) {
                                ProgressMonitorUtility.progress(monitor, i, -1);
                                if (st[i] != null && st[i].nodeKind == 2 && st[i].path.length() > projectEnd) {
                                    IFolder folder = prj.getFolder((IPath)new Path(st[i].path.substring(projectEnd)));
                                    ProgressMonitorUtility.setTaskInfo(monitor, this, folder.getFullPath().toString());
                                    ILocalFolder local = (ILocalFolder)SVNRemoteStorage.this.asLocalResource((IResource)folder);
                                    if (!IStateFilter.SF_INTERNAL_INVALID.accept(local)) {
                                        local.getChildren();
                                    }
                                }
                                ++i;
                            }
                        }
                    }
                }, false).setPriority(50);
            }
        }
    }

    protected boolean canFetchStatuses(IPath path) {
        return path.append(SVNUtility.getSVNFolderName()).toFile().exists();
    }

    protected boolean canFetchStatuses(File file) {
        return new File(file, SVNUtility.getSVNFolderName()).exists();
    }

    protected SVNChangeStatus[] getStatuses(String path) throws Exception {
        ISVNConnector proxy = CoreExtensionsManager.instance().getSVNConnectorFactory().newInstance();
        try {
            SVNChangeStatus[] statuses = SVNUtility.status(proxy, path, 2, 384L, new SVNNullProgressMonitor());
            SVNUtility.reorder(statuses, true);
            SVNChangeStatus[] sVNChangeStatusArray = statuses;
            return sVNChangeStatusArray;
        }
        catch (SVNConnectorException cwe) {
            if (cwe.getErrorId() == 155037) {
                SVNChangeStatus[] sVNChangeStatusArray = new SVNChangeStatus[]{new SVNChangeStatus(path, "", 2, 0L, 0L, 0L, "", 2, 1, 1, 1, false, false, false, null, null, 0L, 0L, 2, "", false, false, null, null)};
                return sVNChangeStatusArray;
            }
            if (cwe.getErrorId() != 155007 && cwe.getErrorId() != 155010) {
                throw cwe;
            }
            SVNChangeStatus[] sVNChangeStatusArray = new SVNChangeStatus[]{};
            return sVNChangeStatusArray;
        }
        finally {
            proxy.dispose();
        }
    }

    protected ILocalResource fillCache(SVNChangeStatus[] statuses, String desiredUrl, IResource resource, int subPathStart, IPath requestedPath) {
        IProject project = resource.getProject();
        ILocalResource retVal = null;
        ISVNConnector proxy = null;
        try {
            int i = 0;
            while (i < statuses.length) {
                block31: {
                    ILocalResource local;
                    Object tRes;
                    block37: {
                        block34: {
                            String propStatus;
                            String textStatus;
                            int changeMask;
                            String fsNodePath;
                            int nodeKind;
                            block36: {
                                boolean isSVNExternals;
                                ILocalResource parent;
                                block29: {
                                    ILocalResource tLocalParent;
                                    block35: {
                                        String nodePath;
                                        block33: {
                                            block32: {
                                                nodeKind = SVNUtility.getNodeKind(statuses[i].path, statuses[i].nodeKind, true);
                                                if (statuses[i].hasConflict && statuses[i].treeConflicts == null || nodeKind == 0) {
                                                    if (proxy == null) {
                                                        proxy = CoreExtensionsManager.instance().getSVNConnectorFactory().newInstance();
                                                    }
                                                    final SVNConflictDescriptor[][] treeConflicts = new SVNConflictDescriptor[1][];
                                                    try {
                                                        proxy.info(new SVNEntryRevisionReference(statuses[i].path), 0, null, new ISVNEntryInfoCallback(){

                                                            public void next(SVNEntryInfo info) {
                                                                treeConflicts[0] = info.treeConflicts;
                                                            }
                                                        }, new SVNNullProgressMonitor());
                                                    }
                                                    catch (Exception exception) {}
                                                    statuses[i].treeConflicts = treeConflicts[0];
                                                }
                                                if (nodeKind == 0 && statuses[i].treeConflicts == null) break block31;
                                                fsNodePath = statuses[i].path;
                                                nodePath = statuses[i].path;
                                                String string = nodePath = nodePath.length() >= subPathStart ? nodePath.substring(subPathStart) : "";
                                                if (nodePath.length() <= 0 || nodePath.charAt(nodePath.length() - 1) != '/') break block32;
                                                nodePath = nodePath.substring(0, nodePath.length() - 1);
                                                break block33;
                                            }
                                            if (i > 0 && nodePath.trim().length() == 0) break block31;
                                        }
                                        tRes = null;
                                        tRes = new Path(statuses[i].path).equals((Object)requestedPath) && (resource.getType() > 2 || resource.getType() == nodeKind) ? resource : (nodeKind == 2 ? (nodePath.length() == 0 ? project : project.getFolder((IPath)new Path(nodePath))) : project.getFile((IPath)new Path(nodePath)));
                                        local = (ILocalResource)this.localResources.get(tRes.getFullPath());
                                        if (local != null) break block34;
                                        parent = this.getFirstExistingParentLocal((IResource)tRes);
                                        isSVNExternals = false;
                                        if (statuses[i].textStatus != 13) break block35;
                                        isSVNExternals = true;
                                        statuses[i] = SVNUtility.getSVNInfoForNotConnected(tRes);
                                        if (statuses[i] != null) break block29;
                                        local = this.registerExternalUnversionedResource((IResource)tRes);
                                        if (tRes == resource) {
                                            retVal = local;
                                        }
                                        break block31;
                                    }
                                    if (!(i != 0 || statuses[i].url == null || SVNUtility.decodeURL(statuses[i].url).startsWith(desiredUrl) || tRes.getParent().getType() == 8 || (tLocalParent = (ILocalResource)this.localResources.get(tRes.getParent().getFullPath())) != null && (tLocalParent.getChangeMask() & 8) != 0)) {
                                        if (proxy == null) {
                                            proxy = CoreExtensionsManager.instance().getSVNConnectorFactory().newInstance();
                                        }
                                        try {
                                            SVNChangeStatus[] tStats = SVNUtility.status(proxy, FileUtility.getWorkingCopyPath((IResource)tRes.getParent()), 2, 128L, new SVNNullProgressMonitor());
                                            SVNUtility.reorder(tStats, true);
                                            SVNChangeStatus[] sVNChangeStatusArray = tStats;
                                            int n = tStats.length;
                                            int n2 = 0;
                                            while (n2 < n) {
                                                SVNChangeStatus st = sVNChangeStatusArray[n2];
                                                if (st.path.equals(statuses[i].path)) {
                                                    isSVNExternals = st.textStatus == 13;
                                                    break;
                                                }
                                                ++n2;
                                            }
                                        }
                                        catch (Exception exception) {}
                                    }
                                }
                                boolean forceCopied = parent != null && parent.isCopied();
                                changeMask = SVNRemoteStorage.getChangeMask(statuses[i].textStatus, statuses[i].propStatus, forceCopied | statuses[i].isCopied, statuses[i].isSwitched, isSVNExternals);
                                if (statuses[i].wcLock != null) {
                                    changeMask |= 0x10;
                                }
                                if (nodeKind == 0 && statuses[i].treeConflicts != null) {
                                    changeMask |= 0x20;
                                }
                                if (statuses[i].isFileExternal) {
                                    changeMask |= 8;
                                }
                                textStatus = statuses[i].treeConflicts != null ? "Conflicting" : SVNRemoteStorage.getTextStatusString(statuses[i].propStatus, statuses[i].textStatus, false);
                                propStatus = SVNRemoteStorage.getPropStatusString(statuses[i].propStatus);
                                if (textStatus != "New" || nodeKind != 2 || !this.containsSVNMetaInChildren((IResource)tRes)) break block36;
                                local = this.registerExternalUnversionedResource((IResource)tRes);
                                break block31;
                            }
                            if (!statuses[i].isSwitched && statuses[i].url != null && !SVNUtility.decodeURL(statuses[i].url).startsWith(desiredUrl)) {
                                changeMask |= 8;
                            }
                            if ((changeMask & 8) != 0) {
                                if (statuses[i].url != null) {
                                    this.switchedToUrls.put(tRes.getFullPath(), SVNUtility.decodeURL(statuses[i].url));
                                } else {
                                    changeMask ^= 8;
                                }
                            }
                            if (textStatus == "Deleted" && nodeKind == 1 && new File(statuses[i].path).exists()) {
                                textStatus = "Prereplaced";
                            }
                            if (FileUtility.isLinked(tRes)) {
                                textStatus = "Linked";
                            } else if (textStatus != "Obstructed" && statuses[i].textStatus == 5) {
                                textStatus = this.getDelegatedStatus((IResource)tRes, "New", changeMask);
                            }
                            if (textStatus == "New" && nodeKind == 2 && this.canFetchStatuses((IPath)new Path(fsNodePath))) {
                                textStatus = "Obstructed";
                            }
                            long revision = statuses[i].lastChangedRevision == -1L && (changeMask & 4) != 0 ? statuses[i].revision : statuses[i].lastChangedRevision;
                            local = this.registerResource((IResource)tRes, revision, statuses[i].revision, textStatus, propStatus, changeMask, statuses[i].lastCommitAuthor, statuses[i].lastChangedDate, statuses[i].treeConflicts == null ? null : statuses[i].treeConflicts[0]);
                            break block37;
                        }
                        this.writeChild(local.getResource(), local.getStatus(), local.getChangeMask());
                    }
                    if (tRes == resource) {
                        retVal = local;
                    }
                }
                ++i;
            }
        }
        finally {
            if (proxy != null) {
                proxy.dispose();
            }
        }
        return retVal;
    }

    protected boolean containsSVNMetaInChildren(IResource resource) {
        if (SVNUtility.isIgnored(resource)) {
            return false;
        }
        boolean hasSVNMeta = false;
        if (resource.getType() == 2 && resource.getLocation() != null) {
            File folder = resource.getLocation().toFile();
            do {
                boolean[] check;
                String[] children;
                File file = folder = (children = folder.list(new FilenameFilter(check = new boolean[]{true}){
                    private final /* synthetic */ boolean[] val$check;
                    {
                        this.val$check = blArray;
                    }

                    public boolean accept(File dir, String name) {
                        boolean accept = false;
                        if (this.val$check[0] && (accept = new File(dir, name).isDirectory())) {
                            this.val$check[0] = false;
                        }
                        return accept;
                    }
                })) != null && children.length > 0 ? new File(folder, children[0]) : null;
            } while (folder != null && !(hasSVNMeta = this.canFetchStatuses(folder)));
        }
        return hasSVNMeta;
    }

    protected String getDelegatedStatus(IResource resource, String status, int mask) {
        if (IStateFilter.SF_LINKED.accept(resource, status, mask) || FileUtility.isLinked(resource)) {
            return "Linked";
        }
        if (IStateFilter.SF_OBSTRUCTED.accept(resource, status, mask)) {
            return "Obstructed";
        }
        if ("Ignored" == status) {
            return "Ignored";
        }
        return this.getTopLevelStatus(resource, status, mask);
    }

    protected String getTopLevelStatus(IResource resource, String status, int mask) {
        ILocalResource topLevel = this.getFirstExistingParentLocal(resource);
        if (topLevel != null) {
            String topLevelStatus = topLevel.getStatus();
            IResource topLevelResource = topLevel.getResource();
            if (IStateFilter.SF_OBSTRUCTED.accept(topLevelResource, topLevelStatus, mask) || IStateFilter.SF_LINKED.accept(topLevelResource, topLevelStatus, mask) || IStateFilter.SF_IGNORED.accept(topLevelResource, topLevelStatus, mask)) {
                return topLevelStatus;
            }
        }
        return status;
    }

    protected ILocalResource registerExternalUnversionedResource(IResource resource) {
        return this.registerResource(resource, -1L, -1L, "Ignored", "Normal", 64, null, 0L, null);
    }

    protected ILocalResource registerResource(IResource current, long revision, long baseRevision, String textStatus, String propStatus, int changeMask, String author, long date, SVNConflictDescriptor treeConflictDescriptor) {
        SVNLocalResource local = null;
        if (IStateFilter.SF_OBSTRUCTED.accept(current, textStatus, changeMask)) {
            try {
                IIgnoreRecommendations[] ignores = CoreExtensionsManager.instance().getIgnoreRecommendations();
                int i = 0;
                while (i < ignores.length) {
                    if (ignores[i].isAcceptableNature(current) && ignores[i].isOutput(current)) {
                        IPath location = current.getProject().getLocation();
                        if (location != null) {
                            String projectPath = location.removeLastSegments(1).toString();
                            File checkedResource = new File(String.valueOf(projectPath) + current.getFullPath().toString());
                            textStatus = !checkedResource.exists() ? IStateFilter.ST_NOTEXISTS : "Ignored";
                            IPath invalidMetaPath = new Path(String.valueOf(projectPath) + current.getFullPath().toString()).append(SVNUtility.getSVNFolderName());
                            FileUtility.deleteRecursive(invalidMetaPath.toFile());
                        }
                        break;
                    }
                    ++i;
                }
            }
            catch (CoreException coreException) {}
        }
        if (IStateFilter.SF_UNVERSIONED.accept(current, textStatus, changeMask) && !IStateFilter.SF_PREREPLACEDREPLACED.accept(current, textStatus, changeMask) && !IStateFilter.SF_DELETED.accept(current, textStatus, changeMask) || IStateFilter.SF_LINKED.accept(current, textStatus, changeMask)) {
            revision = -1L;
            author = null;
            date = -1L;
        }
        local = current instanceof IContainer ? new SVNLocalFolder(current, revision, baseRevision, textStatus, propStatus, changeMask, author, date, treeConflictDescriptor) : new SVNLocalFile(current, revision, baseRevision, textStatus, propStatus, changeMask, author, date, treeConflictDescriptor);
        this.writeChild(current, textStatus, changeMask);
        this.localResources.put(current.getFullPath(), local);
        return local;
    }

    protected void writeChild(IResource current, String status, int mask) {
        if (!SF_NONSVN.accept(current, status, mask)) {
            IContainer parent = current.getParent();
            HashSet<IResource> children = (HashSet<IResource>)this.parent2Children.get(parent.getFullPath());
            if (children == null) {
                children = new HashSet<IResource>();
                this.parent2Children.put(parent.getFullPath(), children);
            }
            children.add(current);
        }
    }

    protected ILocalResource getFirstExistingParentLocal(IResource node) {
        IContainer parent = node.getParent();
        if (parent == null) {
            return null;
        }
        ILocalResource local = (ILocalResource)this.localResources.get(parent.getFullPath());
        if (local != null) {
            return local;
        }
        return this.getFirstExistingParentLocal((IResource)parent);
    }

    protected String deserializeStatus(String status) {
        if ("null".equals(status)) {
            return IStateFilter.ST_NOTEXISTS;
        }
        if ("Ignored".equals(status)) {
            return "Ignored";
        }
        if ("New".equals(status)) {
            return "New";
        }
        if ("Added".equals(status)) {
            return "Added";
        }
        if ("Normal".equals(status)) {
            return "Normal";
        }
        if ("Modified".equals(status)) {
            return "Modified";
        }
        if ("Conflicting".equals(status)) {
            return "Conflicting";
        }
        if ("Deleted".equals(status)) {
            return "Deleted";
        }
        if ("Missing".equals(status)) {
            return "Missing";
        }
        if ("Obstructed".equals(status)) {
            return "Obstructed";
        }
        if ("Prereplaced".equals(status)) {
            return "Prereplaced";
        }
        if ("Replaced".equals(status)) {
            return "Replaced";
        }
        throw new RuntimeException(SVNMessages.getErrorString("Error_UnknownStatus"));
    }

    public static String getCompoundStatusString(int propStatus, int textStatus, boolean isRemoteStatus) {
        String textStr = SVNRemoteStorage.getTextStatusString(propStatus, textStatus, isRemoteStatus);
        String propStr = SVNRemoteStorage.getPropStatusString(propStatus);
        return SVNRemoteStorage.getCompoundStatusString(textStr, propStr);
    }

    public static String getCompoundStatusString(String textStatus, String propStatus) {
        String status = textStatus;
        if (propStatus == "Conflicting") {
            status = "Conflicting";
        } else if (textStatus == "Normal" && propStatus == "Modified") {
            status = "Modified";
        }
        return status;
    }

    protected static String getTextStatusString(int propKind, int textKind, boolean isRemoteStatus) {
        String status = "Normal";
        switch (textKind) {
            case 11: {
                status = "Ignored";
                break;
            }
            case 5: {
                status = isRemoteStatus ? IStateFilter.ST_NOTEXISTS : "New";
                break;
            }
            case 3: {
                status = "Added";
                break;
            }
            case 4: {
                status = "Deleted";
                break;
            }
            case 6: {
                status = "Missing";
                break;
            }
            case 9: {
                status = isRemoteStatus ? "Modified" : "Conflicting";
                break;
            }
            case 2: {
                status = "Modified";
                break;
            }
            case 10: {
                status = "Obstructed";
                break;
            }
            case 7: {
                status = "Replaced";
                break;
            }
            case 0: {
                if (isRemoteStatus || propKind != 0) break;
                status = IStateFilter.ST_NOTEXISTS;
            }
        }
        return status;
    }

    protected static String getPropStatusString(int propKind) {
        String status = "Normal";
        if (propKind == 9) {
            status = "Conflicting";
        } else if (propKind == 2) {
            status = "Modified";
        }
        return status;
    }

    protected static int getChangeMask(int textStatus, int propKind, boolean isCopied, boolean isSwitched, boolean isSVNExternals) {
        int changeMask = 0;
        if (isCopied) {
            changeMask |= 4;
        }
        if (isSwitched) {
            changeMask |= 8;
        }
        if (isSVNExternals) {
            changeMask |= 0x80;
        }
        return changeMask;
    }

    private SVNRemoteStorage() {
        this.localResources = Collections.synchronizedMap(new HashMap(500));
        this.switchedToUrls = Collections.synchronizedMap(new LinkedHashMap());
        this.parent2Children = new HashMap(500);
        this.externalsLocations = new HashMap();
        this.resourceStateListeners = new HashMap<Class, List<IResourceStatesListener>>();
        this.fetchQueue = new LinkedList();
    }
}

