/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.action.local;

import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.svn.core.IStateFilter;
import org.eclipse.team.svn.core.operation.CompositeOperation;
import org.eclipse.team.svn.core.operation.IActionOperation;
import org.eclipse.team.svn.core.operation.local.RefreshResourcesOperation;
import org.eclipse.team.svn.core.operation.local.RestoreProjectMetaOperation;
import org.eclipse.team.svn.core.operation.local.SaveProjectMetaOperation;
import org.eclipse.team.svn.core.operation.remote.ReplaceWithRemoteOperation;
import org.eclipse.team.svn.core.resource.ILocalResource;
import org.eclipse.team.svn.core.resource.IRepositoryResource;
import org.eclipse.team.svn.core.svnstorage.SVNRemoteStorage;
import org.eclipse.team.svn.ui.SVNTeamUIPlugin;
import org.eclipse.team.svn.ui.SVNUIMessages;
import org.eclipse.team.svn.ui.action.AbstractNonRecursiveTeamAction;
import org.eclipse.team.svn.ui.dialog.DefaultDialog;
import org.eclipse.team.svn.ui.dialog.ReplaceWarningDialog;
import org.eclipse.team.svn.ui.panel.local.ReplaceWithUrlPanel;
import org.eclipse.team.svn.ui.preferences.SVNTeamPreferences;

public class ReplaceWithRevisionAction
extends AbstractNonRecursiveTeamAction {
    public void runImpl(IAction action) {
        IResource[] resources = this.getSelectedResources(IStateFilter.SF_ONREPOSITORY);
        IActionOperation op = ReplaceWithRevisionAction.getReplaceOperation(resources, this.getShell());
        if (op != null) {
            this.runScheduled(op);
        }
    }

    public boolean isEnabled() {
        return this.getSelectedResources().length == 1 && this.checkForResourcesPresence(IStateFilter.SF_ONREPOSITORY);
    }

    public static IActionOperation getReplaceOperation(IResource[] resources, Shell shell) {
        ReplaceWarningDialog dialog;
        ILocalResource local;
        IRepositoryResource remote = SVNRemoteStorage.instance().asRepositoryResource(resources[0]);
        ReplaceWithUrlPanel panel = new ReplaceWithUrlPanel(remote, (local = SVNRemoteStorage.instance().asLocalResourceAccessible(resources[0])).getRevision());
        DefaultDialog selectionDialog = new DefaultDialog(shell, panel);
        if (selectionDialog.open() == 0 && (dialog = new ReplaceWarningDialog(shell)).open() == 0) {
            IRepositoryResource selected = panel.getSelectedResource();
            boolean ignoreExternals = SVNTeamPreferences.getBehaviourBoolean(SVNTeamUIPlugin.instance().getPreferenceStore(), "externals.ignore");
            CompositeOperation op = new CompositeOperation("Operation_ReplaceWithRevision", SVNUIMessages.class);
            SaveProjectMetaOperation saveOp = new SaveProjectMetaOperation(resources);
            op.add((IActionOperation)saveOp);
            op.add((IActionOperation)new ReplaceWithRemoteOperation(resources[0], selected, ignoreExternals));
            op.add((IActionOperation)new RestoreProjectMetaOperation(saveOp));
            op.add((IActionOperation)new RefreshResourcesOperation(resources));
            return op;
        }
        return null;
    }
}

