/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.panel.local;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.compare.internal.TabFolderLayout;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.team.svn.core.connector.ISVNProgressMonitor;
import org.eclipse.team.svn.core.connector.SVNNotification;
import org.eclipse.team.svn.core.connector.SVNRevision;
import org.eclipse.team.svn.core.connector.SVNRevisionRange;
import org.eclipse.team.svn.core.extension.CoreExtensionsManager;
import org.eclipse.team.svn.core.operation.CompositeOperation;
import org.eclipse.team.svn.core.operation.IActionOperation;
import org.eclipse.team.svn.core.operation.local.JavaHLMergeOperation;
import org.eclipse.team.svn.core.operation.remote.LocateResourceURLInHistoryOperation;
import org.eclipse.team.svn.core.resource.IRepositoryResource;
import org.eclipse.team.svn.core.resource.IRepositoryResourceProvider;
import org.eclipse.team.svn.core.svnstorage.SVNRemoteStorage;
import org.eclipse.team.svn.core.utility.SVNUtility;
import org.eclipse.team.svn.ui.SVNUIMessages;
import org.eclipse.team.svn.ui.composite.DepthSelectionComposite;
import org.eclipse.team.svn.ui.composite.RepositoryResourceSelectionComposite;
import org.eclipse.team.svn.ui.dialog.DefaultDialog;
import org.eclipse.team.svn.ui.panel.AbstractAdvancedDialogPanel;
import org.eclipse.team.svn.ui.panel.IDialogManagerEx;
import org.eclipse.team.svn.ui.panel.reporting.PreviewPanel;
import org.eclipse.team.svn.ui.utility.UIMonitorUtility;
import org.eclipse.team.svn.ui.verifier.AbstractVerifier;
import org.eclipse.team.svn.ui.verifier.AbstractVerifierProxy;
import org.eclipse.team.svn.ui.verifier.IValidationManager;

public class MergePanel
extends AbstractAdvancedDialogPanel {
    public static final int MODE_1URL = 0;
    public static final int MODE_2URL = 1;
    public static final int MODE_REINTEGRATE = 2;
    protected static final String FIRST_URL_HISTORY = "Merge_FirstUrl";
    protected static final String SECOND_URL_HISTORY = "Merge_SecondUrl";
    protected IResource[] to;
    protected IRepositoryResource baseResource;
    protected long currentRevision;
    protected DepthSelectionComposite depthSelector;
    protected DepthSelectionComposite depthSelectorSimple;
    protected IRepositoryResource firstSelectedResource;
    protected IRepositoryResource secondSelectedResource;
    protected SVNRevisionRange[] selectedRevisions;
    protected boolean isReverseRevisions;
    protected int mode;
    protected boolean ignoreAncestry;
    protected boolean recordOnly;
    protected RepositoryResourceSelectionComposite simpleSelectionComposite;
    protected RepositoryResourceSelectionComposite firstSelectionComposite;
    protected RepositoryResourceSelectionComposite secondSelectionComposite;
    protected RepositoryResourceSelectionComposite reintegrateSelectionComposite;
    protected Button ignoreAncestryButton;
    protected Button ignoreAncestrySimpleButton;
    protected Button recordOnlyButton;
    protected Button recordOnlySimpleButton;

    public MergePanel(IResource[] to, IRepositoryResource baseResource, long currentRevision) {
        super(new String[]{IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL}, new String[]{SVNUIMessages.MergePanel_Preview});
        this.dialogTitle = SVNUIMessages.MergePanel_Title;
        this.dialogDescription = SVNUIMessages.MergePanel_Description;
        this.defaultMessage = SVNUIMessages.MergePanel_Message;
        this.to = to;
        this.firstSelectedResource = this.secondSelectedResource = baseResource;
        this.baseResource = this.secondSelectedResource;
        this.currentRevision = currentRevision;
    }

    public int getMode() {
        return this.mode;
    }

    public Point getPrefferedSizeImpl() {
        return new Point(727, 245);
    }

    public SVNRevision getStartRevision() {
        return this.simpleSelectionComposite.getStartRevision();
    }

    public IRepositoryResource getSelectedResource() {
        IRepositoryResource retVal = SVNUtility.copyOf((IRepositoryResource)this.simpleSelectionComposite.getSelectedResource());
        retVal.setSelectedRevision(this.simpleSelectionComposite.getSecondSelectedRevision());
        return retVal;
    }

    public IRepositoryResource[] getSelection() {
        return this.getSelection(this.getSelectedResource());
    }

    public IRepositoryResource[] getFirstSelection() {
        return this.getSelection(this.firstSelectedResource);
    }

    public IRepositoryResource[] getSecondSelection() {
        return this.getSelection(this.secondSelectedResource);
    }

    public boolean getIgnoreAncestry() {
        return this.ignoreAncestry;
    }

    public boolean getRecordOnly() {
        return this.recordOnly;
    }

    public SVNRevisionRange[] getSelectedRevisions() {
        SVNRevisionRange[] revisions = null;
        if (this.selectedRevisions != null) {
            revisions = new SVNRevisionRange[this.selectedRevisions.length];
            int i = 0;
            while (i < this.selectedRevisions.length) {
                SVNRevisionRange range = this.selectedRevisions[i];
                if (range.from.equals((Object)range.to) && range.from.getKind() == 1) {
                    SVNRevision.Number from = SVNRevision.fromNumber((long)(((SVNRevision.Number)range.from).getNumber() - 1L));
                    SVNRevision to = range.from;
                    if (this.isReverseRevisions) {
                        SVNRevision.Number tmp = from;
                        from = to;
                        to = tmp;
                    }
                    range = new SVNRevisionRange((SVNRevision)from, to);
                }
                revisions[i] = range;
                ++i;
            }
        }
        return revisions;
    }

    public void createControlsImpl(Composite parent) {
        ((GridLayout)parent.getLayout()).verticalSpacing = 2;
        final TabFolder tabFolder = new TabFolder(parent, 0);
        tabFolder.setLayout((Layout)new TabFolderLayout());
        tabFolder.setLayoutData((Object)new GridData(1808));
        TabItem tabItem = new TabItem(tabFolder, 0);
        tabItem.setText(SVNUIMessages.MergePanel_1URL);
        tabItem.setControl((Control)this.create1URLModeView((Composite)tabFolder));
        tabItem = new TabItem(tabFolder, 0);
        tabItem.setText(SVNUIMessages.MergePanel_2URL);
        tabItem.setControl((Control)this.create2URLModeView((Composite)tabFolder));
        if (CoreExtensionsManager.instance().getSVNConnectorFactory().getSVNAPIVersion() >= 5) {
            tabItem = new TabItem(tabFolder, 0);
            tabItem.setText(SVNUIMessages.MergePanel_Reintegrate);
            tabItem.setControl((Control)this.createReintegrateModeView((Composite)tabFolder));
        }
        tabFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MergePanel.this.mode = tabFolder.getSelectionIndex();
                MergePanel.this.validateContent();
            }
        });
        this.mode = 0;
    }

    protected Composite create1URLModeView(Composite parent) {
        GridData data = null;
        GridLayout layout = null;
        parent = new Composite(parent, 0);
        layout = new GridLayout();
        parent.setLayout((Layout)layout);
        data = new GridData(768);
        parent.setLayoutData((Object)data);
        int mode = CoreExtensionsManager.instance().getSVNConnectorFactory().getSVNAPIVersion() >= 5 ? 2 : 1;
        this.simpleSelectionComposite = new RepositoryResourceSelectionComposite(parent, 0, new ValidationManagerProxy(this){

            protected AbstractVerifier wrapVerifier(AbstractVerifier verifier) {
                return new AbstractVerifierProxy(verifier){

                    protected boolean isVerificationEnabled(Control input) {
                        return mode == 0;
                    }
                };
            }
        }, FIRST_URL_HISTORY, this.firstSelectedResource, true, SVNUIMessages.MergePanel_Selection_Title, SVNUIMessages.MergePanel_Selection_Description, mode, 0);
        data = new GridData(768);
        this.simpleSelectionComposite.setLayoutData(data);
        this.simpleSelectionComposite.setCurrentRevision(this.currentRevision);
        Label separator = new Label(parent, 258);
        separator.setLayoutData((Object)new GridData(768));
        separator.setVisible(false);
        data = new GridData();
        this.ignoreAncestrySimpleButton = new Button(parent, 32);
        this.ignoreAncestrySimpleButton.setLayoutData((Object)data);
        this.ignoreAncestrySimpleButton.setText(SVNUIMessages.MergePanel_Button_IgnoreAncestry);
        this.ignoreAncestrySimpleButton.setSelection(this.ignoreAncestry);
        data = new GridData();
        this.recordOnlySimpleButton = new Button(parent, 32);
        this.recordOnlySimpleButton.setLayoutData((Object)data);
        this.recordOnlySimpleButton.setText(SVNUIMessages.MergePanel_Button_RecordOnly);
        this.recordOnlySimpleButton.setSelection(this.recordOnly);
        this.depthSelectorSimple = new DepthSelectionComposite(parent, 0, true);
        this.depthSelectorSimple.setLayoutData(new GridData(768));
        return parent;
    }

    protected Composite create2URLModeView(Composite parent) {
        GridData data = null;
        GridLayout layout = null;
        parent = new Composite(parent, 0);
        layout = new GridLayout();
        parent.setLayout((Layout)layout);
        data = new GridData(768);
        parent.setLayoutData((Object)data);
        final ValidationManagerProxy proxy2 = new ValidationManagerProxy(this){

            protected AbstractVerifier wrapVerifier(AbstractVerifier verifier) {
                return new AbstractVerifierProxy(verifier){

                    protected boolean isVerificationEnabled(Control input) {
                        return mode == 1;
                    }
                };
            }
        };
        ValidationManagerProxy proxy = new ValidationManagerProxy(this){

            protected AbstractVerifier wrapVerifier(AbstractVerifier verifier) {
                return new AbstractVerifierProxy(verifier){

                    protected boolean isVerificationEnabled(Control input) {
                        return mode == 1;
                    }

                    public boolean verify(Control input) {
                        for (Control cmp : proxy2.getControls()) {
                            proxy2.validateControl(cmp);
                        }
                        return super.verify(input);
                    }
                };
            }
        };
        this.firstSelectionComposite = new RepositoryResourceSelectionComposite(parent, 0, proxy, FIRST_URL_HISTORY, "MergePanel_SourceURL1", this.firstSelectedResource, true, SVNUIMessages.MergePanel_Selection_Title, SVNUIMessages.MergePanel_Selection_Description, 0, 0);
        data = new GridData(768);
        this.firstSelectionComposite.setLayoutData(data);
        this.firstSelectionComposite.setCurrentRevision(this.currentRevision);
        Label separator = new Label(parent, 258);
        separator.setLayoutData((Object)new GridData(768));
        separator.setVisible(false);
        this.secondSelectionComposite = new RepositoryResourceSelectionComposite(parent, 0, proxy2, SECOND_URL_HISTORY, "MergePanel_SourceURL2", this.secondSelectedResource, true, SVNUIMessages.MergePanel_Selection_Title, SVNUIMessages.MergePanel_Selection_Description, 0, 0);
        data = new GridData(768);
        this.secondSelectionComposite.setLayoutData(data);
        this.secondSelectionComposite.setCurrentRevision(this.currentRevision);
        separator = new Label(parent, 258);
        separator.setLayoutData((Object)new GridData(768));
        separator.setVisible(false);
        data = new GridData();
        this.ignoreAncestryButton = new Button(parent, 32);
        this.ignoreAncestryButton.setLayoutData((Object)data);
        this.ignoreAncestryButton.setText(SVNUIMessages.MergePanel_Button_IgnoreAncestry);
        this.ignoreAncestryButton.setSelection(this.ignoreAncestry);
        data = new GridData();
        this.recordOnlyButton = new Button(parent, 32);
        this.recordOnlyButton.setLayoutData((Object)data);
        this.recordOnlyButton.setText(SVNUIMessages.MergePanel_Button_RecordOnly);
        this.recordOnlyButton.setSelection(this.recordOnly);
        this.depthSelector = new DepthSelectionComposite(parent, 0, true);
        this.depthSelector.setLayoutData(new GridData(768));
        return parent;
    }

    protected Composite createReintegrateModeView(Composite parent) {
        GridData data = null;
        GridLayout layout = null;
        parent = new Composite(parent, 0);
        layout = new GridLayout();
        parent.setLayout((Layout)layout);
        data = new GridData(768);
        parent.setLayoutData((Object)data);
        this.reintegrateSelectionComposite = new RepositoryResourceSelectionComposite(parent, 0, new ValidationManagerProxy(this){

            protected AbstractVerifier wrapVerifier(AbstractVerifier verifier) {
                return new AbstractVerifierProxy(verifier){

                    protected boolean isVerificationEnabled(Control input) {
                        return mode == 2;
                    }
                };
            }
        }, FIRST_URL_HISTORY, this.firstSelectedResource, true, SVNUIMessages.MergePanel_Selection_Title, SVNUIMessages.MergePanel_Selection_Description, 0, 0);
        data = new GridData(768);
        this.reintegrateSelectionComposite.setLayoutData(data);
        this.reintegrateSelectionComposite.setCurrentRevision(this.currentRevision);
        return parent;
    }

    public int getDepth() {
        return this.mode == 0 ? this.depthSelectorSimple.getDepth() : (this.mode == 1 ? this.depthSelector.getDepth() : -2);
    }

    protected void showDetails() {
        this.saveChangesImpl();
        LocateResourceURLInHistoryOperation locateFirst = new LocateResourceURLInHistoryOperation(this.getFirstSelection());
        LocateResourceURLInHistoryOperation locateSecond = null;
        LocateResourceURLInHistoryOperation firstSet = locateFirst;
        LocateResourceURLInHistoryOperation secondSet = null;
        if (this.mode == 0) {
            firstSet = new IRepositoryResourceProvider.DefaultRepositoryResourceProvider(this.getFirstSelection());
        } else if (this.mode == 1) {
            secondSet = locateSecond = new LocateResourceURLInHistoryOperation(this.getSecondSelection());
        }
        JavaHLMergeOperation mergeOp = null;
        if (this.mode == 1) {
            mergeOp = new JavaHLMergeOperation(this.to, (IRepositoryResourceProvider)firstSet, (IRepositoryResourceProvider)secondSet, true, this.getIgnoreAncestry(), this.getDepth());
            mergeOp.setRecordOnly(this.getRecordOnly());
        } else if (this.mode == 0) {
            mergeOp = new JavaHLMergeOperation(this.to, (IRepositoryResourceProvider)firstSet, this.getSelectedRevisions(), true, this.getIgnoreAncestry(), this.getDepth());
            mergeOp.setRecordOnly(this.getRecordOnly());
        } else {
            mergeOp = new JavaHLMergeOperation(this.to, (IRepositoryResourceProvider)firstSet, true);
        }
        final StringBuffer buf = new StringBuffer();
        buf.append(SVNUIMessages.MergePanel_Preview_Header_Text);
        buf.append(SVNUIMessages.MergePanel_Preview_Header_Line);
        mergeOp.setExternalMonitor(new ISVNProgressMonitor(){

            public boolean isActivityCancelled() {
                return false;
            }

            public void progress(int current, int total, ISVNProgressMonitor.ItemState state) {
                buf.append("<b>");
                switch (state.action) {
                    case 9: {
                        buf.append(SVNUIMessages.MergePanel_Preview_Added);
                        break;
                    }
                    case 8: {
                        buf.append(SVNUIMessages.MergePanel_Preview_Deleted);
                        break;
                    }
                    case 10: {
                        buf.append(SVNUIMessages.MergePanel_Preview_Modified);
                        break;
                    }
                    default: {
                        if (SVNNotification.PerformedAction.isKnownAction((int)state.action)) {
                            buf.append(SVNNotification.PerformedAction.actionNames[state.action]);
                        } else {
                            buf.append("\t");
                        }
                        buf.append(SVNUIMessages.MergePanel_Preview_Default);
                    }
                }
                buf.append(state.path);
                buf.append("\n");
            }
        });
        if (this.mode != 0) {
            CompositeOperation op = new CompositeOperation(mergeOp.getId(), mergeOp.getMessagesClass());
            op.add((IActionOperation)locateFirst);
            if (this.mode == 1) {
                op.add((IActionOperation)locateSecond);
            }
            op.add((IActionOperation)mergeOp);
            UIMonitorUtility.doTaskNowDefault((IActionOperation)op, true);
        } else {
            UIMonitorUtility.doTaskNowDefault((IActionOperation)mergeOp, true);
        }
        if (mergeOp.getExecutionState() == 0) {
            Font font = new Font((Device)UIMonitorUtility.getDisplay(), "Courier New", 8, 0);
            new DefaultDialog(this.manager.getShell(), new PreviewPanel(SVNUIMessages.MergePanel_Preview_Title, SVNUIMessages.MergePanel_Preview_Description, SVNUIMessages.MergePanel_Preview_Message, buf.toString(), font)).open();
        }
    }

    protected void saveChangesImpl() {
        if (this.mode == 0) {
            this.firstSelectedResource = this.simpleSelectionComposite.getSelectedResource();
            this.secondSelectedResource = this.simpleSelectionComposite.getSecondSelectedResource();
            this.selectedRevisions = this.simpleSelectionComposite.getSelectedRevisions();
            this.isReverseRevisions = this.simpleSelectionComposite.isReverseRevisions();
            this.simpleSelectionComposite.saveHistory();
            this.ignoreAncestry = this.ignoreAncestrySimpleButton.getSelection();
            this.recordOnly = this.recordOnlySimpleButton.getSelection();
        } else if (this.mode == 1) {
            this.firstSelectedResource = this.firstSelectionComposite.getSelectedResource();
            this.firstSelectionComposite.saveHistory();
            this.secondSelectedResource = this.secondSelectionComposite.getSelectedResource();
            this.secondSelectionComposite.saveHistory();
            this.ignoreAncestry = this.ignoreAncestryButton.getSelection();
            this.recordOnly = this.recordOnlyButton.getSelection();
        } else {
            this.firstSelectedResource = this.secondSelectedResource = this.reintegrateSelectionComposite.getSelectedResource();
            this.reintegrateSelectionComposite.saveHistory();
        }
    }

    protected void cancelChangesImpl() {
    }

    protected void setButtonsEnabled(boolean enabled) {
        ((IDialogManagerEx)this.manager).setExtendedButtonEnabled(0, enabled);
    }

    protected IRepositoryResource[] getSelection(IRepositoryResource base) {
        if (this.to.length == 1) {
            return new IRepositoryResource[]{base};
        }
        IRepositoryResource[] retVal = new IRepositoryResource[this.to.length];
        String baseUrl = base.getUrl();
        int i = 0;
        while (i < retVal.length) {
            String url = String.valueOf(baseUrl) + "/" + SVNRemoteStorage.instance().asRepositoryResource(this.to[i]).getName();
            retVal[i] = this.to[i].getType() == 1 ? base.asRepositoryFile(url, false) : base.asRepositoryContainer(url, false);
            ++i;
        }
        return retVal;
    }

    public String getHelpId() {
        return "org.eclipse.team.svn.help.mergeDialogContext";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected abstract class ValidationManagerProxy
    implements IValidationManager {
        protected Set<Control> controls = new HashSet<Control>();

        protected ValidationManagerProxy() {
        }

        @Override
        public void attachTo(Control cmp, AbstractVerifier verifier) {
            this.controls.add(cmp);
            MergePanel.this.attachTo(cmp, this.wrapVerifier(verifier));
        }

        @Override
        public void detachFrom(Control cmp) {
            this.controls.remove(cmp);
            MergePanel.this.detachFrom(cmp);
        }

        @Override
        public void detachAll() {
            MergePanel.this.detachAll();
        }

        @Override
        public boolean isFilledRight() {
            return MergePanel.this.isFilledRight();
        }

        @Override
        public void validateContent() {
            MergePanel.this.validateContent();
        }

        @Override
        public boolean validateControl(Control cmp) {
            return MergePanel.this.validateControl(cmp);
        }

        public Set<Control> getControls() {
            return this.controls;
        }

        protected abstract AbstractVerifier wrapVerifier(AbstractVerifier var1);
    }
}

