/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.preferences;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.regex.Pattern;
import org.eclipse.compare.internal.TabFolderLayout;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.team.svn.core.SVNTeamPlugin;
import org.eclipse.team.svn.core.connector.ISVNConnector;
import org.eclipse.team.svn.core.connector.SVNConnectorException;
import org.eclipse.team.svn.core.extension.CoreExtensionsManager;
import org.eclipse.team.svn.core.extension.properties.PredefinedProperty;
import org.eclipse.team.svn.core.operation.LoggedOperation;
import org.eclipse.team.svn.core.utility.FileUtility;
import org.eclipse.team.svn.ui.SVNUIMessages;
import org.eclipse.team.svn.ui.SpellcheckedTextProvider;
import org.eclipse.team.svn.ui.dialog.DefaultDialog;
import org.eclipse.team.svn.ui.panel.common.EditAutoPropertiesPanel;
import org.eclipse.team.svn.ui.panel.common.EditCustomPropertiesPanel;
import org.eclipse.team.svn.ui.preferences.AbstractSVNTeamPreferencesPage;
import org.eclipse.team.svn.ui.preferences.SVNTeamPreferences;
import org.eclipse.ui.PlatformUI;

public class SVNTeamPropsPreferencePage
extends AbstractSVNTeamPreferencesPage {
    protected CheckboxTableViewer autopropTableViewer;
    protected Button autopropBtnAdd;
    protected Button autopropBtnEdit;
    protected Button autopropBtnRemove;
    protected Button autopropBtnExport;
    protected Button autopropBtnImport;
    protected String autoPropsValue;
    protected String customPropsValue;
    protected boolean forceTextMIME;
    protected Button forceTextMIMEButton;
    protected TableViewer custompropTableViewer;
    protected Button custompropBtnAdd;
    protected Button custompropBtnEdit;
    protected Button custompropBtnRemove;
    protected StyledText customPropDescription;
    public static final int COLUMN_INDEX_FILE_NAME = 1;
    public static final int COLUMN_INDEX_PROPERTIES = 2;
    public static final String AUTO_PROPS_CONFIG_FILE_NAME = "config";
    public static final String AUTO_PROPS_SECTION_HEADER = "[auto-props]";
    public static final String AUTO_PROPS_COMMENT_START = "#";
    public static final String AUTO_PROPS_PATTERN_SEPARATOR = "=";
    public static final String AUTO_PROPS_PROPS_SEPARATOR = ";";

    protected void saveValues(IPreferenceStore store) {
        AutoProperty property;
        int propsCount = this.autopropTableViewer.getTable().getItemCount();
        String[] props = new String[3 * propsCount];
        int i = 0;
        while (i < propsCount) {
            property = (AutoProperty)this.autopropTableViewer.getElementAt(i);
            props[3 * i] = property.enabled ? "1" : "0";
            props[3 * i + 1] = property.fileName;
            props[3 * i + 2] = property.properties;
            ++i;
        }
        this.autoPropsValue = FileUtility.encodeArrayToString((String[])props);
        SVNTeamPreferences.setAutoPropertiesList(store, "autoproperties", this.autoPropsValue);
        propsCount = this.custompropTableViewer.getTable().getItemCount();
        props = new String[3 * propsCount];
        i = 0;
        while (i < propsCount) {
            property = (PredefinedProperty)this.custompropTableViewer.getElementAt(i);
            props[3 * i] = ((PredefinedProperty)property).name;
            props[3 * i + 1] = ((PredefinedProperty)property).validationRegexp;
            props[3 * i + 2] = ((PredefinedProperty)property).description;
            ++i;
        }
        this.customPropsValue = FileUtility.encodeArrayToString((String[])props);
        SVNTeamPreferences.setCustomPropertiesList(store, "customproperties", this.customPropsValue);
        SVNTeamPreferences.setPropertiesBoolean(store, "forceTextMime", this.forceTextMIME);
    }

    protected void loadDefaultValues(IPreferenceStore store) {
        this.autoPropsValue = "";
        this.customPropsValue = "";
        this.forceTextMIME = true;
    }

    protected void loadValues(IPreferenceStore store) {
        this.autoPropsValue = SVNTeamPreferences.getAutoPropertiesList(store, "autoproperties");
        this.customPropsValue = SVNTeamPreferences.getCustomPropertiesList(store, "customproperties");
        this.forceTextMIME = SVNTeamPreferences.getPropertiesBoolean(store, "forceTextMime");
    }

    protected void initializeControls() {
        this.removeAllProperties();
        this.forceTextMIMEButton.setSelection(this.forceTextMIME);
        this.populateAutopropTable(SVNTeamPropsPreferencePage.loadAutoProperties(this.autoPropsValue));
        this.populateCustompropTable(SVNTeamPropsPreferencePage.loadCustomProperties(this.customPropsValue));
    }

    protected Control createContentsImpl(Composite parent) {
        TabFolder tabFolder = new TabFolder(parent, 0);
        tabFolder.setLayout((Layout)new TabFolderLayout());
        tabFolder.setLayoutData((Object)new GridData());
        TabItem tabItem = new TabItem(tabFolder, 0);
        tabItem.setText(SVNUIMessages.PreferencePage_automaticProperties);
        tabItem.setControl((Control)this.createAutopropsComposite(tabFolder));
        tabItem = new TabItem(tabFolder, 0);
        tabItem.setText(SVNUIMessages.PreferencePage_customProperties);
        tabItem.setControl((Control)this.createCustompropsComposite(tabFolder));
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.team.svn.help.autoPropsPreferencesContext");
        return tabFolder;
    }

    protected Composite createAutopropsComposite(TabFolder tabFolder) {
        Composite composite = new Composite((Composite)tabFolder, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 5;
        layout.marginHeight = 5;
        composite.setLayout((Layout)layout);
        GridData data = new GridData(1808);
        composite.setLayoutData((Object)data);
        this.forceTextMIMEButton = new Button(composite, 32);
        data = new GridData(768);
        data.horizontalSpan = 2;
        this.forceTextMIMEButton.setLayoutData((Object)data);
        this.forceTextMIMEButton.setText(SVNUIMessages.AutoPropsPreferencePage_forceTextMIME);
        this.forceTextMIMEButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                SVNTeamPropsPreferencePage.this.forceTextMIME = SVNTeamPropsPreferencePage.this.forceTextMIMEButton.getSelection();
            }
        });
        this.createAutopropTable(composite);
        this.createAutopropButtons(composite);
        this.autopropTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                SVNTeamPropsPreferencePage.this.autopropBtnEdit.setEnabled(selection.size() == 1);
                SVNTeamPropsPreferencePage.this.autopropBtnRemove.setEnabled(selection.size() > 0);
            }
        });
        this.autopropTableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                SVNTeamPropsPreferencePage.this.editAutoProperty();
            }
        });
        this.autopropTableViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                ((AutoProperty)event.getElement()).enabled = event.getChecked();
                SVNTeamPropsPreferencePage.this.autopropBtnExport.setEnabled(SVNTeamPropsPreferencePage.this.autopropTableViewer.getCheckedElements().length != 0);
            }
        });
        this.autopropBtnAdd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SVNTeamPropsPreferencePage.this.addAutoProperty();
                SVNTeamPropsPreferencePage.this.autopropBtnExport.setEnabled(SVNTeamPropsPreferencePage.this.autopropTableViewer.getCheckedElements().length != 0);
            }
        });
        this.autopropBtnEdit.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SVNTeamPropsPreferencePage.this.editAutoProperty();
            }
        });
        this.autopropBtnRemove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SVNTeamPropsPreferencePage.this.removeAutoProperty();
                SVNTeamPropsPreferencePage.this.autopropBtnExport.setEnabled(SVNTeamPropsPreferencePage.this.autopropTableViewer.getCheckedElements().length != 0);
            }
        });
        this.autopropBtnExport.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SVNTeamPropsPreferencePage.this.exportAutoProperties();
            }
        });
        this.autopropBtnImport.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SVNTeamPropsPreferencePage.this.importAutoProperties();
                SVNTeamPropsPreferencePage.this.autopropBtnExport.setEnabled(SVNTeamPropsPreferencePage.this.autopropTableViewer.getCheckedElements().length != 0);
            }
        });
        return composite;
    }

    protected void createAutopropTable(Composite parent) {
        this.autopropTableViewer = CheckboxTableViewer.newCheckList((Composite)parent, (int)68354);
        TableLayout layout = new TableLayout();
        layout.addColumnData((ColumnLayoutData)new ColumnPixelData(20, false));
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(25, true));
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(75, true));
        this.autopropTableViewer.getTable().setLayout((Layout)layout);
        this.autopropTableViewer.getTable().setLinesVisible(true);
        this.autopropTableViewer.getTable().setHeaderVisible(true);
        GridData data = new GridData(1808);
        data.heightHint = 200;
        this.autopropTableViewer.getTable().setLayoutData((Object)data);
        this.autopropTableViewer.setLabelProvider((IBaseLabelProvider)new ITableLabelProvider(){

            public Image getColumnImage(Object element, int columnIndex) {
                return null;
            }

            public String getColumnText(Object element, int columnIndex) {
                if (columnIndex == 1) {
                    return ((AutoProperty)element).fileName;
                }
                if (columnIndex == 2) {
                    return ((AutoProperty)element).properties;
                }
                return "";
            }

            public void addListener(ILabelProviderListener listener) {
            }

            public void dispose() {
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void removeListener(ILabelProviderListener listener) {
            }
        });
        TableColumn column = new TableColumn(this.autopropTableViewer.getTable(), 0);
        column.setResizable(false);
        column = new TableColumn(this.autopropTableViewer.getTable(), 0);
        column.setText(SVNUIMessages.AutoPropsPreferencePage_columnHeaderFileName);
        column = new TableColumn(this.autopropTableViewer.getTable(), 0);
        column.setText(SVNUIMessages.AutoPropsPreferencePage_columnHeaderProperties);
    }

    protected void createAutopropButtons(Composite parent) {
        Composite buttons = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        buttons.setLayout((Layout)layout);
        buttons.setLayoutData((Object)new GridData(2));
        this.autopropBtnAdd = this.createButton(buttons, SVNUIMessages.AutoPropsPreferencePage_buttonTextAdd, true);
        this.autopropBtnEdit = this.createButton(buttons, SVNUIMessages.AutoPropsPreferencePage_buttonTextEdit, false);
        this.autopropBtnRemove = this.createButton(buttons, SVNUIMessages.AutoPropsPreferencePage_buttonTextRemove, false);
        this.autopropBtnExport = this.createButton(buttons, SVNUIMessages.AutoPropsPreferencePage_buttonTextExport, this.autopropTableViewer.getCheckedElements().length != 0);
        this.autopropBtnImport = this.createButton(buttons, SVNUIMessages.AutoPropsPreferencePage_buttonTextImport, true);
    }

    protected Button createButton(Composite parent, String text, boolean enabled) {
        Button button = new Button(parent, 8);
        button.setText(text);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.widthHint = DefaultDialog.computeButtonWidth(button);
        button.setLayoutData((Object)data);
        button.setEnabled(enabled);
        return button;
    }

    public void addAutoProperty() {
        EditAutoPropertiesPanel panel = new EditAutoPropertiesPanel(null);
        DefaultDialog dialog = new DefaultDialog(this.getShell(), panel);
        if (dialog.open() == 0) {
            AutoProperty property = new AutoProperty(panel.getFileName(), panel.getProperties(), true);
            this.autopropTableViewer.add((Object)property);
            this.autopropTableViewer.setChecked((Object)property, property.enabled);
        }
    }

    public void editAutoProperty() {
        IStructuredSelection selection = (IStructuredSelection)this.autopropTableViewer.getSelection();
        AutoProperty property = (AutoProperty)selection.getFirstElement();
        EditAutoPropertiesPanel panel = new EditAutoPropertiesPanel(property);
        DefaultDialog dialog = new DefaultDialog(this.getShell(), panel);
        if (dialog.open() == 0) {
            property.fileName = panel.getFileName();
            property.properties = panel.getProperties();
            this.autopropTableViewer.update((Object)property, null);
        }
    }

    public void removeAutoProperty() {
        IStructuredSelection selection = (IStructuredSelection)this.autopropTableViewer.getSelection();
        this.autopropTableViewer.remove(selection.toArray());
    }

    public void removeAllProperties() {
        this.autopropTableViewer.getTable().clearAll();
        this.autopropTableViewer.refresh();
        this.custompropTableViewer.getTable().clearAll();
        this.custompropTableViewer.refresh();
    }

    public void exportAutoProperties() {
        String filePath = this.findConfigFile(SVNUIMessages.AutoPropsPreferencePage_dialogTitleExport);
        if (filePath == null) {
            return;
        }
        File srcCfg = new File(filePath);
        File tmpCfg = null;
        BufferedReader srcReader = null;
        PrintWriter tmpWriter = null;
        try {
            try {
                String line;
                tmpCfg = SVNTeamPlugin.instance().getTemporaryFile(null, srcCfg.getName());
                if (!srcCfg.exists()) {
                    srcCfg.createNewFile();
                }
                srcReader = new BufferedReader(new FileReader(srcCfg));
                tmpWriter = new PrintWriter(new FileOutputStream(tmpCfg));
                while ((line = srcReader.readLine()) != null && !line.startsWith(AUTO_PROPS_SECTION_HEADER)) {
                    tmpWriter.println(line);
                }
                tmpWriter.println(AUTO_PROPS_SECTION_HEADER);
                while ((line = srcReader.readLine()) != null && !line.trim().equals("")) {
                    tmpWriter.println(line);
                }
                Object[] checkedProps = this.autopropTableViewer.getCheckedElements();
                int i = 0;
                while (i < checkedProps.length) {
                    AutoProperty property = (AutoProperty)checkedProps[i];
                    if (!property.properties.equals("")) {
                        tmpWriter.println(String.valueOf(property.fileName) + " " + AUTO_PROPS_PATTERN_SEPARATOR + " " + property.properties);
                    }
                    ++i;
                }
                while ((line = srcReader.readLine()) != null) {
                    tmpWriter.println(line);
                }
                srcReader.close();
                tmpWriter.close();
                srcCfg.delete();
                tmpCfg.renameTo(srcCfg);
            }
            catch (IOException ioe) {
                LoggedOperation.reportError((String)SVNUIMessages.Error_ExportProperties, (Throwable)ioe);
                try {
                    if (srcReader != null) {
                        srcReader.close();
                    }
                }
                catch (IOException iOException) {}
                if (tmpWriter != null) {
                    tmpWriter.close();
                }
                if (tmpCfg != null) {
                    tmpCfg.delete();
                }
                return;
            }
        }
        catch (Throwable throwable) {
            try {
                if (srcReader != null) {
                    srcReader.close();
                }
            }
            catch (IOException iOException) {}
            if (tmpWriter != null) {
                tmpWriter.close();
            }
            if (tmpCfg != null) {
                tmpCfg.delete();
            }
            throw throwable;
        }
        try {
            if (srcReader != null) {
                srcReader.close();
            }
        }
        catch (IOException iOException) {}
        if (tmpWriter != null) {
            tmpWriter.close();
        }
        if (tmpCfg != null) {
            tmpCfg.delete();
        }
    }

    public void importAutoProperties() {
        String filePath = this.findConfigFile(SVNUIMessages.AutoPropsPreferencePage_dialogTitleImport);
        if (filePath == null) {
            return;
        }
        BufferedReader cfgReader = null;
        ArrayList<AutoProperty> autoPropsList = new ArrayList<AutoProperty>();
        try {
            try {
                String line;
                cfgReader = new BufferedReader(new FileReader(filePath));
                while ((line = cfgReader.readLine()) != null) {
                    if (line.startsWith(AUTO_PROPS_SECTION_HEADER)) break;
                }
                Pattern p = Pattern.compile("\\[.*\\]");
                while ((line = cfgReader.readLine()) != null && !p.matcher(line).matches()) {
                    if (line.startsWith(AUTO_PROPS_COMMENT_START) || line.equals("")) continue;
                    String fileName = "";
                    String properties = "";
                    int index = line.indexOf(AUTO_PROPS_PATTERN_SEPARATOR);
                    if (index != -1) {
                        fileName = line.substring(0, index).trim();
                        if (index < line.length() - 1) {
                            properties = line.substring(index + 1).trim();
                        }
                    } else {
                        fileName = line.trim();
                    }
                    autoPropsList.add(new AutoProperty(fileName, properties, true));
                }
                this.populateAutopropTable(autoPropsList.toArray());
            }
            catch (IOException ioe) {
                LoggedOperation.reportError((String)SVNUIMessages.Error_ImportProperties, (Throwable)ioe);
                try {
                    if (cfgReader != null) {
                        cfgReader.close();
                    }
                }
                catch (IOException iOException) {}
                return;
            }
        }
        catch (Throwable throwable) {
            try {
                if (cfgReader != null) {
                    cfgReader.close();
                }
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            if (cfgReader != null) {
                cfgReader.close();
            }
        }
        catch (IOException iOException) {}
    }

    public void populateAutopropTable(Object[] items) {
        int i = 0;
        while (i < items.length) {
            this.autopropTableViewer.add(items[i]);
            this.autopropTableViewer.setChecked(items[i], ((AutoProperty)items[i]).enabled);
            ++i;
        }
    }

    public void populateCustompropTable(Object[] items) {
        int i = 0;
        while (i < items.length) {
            this.custompropTableViewer.add(items[i]);
            ++i;
        }
    }

    protected Composite createCustompropsComposite(TabFolder tabFolder) {
        Composite composite = new Composite((Composite)tabFolder, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 5;
        layout.marginHeight = 5;
        composite.setLayout((Layout)layout);
        GridData data = new GridData(1808);
        composite.setLayoutData((Object)data);
        this.createCustompropTable(composite);
        this.createCustompropButtons(composite);
        data = new GridData(768);
        data.heightHint = 80;
        data.widthHint = 0;
        this.customPropDescription = SpellcheckedTextProvider.getTextWidget(composite, data, 578);
        this.customPropDescription.setText(SVNUIMessages.CustomPropsPreferencePage_description);
        this.customPropDescription.setEditable(false);
        this.custompropTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                SVNTeamPropsPreferencePage.this.refreshDescription();
                SVNTeamPropsPreferencePage.this.custompropBtnEdit.setEnabled(selection.size() == 1);
                SVNTeamPropsPreferencePage.this.custompropBtnRemove.setEnabled(selection.size() > 0);
            }
        });
        this.custompropTableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                SVNTeamPropsPreferencePage.this.editCustomProperty();
            }
        });
        this.custompropBtnAdd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SVNTeamPropsPreferencePage.this.addCustomProperty();
            }
        });
        this.custompropBtnEdit.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SVNTeamPropsPreferencePage.this.editCustomProperty();
            }
        });
        this.custompropBtnRemove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SVNTeamPropsPreferencePage.this.removeCustomProperty();
            }
        });
        return composite;
    }

    protected void createCustompropTable(Composite parent) {
        this.custompropTableViewer = new TableViewer(parent, 68354);
        TableLayout layout = new TableLayout();
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(30, true));
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(70, true));
        this.custompropTableViewer.getTable().setLayout((Layout)layout);
        this.custompropTableViewer.getTable().setLinesVisible(true);
        this.custompropTableViewer.getTable().setHeaderVisible(true);
        GridData data = new GridData(1808);
        data.heightHint = 150;
        this.custompropTableViewer.getTable().setLayoutData((Object)data);
        this.custompropTableViewer.setLabelProvider((IBaseLabelProvider)new ITableLabelProvider(){

            public Image getColumnImage(Object element, int columnIndex) {
                return null;
            }

            public String getColumnText(Object element, int columnIndex) {
                if (columnIndex == 0) {
                    return ((PredefinedProperty)element).name;
                }
                if (columnIndex == 1) {
                    return ((PredefinedProperty)element).validationRegexp;
                }
                return "";
            }

            public void addListener(ILabelProviderListener listener) {
            }

            public void dispose() {
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void removeListener(ILabelProviderListener listener) {
            }
        });
        TableColumn column = new TableColumn(this.custompropTableViewer.getTable(), 0);
        column.setText(SVNUIMessages.CustomPropsPreferencePage_columnHeaderPropName);
        column = new TableColumn(this.custompropTableViewer.getTable(), 0);
        column.setText(SVNUIMessages.CustomPropsPreferencePage_columnHeaderRegexp);
    }

    protected void createCustompropButtons(Composite parent) {
        Composite buttons = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        buttons.setLayout((Layout)layout);
        buttons.setLayoutData((Object)new GridData(2));
        this.custompropBtnAdd = this.createButton(buttons, SVNUIMessages.AutoPropsPreferencePage_buttonTextAdd, true);
        this.custompropBtnEdit = this.createButton(buttons, SVNUIMessages.AutoPropsPreferencePage_buttonTextEdit, false);
        this.custompropBtnRemove = this.createButton(buttons, SVNUIMessages.AutoPropsPreferencePage_buttonTextRemove, false);
    }

    protected void refreshDescription() {
        IStructuredSelection selection = (IStructuredSelection)this.custompropTableViewer.getSelection();
        if (selection.size() == 0) {
            this.customPropDescription.setText(SVNUIMessages.CustomPropsPreferencePage_description);
            return;
        }
        String description = ((PredefinedProperty)selection.getFirstElement()).description;
        if (description.equals("")) {
            this.customPropDescription.setText("No description available.");
        } else {
            this.customPropDescription.setText(description);
        }
    }

    public void addCustomProperty() {
        EditCustomPropertiesPanel panel = new EditCustomPropertiesPanel(null);
        DefaultDialog dialog = new DefaultDialog(this.getShell(), panel);
        if (dialog.open() == 0) {
            this.custompropTableViewer.add((Object)panel.getProperty());
        }
    }

    public void editCustomProperty() {
        IStructuredSelection selection = (IStructuredSelection)this.custompropTableViewer.getSelection();
        PredefinedProperty property = (PredefinedProperty)selection.getFirstElement();
        EditCustomPropertiesPanel panel = new EditCustomPropertiesPanel(property);
        DefaultDialog dialog = new DefaultDialog(this.getShell(), panel);
        if (dialog.open() == 0) {
            property = panel.getProperty();
            this.custompropTableViewer.update((Object)property, null);
            this.refreshDescription();
        }
    }

    public void removeCustomProperty() {
        IStructuredSelection selection = (IStructuredSelection)this.custompropTableViewer.getSelection();
        this.custompropTableViewer.remove(selection.toArray());
        this.refreshDescription();
    }

    public static PredefinedProperty[] loadCustomProperties(String encodedProps) {
        ArrayList<PredefinedProperty> propsList = new ArrayList<PredefinedProperty>();
        String[] props = FileUtility.decodeStringToArray((String)encodedProps);
        int i = 0;
        while (i < props.length) {
            String propName = props[i];
            String regexp = i + 1 == props.length ? "" : props[i + 1];
            String description = i + 2 >= props.length ? "" : props[i + 2];
            PredefinedProperty property = new PredefinedProperty(propName, description, "", regexp);
            propsList.add(property);
            i += 3;
        }
        return propsList.toArray(new PredefinedProperty[propsList.size()]);
    }

    public static Object[] loadAutoProperties(String encodedProps) {
        ArrayList<AutoProperty> propsList = new ArrayList<AutoProperty>();
        String[] props = FileUtility.decodeStringToArray((String)encodedProps);
        int i = 0;
        while (i < props.length) {
            boolean enabled = !props[i].equals("0");
            String fileName = props[i + 1];
            String properties = i + 2 == props.length ? "" : props[i + 2];
            AutoProperty property = new AutoProperty(fileName, properties, enabled);
            propsList.add(property);
            i += 3;
        }
        return propsList.toArray();
    }

    public String findConfigFile(String dialogTitle) {
        String cfgDir;
        ISVNConnector connector = CoreExtensionsManager.instance().getSVNConnectorFactory().newInstance();
        try {
            cfgDir = connector.getConfigDirectory();
        }
        catch (SVNConnectorException cwe) {
            LoggedOperation.reportError((String)SVNUIMessages.Error_FindConfigFile, (Throwable)cwe);
            return null;
        }
        FileDialog dlg = new FileDialog(this.getShell());
        dlg.setText(dialogTitle);
        dlg.setFilterPath(cfgDir);
        File cfgFile = new File(String.valueOf(cfgDir) + System.getProperty("file.separator") + AUTO_PROPS_CONFIG_FILE_NAME);
        if (cfgFile.exists()) {
            dlg.setFileName(AUTO_PROPS_CONFIG_FILE_NAME);
        }
        return dlg.open();
    }

    public static class AutoProperty {
        public String fileName;
        public String properties;
        public boolean enabled;

        public AutoProperty(String fileName, String properties, boolean enabled) {
            this.fileName = fileName;
            this.properties = properties;
            this.enabled = enabled;
        }
    }
}

