/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.utility;

import java.util.Arrays;
import java.util.HashSet;
import org.eclipse.core.resources.IResource;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.svn.core.IStateFilter;
import org.eclipse.team.svn.core.operation.CompositeOperation;
import org.eclipse.team.svn.core.operation.IActionOperation;
import org.eclipse.team.svn.core.operation.IPostCommitErrorsProvider;
import org.eclipse.team.svn.core.operation.IRevisionProvider;
import org.eclipse.team.svn.core.operation.local.AddToSVNWithPropertiesOperation;
import org.eclipse.team.svn.core.operation.local.ClearLocalStatusesOperation;
import org.eclipse.team.svn.core.operation.local.CommitOperation;
import org.eclipse.team.svn.core.operation.local.IUnresolvedConflictDetector;
import org.eclipse.team.svn.core.operation.local.RefreshResourcesOperation;
import org.eclipse.team.svn.core.operation.remote.SetRevisionAuthorNameOperation;
import org.eclipse.team.svn.core.utility.FileUtility;
import org.eclipse.team.svn.ui.action.IResourceSelector;
import org.eclipse.team.svn.ui.extension.ExtensionsManager;
import org.eclipse.team.svn.ui.operation.ClearUpdateStatusesOperation;
import org.eclipse.team.svn.ui.operation.NotifyUnresolvedConflictOperation;
import org.eclipse.team.svn.ui.operation.ShowPostCommitErrorsOperation;
import org.eclipse.team.svn.ui.operation.TreatAsEditsOperation;
import org.eclipse.ui.IWorkbenchPart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommitActionUtility {
    protected IResourceSelector selector;
    protected HashSet<IResource> newNonRecursive;
    protected HashSet<IResource> newRecursive;
    protected HashSet<IResource> parents;
    protected IResource[] allResources;
    protected HashSet<IResource> allResourcesSet;
    protected boolean canBeRecursiveCommit = true;

    public CommitActionUtility(IResourceSelector selector) {
        this.initialize(selector);
    }

    public void initialize(IResourceSelector selector) {
        this.selector = selector;
        this.allResourcesSet = new HashSet();
        this.allResourcesSet.addAll(Arrays.asList(this.selector.getSelectedResourcesRecursive((IStateFilter)new IStateFilter.OrStateFilter(new IStateFilter[]{IStateFilter.SF_COMMITABLE, IStateFilter.SF_CONFLICTING, IStateFilter.SF_TREE_CONFLICTING, IStateFilter.SF_NEW}))));
        this.newNonRecursive = new HashSet<IResource>(Arrays.asList(this.selector.getSelectedResources(IStateFilter.SF_IGNORED_BUT_NOT_EXTERNAL)));
        this.newRecursive = new HashSet<IResource>(Arrays.asList(FileUtility.getResourcesRecursive((IResource[])this.allResourcesSet.toArray(new IResource[this.allResourcesSet.size()]), (IStateFilter)IStateFilter.SF_NEW, (int)0)));
        HashSet<IResource> fullSet = new HashSet<IResource>(this.newNonRecursive);
        fullSet.addAll(this.newRecursive);
        this.parents = new HashSet<IResource>(Arrays.asList(FileUtility.getOperableParents((IResource[])fullSet.toArray(new IResource[fullSet.size()]), (IStateFilter)IStateFilter.SF_UNVERSIONED)));
        this.newNonRecursive.addAll(this.parents);
        fullSet.addAll(this.parents);
        this.allResourcesSet.addAll(fullSet);
        this.allResources = this.allResourcesSet.toArray(new IResource[this.allResourcesSet.size()]);
        this.allResourcesSet.addAll(Arrays.asList(FileUtility.addOperableParents((IResource[])this.allResources, (IStateFilter)IStateFilter.SF_ADDED, (boolean)true)));
        this.allResources = this.allResourcesSet.toArray(new IResource[this.allResourcesSet.size()]);
        boolean bl = this.canBeRecursiveCommit = FileUtility.getOperableParents((IResource[])this.selector.getSelectedResources(), (IStateFilter)IStateFilter.SF_ADDED, (boolean)false).length == 0;
        if (this.canBeRecursiveCommit && FileUtility.checkForResourcesPresence((IResource[])this.allResources, (IStateFilter)IStateFilter.SF_SWITCHED, (int)0)) {
            this.canBeRecursiveCommit = false;
        }
    }

    public HashSet<IResource> getAllResourcesSet() {
        return this.allResourcesSet;
    }

    public IResource[] getAllResources() {
        return this.allResources;
    }

    public CompositeOperation getCompositeCommitOperation(IResource[] selectedResources, IResource[] treatAsEdits, String message, boolean keepLocks, Shell shell, IWorkbenchPart part) {
        return this.getNonRecursiveImpl(selectedResources, treatAsEdits, message, keepLocks, shell, part);
    }

    public CompositeOperation getCompositeCommitOperation(IResource[] selectedResources, IResource[] notSelectedResources, IResource[] treatAsEdits, String message, boolean keepLocks, Shell shell, IWorkbenchPart part, boolean tryRecursive) {
        return this.canBeRecursiveCommit && tryRecursive ? this.getRecursiveImpl(selectedResources, notSelectedResources, treatAsEdits, message, keepLocks, shell, part) : this.getNonRecursiveImpl(selectedResources, treatAsEdits, message, keepLocks, shell, part);
    }

    protected CompositeOperation getRecursiveImpl(IResource[] selectedResources, IResource[] notSelectedResources, IResource[] treatAsEdits, String message, boolean keepLocks, Shell shell, IWorkbenchPart part) {
        IResource[] notSelectedNew = FileUtility.getResourcesRecursive((IResource[])notSelectedResources, (IStateFilter)IStateFilter.SF_UNVERSIONED, (int)0);
        boolean allowsRecursiveAdd = true;
        int i = 0;
        while (i < notSelectedNew.length) {
            if (this.newRecursive.remove(notSelectedNew[i])) {
                allowsRecursiveAdd = false;
            } else if (!this.parents.contains(notSelectedNew[i])) {
                this.newNonRecursive.remove(notSelectedNew[i]);
            }
            ++i;
        }
        CommitOperation mainOp = new CommitOperation(notSelectedResources.length == 0 ? this.selector.getSelectedResources() : selectedResources, message, allowsRecursiveAdd && notSelectedNew.length == notSelectedResources.length, keepLocks);
        CompositeOperation op = new CompositeOperation(mainOp.getId(), mainOp.getMessagesClass());
        if (treatAsEdits != null && treatAsEdits.length > 0) {
            op.add((IActionOperation)new TreatAsEditsOperation(treatAsEdits));
        }
        if (allowsRecursiveAdd) {
            if (this.newNonRecursive.size() > 0) {
                IResource[] newNonRecursive = this.newNonRecursive.toArray(new IResource[this.newNonRecursive.size()]);
                op.add((IActionOperation)new AddToSVNWithPropertiesOperation(newNonRecursive, false));
                op.add((IActionOperation)new ClearLocalStatusesOperation(newNonRecursive));
            }
            if (this.newRecursive.size() > 0) {
                IResource[] newRecursive = this.newRecursive.toArray(new IResource[this.newRecursive.size()]);
                op.add((IActionOperation)new AddToSVNWithPropertiesOperation(newRecursive, true));
                op.add((IActionOperation)new ClearLocalStatusesOperation(newRecursive));
            }
        } else {
            this.newNonRecursive.addAll(this.newRecursive);
            this.newRecursive.clear();
            IResource[] newNonRecursive = this.newNonRecursive.toArray(new IResource[this.newNonRecursive.size()]);
            op.add((IActionOperation)new AddToSVNWithPropertiesOperation(newNonRecursive, false));
            op.add((IActionOperation)new ClearLocalStatusesOperation(newNonRecursive));
        }
        this.addCommonPart(selectedResources, op, mainOp, shell, part);
        op.add((IActionOperation)new SetRevisionAuthorNameOperation((IRevisionProvider)mainOp, 4L), new IActionOperation[]{mainOp});
        return op;
    }

    protected CompositeOperation getNonRecursiveImpl(IResource[] selectedResources, IResource[] treatAsEdits, String message, boolean keepLocks, Shell shell, IWorkbenchPart part) {
        IResource[] newResources;
        CommitOperation mainOp = new CommitOperation(selectedResources, message, false, keepLocks);
        CompositeOperation op = new CompositeOperation(mainOp.getId(), mainOp.getMessagesClass());
        if (treatAsEdits != null && treatAsEdits.length > 0) {
            op.add((IActionOperation)new TreatAsEditsOperation(treatAsEdits));
        }
        if ((newResources = FileUtility.getResourcesRecursive((IResource[])selectedResources, (IStateFilter)IStateFilter.SF_UNVERSIONED, (int)0)).length > 0) {
            op.add((IActionOperation)new AddToSVNWithPropertiesOperation(newResources, false));
            op.add((IActionOperation)new ClearLocalStatusesOperation(newResources));
        }
        this.addCommonPart(selectedResources, op, mainOp, shell, part);
        op.add((IActionOperation)new SetRevisionAuthorNameOperation((IRevisionProvider)mainOp, 4L), new IActionOperation[]{mainOp});
        return op;
    }

    protected void addCommonPart(IResource[] selectedResources, CompositeOperation op, CommitOperation mainOp, Shell shell, IWorkbenchPart part) {
        op.add((IActionOperation)mainOp);
        op.add((IActionOperation)new ClearUpdateStatusesOperation(selectedResources), new IActionOperation[]{mainOp});
        op.add((IActionOperation)new RefreshResourcesOperation(selectedResources));
        op.add((IActionOperation)new NotifyUnresolvedConflictOperation((IUnresolvedConflictDetector)mainOp));
        op.add((IActionOperation)new ShowPostCommitErrorsOperation((IPostCommitErrorsProvider)mainOp));
        ExtensionsManager.getInstance().getCurrentCommitFactory().performAfterCommitTasks(op, (IRevisionProvider)mainOp, null, part);
    }
}

