/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.utils.gef;

import com.google.common.collect.Lists;
import java.util.List;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.wb.gef.core.EditPart;
import org.eclipse.wb.gef.core.IEditPartViewer;
import org.eclipse.wb.internal.draw2d.events.EventTable;

public final class EditPartsSelectionProvider
implements ISelectionProvider {
    private final IEditPartViewer m_viewer;
    private final EventTable m_eventTable = new EventTable();
    private final ISelectionChangedListener m_selectionListener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent event) {
            EditPartsSelectionProvider.this.fireSelectionChanged();
        }
    };

    public EditPartsSelectionProvider(IEditPartViewer viewer) {
        this.m_viewer = viewer;
    }

    public ISelection getSelection() {
        List models = Lists.newArrayList();
        for (EditPart editPart : this.m_viewer.getSelectedEditParts()) {
            models.add(editPart.getModel());
        }
        return new StructuredSelection(models);
    }

    public void setSelection(ISelection selection) {
        List editParts = Lists.newArrayList();
        for (Object model : (StructuredSelection)selection) {
            EditPart editPart = this.m_viewer.getEditPartByModel(model);
            if (editPart == null) continue;
            editParts.add(editPart);
        }
        this.m_viewer.setSelection(editParts);
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.m_eventTable.addListener(ISelectionChangedListener.class, listener);
        if (this.m_eventTable.getListeners(ISelectionChangedListener.class).size() == 1) {
            this.m_viewer.addSelectionChangedListener(this.m_selectionListener);
        }
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.m_eventTable.removeListener(ISelectionChangedListener.class, listener);
        if (this.m_eventTable.getListeners(ISelectionChangedListener.class).isEmpty()) {
            this.m_viewer.removeSelectionChangedListener(this.m_selectionListener);
        }
    }

    private void fireSelectionChanged() {
        ISelection selection = this.getSelection();
        SelectionChangedEvent event = new SelectionChangedEvent((ISelectionProvider)this, selection);
        for (ISelectionChangedListener listener : this.m_eventTable.getListeners(ISelectionChangedListener.class)) {
            listener.selectionChanged(event);
        }
    }
}

