/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.wizards;

import org.eclipse.core.resources.IFile;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;
import org.eclipse.wst.jsdt.internal.ui.JavaPluginImages;
import org.eclipse.wst.jsdt.internal.ui.JavaScriptPlugin;
import org.eclipse.wst.jsdt.internal.ui.wizards.NewJSFileWizardPage;
import org.eclipse.wst.jsdt.internal.ui.wizards.NewWizardMessages;

public class NewJSWizard
extends Wizard
implements INewWizard {
    private NewJSFileWizardPage fNewFilePage;
    private IStructuredSelection fSelection;
    private IWorkbench fWorkbench;

    public void addPages() {
        this.fNewFilePage = new NewJSFileWizardPage("JSWizardNewFileCreationPage", (IStructuredSelection)new StructuredSelection(IDE.computeSelectedResources((IStructuredSelection)this.fSelection)));
        this.fNewFilePage.setTitle(NewWizardMessages.Javascript_UI_Wizard_New_Heading);
        this.fNewFilePage.setDescription(NewWizardMessages.Javascript_UI_Wizard_New_Description);
        this.addPage((IWizardPage)this.fNewFilePage);
    }

    public void init(IWorkbench workbench, IStructuredSelection aSelection) {
        this.fWorkbench = workbench;
        this.fSelection = aSelection;
        this.setWindowTitle(NewWizardMessages.Javascript_UI_Wizard_New_Title);
        this.setDefaultPageImageDescriptor(JavaPluginImages.DESC_WIZBAN_NEWJSFILE);
    }

    private void openEditor(final IFile file) {
        if (file != null) {
            this.fWorkbench.getDisplay().asyncExec(new Runnable(){

                public void run() {
                    try {
                        IWorkbenchPage page;
                        IWorkbenchWindow activeWorkbenchWindow = NewJSWizard.this.fWorkbench.getActiveWorkbenchWindow();
                        if (activeWorkbenchWindow != null && (page = activeWorkbenchWindow.getActivePage()) != null) {
                            IDE.openEditor((IWorkbenchPage)page, (IFile)file, (boolean)true, (boolean)false);
                        }
                    }
                    catch (PartInitException e) {
                        JavaScriptPlugin.log(e);
                    }
                }
            });
        }
    }

    public boolean performFinish() {
        boolean performedOK = false;
        String fileName = this.fNewFilePage.getFileName();
        if (fileName.lastIndexOf(46) == -1) {
            String newFileName = this.fNewFilePage.addDefaultExtension(fileName);
            this.fNewFilePage.setFileName(newFileName);
        }
        IFile file = this.fNewFilePage.createNewFile();
        this.fNewFilePage.addFileComment(file, false);
        if (file != null) {
            this.openEditor(file);
            performedOK = true;
        }
        return performedOK;
    }
}

