/*
 * Decompiled with CFR 0.152.
 */
package org.h2.table;

import java.sql.SQLException;
import java.util.HashMap;
import org.h2.engine.Session;
import org.h2.expression.Expression;
import org.h2.table.PlanItem;
import org.h2.table.TableFilter;
import org.h2.util.New;
import org.h2.util.ObjectArray;
import org.h2.util.ObjectUtils;

public class Plan {
    private final TableFilter[] filters;
    private final HashMap<TableFilter, PlanItem> planItems = New.hashMap();
    private final Expression[] allConditions;
    private final TableFilter[] allFilters;

    public Plan(TableFilter[] tableFilterArray, int n, Expression expression) {
        this.filters = new TableFilter[n];
        ObjectUtils.arrayCopy(tableFilterArray, this.filters, n);
        ObjectArray<Expression> objectArray = ObjectArray.newInstance();
        ObjectArray<TableFilter> objectArray2 = ObjectArray.newInstance();
        if (expression != null) {
            objectArray.add(expression);
        }
        for (int i = 0; i < n; ++i) {
            TableFilter tableFilter = tableFilterArray[i];
            do {
                objectArray2.add(tableFilter);
                if (tableFilter.getJoinCondition() == null) continue;
                objectArray.add(tableFilter.getJoinCondition());
            } while ((tableFilter = tableFilter.getJoin()) != null);
        }
        this.allConditions = new Expression[objectArray.size()];
        objectArray.toArray(this.allConditions);
        this.allFilters = new TableFilter[objectArray2.size()];
        objectArray2.toArray(this.allFilters);
    }

    public PlanItem getItem(TableFilter tableFilter) {
        return this.planItems.get(tableFilter);
    }

    public TableFilter[] getFilters() {
        return this.filters;
    }

    public void removeUnusableIndexConditions() {
        for (int i = 0; i < this.allFilters.length; ++i) {
            TableFilter tableFilter = this.allFilters[i];
            this.setEvaluatable(tableFilter, true);
            if (i < this.allFilters.length - 1) {
                tableFilter.optimizeFullCondition(false);
            }
            tableFilter.removeUnusableIndexConditions();
        }
        for (TableFilter tableFilter : this.allFilters) {
            this.setEvaluatable(tableFilter, false);
        }
    }

    public double calculateCost(Session session) throws SQLException {
        double d = 1.0;
        boolean bl = false;
        for (TableFilter tableFilter : this.allFilters) {
            PlanItem planItem = tableFilter.getBestPlanItem(session);
            this.planItems.put(tableFilter, planItem);
            d += d * planItem.cost;
            this.setEvaluatable(tableFilter, true);
            Expression expression = tableFilter.getJoinCondition();
            if (expression == null || expression.isEverything(3)) continue;
            bl = true;
            break;
        }
        if (bl) {
            d = Double.POSITIVE_INFINITY;
        }
        for (TableFilter tableFilter : this.allFilters) {
            this.setEvaluatable(tableFilter, false);
        }
        return d;
    }

    private void setEvaluatable(TableFilter tableFilter, boolean bl) {
        for (Expression expression : this.allConditions) {
            expression.setEvaluatable(tableFilter, bl);
        }
    }
}

