/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwtorm.jdbc.gen;

import com.google.gwtorm.client.OrmException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class GeneratedClassLoader
extends ClassLoader {
    private static final boolean debugCodeGen;
    private static final Method defineClass;

    public GeneratedClassLoader(ClassLoader parent) {
        super(parent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void defineClass(String name, byte[] code) throws OrmException {
        if (debugCodeGen) {
            File outClassFile = new File("generated_classes/" + name.replace('.', '/') + ".class");
            outClassFile.getParentFile().mkdirs();
            try {
                FileOutputStream out = new FileOutputStream(outClassFile);
                try {
                    out.write(code);
                }
                finally {
                    out.close();
                }
            }
            catch (IOException e) {
                throw new OrmException("Cannot save debug class " + outClassFile, e);
            }
        }
        try {
            defineClass.invoke((Object)this.getParent(), name, code, 0, code.length);
        }
        catch (IllegalArgumentException e) {
            throw new OrmException("Unable to inject class " + name, e);
        }
        catch (SecurityException e) {
            throw new OrmException("Unable to inject class " + name, e);
        }
        catch (IllegalAccessException e) {
            throw new OrmException("Unable to inject class " + name, e);
        }
        catch (InvocationTargetException e) {
            throw new OrmException("Unable to inject class " + name, e);
        }
    }

    static {
        Method m;
        debugCodeGen = "true".equals(System.getProperty("gwtorm.debugCodeGen"));
        try {
            m = ClassLoader.class.getDeclaredMethod("defineClass", String.class, byte[].class, Integer.TYPE, Integer.TYPE);
            m.setAccessible(true);
        }
        catch (SecurityException e) {
            throw new LinkageError("No defineClass in ClassLoader");
        }
        catch (NoSuchMethodException e) {
            throw new LinkageError("No defineClass in ClassLoader");
        }
        defineClass = m;
    }
}

