/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.nattable.viewport.event;

import java.util.Collection;
import net.sourceforge.nattable.coordinate.Range;
import net.sourceforge.nattable.layer.event.ILayerEventHandler;
import net.sourceforge.nattable.layer.event.IStructuralChangeEvent;
import net.sourceforge.nattable.layer.event.StructuralDiff;
import net.sourceforge.nattable.viewport.ViewportLayer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ViewportEventHandler
implements ILayerEventHandler<IStructuralChangeEvent> {
    private final ViewportLayer viewportLayer;

    public ViewportEventHandler(ViewportLayer viewportLayer) {
        this.viewportLayer = viewportLayer;
    }

    @Override
    public Class<IStructuralChangeEvent> getLayerEventClass() {
        return IStructuralChangeEvent.class;
    }

    @Override
    public void handleLayerEvent(IStructuralChangeEvent event) {
        Collection<StructuralDiff> rowDiffs;
        Collection<StructuralDiff> columnDiffs;
        if (event.isHorizontalStructureChanged()) {
            this.viewportLayer.invalidateHorizontalStructure();
        }
        if (event.isVerticalStructureChanged()) {
            this.viewportLayer.invalidateVerticalStructure();
        }
        if ((columnDiffs = event.getColumnDiffs()) != null) {
            int columnOffset = 0;
            int minimumOriginColumnPosition = this.viewportLayer.getMinimumOriginColumnPosition();
            for (StructuralDiff columnDiff : columnDiffs) {
                switch (columnDiff.getDiffType()) {
                    case ADD: {
                        Range afterPositionRange = columnDiff.getAfterPositionRange();
                        if (afterPositionRange.start >= minimumOriginColumnPosition) break;
                        columnOffset += afterPositionRange.size();
                        break;
                    }
                    case DELETE: {
                        Range beforePositionRange = columnDiff.getBeforePositionRange();
                        if (beforePositionRange.start >= minimumOriginColumnPosition) break;
                        columnOffset -= Math.min(beforePositionRange.end, minimumOriginColumnPosition + 1) - beforePositionRange.start;
                    }
                }
            }
            this.viewportLayer.setMinimumOriginColumnPosition(minimumOriginColumnPosition + columnOffset);
        }
        if ((rowDiffs = event.getRowDiffs()) != null) {
            int rowOffset = 0;
            int minimumOriginRowPosition = this.viewportLayer.getMinimumOriginRowPosition();
            for (StructuralDiff rowDiff : rowDiffs) {
                switch (rowDiff.getDiffType()) {
                    case ADD: {
                        Range afterPositionRange = rowDiff.getAfterPositionRange();
                        if (afterPositionRange.start >= minimumOriginRowPosition) break;
                        rowOffset += afterPositionRange.size();
                        break;
                    }
                    case DELETE: {
                        Range beforePositionRange = rowDiff.getBeforePositionRange();
                        if (beforePositionRange.start >= minimumOriginRowPosition) break;
                        rowOffset -= Math.min(beforePositionRange.end, minimumOriginRowPosition + 1) - beforePositionRange.start;
                    }
                }
            }
            this.viewportLayer.setMinimumOriginRowPosition(minimumOriginRowPosition + rowOffset);
        }
    }
}

