/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.util;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.lucene.document.Document;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.DisjunctionMaxQuery;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.AppendedSolrParams;
import org.apache.solr.common.params.DefaultSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.core.SolrCore;
import org.apache.solr.highlight.SolrHighlighter;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.CacheRegenerator;
import org.apache.solr.search.DocIterator;
import org.apache.solr.search.DocList;
import org.apache.solr.search.DocSet;
import org.apache.solr.search.QParser;
import org.apache.solr.search.QueryParsing;
import org.apache.solr.search.SolrCache;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.search.SolrQueryParser;
import org.apache.solr.search.function.FunctionQuery;
import org.apache.solr.update.DocumentBuilder;
import org.apache.solr.util.CommonParams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SolrPluginUtils {
    static final Logger log = LoggerFactory.getLogger(SolrPluginUtils.class);
    @Deprecated
    public static String FL = "fl";
    private static final Pattern splitList = Pattern.compile(",| ");
    private static final Pattern DANGLING_OP_PATTERN = Pattern.compile("\\s+[-+\\s]+$");
    private static final Pattern CONSECUTIVE_OP_PATTERN = Pattern.compile("\\s+[+-](?:\\s*[+-]+)+");

    public static void setDefaults(SolrQueryRequest req, SolrParams defaults) {
        SolrPluginUtils.setDefaults(req, defaults, null, null);
    }

    public static void setDefaults(SolrQueryRequest req, SolrParams defaults, SolrParams appends, SolrParams invariants) {
        SolrParams p = req.getParams();
        if (defaults != null) {
            p = new DefaultSolrParams(p, defaults);
        }
        if (appends != null) {
            p = new AppendedSolrParams(p, appends);
        }
        if (invariants != null) {
            p = new DefaultSolrParams(invariants, p);
        }
        req.setParams(p);
    }

    public static int numDocs(SolrIndexSearcher s, Query q, Query f) throws IOException {
        return null == f ? s.getDocSet(q).size() : s.numDocs(q, f);
    }

    @Deprecated
    public static String getParam(SolrQueryRequest req, String param, String def) {
        String v = req.getParam(param);
        if (null == v || "".equals(v.trim())) {
            return def;
        }
        return v;
    }

    @Deprecated
    public static Number getNumberParam(SolrQueryRequest req, String param, Number def) {
        Number r = def;
        String v = req.getParam(param);
        if (null == v || "".equals(v.trim())) {
            return r;
        }
        try {
            r = new Float(v);
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        return r;
    }

    @Deprecated
    public static boolean getBooleanParam(SolrQueryRequest req, String param, boolean def) {
        String v = req.getParam(param);
        if (null == v || "".equals(v.trim())) {
            return def;
        }
        return !"false".equals(v.trim());
    }

    public static String[] split(String value) {
        return splitList.split(value.trim(), 0);
    }

    public static int setReturnFields(SolrQueryRequest req, SolrQueryResponse res) {
        return SolrPluginUtils.setReturnFields(req.getParams().get("fl"), res);
    }

    public static int setReturnFields(String fl, SolrQueryResponse res) {
        String[] flst;
        int flags = 0;
        if (fl != null && (flst = SolrPluginUtils.split(fl)).length > 0 && (flst.length != 1 || flst[0].length() != 0)) {
            LinkedHashSet<String> set = new LinkedHashSet<String>();
            for (String fname : flst) {
                if ("score".equalsIgnoreCase(fname)) {
                    flags |= 1;
                }
                set.add(fname);
            }
            res.setReturnFields(set);
        }
        return flags;
    }

    public static void optimizePreFetchDocs(DocList docs, Query query, SolrQueryRequest req, SolrQueryResponse res) throws IOException {
        SolrIndexSearcher searcher = req.getSearcher();
        if (!searcher.enableLazyFieldLoading) {
            return;
        }
        HashSet<String> fieldFilter = null;
        Set<String> returnFields = res.getReturnFields();
        if (returnFields != null) {
            SchemaField keyField;
            fieldFilter = new HashSet<String>(returnFields);
            SolrHighlighter highligher = req.getCore().getHighlighter();
            if (highligher.isHighlightingEnabled(req.getParams())) {
                for (String field : highligher.getHighlightFields(query, req, null)) {
                    fieldFilter.add(field);
                }
            }
            if (null != (keyField = req.getSearcher().getSchema().getUniqueKeyField())) {
                fieldFilter.add(keyField.getName());
            }
        }
        DocIterator iter = docs.iterator();
        for (int i = 0; i < docs.size(); ++i) {
            searcher.doc(iter.nextDoc(), fieldFilter);
        }
    }

    @Deprecated
    public static NamedList doStandardDebug(SolrQueryRequest req, String userQuery, Query query, DocList results, CommonParams params) throws IOException {
        String debug = SolrPluginUtils.getParam(req, "debugQuery", params.debugQuery);
        SimpleOrderedMap dbg = null;
        if (debug != null) {
            dbg = new SimpleOrderedMap();
            dbg.add("rawquerystring", (Object)req.getQueryString());
            dbg.add("querystring", (Object)userQuery);
            dbg.add("parsedquery", (Object)QueryParsing.toString(query, req.getSchema()));
            dbg.add("parsedquery_toString", (Object)query.toString());
            dbg.add("explain", (Object)SolrPluginUtils.getExplainList(query, results, req.getSearcher(), req.getSchema()));
            String otherQueryS = req.getParam("explainOther");
            if (otherQueryS != null && otherQueryS.length() > 0) {
                DocList otherResults = SolrPluginUtils.doSimpleQuery(otherQueryS, req, 0, 10);
                dbg.add("otherQuery", (Object)otherQueryS);
                dbg.add("explainOther", (Object)SolrPluginUtils.getExplainList(query, otherResults, req.getSearcher(), req.getSchema()));
            }
        }
        return dbg;
    }

    public static NamedList doStandardDebug(SolrQueryRequest req, String userQuery, Query query, DocList results) throws IOException {
        String debug = req.getParams().get("debugQuery");
        SimpleOrderedMap dbg = null;
        if (debug != null) {
            dbg = new SimpleOrderedMap();
            SolrIndexSearcher searcher = req.getSearcher();
            IndexSchema schema = req.getSchema();
            boolean explainStruct = req.getParams().getBool("debug.explain.structured", false);
            dbg.add("rawquerystring", (Object)req.getParams().get("q"));
            dbg.add("querystring", (Object)userQuery);
            dbg.add("parsedquery", (Object)QueryParsing.toString(query, schema));
            dbg.add("parsedquery_toString", (Object)query.toString());
            NamedList<Explanation> explain = SolrPluginUtils.getExplanations(query, results, searcher, schema);
            dbg.add("explain", explainStruct ? SolrPluginUtils.explanationsToNamedLists(explain) : SolrPluginUtils.explanationsToStrings(explain));
            String otherQueryS = req.getParams().get("explainOther");
            if (otherQueryS != null && otherQueryS.length() > 0) {
                DocList otherResults = SolrPluginUtils.doSimpleQuery(otherQueryS, req, 0, 10);
                dbg.add("otherQuery", (Object)otherQueryS);
                NamedList<Explanation> explainO = SolrPluginUtils.getExplanations(query, otherResults, searcher, schema);
                dbg.add("explainOther", explainStruct ? SolrPluginUtils.explanationsToNamedLists(explainO) : SolrPluginUtils.explanationsToStrings(explainO));
            }
        }
        return dbg;
    }

    public static NamedList<Object> explanationToNamedList(Explanation e) {
        SimpleOrderedMap out = new SimpleOrderedMap();
        out.add("match", (Object)e.isMatch());
        out.add("value", (Object)Float.valueOf(e.getValue()));
        out.add("description", (Object)e.getDescription());
        Explanation[] details = e.getDetails();
        if (null == details || 0 == details.length) {
            return out;
        }
        ArrayList<NamedList<Object>> kids = new ArrayList<NamedList<Object>>(details.length);
        for (Explanation d : details) {
            kids.add(SolrPluginUtils.explanationToNamedList(d));
        }
        out.add("details", kids);
        return out;
    }

    public static NamedList<NamedList<Object>> explanationsToNamedLists(NamedList<Explanation> explanations) {
        SimpleOrderedMap out = new SimpleOrderedMap();
        for (Map.Entry entry : explanations) {
            out.add((String)entry.getKey(), SolrPluginUtils.explanationToNamedList((Explanation)entry.getValue()));
        }
        return out;
    }

    public static NamedList<Explanation> getExplanations(Query query, DocList docs, SolrIndexSearcher searcher, IndexSchema schema) throws IOException {
        SimpleOrderedMap explainList = new SimpleOrderedMap();
        DocIterator iterator = docs.iterator();
        for (int i = 0; i < docs.size(); ++i) {
            int id = iterator.nextDoc();
            Document doc = searcher.doc(id);
            String strid = schema.printableUniqueKey(doc);
            explainList.add(strid, (Object)searcher.explain(query, id));
        }
        return explainList;
    }

    private static NamedList<String> explanationsToStrings(NamedList<Explanation> explanations) {
        SimpleOrderedMap out = new SimpleOrderedMap();
        for (Map.Entry entry : explanations) {
            out.add((String)entry.getKey(), (Object)("\n" + ((Explanation)entry.getValue()).toString()));
        }
        return out;
    }

    @Deprecated
    public static NamedList getExplainList(Query query, DocList docs, SolrIndexSearcher searcher, IndexSchema schema) throws IOException {
        return SolrPluginUtils.explanationsToStrings(SolrPluginUtils.getExplanations(query, docs, searcher, schema));
    }

    public static DocList doSimpleQuery(String sreq, SolrQueryRequest req, int start, int limit) throws IOException {
        List commands = StrUtils.splitSmart((String)sreq, (char)';');
        String qs = commands.size() >= 1 ? (String)commands.get(0) : "";
        try {
            Query query = QParser.getParser(qs, null, req).getQuery();
            Sort sort = null;
            if (commands.size() >= 2) {
                sort = QueryParsing.parseSort((String)commands.get(1), req);
            }
            DocList results = req.getSearcher().getDocList(query, (DocSet)null, sort, start, limit);
            return results;
        }
        catch (ParseException e) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Error parsing query: " + qs);
        }
    }

    public static Map<String, Float> parseFieldBoosts(String in) {
        return SolrPluginUtils.parseFieldBoosts(new String[]{in});
    }

    public static Map<String, Float> parseFieldBoosts(String[] fieldLists) {
        if (null == fieldLists || 0 == fieldLists.length) {
            return new HashMap<String, Float>();
        }
        HashMap<String, Float> out = new HashMap<String, Float>(7);
        for (String in : fieldLists) {
            String[] bb;
            if (null == in || "".equals(in.trim())) continue;
            for (String s : bb = in.trim().split("\\s+")) {
                String[] bbb = s.split("\\^");
                out.put(bbb[0], 1 == bbb.length ? null : Float.valueOf(bbb[1]));
            }
        }
        return out;
    }

    @Deprecated
    public static List<Query> parseFuncs(IndexSchema s, String in) throws ParseException {
        Map<String, Float> ff = SolrPluginUtils.parseFieldBoosts(in);
        ArrayList<Query> funcs = new ArrayList<Query>(ff.keySet().size());
        for (String f : ff.keySet()) {
            FunctionQuery fq = QueryParsing.parseFunction(f, s);
            Float b = ff.get(f);
            if (null != b) {
                fq.setBoost(b.floatValue());
            }
            funcs.add(fq);
        }
        return funcs;
    }

    public static void setMinShouldMatch(BooleanQuery q, String spec) {
        int optionalClauses = 0;
        for (BooleanClause c : q.clauses()) {
            if (c.getOccur() != BooleanClause.Occur.SHOULD) continue;
            ++optionalClauses;
        }
        int msm = SolrPluginUtils.calculateMinShouldMatch(optionalClauses, spec);
        if (0 < msm) {
            q.setMinimumNumberShouldMatch(msm);
        }
    }

    static int calculateMinShouldMatch(int optionalClauseCount, String spec) {
        int result = optionalClauseCount;
        if (-1 < spec.indexOf("<")) {
            for (String s : spec.trim().split(" ")) {
                String[] parts = s.split("<");
                int upperBound = new Integer(parts[0]);
                if (optionalClauseCount <= upperBound) {
                    return result;
                }
                result = SolrPluginUtils.calculateMinShouldMatch(optionalClauseCount, parts[1]);
            }
            return result;
        }
        if (-1 < spec.indexOf("%")) {
            int percent = new Integer(spec.replace("%", ""));
            float calc = (float)(result * percent) / 100.0f;
            result = calc < 0.0f ? result + (int)calc : (int)calc;
        } else {
            int calc = new Integer(spec);
            int n = result = calc < 0 ? result + calc : calc;
        }
        return optionalClauseCount < result ? optionalClauseCount : (result < 0 ? 0 : result);
    }

    public static void flattenBooleanQuery(BooleanQuery to, BooleanQuery from) {
        for (BooleanClause clause : from.clauses()) {
            Query cq = clause.getQuery();
            cq.setBoost(cq.getBoost() * from.getBoost());
            if (cq instanceof BooleanQuery && !clause.isRequired() && !clause.isProhibited()) {
                SolrPluginUtils.flattenBooleanQuery(to, (BooleanQuery)cq);
                continue;
            }
            to.add(clause);
        }
    }

    public static CharSequence partialEscape(CharSequence s) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '\\' || c == '!' || c == '(' || c == ')' || c == ':' || c == '^' || c == '[' || c == ']' || c == '{' || c == '}' || c == '~' || c == '*' || c == '?') {
                sb.append('\\');
            }
            sb.append(c);
        }
        return sb;
    }

    public static CharSequence stripIllegalOperators(CharSequence s) {
        String temp = CONSECUTIVE_OP_PATTERN.matcher(s).replaceAll(" ");
        return DANGLING_OP_PATTERN.matcher(temp).replaceAll("");
    }

    public static CharSequence stripUnbalancedQuotes(CharSequence s) {
        int count = 0;
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) != '\"') continue;
            ++count;
        }
        if (!(count & true)) {
            return s;
        }
        return ((Object)s).toString().replace("\"", "");
    }

    public static Sort getSort(SolrQueryRequest req) {
        String sort = req.getParams().get("sort");
        if (null == sort || sort.equals("")) {
            return null;
        }
        SolrException sortE = null;
        Sort ss = null;
        try {
            ss = QueryParsing.parseSort(sort, req);
        }
        catch (SolrException e) {
            sortE = e;
        }
        if (null == ss || null != sortE) {
            SolrCore.log.warn("Invalid sort \"" + sort + "\" was specified, ignoring", (Throwable)sortE);
            return null;
        }
        return ss;
    }

    public static List<Query> parseFilterQueries(SolrQueryRequest req) throws ParseException {
        return SolrPluginUtils.parseQueryStrings(req, req.getParams().getParams("fq"));
    }

    public static List<Query> parseQueryStrings(SolrQueryRequest req, String[] queries) throws ParseException {
        if (null == queries || 0 == queries.length) {
            return null;
        }
        ArrayList<Query> out = new ArrayList<Query>(queries.length);
        for (String q : queries) {
            if (null == q || 0 == q.trim().length()) continue;
            out.add(QParser.getParser(q, null, req).getQuery());
        }
        return out;
    }

    public static SolrDocumentList docListToSolrDocumentList(DocList docs, SolrIndexSearcher searcher, Set<String> fields, Map<SolrDocument, Integer> ids) throws IOException {
        DocumentBuilder db = new DocumentBuilder(searcher.getSchema());
        SolrDocumentList list = new SolrDocumentList();
        list.setNumFound((long)docs.matches());
        list.setMaxScore(Float.valueOf(docs.maxScore()));
        list.setStart((long)docs.offset());
        DocIterator dit = docs.iterator();
        while (dit.hasNext()) {
            int docid = dit.nextDoc();
            Document luceneDoc = searcher.doc(docid, fields);
            SolrDocument doc = new SolrDocument();
            db.loadStoredFields(doc, luceneDoc);
            if (docs.hasScores()) {
                doc.addField("score", (Object)Float.valueOf(dit.score()));
            } else {
                doc.addField("score", (Object)Float.valueOf(0.0f));
            }
            list.add((Object)doc);
            if (ids == null) continue;
            ids.put(doc, new Integer(docid));
        }
        return list;
    }

    public static void addOrReplaceResults(SolrQueryResponse rsp, SolrDocumentList docs) {
        NamedList vals = rsp.getValues();
        int idx = vals.indexOf("response", 0);
        if (idx >= 0) {
            log.debug("Replacing DocList with SolrDocumentList " + docs.size());
            vals.setVal(idx, (Object)docs);
        } else {
            log.debug("Adding SolrDocumentList response" + docs.size());
            vals.add("response", (Object)docs);
        }
    }

    public static void invokeSetters(Object bean, NamedList initArgs) {
        if (initArgs == null) {
            return;
        }
        Class<?> clazz = bean.getClass();
        Method[] methods = clazz.getMethods();
        for (Map.Entry entry : initArgs) {
            String key = (String)entry.getKey();
            String setterName = "set" + String.valueOf(Character.toUpperCase(key.charAt(0))) + key.substring(1);
            Method method = null;
            try {
                for (Method m : methods) {
                    if (!m.getName().equals(setterName) || m.getParameterTypes().length != 1) continue;
                    method = m;
                    break;
                }
                if (method == null) {
                    throw new RuntimeException("no setter corrresponding to '" + key + "' in " + clazz.getName());
                }
                Class<?> pClazz = method.getParameterTypes()[0];
                Object val = entry.getValue();
                method.invoke(bean, val);
            }
            catch (InvocationTargetException e1) {
                throw new RuntimeException("Error invoking setter " + setterName + " on class : " + clazz.getName(), e1);
            }
            catch (IllegalAccessException e1) {
                throw new RuntimeException("Error invoking setter " + setterName + " on class : " + clazz.getName(), e1);
            }
        }
    }

    public static String resolveUpdateChainParam(SolrParams params, Logger log) {
        if (params.get("update.processor") != null && log != null) {
            log.warn("Use of deprecated update request parameter update.processor detected. Please use the new parameter update.chain instead, as support for update.processor will be removed in a later version.");
        }
        return params.get("update.chain") != null ? params.get("update.chain") : params.get("update.processor");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DisjunctionMaxQueryParser
    extends SolrQueryParser {
        protected Map<String, Alias> aliases = new HashMap<String, Alias>(3);

        public DisjunctionMaxQueryParser(QParser qp, String defaultField) {
            super(qp, defaultField);
            this.setDefaultOperator(QueryParser.Operator.OR);
        }

        public DisjunctionMaxQueryParser(IndexSchema s, String defaultField) {
            super(s, defaultField);
            this.setDefaultOperator(QueryParser.Operator.OR);
        }

        public DisjunctionMaxQueryParser(IndexSchema s) {
            this(s, null);
        }

        public void addAlias(String field, float tiebreaker, Map<String, Float> fieldBoosts) {
            Alias a = new Alias();
            a.tie = tiebreaker;
            a.fields = fieldBoosts;
            this.aliases.put(field, a);
        }

        @Override
        protected Query getFieldQuery(String field, String queryText, boolean quoted) throws ParseException {
            if (this.aliases.containsKey(field)) {
                Alias a = this.aliases.get(field);
                DisjunctionMaxQuery q = new DisjunctionMaxQuery(a.tie);
                boolean ok = false;
                for (String f : a.fields.keySet()) {
                    Query sub = this.getFieldQuery(f, queryText, quoted);
                    if (null == sub) continue;
                    if (null != a.fields.get(f)) {
                        sub.setBoost(a.fields.get(f).floatValue());
                    }
                    q.add(sub);
                    ok = true;
                }
                return ok ? q : null;
            }
            try {
                return super.getFieldQuery(field, queryText, quoted);
            }
            catch (Exception e) {
                return null;
            }
        }

        protected static class Alias {
            public float tie;
            public Map<String, Float> fields;

            protected Alias() {
            }
        }
    }

    public static class IdentityRegenerator
    implements CacheRegenerator {
        public boolean regenerateItem(SolrIndexSearcher newSearcher, SolrCache newCache, SolrCache oldCache, Object oldKey, Object oldVal) throws IOException {
            newCache.put(oldKey, oldVal);
            return true;
        }
    }
}

