/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.util.resources;

import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class ClassLoaderCache {
    private static ClassLoaderCache _clc;
    private Map _cache = Collections.synchronizedMap(new HashMap());

    protected ClassLoaderCache() {
    }

    public static ClassLoaderCache getDefault() {
        if (_clc == null) {
            _clc = new ClassLoaderCache();
        }
        return _clc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URL getResource(String string) {
        URL uRL = this.getClass().getClassLoader().getResource(string);
        if (uRL == null) {
            Map map = this._cache;
            synchronized (map) {
                Iterator iterator = this._cache.values().iterator();
                while (iterator.hasNext() && uRL == null) {
                    ClassLoader classLoader = (ClassLoader)iterator.next();
                    if (classLoader == null) continue;
                    uRL = classLoader.getResource(string);
                }
            }
        }
        return uRL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Enumeration getResources(String string) throws IOException {
        Enumeration<URL> enumeration = this.getClass().getClassLoader().getResources(string);
        if (enumeration == null) {
            Map map = this._cache;
            synchronized (map) {
                Iterator iterator = this._cache.values().iterator();
                while (iterator.hasNext() && enumeration == null) {
                    ClassLoader classLoader = (ClassLoader)iterator.next();
                    if (classLoader == null) continue;
                    enumeration = classLoader.getResources(string);
                }
            }
        }
        return enumeration;
    }

    public Class classForName(String string) {
        Class<?> clazz = null;
        try {
            clazz = Class.forName(string, true, this.getClassLoaderFor(string));
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (NoClassDefFoundError noClassDefFoundError) {}
        return clazz;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClassLoader getClassLoaderFor(String string) {
        ClassLoader classLoader = (ClassLoader)this._cache.get(string);
        int n = string.lastIndexOf(46);
        String string2 = n == -1 ? "" : string.substring(0, n);
        while (classLoader == null & string2.length() > 0) {
            Map map = this._cache;
            synchronized (map) {
                Iterator iterator = this._cache.keySet().iterator();
                while (iterator.hasNext() & classLoader == null) {
                    String string3 = (String)iterator.next();
                    if (string3.indexOf(string2) < 0) continue;
                    classLoader = (ClassLoader)this._cache.get(string3);
                }
            }
            n = string2.lastIndexOf(46);
            string2 = n == -1 ? "" : string2.substring(0, n);
        }
        return classLoader != null ? classLoader : this.getClass().getClassLoader();
    }

    public void put(String string, ClassLoader classLoader) {
        if (this._cache.containsKey(string)) {
            throw new IllegalArgumentException("Duplicate entries in cache");
        }
        this._cache.put(string, classLoader);
    }

    public boolean isAssignableFrom(String string, Class clazz) {
        Class<?> clazz2 = null;
        boolean bl = false;
        try {
            clazz2 = Class.forName(string, true, this.getClassLoaderFor(string));
            bl = clazz2.isAssignableFrom(clazz);
        }
        catch (ClassNotFoundException classNotFoundException) {}
        return bl;
    }

    public boolean isInstanceOf(String string, Object object) {
        return this.isAssignableFrom(string, object.getClass());
    }

    public boolean isNonAdvisableClassName(String string) {
        return string.startsWith("org.aspectj") || string.startsWith("org.apache.") || string.startsWith("org.mozilla.javascript.") || string.startsWith("org.xml.sax.") || string.startsWith("sunw.") || string.startsWith("sun.") || string.startsWith("java.") && !string.startsWith("java.awt.") || string.startsWith("javax.") && !string.startsWith("javax.swing.") || string.startsWith("com.sun.") || string.startsWith("com.ibm.sns.") || string.startsWith("org.eclipse.actf.");
    }
}

