/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.oda.pojo.ui.impl.dialogs;

import java.io.File;
import java.io.FileFilter;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.birt.data.oda.pojo.ui.i18n.Messages;
import org.eclipse.birt.data.oda.pojo.ui.util.Utils;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;

public class JarsSelectionDialog
extends ElementTreeSelectionDialog {
    private static final String JAR_EXT = ".jar";
    private static final String ZIP_EXT = ".zip";
    private static final Image IMG_FOLDER = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER");
    private static final Image IMG_FILE = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FILE");
    private File topDir;

    public JarsSelectionDialog(Shell parent, File topDir) {
        super(parent, (ILabelProvider)new LabelProvider(), (ITreeContentProvider)new ContentProvider());
        assert (topDir != null);
        this.setValidator(new SelectionValidator());
        this.setInput(topDir.getAbsolutePath());
        this.setTitle(Messages.getString("DataSet.JarsSelectDlg.Title"));
        this.topDir = topDir;
    }

    protected Control createDialogArea(Composite parent) {
        Control c = super.createDialogArea(parent);
        this.getTreeViewer().expandToLevel(2);
        return c;
    }

    private static File[] getChildren(File f) {
        if (!f.isDirectory()) {
            return new File[0];
        }
        File[] result = f.listFiles(new FileFilter(){

            @Override
            public boolean accept(File child) {
                if (child.isDirectory()) {
                    return true;
                }
                String name = child.getName().toLowerCase();
                return name.endsWith(JarsSelectionDialog.JAR_EXT) || name.endsWith(JarsSelectionDialog.ZIP_EXT);
            }
        });
        if (result != null) {
            Arrays.sort(result, new Utils.FileComparator());
        }
        return result == null ? new File[]{} : result;
    }

    public String[] getSelectedItems() {
        Object[] selected;
        ArrayList<String> result = new ArrayList<String>();
        Object[] objectArray = selected = this.getResult() == null ? new Object[]{} : this.getResult();
        int n = selected.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            File f = (File)o;
            if (f.isFile()) {
                URI relative = this.topDir.toURI().relativize(f.toURI());
                result.add(relative.getPath());
            }
            ++n2;
        }
        return result.toArray(new String[0]);
    }

    private static class ContentProvider
    implements ITreeContentProvider {
        private ContentProvider() {
        }

        public Object[] getChildren(Object arg0) {
            if (arg0 instanceof File) {
                File f = (File)arg0;
                return JarsSelectionDialog.getChildren(f);
            }
            return null;
        }

        public Object getParent(Object arg0) {
            return null;
        }

        public boolean hasChildren(Object arg0) {
            if (arg0 instanceof File) {
                File f = (File)arg0;
                return JarsSelectionDialog.getChildren(f).length > 0;
            }
            return false;
        }

        public Object[] getElements(Object arg0) {
            if (arg0 instanceof String) {
                return new Object[]{new File((String)arg0)};
            }
            return null;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer arg0, Object arg1, Object arg2) {
        }
    }

    private static class LabelProvider
    implements ILabelProvider {
        private LabelProvider() {
        }

        public Image getImage(Object arg0) {
            if (arg0 instanceof File) {
                File f = (File)arg0;
                if (f.isFile()) {
                    return IMG_FILE;
                }
                return IMG_FOLDER;
            }
            return null;
        }

        public String getText(Object arg0) {
            if (arg0 instanceof File) {
                File f = (File)arg0;
                if (f.getName().trim().equals("")) {
                    return f.getPath();
                }
                return f.getName();
            }
            return "";
        }

        public void addListener(ILabelProviderListener arg0) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object arg0, String arg1) {
            return false;
        }

        public void removeListener(ILabelProviderListener arg0) {
        }
    }

    private static class SelectionValidator
    implements ISelectionStatusValidator {
        private SelectionValidator() {
        }

        public IStatus validate(Object[] selections) {
            if (selections != null && selections.length > 0) {
                Object[] objectArray = selections;
                int n = selections.length;
                int n2 = 0;
                while (n2 < n) {
                    Object o = objectArray[n2];
                    if (o instanceof File && ((File)o).isFile()) {
                        return new Status(0, "org.eclipse.birt.data.oda.pojo.ui", 0, "", null);
                    }
                    ++n2;
                }
            }
            return new Status(4, "org.eclipse.birt.data.oda.pojo.ui", 4, "", null);
        }
    }
}

