/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.data.oda.hive.ui.profile;

import java.util.Properties;
import org.eclipse.birt.report.data.oda.hive.HiveConstants;
import org.eclipse.birt.report.data.oda.hive.ui.i18n.Messages;
import org.eclipse.birt.report.data.oda.jdbc.ui.JdbcPlugin;
import org.eclipse.birt.report.data.oda.jdbc.ui.dialogs.JdbcDriverManagerDialog;
import org.eclipse.birt.report.data.oda.jdbc.ui.util.DriverLoader;
import org.eclipse.birt.report.data.oda.jdbc.ui.util.ExceptionHandler;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.variables.IStringVariableManager;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class HiveSelectionPageHelper {
    private WizardPage m_wizardPage;
    private PreferencePage m_propertyPage;
    private Button manageButton;
    private Button testButton;
    private final String CONTEXT_ID_DATASOURCE_HIVE = "org.eclipse.birt.cshelp.Wizard_Hive_Datasource_ID";
    private Label m_driverClass;
    private Label serverTypeLabel;
    private Label driverClassLabel;
    private Label jdbcUrlLabel;
    private Label userNameLabel;
    private Label passwordLabel;
    private Label addFileLabel;
    private Text jdbcUrlText;
    private Text userNameText;
    private Text passwordText;
    private Text addFileText;
    private Combo hiveDriverSelection;
    private String serverType;
    private String driverClass;
    private String driverUrl;
    private String DEFAULT_MESSAGE = "";
    protected static final String HIVE_SERVER_1 = Messages.getMessage("datasource.ServerType.type1");
    protected static final String HIVE_SERVER_2 = Messages.getMessage("datasource.ServerType.type2");
    private static final String EMPTY_STRING = "";

    public HiveSelectionPageHelper(WizardPage page, String odaDesignerID) {
        this.m_wizardPage = page;
        this.setDefaultMessage(odaDesignerID);
    }

    public HiveSelectionPageHelper(PreferencePage page, String odaDesignerID) {
        this.m_propertyPage = page;
        this.setDefaultMessage(odaDesignerID);
    }

    private void setDefaultMessage(String odaDesignerID) {
        String msgExpr = Messages.getMessage("datasource.page.title");
        String dsMsgExpr = msgExpr.replace("odadesignerid", odaDesignerID);
        IStringVariableManager varMgr = VariablesPlugin.getDefault().getStringVariableManager();
        try {
            this.DEFAULT_MESSAGE = varMgr.performStringSubstitution(dsMsgExpr, false);
        }
        catch (CoreException coreException) {}
    }

    void createCustomControl(Composite parent) {
        ScrolledComposite scrollContent = new ScrolledComposite(parent, 768);
        scrollContent.setAlwaysShowScrollBars(false);
        scrollContent.setExpandHorizontal(true);
        scrollContent.setLayout((Layout)new FillLayout());
        Composite content = new Composite((Composite)scrollContent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 4;
        layout.verticalSpacing = 10;
        layout.marginBottom = 10;
        content.setLayout((Layout)layout);
        this.createHiveDriverSelectionGroup(content);
        this.createDriverPropertyEditorArea(content);
        this.createButtonArea(content);
        this.resetLabelStyle();
        Point size = content.computeSize(-1, -1);
        content.setSize(size.x, size.y);
        scrollContent.setMinWidth(size.x + 10);
        scrollContent.setContent((Control)content);
        this.addControlListeners();
        this.updateTestButton();
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "org.eclipse.birt.cshelp.Wizard_Hive_Datasource_ID");
    }

    private void createButtonArea(Composite content) {
        this.manageButton = new Button(content, 8);
        this.manageButton.setText(JdbcPlugin.getResourceString((String)"wizard.label.manageDriver"));
        this.testButton = new Button(content, 8);
        this.testButton.setText(JdbcPlugin.getResourceString((String)"wizard.label.testConnection"));
        this.testButton.setLayoutData((Object)new GridData(2));
    }

    private void createDriverPropertyEditorArea(Composite content) {
        this.userNameLabel = new Label(content, 16384);
        this.userNameLabel.setText(JdbcPlugin.getResourceString((String)"wizard.label.username"));
        this.userNameText = new Text(content, 2048);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 3;
        gridData.horizontalAlignment = 4;
        this.userNameText.setLayoutData((Object)gridData);
        this.passwordLabel = new Label(content, 16384);
        this.passwordLabel.setText(JdbcPlugin.getResourceString((String)"wizard.label.password"));
        this.passwordText = new Text(content, 0x400800);
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        gridData.horizontalAlignment = 4;
        this.passwordText.setLayoutData((Object)gridData);
        this.addFileLabel = new Label(content, 0);
        this.addFileLabel.setText(Messages.getMessage("datasource.addfile"));
        this.addFileText = new Text(content, 2048);
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        gridData.horizontalAlignment = 4;
        this.addFileText.setLayoutData((Object)gridData);
    }

    private void createHiveDriverSelectionGroup(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText(Messages.getMessage("datasource.group.text"));
        GridLayout layot = new GridLayout();
        layot.numColumns = 2;
        group.setLayout((Layout)layot);
        GridData groupGd = new GridData(1808);
        groupGd.horizontalSpan = 4;
        group.setLayoutData((Object)groupGd);
        this.serverTypeLabel = new Label((Composite)group, 0);
        this.serverTypeLabel.setText(Messages.getMessage("datasource.label.ServerType"));
        this.hiveDriverSelection = new Combo((Composite)group, 2056);
        GridData gd = new GridData(768);
        this.hiveDriverSelection.setLayoutData((Object)gd);
        this.hiveDriverSelection.add(Messages.getMessage("datasource.ServerType.type1"));
        this.hiveDriverSelection.add(Messages.getMessage("datasource.ServerType.type2"));
        this.hiveDriverSelection.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                HiveSelectionPageHelper.this.handleHiveDriverSelection();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.driverClassLabel = new Label((Composite)group, 16384);
        this.driverClassLabel.setText(Messages.getMessage("datasource.page.driver.class"));
        this.m_driverClass = new Label((Composite)group, 16384);
        GridData gridData1 = new GridData();
        gridData1.horizontalAlignment = 4;
        gridData1.grabExcessHorizontalSpace = true;
        this.m_driverClass.setLayoutData((Object)gridData1);
        this.jdbcUrlLabel = new Label((Composite)group, 16384);
        this.jdbcUrlLabel.setText(JdbcPlugin.getResourceString((String)"wizard.label.url"));
        this.jdbcUrlText = new Text((Composite)group, 2048);
        GridData gridData2 = new GridData();
        gridData2.horizontalAlignment = 4;
        gridData2.grabExcessHorizontalSpace = true;
        this.jdbcUrlText.setLayoutData((Object)gridData2);
    }

    private void resetLabelStyle() {
        int width = this.serverTypeLabel.computeSize((int)-1, (int)-1).x;
        width = this.getMaxValue(width, this.driverClassLabel);
        width = this.getMaxValue(width, this.jdbcUrlLabel);
        width = this.getMaxValue(width, this.userNameLabel);
        width = this.getMaxValue(width, this.passwordLabel);
        width = this.getMaxValue(width, this.addFileLabel);
        GridData gd1 = new GridData();
        gd1.widthHint = width;
        this.serverTypeLabel.setLayoutData((Object)gd1);
        GridData gd2 = new GridData();
        gd2.widthHint = width;
        this.driverClassLabel.setLayoutData((Object)gd2);
        GridData gd3 = new GridData();
        gd3.widthHint = width;
        this.jdbcUrlLabel.setLayoutData((Object)gd3);
        GridData gd4 = new GridData();
        gd4.widthHint = width;
        gd4.horizontalIndent = 10;
        this.userNameLabel.setLayoutData((Object)gd4);
        GridData gd5 = new GridData();
        gd5.widthHint = width;
        gd5.horizontalIndent = 10;
        this.passwordLabel.setLayoutData((Object)gd5);
        GridData gd6 = new GridData();
        gd6.widthHint = width;
        gd6.horizontalIndent = 10;
        this.addFileLabel.setLayoutData((Object)gd6);
    }

    private int getMaxValue(int width, Label label) {
        int another = label.computeSize((int)-1, (int)-1).x;
        return another > width ? another : width;
    }

    void initCustomControl(Properties profileProps) {
        if (profileProps == null || profileProps.isEmpty()) {
            this.driverClass = "org.apache.hive.jdbc.HiveDriver";
            this.m_driverClass.setText(this.driverClass);
        } else {
            if (this.driverClass == null || this.driverClass.trim().length() == 0) {
                this.driverClass = profileProps.getProperty("odaDriverClass");
            }
            if (this.driverClass == null) {
                this.driverClass = EMPTY_STRING;
            }
            this.m_driverClass.setText(this.driverClass);
            this.driverUrl = profileProps.getProperty("odaURL");
            if (this.driverUrl == null) {
                this.driverUrl = EMPTY_STRING;
            }
            this.jdbcUrlText.setText(this.driverUrl);
            String user = profileProps.getProperty("odaUser");
            if (user == null) {
                user = EMPTY_STRING;
            }
            this.userNameText.setText(user);
            String odaPassword = profileProps.getProperty("odaPassword");
            if (odaPassword == null) {
                odaPassword = EMPTY_STRING;
            }
            this.passwordText.setText(odaPassword);
            String addFile = profileProps.getProperty("addListFile");
            if (addFile == null) {
                addFile = EMPTY_STRING;
            }
            this.addFileText.setText(addFile);
        }
        this.initDriverClassSettings();
    }

    private void initDriverClassSettings() {
        if ("org.apache.hadoop.hive.jdbc.HiveDriver".equals(this.driverClass)) {
            this.hiveDriverSelection.setText(HIVE_SERVER_1);
            if (this.driverUrl == null || this.driverUrl.trim().length() == 0) {
                this.driverUrl = "jdbc:hive://localhost:10000/default";
            }
            this.jdbcUrlText.setText(HiveConstants.formatHiveServer1URL((String)this.driverUrl));
        } else {
            this.driverClass = "org.apache.hive.jdbc.HiveDriver";
            this.hiveDriverSelection.setText(HIVE_SERVER_2);
            if (this.driverUrl == null || this.driverUrl.trim().length() == 0) {
                this.driverUrl = "jdbc:hive://localhost:10000/default";
            }
            this.jdbcUrlText.setText(HiveConstants.formatHiveServer2URL((String)this.driverUrl));
        }
        this.m_driverClass.setText(this.driverClass);
    }

    private void handleHiveDriverSelection() {
        this.serverType = this.hiveDriverSelection.getText();
        this.driverUrl = this.jdbcUrlText.getText();
        if (this.driverUrl.trim().length() == 0) {
            this.driverUrl = "jdbc:hive://localhost:10000/default";
        }
        if (HIVE_SERVER_1.equals(this.serverType)) {
            this.driverClass = "org.apache.hadoop.hive.jdbc.HiveDriver";
            this.jdbcUrlText.setText(HiveConstants.formatHiveServer1URL((String)this.driverUrl));
        } else {
            this.driverClass = "org.apache.hive.jdbc.HiveDriver";
            this.jdbcUrlText.setText(HiveConstants.formatHiveServer2URL((String)this.driverUrl));
        }
        this.m_driverClass.setText(this.driverClass);
    }

    Properties collectCustomProperties(Properties props) {
        if (props == null) {
            props = new Properties();
        }
        props.setProperty("odaDriverClass", this.driverClass);
        props.setProperty("odaURL", this.getDriverURL());
        props.setProperty("odaUser", this.getODAUser());
        props.setProperty("odaPassword", this.getODAPassword());
        props.setProperty("addListFile", this.getAddFile());
        return props;
    }

    private String getODAUser() {
        if (this.userNameText == null) {
            return EMPTY_STRING;
        }
        return this.getTrimedString(this.userNameText.getText());
    }

    private String getODAPassword() {
        if (this.passwordText == null) {
            return EMPTY_STRING;
        }
        return this.getTrimedString(this.passwordText.getText());
    }

    private String getDriverURL() {
        if (this.jdbcUrlText == null) {
            return EMPTY_STRING;
        }
        return this.getTrimedString(this.jdbcUrlText.getText());
    }

    private String getAddFile() {
        if (this.addFileText == null) {
            return EMPTY_STRING;
        }
        return this.getTrimedString(this.addFileText.getText());
    }

    private String getTrimedString(String tobeTrimed) {
        if (tobeTrimed != null) {
            tobeTrimed = tobeTrimed.trim();
        }
        return tobeTrimed;
    }

    private void setMessage(String message) {
        if (this.m_wizardPage != null) {
            this.m_wizardPage.setMessage(message);
        } else if (this.m_propertyPage != null) {
            this.m_propertyPage.setMessage(message);
        }
    }

    private Control getControl() {
        if (this.m_wizardPage != null) {
            return this.m_wizardPage.getControl();
        }
        assert (this.m_propertyPage != null);
        return this.m_propertyPage.getControl();
    }

    private void addControlListeners() {
        this.jdbcUrlText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (!HiveSelectionPageHelper.this.jdbcUrlText.isFocusControl() && HiveSelectionPageHelper.this.jdbcUrlText.getText().trim().length() == 0) {
                    return;
                }
                HiveSelectionPageHelper.this.driverUrl = HiveSelectionPageHelper.this.jdbcUrlText.getText();
                HiveSelectionPageHelper.this.verifyJDBCProperties();
                HiveSelectionPageHelper.this.updateTestButton();
            }
        });
        this.testButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                HiveSelectionPageHelper.this.testButton.setEnabled(false);
                try {
                    if (HiveSelectionPageHelper.this.testConnection()) {
                        MessageDialog.openInformation((Shell)HiveSelectionPageHelper.this.getShell(), (String)JdbcPlugin.getResourceString((String)"connection.test"), (String)JdbcPlugin.getResourceString((String)"connection.success"));
                    } else {
                        OdaException ex = new OdaException(JdbcPlugin.getResourceString((String)"connection.failed"));
                        ExceptionHandler.showException((Shell)HiveSelectionPageHelper.this.getShell(), (String)JdbcPlugin.getResourceString((String)"connection.test"), (String)JdbcPlugin.getResourceString((String)"connection.failed"), (Throwable)ex);
                    }
                }
                catch (OdaException e1) {
                    ExceptionHandler.showException((Shell)HiveSelectionPageHelper.this.getShell(), (String)JdbcPlugin.getResourceString((String)"connection.test"), (String)JdbcPlugin.getResourceString((String)e1.getLocalizedMessage()), (Throwable)e1);
                }
                HiveSelectionPageHelper.this.testButton.setEnabled(true);
            }
        });
        this.manageButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JdbcDriverManagerDialog dlg = new JdbcDriverManagerDialog(HiveSelectionPageHelper.this.getShell());
                HiveSelectionPageHelper.this.manageButton.setEnabled(false);
                HiveSelectionPageHelper.this.testButton.setEnabled(false);
                if (dlg.open() == 0) {
                    BusyIndicator.showWhile((Display)(HiveSelectionPageHelper.this.getShell() == null ? null : HiveSelectionPageHelper.this.getShell().getDisplay()), (Runnable)new Runnable(){

                        @Override
                        public void run() {
                            HiveSelectionPageHelper.this.okPressedProcess();
                        }
                    });
                }
                HiveSelectionPageHelper.this.updateTestButton();
                HiveSelectionPageHelper.this.manageButton.setEnabled(true);
            }
        });
    }

    private void okPressedProcess() {
    }

    private boolean testConnection() throws OdaException {
        if (!this.isValidDataSource()) {
            return false;
        }
        String url = this.jdbcUrlText.getText().trim();
        String userid = this.userNameText.getText().trim();
        String passwd = this.passwordText.getText();
        return DriverLoader.testConnection((String)this.driverClass, (String)url, null, (String)userid, (String)passwd);
    }

    private boolean isValidDataSource() {
        return !this.isURLBlank();
    }

    private boolean isURLBlank() {
        return this.jdbcUrlText == null || this.jdbcUrlText.getText().trim().length() == 0;
    }

    private Shell getShell() {
        if (this.m_wizardPage != null) {
            return this.m_wizardPage.getShell();
        }
        if (this.m_propertyPage != null) {
            return this.m_propertyPage.getShell();
        }
        return null;
    }

    private void updateTestButton() {
        if (this.isURLBlank()) {
            this.setMessage(Messages.getMessage("datasource.error.EmptyURL"), 3);
            this.testButton.setEnabled(false);
        } else {
            this.setMessage(this.DEFAULT_MESSAGE);
            if (!this.testButton.isEnabled()) {
                this.testButton.setEnabled(true);
            }
        }
    }

    void resetTestButton() {
        this.updateTestButton();
        this.enableParent((Control)this.testButton);
    }

    private void enableParent(Control control) {
        Composite parent = control.getParent();
        if (parent == null || parent instanceof Shell) {
            return;
        }
        if (!parent.isEnabled()) {
            parent.setEnabled(true);
        }
        this.enableParent((Control)parent);
    }

    private void setMessage(String message, int type) {
        if (this.m_wizardPage != null) {
            this.m_wizardPage.setMessage(message, type);
        } else if (this.m_propertyPage != null) {
            this.m_propertyPage.setMessage(message, type);
        }
    }

    private void verifyJDBCProperties() {
        this.setPageComplete(!this.isURLBlank());
    }

    private void setPageComplete(boolean complete) {
        if (this.m_wizardPage != null) {
            this.m_wizardPage.setPageComplete(complete);
        } else if (this.m_propertyPage != null) {
            this.m_propertyPage.setValid(complete);
        }
    }
}

