/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.data.ui.util;

import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.IBaseDataSetDesign;
import org.eclipse.birt.data.engine.api.IBaseDataSourceDesign;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IJointDataSetDesign;
import org.eclipse.birt.data.engine.api.IPreparedQuery;
import org.eclipse.birt.data.engine.api.IQueryDefinition;
import org.eclipse.birt.data.engine.api.IResultMetaData;
import org.eclipse.birt.data.engine.api.querydefn.BaseDataSetDesign;
import org.eclipse.birt.data.engine.api.querydefn.BaseDataSourceDesign;
import org.eclipse.birt.data.engine.api.querydefn.InputParameterBinding;
import org.eclipse.birt.data.engine.api.querydefn.ParameterDefinition;
import org.eclipse.birt.data.engine.api.querydefn.QueryDefinition;
import org.eclipse.birt.data.engine.api.querydefn.ScriptExpression;
import org.eclipse.birt.report.data.adapter.api.DataAdapterUtil;
import org.eclipse.birt.report.data.adapter.api.DataRequestSession;
import org.eclipse.birt.report.data.adapter.api.DataSessionContext;
import org.eclipse.birt.report.designer.data.ui.dataset.DataSetViewData;
import org.eclipse.birt.report.designer.data.ui.util.DatasetClassPathHelper;
import org.eclipse.birt.report.designer.data.ui.util.Utility;
import org.eclipse.birt.report.designer.internal.ui.data.DataService;
import org.eclipse.birt.report.model.api.ColumnHintHandle;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.DerivedDataSetHandle;
import org.eclipse.birt.report.model.api.JointDataSetHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.ParamBindingHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.ResultSetColumnHandle;
import org.eclipse.birt.report.model.api.ScriptLibHandle;
import org.eclipse.birt.report.model.api.elements.structures.ComputedColumn;
import org.eclipse.birt.report.model.api.elements.structures.ResultSetColumn;
import org.eclipse.birt.report.model.api.metadata.PropertyValueException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DataSetProvider {
    private static final String BIRT_SCRIPTLIB = "/birt/scriptlib";
    private static final String BIRT_CLASSES = "/birt/WEB-INF/classes/";
    private static final String VIEWER_NAMESPACE = "org.eclipse.birt.report.viewer";
    private static final String DERIVED_SEPERATOR = "::";
    private static DataSetProvider instance = null;
    private Map<DataSetHandle, DataSetViewData[]> htColumns = new LinkedHashMap<DataSetHandle, DataSetViewData[]>(10, 0.75f, true){
        private static final long serialVersionUID = 4685315474104939633L;

        @Override
        protected boolean removeEldestEntry(Map.Entry eldest) {
            return this.size() > 10;
        }
    };
    private static Hashtable<String, IConfigurationElement> htDataSourceExtensions = new Hashtable(10);
    private boolean needToFocusOnOutput = true;

    private static DataSetProvider newInstance() {
        return new DataSetProvider();
    }

    public static DataSetProvider getCurrentInstance() {
        if (instance == null) {
            instance = DataSetProvider.newInstance();
        }
        return instance;
    }

    public DataSetViewData[] getColumns(String dataSetName, boolean refresh) throws BirtException {
        ModuleHandle handle = Utility.getReportModuleHandle();
        DataSetHandle dataSet = handle.findDataSet(dataSetName);
        if (dataSet == null) {
            return new DataSetViewData[0];
        }
        return this.getColumns(dataSet, refresh);
    }

    public DataSetViewData[] getColumns(DataSetHandle dataSet, boolean refresh) throws BirtException {
        return this.getColumns(dataSet, refresh, true);
    }

    public DataSetViewData[] getColumns(DataSetHandle dataSet, boolean refresh, boolean useColumnHints) throws BirtException {
        if (dataSet == null) {
            return new DataSetViewData[0];
        }
        DataSetViewData[] columns = null;
        DataRequestSession session = null;
        try {
            try {
                columns = this.htColumns.get(dataSet);
                if (columns == null || refresh) {
                    DataSessionContext context = new DataSessionContext(3, dataSet.getModuleHandle());
                    session = DataRequestSession.newSession((DataSessionContext)context);
                    columns = this.populateAllOutputColumns(dataSet, session);
                    this.htColumns.put(dataSet, columns);
                }
            }
            catch (BirtException e) {
                columns = new DataSetViewData[]{};
                this.htColumns.put(dataSet, columns);
                throw e;
            }
        }
        finally {
            if (session != null) {
                session.shutdown();
            }
        }
        if (columns == null) {
            columns = new DataSetViewData[]{};
            this.htColumns.put(dataSet, columns);
        }
        return columns;
    }

    public DataSetViewData[] populateAllOutputColumns(DataSetHandle dataSetHandle, DataRequestSession session) throws BirtException {
        try {
            DataService.getInstance().registerSession(dataSetHandle, session);
            IResultMetaData metaData = session.getDataSetMetaData(dataSetHandle, false);
            if (metaData == null) {
                DataSetViewData[] dataSetViewDataArray = new DataSetViewData[]{};
                return dataSetViewDataArray;
            }
            DataSetViewData[] items = new DataSetViewData[metaData.getColumnCount()];
            int i = 0;
            while (i < metaData.getColumnCount()) {
                items[i] = new DataSetViewData();
                items[i].setName(metaData.getColumnName(i + 1));
                items[i].setDataTypeName(DataAdapterUtil.adapterToModelDataType((int)metaData.getColumnType(i + 1)));
                items[i].setAlias(metaData.getColumnAlias(i + 1));
                items[i].setComputedColumn(metaData.isComputedColumn(i + 1));
                items[i].setPosition(i + 1);
                items[i].setDataType(metaData.getColumnType(i + 1));
                ColumnHintHandle hint = this.findColumnHint(dataSetHandle, items[i].getName());
                if (hint != null) {
                    if (!items[i].isComputedColumn()) {
                        items[i].setAnalysis(hint.getAnalysis());
                        if ("attribute".equals(hint.getAnalysis())) {
                            items[i].setAnalysisColumn(hint.getAnalysisColumn());
                        } else {
                            items[i].setAnalysisColumn(null);
                        }
                    } else {
                        items[i].setAnalysis(hint.getAnalysis());
                        items[i].setAnalysisColumn(hint.getAnalysisColumn());
                    }
                    items[i].setDisplayName(hint.getDisplayName());
                    items[i].setDisplayNameKey(hint.getDisplayNameKey());
                    items[i].setACLExpression(hint.getACLExpression());
                    items[i].setFormat(hint.getFormat());
                    items[i].setDisplayLength(hint.getDisplayLength());
                    items[i].setHeading(hint.getHeading());
                    items[i].setHelpText(hint.getHelpText());
                    items[i].setFormatValue(hint.getValueFormat());
                    items[i].setHorizontalAlign(hint.getHorizontalAlign());
                    items[i].setTextFormat(hint.getTextFormat());
                    items[i].setDescription(hint.getDescription());
                    items[i].setWordWrap(hint.wordWrap());
                    items[i].setIndexColumn(hint.isIndexColumn());
                    items[i].setRemoveDuplicateValues(hint.isCompressed());
                    items[i].setAlias(hint.getAlias());
                    items[i].setActionHandle(hint.getActionHandle());
                } else if (items[i].isComputedColumn()) {
                    items[i].setAnalysis(null);
                    items[i].setAnalysisColumn(null);
                } else {
                    items[i].setAnalysisColumn(null);
                }
                ++i;
            }
            DataSetViewData[] dataSetViewDataArray = items;
            return dataSetViewDataArray;
        }
        finally {
            DataService.getInstance().unRegisterSession(session);
        }
    }

    public DataSetViewData[] populateAllCachedMetaData(DataSetHandle dataSetHandle, DataRequestSession session) throws BirtException {
        IResultMetaData metaData = session.getDataSetMetaData(dataSetHandle, true);
        DataSetViewData[] items = new DataSetViewData[metaData.getColumnCount()];
        int i = 0;
        while (i < metaData.getColumnCount()) {
            items[i] = new DataSetViewData();
            items[i].setName(metaData.getColumnName(i + 1));
            items[i].setDataTypeName(DataAdapterUtil.adapterToModelDataType((int)metaData.getColumnType(i + 1)));
            items[i].setAlias(metaData.getColumnAlias(i + 1));
            items[i].setComputedColumn(metaData.isComputedColumn(i + 1));
            items[i].setPosition(i + 1);
            items[i].setDataType(metaData.getColumnType(i + 1));
            ColumnHintHandle hint = this.findColumnHint(dataSetHandle, items[i].getName());
            if (hint != null) {
                if (!items[i].isComputedColumn()) {
                    items[i].setAnalysis(hint.getAnalysis());
                    if ("attribute".equals(items[i].getAnalysis())) {
                        items[i].setAnalysisColumn(hint.getAnalysisColumn());
                    } else {
                        items[i].setAnalysisColumn(null);
                    }
                } else {
                    items[i].setAnalysis(hint.getAnalysis());
                    items[i].setAnalysisColumn(hint.getAnalysisColumn());
                }
                items[i].setDisplayName(hint.getDisplayName());
                items[i].setDisplayNameKey(hint.getDisplayNameKey());
                items[i].setACLExpression(hint.getACLExpression());
                items[i].setFormat(hint.getFormat());
                items[i].setDisplayLength(hint.getDisplayLength());
                items[i].setHeading(hint.getHeading());
                items[i].setHelpText(hint.getHelpText());
                items[i].setHorizontalAlign(hint.getHorizontalAlign());
                items[i].setFormatValue(hint.getValueFormat());
                items[i].setTextFormat(hint.getTextFormat());
                items[i].setDescription(hint.getDescription());
                items[i].setWordWrap(hint.wordWrap());
                items[i].setIndexColumn(hint.isIndexColumn());
                items[i].setRemoveDuplicateValues(hint.isCompressed());
                items[i].setActionHandle(hint.getActionHandle());
            } else if (items[i].isComputedColumn()) {
                items[i].setAnalysis(null);
                items[i].setAnalysisColumn(null);
            } else {
                items[i].setAnalysis(null);
                items[i].setAnalysisColumn(null);
            }
            ++i;
        }
        return items;
    }

    public void updateColumnsOfDataSetHandle(DataSetHandle dataSet, DataSetViewData[] dsItemModel) {
        if (dataSet == null || dsItemModel == null || dsItemModel.length == 0) {
            return;
        }
        this.htColumns.put(dataSet, dsItemModel);
    }

    public void setModelOfDataSetHandle(DataSetHandle dataSet, DataSetViewData[] dsItemModel) {
        if (dataSet == null || dsItemModel == null) {
            return;
        }
        this.updateModel(dataSet, dsItemModel);
        this.cleanUnusedResultSetColumn(dataSet, dsItemModel);
        this.cleanUnusedComputedColumn(dataSet, dsItemModel);
        this.htColumns.put(dataSet, dsItemModel);
    }

    private ColumnHintHandle findColumnHint(DataSetHandle handle, String columnName) {
        if (columnName == null || columnName.trim().length() == 0) {
            return null;
        }
        ColumnHintHandle hint2 = null;
        if (handle instanceof DerivedDataSetHandle) {
            String[] splits = columnName.split(DERIVED_SEPERATOR);
            List inputDataSets = ((DerivedDataSetHandle)handle).getInputDataSets();
            int i = 0;
            while (i < inputDataSets.size()) {
                hint2 = this.findColumnHint((DataSetHandle)inputDataSets.get(i), columnName);
                if (hint2 != null) {
                    return hint2;
                }
                if (splits.length > 1 && splits[0].equals(((DataSetHandle)inputDataSets.get(i)).getName())) {
                    columnName = columnName.substring(columnName.indexOf(DERIVED_SEPERATOR) + DERIVED_SEPERATOR.length());
                    return this.findColumnHint((DataSetHandle)inputDataSets.get(i), columnName);
                }
                ++i;
            }
        }
        for (ColumnHintHandle hint2 : handle.getPropertyHandle("columnHints")) {
            if (!columnName.equals(hint2.getColumnName())) continue;
            return hint2;
        }
        return null;
    }

    private void cleanUnusedResultSetColumn(DataSetHandle dataSetHandle, DataSetViewData[] dsItemModel) {
        PropertyHandle handle = dataSetHandle.getPropertyHandle("resultSet");
        if (handle != null && handle.getListValue() != null) {
            ArrayList list = handle.getListValue();
            int count = list.size();
            int n = count - 1;
            while (n >= 0) {
                ResultSetColumn rsColumn = (ResultSetColumn)list.get(n);
                String columnName = rsColumn.getColumnName();
                boolean found = false;
                int m = 0;
                while (m < dsItemModel.length) {
                    if (columnName.equals(dsItemModel[m].getName())) {
                        found = true;
                        break;
                    }
                    ++m;
                }
                if (!found) {
                    try {
                        handle.removeItem((Object)rsColumn);
                    }
                    catch (PropertyValueException propertyValueException) {}
                }
                --n;
            }
        }
    }

    private void cleanUnusedComputedColumn(DataSetHandle dataSetHandle, DataSetViewData[] dsItemModel) {
        PropertyHandle handle = dataSetHandle.getPropertyHandle("computedColumns");
        if (handle != null && handle.getListValue() != null) {
            ArrayList list = handle.getListValue();
            int count = list.size();
            int n = count - 1;
            while (n >= 0) {
                ComputedColumn rsColumn = (ComputedColumn)list.get(n);
                String columnName = rsColumn.getName();
                boolean found = false;
                int m = 0;
                while (m < dsItemModel.length) {
                    if (columnName.equals(dsItemModel[m].getName())) {
                        found = true;
                        break;
                    }
                    ++m;
                }
                if (!found) {
                    try {
                        handle.removeItem((Object)rsColumn);
                    }
                    catch (PropertyValueException propertyValueException) {}
                }
                --n;
            }
        }
    }

    private final QueryDefinition getQueryDefinition(IBaseDataSetDesign dataSetDesign, int rowsToReturn) {
        if (dataSetDesign != null) {
            QueryDefinition defn = new QueryDefinition(null);
            defn.setDataSetName(dataSetDesign.getName());
            if (rowsToReturn > 0) {
                defn.setMaxRows(rowsToReturn);
            }
            List parameters = dataSetDesign.getParameters();
            for (ParameterDefinition paramDefn : parameters) {
                if (!paramDefn.isInputMode() || paramDefn.getDefaultInputValue() == null) continue;
                InputParameterBinding binding = new InputParameterBinding(paramDefn.getName(), (IBaseExpression)new ScriptExpression(paramDefn.getDefaultInputValue()));
                defn.addInputParamBinding(binding);
            }
            return defn;
        }
        return null;
    }

    public final QueryDefinition getQueryDefinition(IBaseDataSetDesign dataSetDesign, ParamBindingHandle[] bindingParams) {
        return this.getQueryDefinition(dataSetDesign, bindingParams, -1);
    }

    private QueryDefinition getQueryDefinition(IBaseDataSetDesign dataSetDesign, ParamBindingHandle[] bindingParams, int rowsToReturn) {
        if (bindingParams == null || bindingParams.length == 0) {
            return this.getQueryDefinition(dataSetDesign, rowsToReturn);
        }
        if (dataSetDesign != null) {
            QueryDefinition defn = new QueryDefinition(null);
            defn.setDataSetName(dataSetDesign.getName());
            if (rowsToReturn > 0) {
                defn.setMaxRows(rowsToReturn);
            }
            int i = 0;
            while (i < bindingParams.length) {
                ParamBindingHandle param = bindingParams[i];
                InputParameterBinding binding = new InputParameterBinding(param.getParamName(), (IBaseExpression)new ScriptExpression(param.getExpression()));
                defn.addInputParamBinding(binding);
                ++i;
            }
            return defn;
        }
        return null;
    }

    public void updateModel(DataSetHandle ds, DataSetViewData[] columns) {
        PropertyHandle handle = ds.getPropertyHandle("columnHints");
        PropertyHandle resultSetColumnHandle = ds.getPropertyHandle("resultSetHints");
        Iterator iter = handle.iterator();
        if (iter != null) {
            block0: while (iter.hasNext()) {
                ColumnHintHandle hint = (ColumnHintHandle)iter.next();
                int n = 0;
                while (n < columns.length) {
                    String columnName = columns[n].getName();
                    if (resultSetColumnHandle != null && (columnName == null || columnName.trim().length() == 0)) {
                        Iterator resultIter = resultSetColumnHandle.iterator();
                        if (resultIter != null) {
                            while (resultIter.hasNext()) {
                                ResultSetColumnHandle column = (ResultSetColumnHandle)resultIter.next();
                                if (column.getPosition() != n + 1) continue;
                                columnName = column.getColumnName();
                                break;
                            }
                        }
                        if (columnName == null) {
                            columnName = "";
                        }
                        columns[n].setName(columnName);
                    }
                    if (columns[n].getName().equals(hint.getColumnName())) {
                        if (hint.getDisplayNameKey() != null) {
                            columns[n].setExternalizedName(hint.getExternalizedValue("displayNameID", "displayName", hint.getModule().getLocale()));
                        }
                        columns[n].setDisplayName(hint.getDisplayName());
                        columns[n].setDisplayNameKey(hint.getDisplayNameKey());
                        columns[n].setAlias(hint.getAlias());
                        columns[n].setHelpText(hint.getHelpText());
                        columns[n].setAnalysis(hint.getAnalysis());
                        columns[n].setActionHandle(hint.getActionHandle());
                        if ("attribute".equals(columns[n].getAnalysis())) {
                            columns[n].setAnalysisColumn(hint.getAnalysis());
                        } else {
                            columns[n].setAnalysis(null);
                            columns[n].setAnalysisColumn(null);
                        }
                        columns[n].setAnalysisColumn(hint.getAnalysisColumn());
                        columns[n].setACLExpression(hint.getACLExpression());
                        columns[n].setIndexColumn(hint.isIndexColumn());
                        columns[n].setRemoveDuplicateValues(hint.isCompressed());
                        continue block0;
                    }
                    ++n;
                }
            }
        }
    }

    public DataSetViewData[] getCachedDataSetItemModel(DataSetHandle ds, boolean needToFocusOnOutput) {
        this.needToFocusOnOutput = needToFocusOnOutput;
        DataSetViewData[] result = this.htColumns.get(ds);
        if (result == null) {
            DataRequestSession session = null;
            try {
                DataSessionContext context = new DataSessionContext(3, ds.getModuleHandle());
                session = DataRequestSession.newSession((DataSessionContext)context);
                DataSetViewData[] dataSetViewDataArray = result = this.populateAllOutputColumns(ds, session);
                return dataSetViewDataArray;
            }
            catch (BirtException birtException) {
                result = new DataSetViewData[]{};
            }
            finally {
                if (session != null) {
                    session.shutdown();
                }
            }
        }
        return result;
    }

    public static IConfigurationElement findDataSetElement(String dataSetType, String dataSourceType) {
        IConfigurationElement dataSourceElem = DataSetProvider.findDataSourceElement(dataSourceType);
        if (dataSourceElem != null) {
            IExtension ext = dataSourceElem.getDeclaringExtension();
            IConfigurationElement[] elements = ext.getConfigurationElements();
            int n = 0;
            while (n < elements.length) {
                if (elements[n].getAttribute("id").equals(dataSetType)) {
                    return elements[n];
                }
                ++n;
            }
        }
        return null;
    }

    public static IConfigurationElement findDataSourceElement(String dataSourceType) {
        assert (dataSourceType != null);
        IConfigurationElement element = htDataSourceExtensions.get(dataSourceType);
        if (element == null) {
            IConfigurationElement[] elements = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.birt.report.designer.ui.odadatasource");
            int n = 0;
            while (n < elements.length) {
                if (elements[n].getAttribute("id").equals(dataSourceType)) {
                    element = elements[n];
                    htDataSourceExtensions.put(dataSourceType, element);
                    break;
                }
                ++n;
            }
            elements = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.datatools.connectivity.oda.design.ui.dataSource");
            n = 0;
            while (n < elements.length) {
                if (elements[n].getAttribute("id").equals(dataSourceType)) {
                    element = elements[n];
                    htDataSourceExtensions.put(dataSourceType, element);
                    break;
                }
                ++n;
            }
        }
        return element;
    }

    private IBaseDataSetDesign getDataSetDesign(DataSetHandle dataSet, boolean useColumnHints, boolean useFilters, DataRequestSession session) throws BirtException {
        BaseDataSetDesign dataSetDesign = session.getModelAdaptor().adaptDataSet(dataSet);
        if (!useColumnHints) {
            dataSetDesign.getResultSetHints().clear();
        }
        if (!useFilters) {
            dataSetDesign.getFilters().clear();
        }
        if (!(dataSet instanceof JointDataSetHandle)) {
            BaseDataSourceDesign dataSourceDesign = session.getModelAdaptor().adaptDataSource(dataSet.getDataSource());
            session.defineDataSource((IBaseDataSourceDesign)dataSourceDesign);
        }
        if (dataSet instanceof JointDataSetHandle) {
            this.defineSourceDataSets(session, dataSet, (IBaseDataSetDesign)dataSetDesign);
        }
        session.defineDataSet((IBaseDataSetDesign)dataSetDesign);
        return dataSetDesign;
    }

    private void defineSourceDataSets(DataRequestSession session, DataSetHandle dataSet, IBaseDataSetDesign dataSetDesign) throws BirtException {
        List dataSets = dataSet.getModuleHandle().getAllDataSets();
        int i = 0;
        while (i < dataSets.size()) {
            DataSetHandle dsHandle = (DataSetHandle)dataSets.get(i);
            if (dsHandle.getName() != null && (dsHandle.getName().equals(((IJointDataSetDesign)dataSetDesign).getLeftDataSetDesignName()) || dsHandle.getName().equals(((IJointDataSetDesign)dataSetDesign).getRightDataSetDesignName()))) {
                this.getDataSetDesign(dsHandle, true, true, session);
            }
            ++i;
        }
    }

    public Collection getParametersFromDataSet(DataSetHandle dataSet) throws BirtException {
        DataRequestSession session = null;
        try {
            DataSessionContext context = new DataSessionContext(3, dataSet.getModuleHandle());
            session = DataRequestSession.newSession((DataSessionContext)context);
            IBaseDataSetDesign dataSetDesign = this.getDataSetDesign(dataSet, true, true, session);
            QueryDefinition queryDefn = this.getQueryDefinition(dataSetDesign, -1);
            IPreparedQuery query = session.prepare((IQueryDefinition)queryDefn, null);
            Collection collection = query.getParameterMetaData();
            return collection;
        }
        finally {
            if (session != null) {
                session.shutdown();
            }
        }
    }

    public static ClassLoader getCustomScriptClassLoader(ClassLoader parent, ModuleHandle handle) {
        List<URL> urls = DataSetProvider.getClassPathURLs(handle == null ? null : handle.getFileName());
        DataSetProvider.loadResourceFolderScriptLibs(handle, urls);
        if (urls.size() == 0) {
            return parent;
        }
        return new URLClassLoader(urls.toArray(new URL[0]), parent);
    }

    private static void loadResourceFolderScriptLibs(ModuleHandle handle, List<URL> urls) {
        Iterator it = handle.scriptLibsIterator();
        while (it.hasNext()) {
            ScriptLibHandle libHandle = (ScriptLibHandle)it.next();
            URL url = handle.findResource(libHandle.getName(), 2);
            if (url == null) continue;
            urls.add(url);
        }
    }

    private static List<URL> getClassPathURLs(String reportFilePath) {
        ArrayList<URL> urls = new ArrayList<URL>();
        urls.addAll(DataSetProvider.getDefaultViewerScriptLibURLs());
        urls.addAll(DataSetProvider.getWorkspaceProjectURLs(reportFilePath));
        return urls;
    }

    private static List<URL> getDefaultViewerScriptLibURLs() {
        ArrayList<URL> urls = new ArrayList<URL>();
        try {
            Bundle bundle = Platform.getBundle((String)VIEWER_NAMESPACE);
            Enumeration bundleFile = bundle.getEntryPaths(BIRT_SCRIPTLIB);
            while (bundleFile.hasMoreElements()) {
                String o = bundleFile.nextElement().toString();
                if (!o.endsWith(".jar")) continue;
                urls.add(bundle.getResource(o));
            }
            URL classes = bundle.getEntry(BIRT_CLASSES);
            if (classes != null) {
                urls.add(classes);
            }
        }
        catch (Exception exception) {}
        return urls;
    }

    private static List<URL> getWorkspaceProjectURLs(String reportFilePath) {
        return DatasetClassPathHelper.getWorkspaceClassPath(reportFilePath);
    }

    public void clear(DataSetHandle dataSetHandle) {
        if (dataSetHandle != null) {
            this.htColumns.remove(dataSetHandle);
        }
    }

    public void clearAll() {
        this.htColumns.clear();
    }
}

