/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.emitter.config.impl;

import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.birt.core.framework.IBundle;
import org.eclipse.birt.core.framework.Platform;
import org.eclipse.birt.report.engine.emitter.config.IDefaultConfigLoader;
import org.eclipse.birt.report.engine.emitter.config.IEmitterDescriptor;
import org.eclipse.birt.report.engine.emitter.config.RenderOptionDefn;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JarConfigLoader
implements IDefaultConfigLoader {
    private static final String OPTIONS_CONFIG_FILE = "RenderDefaults.cfg";
    private static final String RENDER_OPTIONS_FILE = "RenderOptions.xml";
    private static final String OPTION_QNAME = "option";
    private static final String OPTION_NAME = "name";
    private static final String OPTION_DEFAULT = "default";
    private static final String OPTION_ENABLED = "enabled";
    protected Map<String, RenderOptionDefn> options = new HashMap<String, RenderOptionDefn>();

    @Override
    public Map<String, RenderOptionDefn> loadConfigFor(String bundleName, IEmitterDescriptor descriptor) {
        this.options.clear();
        try {
            this.parseConfigFor(bundleName);
        }
        catch (Exception exception) {}
        return this.options;
    }

    @Override
    public int getPriority() {
        return 0;
    }

    protected void parseConfigFor(String bundleName) throws Exception {
        this.loadCfgFile(this.getResourceURL(bundleName, OPTIONS_CONFIG_FILE));
        this.loadXMLFile(bundleName, RENDER_OPTIONS_FILE);
    }

    protected DefaultHandler getHandler() {
        return new RenderOptionHandler();
    }

    protected void loadCfgFile(URL url) throws Exception {
        if (url != null) {
            InputStream in = url.openStream();
            Properties defaultValues = new Properties();
            defaultValues.load(in);
            for (Map.Entry<Object, Object> entry : defaultValues.entrySet()) {
                String name = entry.getKey().toString();
                String value = entry.getValue().toString();
                this.options.put(name, new RenderOptionDefn(name, value, true));
            }
            in.close();
        }
    }

    protected void loadXMLFile(String bundleName, String fileName) throws Exception {
        URL url = this.getResourceURL(bundleName, fileName);
        if (url != null) {
            InputStream in = url.openStream();
            this.parseConfigXML(in);
            in.close();
        }
    }

    private void parseConfigXML(InputStream in) throws Exception {
        SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
        try {
            parser.parse(in, this.getHandler());
        }
        catch (Throwable throwable) {
            try {
                parser.reset();
                parser = null;
            }
            catch (Exception exception) {}
            throw throwable;
        }
        try {
            parser.reset();
            parser = null;
        }
        catch (Exception exception) {}
    }

    private URL getResourceURL(String bundleName, String resourceName) {
        IBundle bundle = Platform.getBundle((String)bundleName);
        if (bundle != null) {
            return bundle.getEntry(resourceName);
        }
        return null;
    }

    protected class RenderOptionHandler
    extends DefaultHandler {
        protected RenderOptionHandler() {
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            String name;
            if (JarConfigLoader.OPTION_QNAME.equalsIgnoreCase(qName) && !this.isEmpty(name = attributes.getValue(JarConfigLoader.OPTION_NAME))) {
                String defualt = attributes.getValue(JarConfigLoader.OPTION_DEFAULT);
                Boolean enabled = Boolean.TRUE;
                String enabledStr = attributes.getValue(JarConfigLoader.OPTION_ENABLED);
                if (!this.isEmpty(enabledStr)) {
                    enabled = Boolean.valueOf(enabledStr);
                }
                JarConfigLoader.this.options.put(name, new RenderOptionDefn(name, defualt, enabled));
            }
        }

        protected boolean isEmpty(String str) {
            return str == null || str.length() == 0;
        }
    }
}

