/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.common.ui.composite;

import org.eclipse.bpel.common.ui.composite.CompositeEditorKeyBindingService;
import org.eclipse.bpel.common.ui.composite.CompositeEditorSelectionProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IKeyBindingService;
import org.eclipse.ui.internal.EditorSite;
import org.eclipse.ui.internal.WorkbenchPage;
import org.eclipse.ui.internal.registry.EditorDescriptor;

public class CompositeEditorSite
extends EditorSite {
    protected IEditorSite parent;
    protected CompositeEditorKeyBindingService keyBindingService;
    private ISelectionProvider selectionProvider;
    private ISelectionChangedListener selectionChangedListener;

    public CompositeEditorSite(IEditorSite parent, IEditorReference ref, IEditorPart editor, WorkbenchPage page, EditorDescriptor desc) {
        super(ref, editor, page, desc);
        this.parent = parent;
    }

    public IKeyBindingService getKeyBindingService() {
        if (this.keyBindingService == null) {
            this.keyBindingService = new CompositeEditorKeyBindingService(this.parent.getKeyBindingService());
        }
        return this.keyBindingService;
    }

    public void activate() {
        if (this.keyBindingService == null) {
            return;
        }
        this.keyBindingService.activate();
    }

    public void deactivate() {
        if (this.keyBindingService == null) {
            return;
        }
        this.keyBindingService.deactivate();
    }

    public void setSelectionProvider(ISelectionProvider provider) {
        ISelectionProvider oldSelectionProvider = this.selectionProvider;
        this.selectionProvider = provider;
        if (oldSelectionProvider != null) {
            oldSelectionProvider.removeSelectionChangedListener(this.getSelectionChangedListener());
        }
        if (this.selectionProvider != null) {
            this.selectionProvider.addSelectionChangedListener(this.getSelectionChangedListener());
        }
    }

    private ISelectionChangedListener getSelectionChangedListener() {
        if (this.selectionChangedListener == null) {
            this.selectionChangedListener = new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    CompositeEditorSite.this.handleSelectionChanged(event);
                }
            };
        }
        return this.selectionChangedListener;
    }

    protected void handleSelectionChanged(SelectionChangedEvent event) {
        ISelectionProvider parentProvider = this.parent.getSelectionProvider();
        if (parentProvider instanceof CompositeEditorSelectionProvider) {
            SelectionChangedEvent newEvent = new SelectionChangedEvent(parentProvider, event.getSelection());
            ((CompositeEditorSelectionProvider)parentProvider).fireSelectionChanged(newEvent);
        }
    }

    public ISelectionProvider getSelectionProvider() {
        return this.selectionProvider;
    }
}

