/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.common.ui.composite;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.bpel.common.ui.CommonUIPlugin;
import org.eclipse.bpel.common.ui.Messages;
import org.eclipse.bpel.common.ui.Utils;
import org.eclipse.bpel.common.ui.composite.CompositeEditorActionBars;
import org.eclipse.bpel.common.ui.composite.EditorInViewSite;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.CoolBarManager;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.ICoolBarManager;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IActionBars2;
import org.eclipse.ui.IEditorActionBarContributor;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.SubActionBars;
import org.eclipse.ui.internal.EditorActionBuilder;
import org.eclipse.ui.internal.EditorManager;
import org.eclipse.ui.internal.EditorReference;
import org.eclipse.ui.internal.EditorSite;
import org.eclipse.ui.internal.WorkbenchPage;
import org.eclipse.ui.internal.registry.EditorDescriptor;
import org.eclipse.ui.services.IServiceLocator;

public class EditorInViewManager {
    protected WorkbenchPage page;
    protected IViewSite fViewSite;
    protected Map<String, EditorDescriptor> idToDescriptor;
    protected EditorManager eclipseEditorManager;
    private static final String EXTPT_EMBEDDED_EDITORS = "embeddedEditors";
    private static final String CHILD_EDITOR = "editor";
    private static final String ATT_EDITOR_ID = "id";
    private static final String ATT_EDITOR_CLASS = "class";

    public EditorInViewManager(IViewSite viewSite) {
        this.fViewSite = viewSite;
        this.idToDescriptor = new HashMap<String, EditorDescriptor>(10);
        this.page = (WorkbenchPage)viewSite.getPage();
    }

    public IEditorPart createEditor(String editorId, IEditorInput input) throws CoreException {
        IEditorPart editor = this.instantiateEditor(editorId);
        EditorSite site = this.createEditorSite(editorId, input, editor);
        editor.init((IEditorSite)site, input);
        return editor;
    }

    protected IEditorPart instantiateEditor(String editorId) throws CoreException {
        EditorDescriptor descriptor = this.idToDescriptor.get(editorId);
        if (descriptor == null && (descriptor = this.readDescriptor(editorId)) == null) {
            Status status = new Status(4, "org.eclipse.bpel.common.ui", 2, NLS.bind((String)Messages.CompositeEditorManager_Could_not_find_editor, (Object[])new Object[]{editorId}), null);
            throw new CoreException((IStatus)status);
        }
        return (IEditorPart)descriptor.getConfigurationElement().createExecutableExtension(ATT_EDITOR_CLASS);
    }

    protected EditorDescriptor readDescriptor(String editorId) {
        IConfigurationElement[] iConfigurationElementArray = Utils.getConfigurationElements(EXTPT_EMBEDDED_EDITORS);
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            if (CHILD_EDITOR.equals(element.getName())) {
                String extensionId = element.getAttribute(ATT_EDITOR_ID);
                if (extensionId == null) {
                    String pluginId = element.getDeclaringExtension().getNamespace();
                    Status status = new Status(4, pluginId, 1, Messages.CompositeEditorManager_5, null);
                    CommonUIPlugin.getDefault().getLog().log((IStatus)status);
                } else if (editorId.equals(extensionId)) {
                    try {
                        Constructor constuctor = EditorDescriptor.class.getDeclaredConstructor(new Class[0]);
                        constuctor.setAccessible(true);
                        EditorDescriptor descriptor = (EditorDescriptor)constuctor.newInstance(new Object[0]);
                        Method method = descriptor.getClass().getDeclaredMethod("setID", String.class);
                        method.setAccessible(true);
                        method.invoke((Object)descriptor, editorId);
                        method = descriptor.getClass().getDeclaredMethod("setConfigurationElement", IConfigurationElement.class);
                        method.setAccessible(true);
                        method.invoke((Object)descriptor, element);
                        method = descriptor.getClass().getDeclaredMethod("setName", String.class);
                        method.setAccessible(true);
                        method.invoke((Object)descriptor, editorId);
                        this.idToDescriptor.put(editorId, descriptor);
                        return descriptor;
                    }
                    catch (SecurityException e) {
                        CommonUIPlugin.getDefault().createErrorStatus("Problem creating descriptor for " + editorId, e, true);
                    }
                    catch (IllegalArgumentException e) {
                        CommonUIPlugin.getDefault().createErrorStatus("Problem creating descriptor for " + editorId, e, true);
                    }
                    catch (NoSuchMethodException e) {
                        CommonUIPlugin.getDefault().createErrorStatus("Problem creating descriptor for " + editorId, e, true);
                    }
                    catch (InstantiationException e) {
                        CommonUIPlugin.getDefault().createErrorStatus("Problem creating descriptor for " + editorId, e, true);
                    }
                    catch (IllegalAccessException e) {
                        CommonUIPlugin.getDefault().createErrorStatus("Problem creating descriptor for " + editorId, e, true);
                    }
                    catch (InvocationTargetException e) {
                        CommonUIPlugin.getDefault().createErrorStatus("Problem creating descriptor for " + editorId, e, true);
                    }
                }
            }
            ++n2;
        }
        return null;
    }

    protected EditorSite createEditorSite(String editorId, IEditorInput input, IEditorPart editor) {
        EditorDescriptor descriptor = this.idToDescriptor.get(editorId);
        EditorReference ref = new EditorReference(this.getEditorManager(), input, descriptor);
        EditorInViewSite site = new EditorInViewSite(this.fViewSite, (IEditorReference)ref, editor, this.page, descriptor);
        IEditorActionBarContributor contributor = descriptor.createActionBarContributor();
        site.setActionBars((SubActionBars)this.createEditorActionBars(descriptor, contributor, site));
        return site;
    }

    protected CompositeEditorActionBars createEditorActionBars(EditorDescriptor descriptor, IEditorActionBarContributor contributor, EditorSite site) {
        EditorActionBuilder builder;
        IEditorActionBarContributor extension;
        String type = String.valueOf(System.currentTimeMillis());
        CompositeEditorActionBars actionBars = new CompositeEditorActionBars(this.page, (IServiceLocator)site, type);
        if (contributor != null) {
            actionBars.setEditorContributor(contributor);
            contributor.init((IActionBars)actionBars, (IWorkbenchPage)this.page);
        }
        if ((extension = (builder = new EditorActionBuilder()).readActionExtensions((IEditorDescriptor)descriptor)) != null) {
            actionBars.setExtensionContributor(extension);
            extension.init((IActionBars)actionBars, (IWorkbenchPage)this.page);
        }
        return actionBars;
    }

    protected IActionBars2 getIActionBars2Wrapper(final IActionBars actionBars) {
        return new IActionBars2(){

            public ICoolBarManager getCoolBarManager() {
                return new CoolBarManager();
            }

            public void clearGlobalActionHandlers() {
                actionBars.clearGlobalActionHandlers();
            }

            public IAction getGlobalActionHandler(String actionId) {
                return actionBars.getGlobalActionHandler(actionId);
            }

            public IMenuManager getMenuManager() {
                return EditorInViewManager.this.page.getActionBars().getMenuManager();
            }

            public IStatusLineManager getStatusLineManager() {
                return actionBars.getStatusLineManager();
            }

            public IToolBarManager getToolBarManager() {
                return actionBars.getToolBarManager();
            }

            public void setGlobalActionHandler(String actionId, IAction handler) {
                actionBars.setGlobalActionHandler(actionId, handler);
            }

            public void updateActionBars() {
                actionBars.updateActionBars();
            }

            public IServiceLocator getServiceLocator() {
                return actionBars.getServiceLocator();
            }
        };
    }

    public void activate(IEditorPart editor) {
        editor.setFocus();
        IEditorSite site = editor.getEditorSite();
        CompositeEditorActionBars actionBars = (CompositeEditorActionBars)site.getActionBars();
        actionBars.partChanged((IWorkbenchPart)editor);
        actionBars.activate(true);
        ((EditorInViewSite)site).activate();
    }

    public void deactivate(IEditorPart editor) {
        if (editor != null) {
            CompositeEditorActionBars actionBars = (CompositeEditorActionBars)editor.getEditorSite().getActionBars();
            actionBars.deactivate(true);
            IEditorSite site = editor.getEditorSite();
            ((EditorInViewSite)site).deactivate();
        }
    }

    public IEditorPart createEditor(String editorId, IEditorInput input, Composite editorComposite) throws CoreException {
        IEditorPart editor = this.createEditor(editorId, input);
        Composite composite = new Composite(editorComposite, 0);
        composite.setLayout((Layout)new FillLayout());
        editor.createPartControl(composite);
        this.associate(editor, (Control)composite);
        return editor;
    }

    protected void associate(final IEditorPart editor, Control control) {
        control.addListener(26, new Listener(){

            public void handleEvent(Event event) {
                EditorInViewManager.this.activate(editor);
            }
        });
        control.addListener(27, new Listener(){

            public void handleEvent(Event event) {
                EditorInViewManager.this.deactivate(editor);
            }
        });
    }

    public void disposeEditor(IEditorPart editor) {
        EditorInViewSite site = (EditorInViewSite)editor.getSite();
        CompositeEditorActionBars actionBars = (CompositeEditorActionBars)site.getActionBars();
        actionBars.dispose();
        site.dispose();
        try {
            editor.dispose();
        }
        catch (Throwable throwable) {
            System.out.println("disposeEditor: " + editor);
        }
    }

    public EditorManager getEditorManager() {
        if (this.eclipseEditorManager == null) {
            try {
                Field field = WorkbenchPage.class.getDeclaredField("editorMgr");
                field.setAccessible(true);
                this.eclipseEditorManager = (EditorManager)field.get(this.page);
            }
            catch (Exception e) {
                CommonUIPlugin.log(e);
            }
        }
        return this.eclipseEditorManager;
    }
}

