/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.ui.properties;

import org.eclipse.bpel.common.ui.details.IOngoingChange;
import org.eclipse.bpel.common.ui.editmodel.AbstractEditModelCommand;
import org.eclipse.bpel.ui.IBPELUIConstants;
import org.eclipse.bpel.ui.Policy;
import org.eclipse.bpel.ui.commands.CompoundCommand;
import org.eclipse.bpel.ui.expressions.IExpressionEditor;
import org.eclipse.bpel.ui.properties.BPELPropertySection;
import org.eclipse.bpel.ui.properties.IGetExpressionEditor;
import org.eclipse.bpel.ui.util.BatchedMultiObjectAdapter;
import org.eclipse.bpel.ui.util.MultiObjectAdapter;
import org.eclipse.core.resources.IMarker;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.gef.commands.Command;
import org.eclipse.swt.widgets.Composite;

public abstract class TextSection
extends BPELPropertySection
implements IGetExpressionEditor {
    protected static final String NL = "\n";
    protected IExpressionEditor fEditor;
    protected boolean updating = false;
    protected IOngoingChange change;

    protected void disposeEditor() {
        if (this.fEditor != null) {
            this.fEditor.dispose();
            this.fEditor = null;
        }
    }

    @Override
    protected MultiObjectAdapter[] createAdapters() {
        BatchedMultiObjectAdapter adapter = new BatchedMultiObjectAdapter(){
            boolean needRefresh = false;

            @Override
            public void notify(Notification n) {
                if (TextSection.this.markersHaveChanged(n)) {
                    TextSection.this.updateMarkers();
                    return;
                }
                this.needRefresh = this.needRefresh || TextSection.this.isBodyAffected(n);
                TextSection.this.refreshAdapters();
            }

            @Override
            public void finish() {
                if (this.needRefresh) {
                    TextSection.this.updateWidgets();
                }
                this.needRefresh = false;
            }
        };
        return new MultiObjectAdapter[]{adapter};
    }

    protected String getCommandLabel() {
        return IBPELUIConstants.CMD_EDIT_EXPRESSION;
    }

    protected void createChangeHelper() {
        this.change = new IOngoingChange(){

            public String getLabel() {
                return TextSection.this.getCommandLabel();
            }

            public Command createApplyCommand() {
                if (TextSection.this.fEditor == null) {
                    return null;
                }
                CompoundCommand result = TextSection.this.makeCompound(TextSection.this.newStoreToModelCommand(TextSection.this.fEditor.getEditorContent()));
                if (result == null) {
                    return null;
                }
                result.add((Command)new AbstractEditModelCommand(){

                    public void execute() {
                        if ((this).TextSection.this.fEditor != null) {
                            (this).TextSection.this.fEditor.markAsClean();
                        }
                    }

                    public Resource[] getResources() {
                        return EMPTY_RESOURCE_ARRAY;
                    }

                    public Resource[] getModifiedResources() {
                        return EMPTY_RESOURCE_ARRAY;
                    }
                });
                return TextSection.this.wrapInShowContextCommand((Command)result);
            }

            public void restoreOldState() {
                TextSection.this.updateWidgets();
            }
        };
    }

    public boolean shouldUseExtraSpace() {
        return true;
    }

    @Override
    protected void createClient(Composite parent) {
        this.createEditor(parent);
        this.createChangeHelper();
    }

    protected abstract void createEditor(Composite var1);

    protected void notifyEditorChanged() {
        if (this.change != null) {
            this.getCommandFramework().notifyChangeInProgress(this.change);
        }
    }

    protected abstract void updateEditor();

    @Override
    public void aboutToBeHidden() {
        if (Policy.DEBUG) {
            System.out.println("exprdetails.aboutToBeHidden() - " + this);
        }
        super.aboutToBeHidden();
        if (this.change != null) {
            this.getCommandFramework().notifyChangeDone(this.change);
        }
        if (this.fEditor != null) {
            this.fEditor.aboutToBeHidden();
        }
    }

    @Override
    public void aboutToBeShown() {
        if (Policy.DEBUG) {
            System.out.println("exprdetails.aboutToBeShown() - " + this);
        }
        super.aboutToBeShown();
        if (this.fEditor != null) {
            this.fEditor.aboutToBeShown();
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        this.disposeEditor();
    }

    protected void updateWidgets() {
        assert (this.getInput() != null);
        if (!this.updating) {
            this.updating = true;
            try {
                this.updateEditor();
            }
            finally {
                this.updating = false;
            }
        }
    }

    @Override
    public Object getUserContext() {
        return this.fEditor == null ? null : this.fEditor.getUserContext();
    }

    @Override
    public void restoreUserContext(Object userContext) {
        if (this.fEditor != null) {
            this.fEditor.restoreUserContext(userContext);
        }
    }

    @Override
    public IExpressionEditor getExpressionEditor() {
        return this.fEditor;
    }

    protected abstract Command newStoreToModelCommand(Object var1);

    protected abstract boolean isBodyAffected(Notification var1);

    @Override
    public void gotoMarker(IMarker marker) {
        String useType = null;
        IExpressionEditor editor = this.getExpressionEditor();
        if (editor == null) {
            return;
        }
        editor.gotoTextMarker(marker, useType, this.fModelObject);
    }
}

