/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.core.adapters;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.eclipse.bpmn2.ExtensionAttributeValue;
import org.eclipse.bpmn2.modeler.core.ToolTipProvider;
import org.eclipse.bpmn2.modeler.core.adapters.AdapterRegistry;
import org.eclipse.bpmn2.modeler.core.adapters.AdapterUtil;
import org.eclipse.bpmn2.modeler.core.adapters.FeatureDescriptor;
import org.eclipse.bpmn2.modeler.core.adapters.IResourceProvider;
import org.eclipse.bpmn2.modeler.core.adapters.ObjectDescriptor;
import org.eclipse.bpmn2.modeler.core.adapters.ObjectPropertyProvider;
import org.eclipse.bpmn2.modeler.core.utils.ModelUtil;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.transaction.TransactionalEditingDomain;

public class ExtendedPropertiesAdapter<T extends EObject>
extends ObjectPropertyProvider {
    public static final String LONG_DESCRIPTION = "long.description";
    public static final String UI_CAN_EDIT = "ui.can.edit";
    public static final String UI_CAN_EDIT_INLINE = "ui.can.edit.inline";
    public static final String UI_CAN_CREATE_NEW = "ui.can.create.new";
    public static final String UI_CAN_SET_NULL = "ui.can.set.null";
    public static final String UI_IS_MULTI_CHOICE = "ui.is.multi.choice";
    public static final String OBJECT_DESCRIPTOR = "object.descriptor";
    public static final String FEATURE_DESCRIPTOR = "feature.descriptor";
    public static final String LINE_NUMBER = "line.number";
    public static final String IS_EXTENSION_FEATURE = "is.extension.feature";
    private static Hashtable<EClass, EObject> dummyObjects = new Hashtable();
    private Hashtable<EStructuralFeature, Hashtable<String, Object>> featureProperties = new Hashtable();
    private AdapterFactory adapterFactory;

    public ExtendedPropertiesAdapter(AdapterFactory adapterFactory, T object) {
        super(object.eResource());
        this.adapterFactory = adapterFactory;
        this.setTarget((Notifier)object);
    }

    public static ExtendedPropertiesAdapter adapt(Object object) {
        return ExtendedPropertiesAdapter.adapt(object, null);
    }

    public static ExtendedPropertiesAdapter adapt(Object object, EStructuralFeature feature) {
        ExtendedPropertiesAdapter adapter = null;
        if (object instanceof ExtensionAttributeValue) {
            object = ((ExtensionAttributeValue)object).eContainer();
        }
        if (object instanceof EObject) {
            EObject eObject = (EObject)object;
            ExtendedPropertiesAdapter genericAdapter = null;
            for (Adapter a : eObject.eAdapters()) {
                if (!(a instanceof ExtendedPropertiesAdapter) || !((ExtendedPropertiesAdapter)a).canAdapt(eObject, feature)) continue;
                if (a.getClass() == ExtendedPropertiesAdapter.class) {
                    genericAdapter = (ExtendedPropertiesAdapter)a;
                    continue;
                }
                adapter = (ExtendedPropertiesAdapter)a;
            }
            if (adapter == null && genericAdapter != null) {
                adapter = genericAdapter;
            }
            EObject eclass = ExtendedPropertiesAdapter.getFeatureClass(eObject, feature);
            if (adapter == null) {
                adapter = AdapterUtil.adapt((Object)eclass, ExtendedPropertiesAdapter.class);
            }
            if (adapter != null) {
                EObject dummy;
                if (eObject instanceof EClass && (dummy = ExtendedPropertiesAdapter.getDummyObject((EClass)eObject)) != null) {
                    eObject = dummy;
                }
                adapter.setTarget((Notifier)eObject);
                adapter.getObjectDescriptor().setObject(eObject);
                if (feature != null) {
                    adapter.getFeatureDescriptor(feature).setObject(eObject);
                }
            }
        }
        return adapter;
    }

    public static EObject getDummyObject(EClass eclass) {
        EObject object = dummyObjects.get(eclass);
        if (object == null && eclass.eContainer() instanceof EPackage && !eclass.isAbstract()) {
            EPackage pkg = (EPackage)eclass.eContainer();
            object = pkg.getEFactoryInstance().create(eclass);
            dummyObjects.put(eclass, object);
        }
        return object;
    }

    public AdapterFactory getAdapterFactory() {
        return this.adapterFactory;
    }

    public void setObjectDescriptor(ObjectDescriptor<T> od) {
        this.setProperty(OBJECT_DESCRIPTOR, od);
        od.setOwner(this);
    }

    private static EObject getFeatureClass(EObject object, EStructuralFeature feature) {
        EClass eclass = null;
        if (feature != null && feature.eContainer() instanceof EClass) {
            eclass = (EClass)feature.eContainer();
        }
        if (eclass == null || eclass.isAbstract()) {
            return object;
        }
        return eclass;
    }

    public ObjectDescriptor<T> getObjectDescriptor() {
        ObjectDescriptor<EObject> od = (ObjectDescriptor<EObject>)this.getProperty(OBJECT_DESCRIPTOR);
        if (od == null) {
            od = new ObjectDescriptor<EObject>(this, (EObject)this.getTarget());
            this.setObjectDescriptor(od);
        }
        return od;
    }

    public boolean hasFeatureDescriptor(EStructuralFeature feature) {
        FeatureDescriptor fd = (FeatureDescriptor)this.getProperty(feature, FEATURE_DESCRIPTOR);
        return fd != null;
    }

    public FeatureDescriptor<T> getFeatureDescriptor(EStructuralFeature feature) {
        FeatureDescriptor<EObject> fd = (FeatureDescriptor<EObject>)this.getProperty(feature, FEATURE_DESCRIPTOR);
        if (fd == null) {
            fd = new FeatureDescriptor<EObject>(this, (EObject)this.getTarget(), feature);
            this.setFeatureDescriptor(feature, fd);
        }
        return fd;
    }

    public FeatureDescriptor<T> getFeatureDescriptor(String featureName) {
        EStructuralFeature feature = this.getFeature(featureName);
        return this.getFeatureDescriptor(feature);
    }

    public void setFeatureDescriptor(EStructuralFeature feature, FeatureDescriptor<T> fd) {
        Hashtable<String, Object> props = this.featureProperties.get(feature);
        if (props == null) {
            props = new Hashtable();
            this.featureProperties.put(feature, props);
        }
        fd.setOwner(this);
        props.put(FEATURE_DESCRIPTOR, fd);
    }

    public EStructuralFeature getFeature(String name) {
        ExtendedPropertiesAdapter adapter;
        EObject container;
        Object object = this.getObjectDescriptor().object;
        if (object instanceof ExtensionAttributeValue && (container = ((ExtensionAttributeValue)object).eContainer()) != null && (adapter = ExtendedPropertiesAdapter.adapt(container)) != null) {
            return adapter.getFeature(name);
        }
        for (Map.Entry<EStructuralFeature, Hashtable<String, Object>> entry : this.featureProperties.entrySet()) {
            EStructuralFeature feature = entry.getKey();
            if (!feature.getName().equals(name)) continue;
            return feature;
        }
        return null;
    }

    public List<EStructuralFeature> getFeatures() {
        ExtendedPropertiesAdapter adapter;
        EObject container;
        Object object = this.getObjectDescriptor().object;
        if (object instanceof ExtensionAttributeValue && (container = ((ExtensionAttributeValue)object).eContainer()) != null && (adapter = ExtendedPropertiesAdapter.adapt(container)) != null) {
            return adapter.getFeatures();
        }
        ArrayList<EStructuralFeature> features = new ArrayList<EStructuralFeature>();
        features.addAll(this.featureProperties.keySet());
        return features;
    }

    public List<EStructuralFeature> getExtensionFeatures() {
        ArrayList<EStructuralFeature> features = new ArrayList<EStructuralFeature>();
        for (EStructuralFeature f : this.getFeatures()) {
            FeatureDescriptor<T> fd = this.getFeatureDescriptor(f);
            if (fd.getProperty(IS_EXTENSION_FEATURE) == null) continue;
            features.add(f);
        }
        return features;
    }

    private Hashtable<String, Object> getObjectProperties() {
        if (this.properties == null) {
            this.properties = new Hashtable();
        }
        return this.properties;
    }

    @Override
    public Object getProperty(String key) {
        return this.getObjectProperties().get(key);
    }

    @Override
    public void setProperty(String key, Object value) {
        if (value == null) {
            this.getObjectProperties().remove(key);
        } else {
            this.getObjectProperties().put(key, value);
        }
    }

    public Object getProperty(EStructuralFeature feature, String key) {
        Hashtable<String, Object> props = this.featureProperties.get(feature);
        if (props == null) {
            props = new Hashtable();
            this.featureProperties.put(feature, props);
        }
        return props.get(key);
    }

    public boolean getBooleanProperty(String key) {
        Object result = this.getProperty(key);
        if (result instanceof Boolean) {
            return (Boolean)result;
        }
        return false;
    }

    public boolean getBooleanProperty(EStructuralFeature feature, String key) {
        Object result = this.getProperty(feature, key);
        if (result instanceof Boolean) {
            return (Boolean)result;
        }
        return false;
    }

    public void setProperty(EStructuralFeature feature, String key, Object value) {
        Hashtable<String, Object> props = this.featureProperties.get(feature);
        if (props == null) {
            props = new Hashtable();
            this.featureProperties.put(feature, props);
        }
        props.put(key, value);
    }

    public void setTarget(Notifier newTarget) {
        super.setTarget(newTarget);
        if (newTarget instanceof EObject && !(newTarget instanceof EClass)) {
            EObject object = (EObject)newTarget;
            for (Adapter a : object.eAdapters()) {
                if (!(a instanceof ExtendedPropertiesAdapter)) continue;
                return;
            }
            object.eAdapters().add((Object)this);
        }
    }

    public boolean canAdapt(EObject object, EStructuralFeature feature) {
        if (object != null && this.getObjectDescriptor().object.eClass() == object.eClass()) {
            if (feature == null) {
                return true;
            }
            Hashtable<String, Object> props = this.featureProperties.get(feature);
            if (props != null) {
                return true;
            }
        }
        return false;
    }

    public String getDescription(EObject object) {
        return ToolTipProvider.INSTANCE.getLongDescription(this.adapterFactory, object);
    }

    public static boolean compare(EObject thisObject, EObject otherObject, boolean similar) {
        for (EStructuralFeature f : thisObject.eClass().getEAllStructuralFeatures()) {
            ExtendedPropertiesAdapter adapter;
            if (similar && "id".equals(f.getName())) continue;
            Object v1 = otherObject.eGet(f);
            Object v2 = thisObject.eGet(f);
            if (v1 == null && v2 == null) continue;
            if (v1 == null || v2 == null) {
                return false;
            }
            if (v1.equals(v2)) continue;
            if (ModelUtil.isStringWrapper(v1) && ModelUtil.isStringWrapper(v2)) {
                v1 = ModelUtil.getStringWrapperValue(v1);
                v2 = ModelUtil.getStringWrapperValue(v2);
                if (v1 == null && v2 == null) continue;
                if (v1 == null || v2 == null) {
                    return false;
                }
                if (v1.equals(v2)) {
                    continue;
                }
            } else if (v1 instanceof EObject && v2 instanceof EObject && (adapter = ExtendedPropertiesAdapter.adapt((EObject)v1)) != null && adapter.getObjectDescriptor().compare((EObject)v2, similar)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Resource getResource() {
        IResourceProvider rp;
        ObjectDescriptor od;
        Resource resource = super.getResource();
        if (resource == null && (od = (ObjectDescriptor)this.getProperty(OBJECT_DESCRIPTOR)) != null && (rp = AdapterRegistry.INSTANCE.adapt((Object)od.object.eContainer(), IResourceProvider.class)) != null && rp != this) {
            resource = rp.getResource();
        }
        if (resource == null) {
            return super.getResource();
        }
        return resource;
    }

    public TransactionalEditingDomain getEditingDomain() {
        ComposeableAdapterFactory rootAdapterFactory;
        EditingDomain result = null;
        if (this.adapterFactory instanceof IEditingDomainProvider) {
            result = ((IEditingDomainProvider)this.adapterFactory).getEditingDomain();
        }
        if (result == null && this.adapterFactory instanceof ComposeableAdapterFactory && (rootAdapterFactory = ((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory()) instanceof IEditingDomainProvider) {
            result = ((IEditingDomainProvider)rootAdapterFactory).getEditingDomain();
        }
        if (result instanceof TransactionalEditingDomain) {
            return (TransactionalEditingDomain)result;
        }
        return null;
    }
}

