/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.core.adapters;

import java.util.Hashtable;
import java.util.List;
import org.eclipse.bpmn2.Bpmn2Package;
import org.eclipse.bpmn2.modeler.core.adapters.ExtendedPropertiesAdapter;
import org.eclipse.bpmn2.modeler.core.utils.ModelUtil;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;

public class ExtendedPropertiesProvider {
    public static String getLabel(EObject object) {
        String label = "";
        ExtendedPropertiesAdapter adapter = ExtendedPropertiesAdapter.adapt(object);
        if (adapter != null) {
            label = adapter.getObjectDescriptor().getLabel();
        } else if (object != null) {
            label = ModelUtil.toCanonicalString(object.eClass().getName());
        }
        return label;
    }

    public static void setLabel(EObject object, String label) {
        ExtendedPropertiesAdapter adapter = ExtendedPropertiesAdapter.adapt(object);
        if (adapter != null) {
            adapter.getObjectDescriptor().setLabel(label);
        }
    }

    public static String getLabel(EObject object, EStructuralFeature feature) {
        String label = "";
        ExtendedPropertiesAdapter adapter = ExtendedPropertiesAdapter.adapt((Object)object, feature);
        label = adapter != null ? adapter.getFeatureDescriptor(feature).getLabel() : ModelUtil.toCanonicalString(feature.getName());
        label = label.replaceAll(" Ref$", "");
        return label;
    }

    public static void setLabel(EObject object, EStructuralFeature feature, String label) {
        ExtendedPropertiesAdapter adapter = ExtendedPropertiesAdapter.adapt((Object)object, feature);
        if (adapter != null) {
            adapter.getFeatureDescriptor(feature).setLabel(label);
        }
    }

    public static String getTextValue(EObject object) {
        String text;
        ExtendedPropertiesAdapter adapter = ExtendedPropertiesAdapter.adapt(object);
        if (adapter != null && (text = adapter.getObjectDescriptor().getTextValue()) != null && !text.isEmpty()) {
            return text;
        }
        return ModelUtil.toCanonicalString(object);
    }

    public static boolean setTextValue(EObject object, String value) {
        ExtendedPropertiesAdapter adapter = ExtendedPropertiesAdapter.adapt(object);
        if (adapter != null) {
            adapter.getObjectDescriptor().setTextValue(value);
            return true;
        }
        return false;
    }

    public static String getTextValue(EObject object, EStructuralFeature feature) {
        if (feature == null) {
            return ExtendedPropertiesProvider.getTextValue(object);
        }
        ExtendedPropertiesAdapter adapter = ExtendedPropertiesAdapter.adapt((Object)object, feature);
        if (adapter != null) {
            return adapter.getFeatureDescriptor(feature).getTextValue();
        }
        try {
            Object value = object.eGet(feature);
            return value.toString();
        }
        catch (Exception exception) {
            return "";
        }
    }

    public static Object getValue(EObject object, EStructuralFeature feature) {
        return ExtendedPropertiesProvider.getValue(object, feature, -1);
    }

    public static List<Object> getValueList(EObject object, EStructuralFeature feature) {
        ExtendedPropertiesAdapter adapter = ExtendedPropertiesAdapter.adapt((Object)object, feature);
        return adapter.getFeatureDescriptor(feature).getValueList();
    }

    public static Object getValue(EObject object, EStructuralFeature feature, int index) {
        ExtendedPropertiesAdapter adapter = ExtendedPropertiesAdapter.adapt((Object)object, feature);
        Object value = adapter == null ? object.eGet(feature) : adapter.getFeatureDescriptor(feature).getValue(index);
        return value;
    }

    public static boolean setValue(EObject object, EStructuralFeature feature, Object value) {
        return ExtendedPropertiesProvider.setValue(object, feature, value, -1);
    }

    public static boolean setValue(EObject object, EStructuralFeature feature, Object value, int index) {
        ExtendedPropertiesAdapter adapter = ExtendedPropertiesAdapter.adapt((Object)object, feature);
        return adapter.getFeatureDescriptor(feature).setValue(value, index);
    }

    public static boolean isMultiLineText(EObject object, EStructuralFeature feature) {
        if (feature == null) {
            return false;
        }
        ExtendedPropertiesAdapter adapter = ExtendedPropertiesAdapter.adapt((Object)object, feature);
        if (adapter != null) {
            return adapter.getFeatureDescriptor(feature).isMultiLine();
        }
        return false;
    }

    public static boolean setMultiLineText(EObject object, EStructuralFeature feature, boolean multiLine) {
        ExtendedPropertiesAdapter adapter = ExtendedPropertiesAdapter.adapt((Object)object, feature);
        if (adapter != null) {
            adapter.getFeatureDescriptor(feature).setMultiLine(multiLine);
            return true;
        }
        return false;
    }

    public static Hashtable<String, Object> getChoiceOfValues(EObject object, EStructuralFeature feature) {
        if (feature == null) {
            return null;
        }
        if (feature.getEType() instanceof EEnum) {
            EEnum en = (EEnum)feature.getEType();
            Hashtable<String, Object> choices = new Hashtable<String, Object>();
            for (EEnumLiteral el : en.getELiterals()) {
                choices.put(el.getLiteral(), el.getInstance());
            }
            return choices;
        }
        ExtendedPropertiesAdapter adapter = ExtendedPropertiesAdapter.adapt((Object)object, feature);
        if (adapter != null) {
            return adapter.getFeatureDescriptor(feature).getChoiceOfValues();
        }
        return null;
    }

    public static boolean isMultiChoice(EObject object, EStructuralFeature feature) {
        Object result;
        if (feature == null) {
            return false;
        }
        if (feature.getEType() instanceof EEnum) {
            return true;
        }
        ExtendedPropertiesAdapter adapter = ExtendedPropertiesAdapter.adapt((Object)object, feature);
        if (adapter != null && (result = adapter.getProperty(feature, "ui.is.multi.choice")) instanceof Boolean) {
            return (Boolean)result;
        }
        if (feature instanceof EReference && feature.isMany()) {
            return !((EReference)feature).isContainment();
        }
        return ExtendedPropertiesProvider.getChoiceOfValues(object, feature) != null;
    }

    public static boolean canEdit(EObject object, EStructuralFeature feature) {
        if (feature != null && feature.getEType() instanceof EClass) {
            Object result;
            ExtendedPropertiesAdapter adapter = ExtendedPropertiesAdapter.adapt((Object)object, feature);
            if (adapter != null && (result = adapter.getProperty(feature, "ui.can.edit")) instanceof Boolean) {
                return (Boolean)result;
            }
            if (feature instanceof EReference) {
                if (((EReference)feature).isContainment()) {
                    return true;
                }
                if (Bpmn2Package.eINSTANCE.getRootElement().isSuperTypeOf((EClass)feature.getEType())) {
                    return true;
                }
                return feature.isMany();
            }
            return true;
        }
        return false;
    }

    public static boolean canCreateNew(EObject object, EStructuralFeature feature) {
        if (feature != null && feature.getEType() instanceof EClass) {
            Object result;
            ExtendedPropertiesAdapter adapter = ExtendedPropertiesAdapter.adapt((Object)object, feature);
            if (adapter != null && (result = adapter.getProperty(feature, "ui.can.create.new")) instanceof Boolean) {
                return (Boolean)result;
            }
            if (feature instanceof EReference) {
                if (((EReference)feature).isContainment()) {
                    return true;
                }
                return Bpmn2Package.eINSTANCE.getRootElement().isSuperTypeOf((EClass)feature.getEType());
            }
            return true;
        }
        return false;
    }

    public static boolean canEditInline(EObject object, EStructuralFeature feature) {
        Object result;
        ExtendedPropertiesAdapter adapter;
        if (feature != null && feature.getEType() instanceof EClass && (adapter = ExtendedPropertiesAdapter.adapt((Object)object, feature)) != null && (result = adapter.getProperty(feature, "ui.can.edit.inline")) instanceof Boolean) {
            return (Boolean)result;
        }
        return false;
    }

    public static boolean canSetNull(EObject object, EStructuralFeature feature) {
        if (feature != null && feature.getEType() instanceof EClass) {
            Object result;
            ExtendedPropertiesAdapter adapter = ExtendedPropertiesAdapter.adapt((Object)object, feature);
            if (adapter != null && (result = adapter.getProperty(feature, "ui.can.set.null")) instanceof Boolean) {
                return (Boolean)result;
            }
            return true;
        }
        return false;
    }

    public static boolean isList(EObject object, EStructuralFeature feature) {
        if (feature instanceof EReference) {
            return feature.isMany() && ((EReference)feature).isContainment();
        }
        return false;
    }

    public static boolean isContainmentFeature(EObject object, EStructuralFeature feature) {
        return feature instanceof EReference && ((EReference)feature).isContainment() && feature.getEType() instanceof EClass;
    }

    public static boolean isAttribute(EObject object, EStructuralFeature feature) {
        return feature instanceof EAttribute;
    }

    public static boolean isReference(EObject object, EStructuralFeature feature) {
        return feature instanceof EReference;
    }

    public static EClassifier getEType(EObject object, EStructuralFeature feature) {
        ExtendedPropertiesAdapter adapter = ExtendedPropertiesAdapter.adapt(object);
        if (adapter != null) {
            adapter.getFeatureDescriptor(feature).getEType();
        }
        return feature.getEType();
    }

    public static boolean compare(EObject object1, EObject object2, boolean similar) {
        ExtendedPropertiesAdapter adapter = ExtendedPropertiesAdapter.adapt(object1);
        if (adapter != null) {
            adapter.getObjectDescriptor().compare(object2, similar);
        }
        return ExtendedPropertiesAdapter.compare(object1, object2, similar);
    }
}

