/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.core.builder;

import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Map;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.bpmn2.modeler.core.builder.Messages;
import org.eclipse.bpmn2.modeler.core.preferences.Bpmn2Preferences;
import org.eclipse.bpmn2.modeler.core.runtime.TargetRuntime;
import org.eclipse.bpmn2.modeler.core.runtime.XMLConfigElement;
import org.eclipse.bpmn2.modeler.core.utils.ErrorDialog;
import org.eclipse.bpmn2.modeler.core.validation.BPMN2ProjectValidator;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class BPMN2Builder
extends IncrementalProjectBuilder {
    public static final String BUILDER_ID = "org.eclipse.bpmn2.modeler.core.bpmn2Builder";
    private static final String MARKER_TYPE = "org.eclipse.bpmn2.modeler.core.xmlProblem";
    public static final String CONFIG_FOLDER = ".bpmn2config";
    private SAXParserFactory parserFactory;
    private Hashtable<IFolder, Long> timestamps = new Hashtable();
    public static final BPMN2Builder INSTANCE = new BPMN2Builder();

    protected IProject[] build(int kind, Map args, IProgressMonitor monitor) throws CoreException {
        if (kind == 6) {
            this.fullBuild(monitor);
        } else {
            IResourceDelta delta = this.getDelta(this.getProject());
            if (delta == null) {
                this.fullBuild(monitor);
            } else {
                this.incrementalBuild(delta, monitor);
            }
        }
        return null;
    }

    protected void incrementalBuild(IResourceDelta delta, IProgressMonitor monitor) throws CoreException {
        delta.accept((IResourceDeltaVisitor)new BPMN2DeltaVisitor(monitor));
    }

    void validate(IResourceDelta delta, IProgressMonitor monitor) {
        BPMN2ProjectValidator.validate(delta, monitor);
    }

    void validate(IResource resource, IProgressMonitor monitor) {
        BPMN2ProjectValidator.validate(resource, monitor);
    }

    protected void fullBuild(IProgressMonitor monitor) throws CoreException {
        try {
            this.getProject().accept((IResourceVisitor)new BPMN2ResourceVisitor(monitor));
        }
        catch (CoreException coreException) {}
    }

    public void loadExtensions(IProject project) {
        try {
            Long timestamp;
            IFolder folder = project.getFolder(CONFIG_FOLDER);
            if (folder.exists() && ((timestamp = this.timestamps.get(folder)) == null || timestamp < folder.getLocalTimeStamp())) {
                this.timestamps.put(folder, new Long(folder.getLocalTimeStamp()));
                IResource[] iResourceArray = folder.members();
                int n = iResourceArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IResource r = iResourceArray[n2];
                    if (r instanceof IFile && r.exists()) {
                        this.loadExtension((IFile)r);
                    }
                    ++n2;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void loadExtension(IFile file) {
        XMLConfigElementHandler handler = new XMLConfigElementHandler(file);
        try {
            SAXParser parser = this.getParser();
            if (file.exists()) {
                FileInputStream fis = new FileInputStream(file.getLocation().makeAbsolute().toOSString());
                parser.parse((InputStream)fis, (DefaultHandler)handler);
                TargetRuntime rt = Bpmn2Preferences.getInstance(file.getProject()).getRuntime();
                IConfigurationElement element = handler.root.getChildren()[0];
                TargetRuntime.loadExtensions(rt, element.getChildren(), file);
            }
        }
        catch (Exception e) {
            ErrorDialog dlg = new ErrorDialog(Messages.BPMN2Builder_ConfigFileError_Title, e);
            dlg.show();
        }
    }

    public void unloadExtension(IFile file) {
        TargetRuntime.unloadExtensions(file);
    }

    private void addMarker(IFile file, String message, int lineNumber, int severity) {
        try {
            IMarker marker = file.createMarker(MARKER_TYPE);
            marker.setAttribute("message", (Object)message);
            marker.setAttribute("severity", severity);
            if (lineNumber == -1) {
                lineNumber = 1;
            }
            marker.setAttribute("lineNumber", lineNumber);
        }
        catch (CoreException coreException) {}
    }

    void checkXML(IResource resource) {
        if (BPMN2ProjectValidator.isBPMN2File(resource)) {
            IFile file = (IFile)resource;
            this.deleteMarkers(file);
            XMLErrorHandler reporter = new XMLErrorHandler(file);
            try {
                this.getParser().parse(file.getContents(), (DefaultHandler)reporter);
            }
            catch (Exception exception) {}
        }
    }

    private void deleteMarkers(IFile file) {
        try {
            file.deleteMarkers(MARKER_TYPE, false, 0);
        }
        catch (CoreException coreException) {}
    }

    private SAXParser getParser() throws ParserConfigurationException, SAXException {
        if (this.parserFactory == null) {
            this.parserFactory = SAXParserFactory.newInstance();
        }
        return this.parserFactory.newSAXParser();
    }

    class BPMN2DeltaVisitor
    implements IResourceDeltaVisitor {
        IProgressMonitor monitor;

        public BPMN2DeltaVisitor(IProgressMonitor monitor) {
            this.monitor = monitor;
        }

        public boolean visit(IResourceDelta delta) throws CoreException {
            IContainer container;
            IResource resource = delta.getResource();
            if (resource instanceof IFile && BPMN2Builder.CONFIG_FOLDER.equals((container = resource.getParent()).getName()) && container.getParent() instanceof IProject) {
                int kind = delta.getKind();
                if (kind == 2) {
                    BPMN2Builder.this.unloadExtension((IFile)resource);
                } else {
                    BPMN2Builder.this.loadExtension((IFile)resource);
                }
                return true;
            }
            switch (delta.getKind()) {
                case 1: {
                    BPMN2Builder.this.validate(delta, this.monitor);
                    break;
                }
                case 2: {
                    break;
                }
                case 4: {
                    BPMN2Builder.this.validate(delta, this.monitor);
                }
            }
            return true;
        }
    }

    class BPMN2ResourceVisitor
    implements IResourceVisitor {
        IProgressMonitor monitor;

        public BPMN2ResourceVisitor(IProgressMonitor monitor) {
            this.monitor = monitor;
        }

        public boolean visit(IResource resource) {
            BPMN2Builder.this.validate(resource, this.monitor);
            return true;
        }
    }

    private class XMLConfigElementHandler
    extends XMLErrorHandler {
        public XMLConfigElement root;
        private Stack<XMLConfigElement> stack;

        public XMLConfigElementHandler(IFile file) {
            super(file);
            this.stack = new Stack();
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            String value = new String(ch, start, length).trim();
            if (!value.isEmpty()) {
                this.stack.peek().setValue(value);
            }
        }

        @Override
        public void endDocument() throws SAXException {
            this.stack.pop();
        }

        @Override
        public void endElement(String arg0, String arg1, String arg2) throws SAXException {
            this.stack.pop();
        }

        @Override
        public void startDocument() throws SAXException {
            this.root = new XMLConfigElement(this.file.getProject());
            this.stack.push(this.root);
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            XMLConfigElement element = new XMLConfigElement(this.stack.peek(), qName);
            int i = 0;
            while (i < attributes.getLength()) {
                element.setAttribute(attributes.getQName(i), attributes.getValue(i));
                ++i;
            }
            this.stack.push(element);
        }
    }

    private class XMLErrorHandler
    extends DefaultHandler {
        protected IFile file;

        public XMLErrorHandler(IFile file) {
            this.file = file;
        }

        private void addMarker(SAXParseException e, int severity) {
            BPMN2Builder.this.addMarker(this.file, e.getMessage(), e.getLineNumber(), severity);
        }

        @Override
        public void error(SAXParseException exception) throws SAXException {
            this.addMarker(exception, 2);
        }

        @Override
        public void fatalError(SAXParseException exception) throws SAXException {
            this.addMarker(exception, 2);
        }

        @Override
        public void warning(SAXParseException exception) throws SAXException {
            this.addMarker(exception, 1);
        }
    }
}

