/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.core.di;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.bpmn2.Artifact;
import org.eclipse.bpmn2.Association;
import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.Choreography;
import org.eclipse.bpmn2.ChoreographyActivity;
import org.eclipse.bpmn2.Collaboration;
import org.eclipse.bpmn2.ConversationNode;
import org.eclipse.bpmn2.DataObject;
import org.eclipse.bpmn2.DataStore;
import org.eclipse.bpmn2.Definitions;
import org.eclipse.bpmn2.FlowElement;
import org.eclipse.bpmn2.FlowElementsContainer;
import org.eclipse.bpmn2.FlowNode;
import org.eclipse.bpmn2.ItemAwareElement;
import org.eclipse.bpmn2.Lane;
import org.eclipse.bpmn2.LaneSet;
import org.eclipse.bpmn2.MessageFlow;
import org.eclipse.bpmn2.Participant;
import org.eclipse.bpmn2.Process;
import org.eclipse.bpmn2.RootElement;
import org.eclipse.bpmn2.SequenceFlow;
import org.eclipse.bpmn2.SubChoreography;
import org.eclipse.bpmn2.SubProcess;
import org.eclipse.bpmn2.di.BPMNDiagram;
import org.eclipse.bpmn2.di.BPMNEdge;
import org.eclipse.bpmn2.di.BPMNPlane;
import org.eclipse.bpmn2.di.BPMNShape;
import org.eclipse.bpmn2.di.BpmnDiFactory;
import org.eclipse.bpmn2.di.ParticipantBandKind;
import org.eclipse.bpmn2.modeler.core.adapters.ExtendedPropertiesProvider;
import org.eclipse.bpmn2.modeler.core.di.DIImport;
import org.eclipse.bpmn2.modeler.core.di.DIUtils;
import org.eclipse.bpmn2.modeler.core.di.DiagramElementTree;
import org.eclipse.bpmn2.modeler.core.di.DiagramElementTreeNode;
import org.eclipse.bpmn2.modeler.core.di.ImportDiagnostics;
import org.eclipse.bpmn2.modeler.core.di.Messages;
import org.eclipse.bpmn2.modeler.core.di.MissingDIElementsDialog;
import org.eclipse.bpmn2.modeler.core.preferences.Bpmn2Preferences;
import org.eclipse.bpmn2.modeler.core.preferences.ShapeStyle;
import org.eclipse.bpmn2.modeler.core.utils.AnchorUtil;
import org.eclipse.bpmn2.modeler.core.utils.BusinessObjectUtil;
import org.eclipse.bpmn2.modeler.core.utils.GraphicsUtil;
import org.eclipse.bpmn2.modeler.core.utils.ModelUtil;
import org.eclipse.bpmn2.modeler.core.utils.ShapeLayoutManager;
import org.eclipse.bpmn2.modeler.core.utils.Tuple;
import org.eclipse.dd.dc.Bounds;
import org.eclipse.dd.dc.DcFactory;
import org.eclipse.dd.dc.Point;
import org.eclipse.dd.di.DiagramElement;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.graphiti.mm.pictograms.Anchor;
import org.eclipse.graphiti.mm.pictograms.AnchorContainer;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.FixPointAnchor;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.ui.editor.DiagramEditor;
import org.eclipse.swt.widgets.Display;

public class DIGenerator {
    private DIImport importer;
    private Diagram diagram;
    private BPMNDiagram bpmnDiagram;
    private DiagramEditor editor;
    private Definitions definitions;
    private HashMap<BaseElement, PictogramElement> elements;
    private ImportDiagnostics diagnostics;
    private DiagramElementTree missingElements;
    private Bpmn2Preferences preferences;

    public DIGenerator(DIImport importer) {
        this.importer = importer;
        this.elements = importer.getImportedElements();
        this.diagnostics = importer.getDiagnostics();
        this.editor = importer.getEditor();
        this.diagram = this.editor.getDiagramTypeProvider().getDiagram();
        this.bpmnDiagram = BusinessObjectUtil.getFirstElementOfType((PictogramElement)this.diagram, BPMNDiagram.class);
        this.definitions = ModelUtil.getDefinitions(this.bpmnDiagram);
        this.preferences = Bpmn2Preferences.getInstance((EObject)this.definitions);
    }

    public boolean hasMissingDIElements() {
        if (this.missingElements == null) {
            this.missingElements = this.findMissingDIElements();
        }
        return this.missingElements.hasChildren();
    }

    public void generateMissingDIElements() {
        if (this.hasMissingDIElements()) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    MissingDIElementsDialog dlg = new MissingDIElementsDialog(DIGenerator.this.missingElements);
                    if (dlg.open() == 0) {
                        TransactionalEditingDomain domain = DIGenerator.this.editor.getEditingDomain();
                        domain.getCommandStack().execute((Command)new RecordingCommand(domain){

                            protected void doExecute() {
                                DIGenerator.this.createMissingDIElements(DIGenerator.this.missingElements);
                                ShapeLayoutManager layoutManager = new ShapeLayoutManager(DIGenerator.this.editor);
                                for (DiagramElementTreeNode node : DIGenerator.this.missingElements) {
                                    if (!node.getChecked()) continue;
                                    layoutManager.layout(node.getBaseElement());
                                }
                            }
                        });
                    }
                }
            });
        }
    }

    private DiagramElementTree findMissingDIElements() {
        DiagramElementTree missing = new DiagramElementTree(null, null);
        for (BaseElement be : this.definitions.getRootElements()) {
            this.findMissingDIElements(missing, be);
        }
        this.removeDuplicates(missing.getChildren());
        return missing;
    }

    private void removeDuplicates(List<DiagramElementTreeNode> children) {
        ArrayList<DiagramElementTreeNode> duplicates = new ArrayList<DiagramElementTreeNode>();
        for (DiagramElementTreeNode node : children) {
            Collaboration c;
            BaseElement be;
            if (node.hasChildren()) {
                this.removeDuplicates(node.getChildren());
            }
            if ((be = node.getBaseElement()) instanceof Collaboration) {
                c = (Collaboration)be;
                for (Participant p : c.getParticipants()) {
                    for (DiagramElementTreeNode n : children) {
                        if (n.getBaseElement() != p.getProcessRef()) continue;
                        duplicates.add(n);
                    }
                }
                continue;
            }
            if (!(be instanceof ChoreographyActivity)) continue;
            c = (ChoreographyActivity)be;
            for (Participant p : c.getParticipantRefs()) {
                for (DiagramElementTreeNode n : children) {
                    if (n.getBaseElement() != p) continue;
                    duplicates.add(n);
                }
            }
        }
        if (!duplicates.isEmpty()) {
            children.removeAll(duplicates);
        }
    }

    private boolean isMissingDIElement(BaseElement be) {
        boolean missing;
        if (be instanceof DataStore) {
            return false;
        }
        BPMNDiagram bpmnDiagram = DIUtils.findBPMNDiagram(be);
        if (bpmnDiagram != null) {
            return false;
        }
        FlowElementsContainer container = this.getRootElementContainer((EObject)be);
        bpmnDiagram = DIUtils.findBPMNDiagram((BaseElement)container);
        if (bpmnDiagram != null && bpmnDiagram.getPlane().getPlaneElement().contains(be)) {
            return false;
        }
        boolean bl = missing = this.elements.get(be) == null && this.diagnostics.get((EObject)be) == null;
        if (missing) {
            GraphicsUtil.dump("Missing DI element for: " + be.eClass().getName() + " '" + ExtendedPropertiesProvider.getTextValue((EObject)be) + "'");
        }
        return missing;
    }

    private boolean isDataElement(BaseElement be) {
        return be instanceof ItemAwareElement && be instanceof FlowElement;
    }

    private int findMissingDIElements(DiagramElementTreeNode missing, LaneSet laneSet, List<FlowElement> laneElements) {
        int added = 0;
        if (laneSet != null) {
            for (Lane lane : laneSet.getLanes()) {
                BaseElement container = (BaseElement)lane.eContainer().eContainer();
                DiagramElementTreeNode containerNode = missing.getChild(container);
                if (containerNode == null) {
                    containerNode = missing.addChild(container);
                }
                DiagramElementTreeNode parentNode = containerNode.addChild((BaseElement)lane);
                for (FlowNode fn : lane.getFlowNodeRefs()) {
                    if (!this.isMissingDIElement((BaseElement)fn)) continue;
                    parentNode.addChild((BaseElement)fn);
                    laneElements.add((FlowElement)fn);
                    ++added;
                }
                if ((added += this.findMissingDIElements(parentNode, lane.getChildLaneSet(), laneElements)) != 0) continue;
                containerNode.removeChild((BaseElement)lane);
                missing.removeChild(container);
            }
        }
        return added;
    }

    private void findMissingDIElements(DiagramElementTreeNode missing, BaseElement be) {
        DiagramElementTreeNode parentNode;
        FlowElementsContainer container;
        if (be instanceof FlowElementsContainer) {
            container = (FlowElementsContainer)be;
            parentNode = null;
            ArrayList<FlowElement> laneElements = new ArrayList<FlowElement>();
            for (LaneSet laneSet : container.getLaneSets()) {
                this.findMissingDIElements(missing, laneSet, laneElements);
            }
            for (FlowElement fe : container.getFlowElements()) {
                if (!this.isMissingDIElement((BaseElement)fe) || laneElements.contains(fe) || fe instanceof SequenceFlow || fe instanceof DataObject || fe instanceof DataStore) continue;
                if (parentNode == null) {
                    parentNode = missing.addChild((BaseElement)container);
                }
                parentNode.addChild((BaseElement)fe);
                if (!(fe instanceof FlowElementsContainer) && !(fe instanceof ChoreographyActivity)) continue;
                this.findMissingDIElements(parentNode, (BaseElement)fe);
            }
            List<Artifact> artifacts = this.getArtifacts((BaseElement)container);
            if (artifacts != null) {
                for (Artifact a : artifacts) {
                    if (!this.isMissingDIElement((BaseElement)a) || a instanceof Association) continue;
                    if (parentNode == null) {
                        parentNode = missing.addChild((BaseElement)container);
                    }
                    parentNode.addChild((BaseElement)a);
                }
            }
        }
        if (be instanceof Collaboration) {
            container = (Collaboration)be;
            parentNode = null;
            for (Artifact a : container.getArtifacts()) {
                if (!this.isMissingDIElement((BaseElement)a) || a instanceof Association) continue;
                if (parentNode == null) {
                    parentNode = missing.addChild((BaseElement)container);
                }
                parentNode.addChild((BaseElement)a);
            }
            for (Participant p : container.getParticipants()) {
                boolean isParticipantBand = false;
                if (p.eContainer() instanceof Choreography) {
                    Choreography choreography = (Choreography)p.eContainer();
                    for (FlowElement fe : choreography.getFlowElements()) {
                        if (!(fe instanceof ChoreographyActivity) || !((ChoreographyActivity)fe).getParticipantRefs().contains(p)) continue;
                        isParticipantBand = true;
                        break;
                    }
                }
                if (!this.isMissingDIElement((BaseElement)p) || p.getProcessRef() == null || isParticipantBand) continue;
                if (parentNode == null) {
                    parentNode = missing.addChild((BaseElement)container);
                }
                parentNode.addChild((BaseElement)p);
            }
            for (ConversationNode c : container.getConversations()) {
                if (!this.isMissingDIElement((BaseElement)c)) continue;
                if (parentNode == null) {
                    parentNode = missing.addChild((BaseElement)container);
                }
                parentNode.addChild((BaseElement)c);
            }
        } else if (be instanceof Participant) {
            container = (Participant)be;
            if (container.getProcessRef() != null) {
                parentNode = missing.addChild((BaseElement)container);
                parentNode.addChild((BaseElement)container.getProcessRef());
            }
        } else if (be instanceof ChoreographyActivity) {
            container = (ChoreographyActivity)be;
            parentNode = null;
            for (Participant p : container.getParticipantRefs()) {
                if (!this.isMissingDIElement((BaseElement)p)) continue;
                if (parentNode == null) {
                    parentNode = missing.addChild((BaseElement)container);
                }
                DiagramElementTreeNode child = parentNode.addChild((BaseElement)p);
                if (p.getProcessRef() == null) continue;
                this.findMissingDIElements(child, (BaseElement)p.getProcessRef());
            }
        } else if (this.isDataElement(be) && this.isMissingDIElement(be)) {
            missing.addChild(be);
        }
    }

    private List<Artifact> getArtifacts(BaseElement container) {
        if (container instanceof Process) {
            return ((Process)container).getArtifacts();
        }
        if (container instanceof SubProcess) {
            return ((SubProcess)container).getArtifacts();
        }
        if (container instanceof SubChoreography) {
            return ((SubChoreography)container).getArtifacts();
        }
        if (container instanceof Collaboration) {
            return ((Collaboration)container).getArtifacts();
        }
        return null;
    }

    private FlowElementsContainer getRootElementContainer(EObject o) {
        while (o != null) {
            if (o instanceof FlowElementsContainer && o instanceof RootElement) {
                return (FlowElementsContainer)o;
            }
            o = o.eContainer();
        }
        return null;
    }

    private BPMNShape createMissingDIElement(DiagramElementTreeNode node, int x, int y, List<BaseElement> created) {
        BaseElement element = node.getBaseElement();
        BPMNShape bpmnShape = null;
        BPMNDiagram bpmnDiagram = this.createDIDiagram(element);
        if (element instanceof Lane) {
            Lane lane = (Lane)element;
            bpmnShape = this.createDIShape(bpmnDiagram, (BaseElement)lane, x, y);
            node.setBpmnShape(bpmnShape);
            y = this.createMissingDIElementChildren(node, x, y, created);
            created.add((BaseElement)lane);
        } else if (element instanceof FlowElementsContainer) {
            FlowElementsContainer container = (FlowElementsContainer)element;
            if (container instanceof SubProcess || container instanceof SubChoreography) {
                bpmnShape = this.createDIShape(bpmnDiagram, (BaseElement)container, x, y);
                node.setBpmnShape(bpmnShape);
                created.add((BaseElement)container);
            }
            y = this.createMissingDIElementChildren(node, x, y, created);
        } else if (element instanceof Collaboration) {
            y = this.createMissingDIElementChildren(node, x, y, created);
        } else if (element instanceof Artifact) {
            bpmnShape = this.createDIShape(bpmnDiagram, element, x, y);
            node.setBpmnShape(bpmnShape);
            created.add(element);
        } else if (element instanceof Participant) {
            boolean doImport = true;
            if (node.getParent().getBaseElement() instanceof ChoreographyActivity) {
                doImport = false;
            }
            bpmnShape = this.createDIShape(bpmnDiagram, element, x, y, doImport);
            node.setBpmnShape(bpmnShape);
            created.add(element);
            if (!doImport) {
                ChoreographyActivity ca = (ChoreographyActivity)node.getParent().getBaseElement();
                bpmnShape.setChoreographyActivityShape(node.getParent().getBpmnShape());
                if (ca.getParticipantRefs().get(0) == element) {
                    bpmnShape.setParticipantBandKind(ParticipantBandKind.TOP_INITIATING);
                } else {
                    bpmnShape.setParticipantBandKind(ParticipantBandKind.BOTTOM_NON_INITIATING);
                }
            }
            this.createMissingDIElementChildren(node, x, y, created);
        } else if (element instanceof ConversationNode) {
            bpmnShape = this.createDIShape(bpmnDiagram, element, x, y);
            node.setBpmnShape(bpmnShape);
            created.add(element);
        } else if (element instanceof FlowNode) {
            boolean doImport = !(element instanceof ChoreographyActivity);
            bpmnShape = this.createDIShape(bpmnDiagram, element, x, y, doImport);
            node.setBpmnShape(bpmnShape);
            created.add(element);
            y = this.createMissingDIElementChildren(node, x, y, created);
            if (!doImport) {
                this.importer.importShape(bpmnShape);
            }
        } else if (this.isDataElement(element)) {
            bpmnShape = this.createDIShape(bpmnDiagram, element, x, y);
            node.setBpmnShape(bpmnShape);
            created.add(element);
        }
        return bpmnShape;
    }

    private int createMissingDIElementChildren(DiagramElementTreeNode node, int x, int y, List<BaseElement> created) {
        for (DiagramElementTreeNode childNode : node.getChildren()) {
            BPMNShape bpmnShape;
            if (!childNode.getChecked() || (bpmnShape = this.createMissingDIElement(childNode, x, y, created)) == null) continue;
            y = (int)((float)y + (bpmnShape.getBounds().getHeight() + 10.0f));
        }
        return y;
    }

    private void createMissingDIElements(DiagramElementTree missing) {
        BPMNDiagram bpmnDiagram;
        int x = 102400;
        int y = 0;
        ArrayList<BaseElement> shapes = new ArrayList<BaseElement>();
        for (DiagramElementTreeNode node : missing.getChildren()) {
            BPMNShape bpmnShape;
            if (!node.getChecked() || (bpmnShape = this.createMissingDIElement(node, x, y, shapes)) == null) continue;
            y = (int)((float)y + (bpmnShape.getBounds().getHeight() + 10.0f));
        }
        ArrayList<Object> connections = new ArrayList<Object>();
        for (BaseElement be : shapes) {
            BPMNEdge bpmnEdge;
            if (be instanceof FlowNode) {
                FlowNode flowNode = (FlowNode)be;
                bpmnDiagram = this.createDIDiagram((BaseElement)flowNode);
                for (SequenceFlow sf : flowNode.getIncoming()) {
                    if (connections.contains(sf) || (bpmnEdge = this.createDIEdge(bpmnDiagram, (BaseElement)sf)) == null) continue;
                    connections.add(sf);
                }
                for (SequenceFlow sf : flowNode.getOutgoing()) {
                    if (connections.contains(sf) || (bpmnEdge = this.createDIEdge(bpmnDiagram, (BaseElement)sf)) == null) continue;
                    connections.add(sf);
                }
                continue;
            }
            if (!(be instanceof ConversationNode)) continue;
            ConversationNode convNode = (ConversationNode)be;
            bpmnDiagram = this.createDIDiagram((BaseElement)convNode);
            for (MessageFlow mf : convNode.getMessageFlowRefs()) {
                if (connections.contains(mf) || (bpmnEdge = this.createDIEdge(bpmnDiagram, (BaseElement)mf)) == null) continue;
                connections.add(mf);
            }
        }
        TreeIterator iter = this.definitions.eAllContents();
        while (iter.hasNext()) {
            Association assoc;
            BPMNEdge bpmnEdge;
            EObject o = (EObject)iter.next();
            if (!(o instanceof Association) || (bpmnEdge = this.createDIEdge(bpmnDiagram = this.createDIDiagram((BaseElement)(assoc = (Association)o)), (BaseElement)assoc)) == null) continue;
            connections.add(assoc);
        }
    }

    private BPMNDiagram createDIDiagram(BaseElement bpmnElement) {
        BPMNDiagram bpmnDiagram = DIUtils.findBPMNDiagram(bpmnElement, true);
        if (bpmnElement instanceof Process && bpmnDiagram == null) {
            for (Collaboration c : ModelUtil.getAllObjectsOfType(bpmnElement.eResource(), Collaboration.class)) {
                for (Participant p : c.getParticipants()) {
                    if (ModelUtil.isParticipantBand(p) || p.getProcessRef() != bpmnElement) continue;
                    bpmnDiagram = DIUtils.findBPMNDiagram((BaseElement)p, true);
                    break;
                }
                if (bpmnDiagram != null) break;
            }
        }
        if (bpmnDiagram == null) {
            FlowElementsContainer container = this.getRootElementContainer((EObject)bpmnElement);
            if (container == null) {
                this.diagnostics.add(4, (EObject)bpmnElement, Messages.DIGenerator_No_Diagram);
                return this.bpmnDiagram;
            }
            BPMNPlane plane = BpmnDiFactory.eINSTANCE.createBPMNPlane();
            plane.setBpmnElement((BaseElement)container);
            bpmnDiagram = BpmnDiFactory.eINSTANCE.createBPMNDiagram();
            bpmnDiagram.setName(ExtendedPropertiesProvider.getTextValue((EObject)container));
            bpmnDiagram.setPlane(plane);
            this.definitions.getDiagrams().add(bpmnDiagram);
        }
        return bpmnDiagram;
    }

    private BPMNShape createDIShape(BPMNDiagram bpmnDiagram, BaseElement bpmnElement, float x, float y) {
        return this.createDIShape(bpmnDiagram, bpmnElement, x, y, true);
    }

    private BPMNShape createDIShape(BPMNDiagram bpmnDiagram, BaseElement bpmnElement, float x, float y, boolean doImport) {
        BPMNPlane plane = bpmnDiagram.getPlane();
        BPMNShape bpmnShape = null;
        for (DiagramElement de : plane.getPlaneElement()) {
            if (!(de instanceof BPMNShape) || bpmnElement != ((BPMNShape)de).getBpmnElement()) continue;
            bpmnShape = (BPMNShape)de;
            break;
        }
        if (bpmnShape == null) {
            bpmnShape = BpmnDiFactory.eINSTANCE.createBPMNShape();
            bpmnShape.setBpmnElement(bpmnElement);
            Bounds bounds = DcFactory.eINSTANCE.createBounds();
            bounds.setX(x);
            bounds.setY(y);
            ShapeStyle ss = this.preferences.getShapeStyle((EObject)bpmnElement);
            bounds.setWidth((float)ss.getDefaultWidth());
            bounds.setHeight((float)ss.getDefaultHeight());
            bpmnShape.setBounds(bounds);
            plane.getPlaneElement().add(bpmnShape);
            this.preferences.applyBPMNDIDefaults(bpmnShape, null);
            ModelUtil.setID((EObject)bpmnShape);
            if (doImport) {
                this.importer.importShape(bpmnShape);
            }
        }
        return bpmnShape;
    }

    private BPMNEdge createDIEdge(BPMNDiagram bpmnDiagram, BaseElement bpmnElement) {
        BPMNPlane plane = bpmnDiagram.getPlane();
        BPMNEdge bpmnEdge = null;
        for (DiagramElement de : plane.getPlaneElement()) {
            if (!(de instanceof BPMNEdge) || bpmnElement != ((BPMNEdge)de).getBpmnElement()) continue;
            bpmnEdge = (BPMNEdge)de;
            break;
        }
        if (bpmnEdge == null) {
            bpmnEdge = BpmnDiFactory.eINSTANCE.createBPMNEdge();
            bpmnEdge.setBpmnElement(bpmnElement);
            FlowNode sourceElement = null;
            FlowNode targetElement = null;
            if (bpmnElement instanceof SequenceFlow) {
                sourceElement = ((SequenceFlow)bpmnElement).getSourceRef();
                targetElement = ((SequenceFlow)bpmnElement).getTargetRef();
            } else if (bpmnElement instanceof MessageFlow) {
                sourceElement = (BaseElement)((MessageFlow)bpmnElement).getSourceRef();
                targetElement = (BaseElement)((MessageFlow)bpmnElement).getTargetRef();
            } else if (bpmnElement instanceof Association) {
                sourceElement = ((Association)bpmnElement).getSourceRef();
                targetElement = ((Association)bpmnElement).getTargetRef();
            }
            if (sourceElement != null && targetElement != null) {
                DiagramElement de = DIUtils.findPlaneElement(plane.getPlaneElement(), (BaseElement)sourceElement);
                bpmnEdge.setSourceElement(de);
                de = DIUtils.findPlaneElement(plane.getPlaneElement(), (BaseElement)targetElement);
                bpmnEdge.setTargetElement(de);
                Shape sourceShape = (Shape)this.elements.get(sourceElement);
                Shape targetShape = (Shape)this.elements.get(targetElement);
                if (sourceShape != null && targetShape != null) {
                    Tuple<FixPointAnchor, FixPointAnchor> anchors = AnchorUtil.getSourceAndTargetBoundaryAnchors((AnchorContainer)sourceShape, (AnchorContainer)targetShape, null);
                    org.eclipse.graphiti.mm.algorithms.styles.Point sourceLoc = GraphicsUtil.createPoint((Anchor)anchors.getFirst());
                    org.eclipse.graphiti.mm.algorithms.styles.Point targetLoc = GraphicsUtil.createPoint((Anchor)anchors.getSecond());
                    Point point = DcFactory.eINSTANCE.createPoint();
                    point.setX((float)sourceLoc.getX());
                    point.setY((float)sourceLoc.getY());
                    bpmnEdge.getWaypoint().add(point);
                    point = DcFactory.eINSTANCE.createPoint();
                    point.setX((float)targetLoc.getX());
                    point.setY((float)targetLoc.getY());
                    bpmnEdge.getWaypoint().add(point);
                    plane.getPlaneElement().add(bpmnEdge);
                    ModelUtil.setID((EObject)bpmnEdge);
                    this.importer.importConnection(bpmnEdge);
                }
            }
        }
        return bpmnEdge;
    }
}

