/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.core.features;

import org.eclipse.bpmn2.Activity;
import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.Bpmn2Package;
import org.eclipse.bpmn2.EndEvent;
import org.eclipse.bpmn2.Event;
import org.eclipse.bpmn2.Group;
import org.eclipse.bpmn2.ItemAwareElement;
import org.eclipse.bpmn2.SequenceFlow;
import org.eclipse.bpmn2.modeler.core.LifecycleEvent;
import org.eclipse.bpmn2.modeler.core.adapters.ExtendedPropertiesAdapter;
import org.eclipse.bpmn2.modeler.core.features.IBpmn2CreateFeature;
import org.eclipse.bpmn2.modeler.core.features.Messages;
import org.eclipse.bpmn2.modeler.core.merrimac.dialogs.ObjectEditingDialog;
import org.eclipse.bpmn2.modeler.core.preferences.Bpmn2Preferences;
import org.eclipse.bpmn2.modeler.core.preferences.ModelEnablements;
import org.eclipse.bpmn2.modeler.core.runtime.CustomTaskDescriptor;
import org.eclipse.bpmn2.modeler.core.runtime.TargetRuntime;
import org.eclipse.bpmn2.modeler.core.utils.BusinessObjectUtil;
import org.eclipse.bpmn2.modeler.core.utils.FeatureSupport;
import org.eclipse.bpmn2.modeler.core.utils.ModelUtil;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.graphiti.IExecutionInfo;
import org.eclipse.graphiti.features.IFeatureAndContext;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IContext;
import org.eclipse.graphiti.features.context.ICreateConnectionContext;
import org.eclipse.graphiti.features.context.IReconnectionContext;
import org.eclipse.graphiti.features.context.impl.AddConnectionContext;
import org.eclipse.graphiti.features.context.impl.CreateConnectionContext;
import org.eclipse.graphiti.features.context.impl.ReconnectionContext;
import org.eclipse.graphiti.features.impl.AbstractCreateConnectionFeature;
import org.eclipse.graphiti.mm.pictograms.Anchor;
import org.eclipse.graphiti.mm.pictograms.AnchorContainer;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.ui.editor.DiagramEditor;
import org.eclipse.osgi.util.NLS;

public abstract class AbstractBpmn2CreateConnectionFeature<CONNECTION extends BaseElement, SOURCE extends EObject, TARGET extends EObject>
extends AbstractCreateConnectionFeature
implements IBpmn2CreateFeature<CONNECTION, ICreateConnectionContext> {
    protected boolean changesDone = true;

    public AbstractBpmn2CreateConnectionFeature(IFeatureProvider fp) {
        super(fp, "", "");
    }

    public String getCreateName() {
        return ModelUtil.toCanonicalString(this.getFeatureClass().getName());
    }

    public String getCreateDescription() {
        return NLS.bind((String)Messages.AbstractBpmn2CreateConnectionFeature_Create, (Object)ModelUtil.toCanonicalString(this.getFeatureClass().getName()));
    }

    public String getName() {
        return this.getCreateName();
    }

    public String getDescription() {
        return this.getCreateDescription();
    }

    public boolean isAvailable(IContext context) {
        IReconnectionContext rc;
        BaseElement o = null;
        if (context instanceof ICreateConnectionContext) {
            ICreateConnectionContext ccc = (ICreateConnectionContext)context;
            if (ccc.getTargetPictogramElement() != null) {
                o = BusinessObjectUtil.getFirstElementOfType(ccc.getTargetPictogramElement(), BaseElement.class);
            } else if (ccc.getSourcePictogramElement() != null) {
                o = BusinessObjectUtil.getFirstElementOfType(ccc.getSourcePictogramElement(), BaseElement.class);
            }
        } else if (context instanceof IReconnectionContext && (rc = (IReconnectionContext)context).getTargetPictogramElement() != null) {
            o = BusinessObjectUtil.getFirstElementOfType(rc.getTargetPictogramElement(), BaseElement.class);
        }
        if (o instanceof EndEvent || o instanceof Group) {
            return false;
        }
        if (o instanceof EObject) {
            return this.isModelObjectEnabled((EObject)o);
        }
        return false;
    }

    public boolean canStartConnection(ICreateConnectionContext context) {
        return this.getSourceBo(context) != null;
    }

    public static boolean canCreateConnection(AnchorContainer sourceContainer, AnchorContainer targetContainer, EClass connectionClass, String reconnectType) {
        if (sourceContainer != null && targetContainer != null) {
            for (Anchor sourceAnchor : sourceContainer.getAnchors()) {
                for (Connection sourceConnection : sourceAnchor.getOutgoingConnections()) {
                    EObject sourceObject = BusinessObjectUtil.getBusinessObjectForPictogramElement((PictogramElement)sourceConnection);
                    if (connectionClass == Bpmn2Package.eINSTANCE.getDataAssociation()) {
                        EObject o = BusinessObjectUtil.getBusinessObjectForPictogramElement((PictogramElement)sourceContainer);
                        connectionClass = o instanceof ItemAwareElement ? Bpmn2Package.eINSTANCE.getDataInputAssociation() : Bpmn2Package.eINSTANCE.getDataOutputAssociation();
                    }
                    if (sourceObject == null || sourceObject.eClass() != connectionClass || sourceConnection.getEnd().getParent() != targetContainer) continue;
                    return false;
                }
            }
            Bpmn2Preferences prefs = Bpmn2Preferences.getInstance((EObject)sourceContainer);
            if (!prefs.getAllowMultipleConnections() && connectionClass == Bpmn2Package.eINSTANCE.getSequenceFlow()) {
                EObject o;
                EObject businessObject;
                if (!ReconnectionContext.RECONNECT_TARGET.equals(reconnectType) && ((businessObject = BusinessObjectUtil.getBusinessObjectForPictogramElement((PictogramElement)sourceContainer)) instanceof Activity || businessObject instanceof Event)) {
                    for (Anchor a : sourceContainer.getAnchors()) {
                        for (Connection c : a.getOutgoingConnections()) {
                            o = BusinessObjectUtil.getBusinessObjectForPictogramElement((PictogramElement)c);
                            if (!(o instanceof SequenceFlow)) continue;
                            return false;
                        }
                    }
                }
                if (!ReconnectionContext.RECONNECT_SOURCE.equals(reconnectType) && ((businessObject = BusinessObjectUtil.getBusinessObjectForPictogramElement((PictogramElement)targetContainer)) instanceof Activity || businessObject instanceof Event)) {
                    for (Anchor a : targetContainer.getAnchors()) {
                        for (Connection c : a.getIncomingConnections()) {
                            o = BusinessObjectUtil.getBusinessObjectForPictogramElement((PictogramElement)c);
                            if (!(o instanceof SequenceFlow)) continue;
                            return false;
                        }
                    }
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public CONNECTION createBusinessObject(ICreateConnectionContext context) {
        Resource resource = this.getResource(context);
        EClass eclass = this.getBusinessObjectClass();
        ExtendedPropertiesAdapter adapter = ExtendedPropertiesAdapter.adapt(eclass);
        BaseElement businessObject = (BaseElement)adapter.getObjectDescriptor().createObject(resource, eclass);
        EStructuralFeature nameFeature = businessObject.eClass().getEStructuralFeature("name");
        if (nameFeature != null) {
            businessObject.eUnset(nameFeature);
        }
        SOURCE source = this.getSourceBo(context);
        TARGET target = this.getTargetBo(context);
        EStructuralFeature sourceRefFeature = businessObject.eClass().getEStructuralFeature("sourceRef");
        EStructuralFeature targetRefFeature = businessObject.eClass().getEStructuralFeature("targetRef");
        if (sourceRefFeature != null && targetRefFeature != null) {
            businessObject.eSet(sourceRefFeature, source);
            businessObject.eSet(targetRefFeature, target);
        }
        this.putBusinessObject(context, (CONNECTION)businessObject);
        this.changesDone = true;
        return (CONNECTION)businessObject;
    }

    protected Resource getResource(ICreateConnectionContext context) {
        PictogramElement pe = context.getSourcePictogramElement();
        if (pe == null) {
            pe = context.getTargetPictogramElement();
        }
        if (pe == null) {
            pe = context.getSourceAnchor();
        }
        if (pe == null) {
            pe = context.getTargetAnchor();
        }
        EObject bo = BusinessObjectUtil.getBusinessObjectForPictogramElement(pe);
        return bo.eResource();
    }

    @Override
    public CONNECTION getBusinessObject(ICreateConnectionContext context) {
        return (CONNECTION)((BaseElement)context.getProperty((Object)"businessObject"));
    }

    @Override
    public void putBusinessObject(ICreateConnectionContext context, CONNECTION businessObject) {
        context.putProperty((Object)"businessObject", businessObject);
        String id = (String)context.getProperty((Object)"custom.element.id");
        if (id != null) {
            TargetRuntime rt = TargetRuntime.getCurrentRuntime();
            CustomTaskDescriptor ctd = rt.getCustomTask(id);
            ctd.populateObject((EObject)businessObject, this.getResource(context), true);
        }
        TargetRuntime.getCurrentRuntime().notify(new LifecycleEvent(LifecycleEvent.EventType.BUSINESSOBJECT_INITIALIZED, this.getFeatureProvider(), (IContext)context, businessObject));
    }

    @Override
    public EClass getFeatureClass() {
        return this.getBusinessObjectClass();
    }

    @Override
    public void postExecute(IExecutionInfo executionInfo) {
        IFeatureAndContext[] iFeatureAndContextArray = executionInfo.getExecutionList();
        int n = iFeatureAndContextArray.length;
        int n2 = 0;
        while (n2 < n) {
            IFeatureAndContext fc = iFeatureAndContextArray[n2];
            IContext context = fc.getContext();
            if (context instanceof ICreateConnectionContext) {
                ICreateConnectionContext cc = (ICreateConnectionContext)context;
                CONNECTION businessObject = this.getBusinessObject(cc);
                Bpmn2Preferences prefs = (Bpmn2Preferences)((DiagramEditor)this.getDiagramEditor()).getAdapter(Bpmn2Preferences.class);
                if (prefs != null && prefs.getShowPopupConfigDialog(businessObject)) {
                    ObjectEditingDialog dialog = new ObjectEditingDialog((DiagramEditor)this.getDiagramEditor(), (EObject)businessObject);
                    dialog.open();
                }
            }
            ++n2;
        }
    }

    protected AddConnectionContext createAddConnectionContext(ICreateConnectionContext context, Object newObject) {
        AddConnectionContext newContext = new AddConnectionContext(context.getSourceAnchor(), context.getTargetAnchor());
        newContext.setNewObject(newObject);
        Object value = context.getProperty((Object)"custom.element.id");
        newContext.putProperty((Object)"custom.element.id", value);
        value = context.getProperty((Object)"is.importing");
        newContext.putProperty((Object)"is.importing", value);
        value = context.getProperty((Object)"businessObject");
        newContext.putProperty((Object)"businessObject", value);
        return newContext;
    }

    protected boolean isModelObjectEnabled() {
        ModelEnablements me = this.getModelEnablements();
        if (me != null) {
            return me.isEnabled(this.getBusinessObjectClass());
        }
        return false;
    }

    protected boolean isModelObjectEnabled(EObject o) {
        ModelEnablements me = this.getModelEnablements();
        if (me != null) {
            EClass eclass = o instanceof EClass ? (EClass)o : o.eClass();
            return me.isEnabled(eclass);
        }
        return false;
    }

    public boolean hasDoneChanges() {
        return this.changesDone;
    }

    protected ModelEnablements getModelEnablements() {
        DiagramEditor editor = (DiagramEditor)this.getDiagramEditor();
        return (ModelEnablements)editor.getAdapter(ModelEnablements.class);
    }

    protected SOURCE getSourceBo(ICreateConnectionContext context) {
        Anchor a = this.getSourceAnchor(context);
        if (a != null) {
            return BusinessObjectUtil.getFirstElementOfType((PictogramElement)a.getParent(), this.getSourceClass());
        }
        return null;
    }

    protected Anchor getSourceAnchor(ICreateConnectionContext context) {
        Anchor a = context.getSourceAnchor();
        PictogramElement pe = context.getSourcePictogramElement();
        if (a == null && FeatureSupport.isLabelShape(pe)) {
            pe = FeatureSupport.getLabelOwner(pe);
            ((CreateConnectionContext)context).setSourcePictogramElement(pe);
            a = Graphiti.getPeService().getChopboxAnchor((AnchorContainer)pe);
            ((CreateConnectionContext)context).setSourceAnchor(a);
        }
        return a;
    }

    protected TARGET getTargetBo(ICreateConnectionContext context) {
        Anchor a = this.getTargetAnchor(context);
        if (a != null) {
            return BusinessObjectUtil.getFirstElementOfType((PictogramElement)a.getParent(), this.getTargetClass());
        }
        return null;
    }

    protected Anchor getTargetAnchor(ICreateConnectionContext context) {
        Anchor a = context.getTargetAnchor();
        PictogramElement pe = context.getTargetPictogramElement();
        if (a == null && FeatureSupport.isLabelShape(pe)) {
            pe = FeatureSupport.getLabelOwner(pe);
            ((CreateConnectionContext)context).setTargetPictogramElement(pe);
            a = Graphiti.getPeService().getChopboxAnchor((AnchorContainer)pe);
            ((CreateConnectionContext)context).setTargetAnchor(a);
        }
        return a;
    }

    protected abstract Class<SOURCE> getSourceClass();

    protected abstract Class<TARGET> getTargetClass();
}

