/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.core.features;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.modeler.core.features.DefaultConnectionRouter;
import org.eclipse.bpmn2.modeler.core.utils.AnchorUtil;
import org.eclipse.bpmn2.modeler.core.utils.BusinessObjectUtil;
import org.eclipse.bpmn2.modeler.core.utils.GraphicsUtil;
import org.eclipse.bpmn2.modeler.core.utils.ModelUtil;
import org.eclipse.graphiti.mm.algorithms.styles.Point;
import org.eclipse.graphiti.mm.pictograms.Anchor;
import org.eclipse.graphiti.mm.pictograms.AnchorContainer;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.FreeFormConnection;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;

public class ConnectionRoute
implements Comparable<ConnectionRoute>,
Comparator<ConnectionRoute> {
    DefaultConnectionRouter router;
    int id;
    private List<Point> points = new ArrayList<Point>();
    List<Collision> collisions = new ArrayList<Collision>();
    List<Crossing> crossings = new ArrayList<Crossing>();
    Shape source;
    Shape target;
    boolean valid = true;
    private int rank = 0;

    public ConnectionRoute(DefaultConnectionRouter router, int id, Shape source, Shape target) {
        this.router = router;
        this.id = id;
        this.source = source;
        this.target = target;
    }

    public void apply(FreeFormConnection ffc) {
        this.apply(ffc, null, null);
    }

    public void apply(FreeFormConnection ffc, Anchor sourceAnchor, Anchor targetAnchor) {
        if (sourceAnchor == null) {
            AnchorUtil.BoundaryAnchor ba = AnchorUtil.findNearestBoundaryAnchor((AnchorContainer)this.source, this.get(0));
            sourceAnchor = ba.anchor;
            ffc.setStart(sourceAnchor);
        }
        if (targetAnchor == null) {
            Point p = this.get(this.size() - 1);
            AnchorUtil.BoundaryAnchor ba = AnchorUtil.findNearestBoundaryAnchor((AnchorContainer)this.target, p);
            targetAnchor = ba.anchor;
            ffc.setEnd(targetAnchor);
        }
        ffc.getBendpoints().clear();
        int i = 1;
        while (i < this.size() - 1) {
            ffc.getBendpoints().add((Object)this.get(i));
            ++i;
        }
    }

    public String toString() {
        String text;
        if (this.isValid()) {
            Object c;
            Iterator<Object> iter;
            AnchorUtil.BoundaryAnchor sa = AnchorUtil.findNearestBoundaryAnchor((AnchorContainer)this.source, this.get(0));
            AnchorUtil.BoundaryAnchor ta = AnchorUtil.findNearestBoundaryAnchor((AnchorContainer)this.target, this.get(this.size() - 1));
            text = String.valueOf(this.id) + ": length=" + this.getLength() + " points=" + this.getPoints().size() + " source=" + (Object)((Object)sa.locationType) + " target=" + (Object)((Object)ta.locationType);
            if (this.collisions.size() > 0) {
                text = String.valueOf(text) + " collisions=";
                iter = this.collisions.iterator();
                while (iter.hasNext()) {
                    c = (Collision)iter.next();
                    text = String.valueOf(text) + "'" + ((Collision)c).toString() + "'";
                    if (!iter.hasNext()) continue;
                    text = String.valueOf(text) + ", ";
                }
            }
            if (this.crossings.size() > 0) {
                text = String.valueOf(text) + " crossings=";
                iter = this.crossings.iterator();
                while (iter.hasNext()) {
                    c = (Crossing)iter.next();
                    text = String.valueOf(text) + "'" + ((Crossing)c).toString() + "'";
                    if (!iter.hasNext()) continue;
                    text = String.valueOf(text) + ", ";
                }
            }
        } else {
            text = "not valid";
        }
        return text;
    }

    public boolean add(Point newPoint) {
        for (Point p : this.getPoints()) {
            if (!GraphicsUtil.pointsEqual(newPoint, p)) continue;
            this.valid = false;
            return false;
        }
        this.getPoints().add(newPoint);
        return true;
    }

    public Point get(int index) {
        return this.getPoints().get(index);
    }

    public int size() {
        return this.getPoints().size();
    }

    public void addCollision(Shape shape, Point start, Point end) {
        this.collisions.add(new Collision(shape, start, end));
    }

    public void addCrossing(Connection connection, Point start, Point end) {
        this.crossings.add(new Crossing(connection, start, end));
    }

    public void setValid() {
        this.valid = true;
    }

    public boolean isValid() {
        if (this.valid) {
            return this.getLength() < Integer.MAX_VALUE;
        }
        return false;
    }

    public int getLength() {
        int length = 0;
        if (this.getPoints().size() > 1) {
            Point p1 = this.getPoints().get(0);
            int i = 1;
            while (i < this.getPoints().size()) {
                Point p2 = this.getPoints().get(i);
                length += (int)GraphicsUtil.getLength(p1, p2);
                p1 = p2;
                ++i;
            }
        } else {
            return Integer.MAX_VALUE;
        }
        return length;
    }

    @Override
    public int compareTo(ConnectionRoute arg0) {
        return this.compare(this, arg0);
    }

    @Override
    public int compare(ConnectionRoute o1, ConnectionRoute o2) {
        int i = 0;
        if (o1.isValid()) {
            if (o2.isValid()) {
                i = o1.getRank() - o2.getRank();
                if (i == 0 && (i = o1.collisions.size() - o2.collisions.size()) == 0 && i == 0 && (i = o1.getPoints().size() - o2.getPoints().size()) == 0) {
                    i = o1.getLength() - o2.getLength();
                }
                return i;
            }
            return -1;
        }
        if (!o2.isValid()) {
            return 0;
        }
        return 1;
    }

    private boolean removeUnusedPoints() {
        boolean changed = false;
        Point p1 = this.getPoints().get(0);
        int i = 1;
        while (i < this.getPoints().size() - 1) {
            Point p2 = this.getPoints().get(i);
            if (i + 1 < this.getPoints().size()) {
                Point p3 = this.getPoints().get(i + 1);
                int x1 = p1.getX();
                int x2 = p2.getX();
                int x3 = p3.getX();
                int y1 = p1.getY();
                int y2 = p2.getY();
                int y3 = p3.getY();
                if (GraphicsUtil.isVertical(p1, p2) && GraphicsUtil.isVertical(p2, p3) && (y1 < y2 && y2 < y3 || y1 > y2 && y2 > y3) || GraphicsUtil.isHorizontal(p1, p2) && GraphicsUtil.isHorizontal(p2, p3) && (x1 < x2 && x2 < x3 || x1 > x2 && x2 > x3)) {
                    this.getPoints().remove(i);
                    --i;
                    changed = true;
                }
            }
            p1 = p2;
            ++i;
        }
        return changed;
    }

    private boolean removeUnusedSegments() {
        Point p3;
        Point p2;
        boolean changed = false;
        Point p1 = this.getPoints().get(1);
        int i = 2;
        while (i < this.getPoints().size() - 2) {
            p2 = this.getPoints().get(i);
            if (i + 2 < this.getPoints().size()) {
                Point p;
                p3 = this.getPoints().get(i + 1);
                Point p4 = this.getPoints().get(i + 2);
                if (GraphicsUtil.isHorizontal(p1, p2) && GraphicsUtil.isVertical(p2, p3) && GraphicsUtil.isHorizontal(p3, p4)) {
                    p = GraphicsUtil.createPoint(p1.getX(), p3.getY());
                    if (this.router.getCollision(p1, p) == null) {
                        this.getPoints().set(i + 1, p);
                        this.getPoints().remove(p2);
                        this.getPoints().remove(p3);
                        --i;
                        changed = true;
                    }
                } else if (GraphicsUtil.isVertical(p1, p2) && GraphicsUtil.isHorizontal(p2, p3) && GraphicsUtil.isVertical(p3, p4) && this.router.getCollision(p1, p = GraphicsUtil.createPoint(p3.getX(), p1.getY())) == null) {
                    this.getPoints().set(i + 1, p);
                    this.getPoints().remove(p2);
                    this.getPoints().remove(p3);
                    --i;
                    changed = true;
                }
            }
            p1 = p2;
            ++i;
        }
        p1 = this.getPoints().get(0);
        i = 1;
        while (i < this.getPoints().size() - 1) {
            p2 = this.getPoints().get(i);
            if (i + 1 < this.getPoints().size()) {
                p3 = this.getPoints().get(i + 1);
                if (p1.getX() == p2.getX() && p2.getX() == p3.getX()) {
                    if (p2.getY() < p1.getY() && p2.getY() < p3.getY() || p2.getY() > p1.getY() && p2.getY() > p3.getY()) {
                        this.getPoints().remove(p2);
                        --i;
                        changed = true;
                    }
                } else if (p1.getY() == p2.getY() && p2.getY() == p3.getY() && (p2.getX() < p1.getX() && p2.getX() < p3.getX() || p2.getX() > p1.getX() && p2.getX() > p3.getX())) {
                    this.getPoints().remove(p2);
                    --i;
                    changed = true;
                }
            }
            p1 = p2;
            ++i;
        }
        return changed;
    }

    public boolean optimize() {
        boolean changed = this.removeUnusedPoints();
        if (this.removeUnusedSegments()) {
            this.removeUnusedPoints();
            changed = true;
        }
        return changed;
    }

    public int getRank() {
        return this.rank;
    }

    public void setRank(int rank) {
        this.rank = rank;
    }

    public List<Point> getPoints() {
        return this.points;
    }

    public void setPoints(List<Point> points) {
        this.points = points;
    }

    class Collision {
        Shape shape;
        Point start;
        Point end;

        public Collision(Shape shape, Point start, Point end) {
            this.shape = shape;
            this.start = start;
            this.end = end;
        }

        public String toString() {
            BaseElement o = BusinessObjectUtil.getFirstBaseElement((PictogramElement)this.shape);
            return ModelUtil.getTextValue(o);
        }
    }

    class Crossing {
        Connection connection;
        Point start;
        Point end;

        public Crossing(Connection connection, Point start, Point end) {
            this.connection = connection;
            this.start = start;
            this.end = end;
        }

        public String toString() {
            BaseElement o = BusinessObjectUtil.getFirstBaseElement((PictogramElement)this.connection);
            return ModelUtil.getTextValue(o);
        }
    }
}

