/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.core.features;

import org.eclipse.bpmn2.SubProcess;
import org.eclipse.bpmn2.modeler.core.LifecycleEvent;
import org.eclipse.bpmn2.modeler.core.di.DIUtils;
import org.eclipse.bpmn2.modeler.core.runtime.TargetRuntime;
import org.eclipse.bpmn2.modeler.core.utils.BusinessObjectUtil;
import org.eclipse.bpmn2.modeler.core.utils.FeatureSupport;
import org.eclipse.bpmn2.modeler.core.utils.GraphicsUtil;
import org.eclipse.graphiti.datatypes.ILocation;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IContext;
import org.eclipse.graphiti.features.context.IMoveShapeContext;
import org.eclipse.graphiti.features.context.impl.MoveShapeContext;
import org.eclipse.graphiti.features.impl.DefaultMoveShapeFeature;
import org.eclipse.graphiti.mm.PropertyContainer;
import org.eclipse.graphiti.mm.algorithms.styles.Point;
import org.eclipse.graphiti.mm.pictograms.Anchor;
import org.eclipse.graphiti.mm.pictograms.AnchorContainer;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.services.Graphiti;

public class DefaultMoveBPMNShapeFeature
extends DefaultMoveShapeFeature {
    protected ILocation preMoveLoc;

    public DefaultMoveBPMNShapeFeature(IFeatureProvider fp) {
        super(fp);
    }

    public boolean canMoveShape(IMoveShapeContext context) {
        if (Graphiti.getPeService().getProperty((PropertyContainer)context.getShape(), "ROUTING_NET_LANE") != null) {
            return false;
        }
        if (FeatureSupport.isLabelShape(context.getPictogramElement())) {
            return false;
        }
        ContainerShape targetContainer = context.getTargetContainer();
        if (FeatureSupport.isLabelShape((PictogramElement)targetContainer)) {
            return false;
        }
        if (Graphiti.getPeService().getProperty((PropertyContainer)targetContainer, "ROUTING_NET_LANE") != null) {
            int x = context.getX();
            int y = context.getY();
            ILocation loc = Graphiti.getPeService().getLocationRelativeToDiagram((Shape)targetContainer);
            ((MoveShapeContext)context).setX(x + loc.getX());
            ((MoveShapeContext)context).setY(y + loc.getY());
            ((MoveShapeContext)context).setSourceContainer(targetContainer.getContainer());
            ((MoveShapeContext)context).setTargetContainer(targetContainer.getContainer());
        }
        boolean doit = true;
        LifecycleEvent event = new LifecycleEvent(LifecycleEvent.EventType.PICTOGRAMELEMENT_CAN_MOVE, this.getFeatureProvider(), (IContext)context, context.getPictogramElement());
        event.doit = doit;
        TargetRuntime.getCurrentRuntime().notify(event);
        return event.doit;
    }

    public void moveShape(IMoveShapeContext context) {
        TargetRuntime rt = TargetRuntime.getCurrentRuntime();
        rt.notify(new LifecycleEvent(LifecycleEvent.EventType.PICTOGRAMELEMENT_PRE_MOVE, this.getFeatureProvider(), (IContext)context, context.getPictogramElement()));
        super.moveShape(context);
        rt.notify(new LifecycleEvent(LifecycleEvent.EventType.PICTOGRAMELEMENT_POST_MOVE, this.getFeatureProvider(), (IContext)context, context.getPictogramElement()));
    }

    protected void preMoveShape(IMoveShapeContext context) {
        this.preMoveLoc = Graphiti.getLayoutService().getLocationRelativeToDiagram(context.getShape());
        super.preMoveShape(context);
    }

    protected void postMoveShape(IMoveShapeContext context) {
        PictogramElement pe;
        Shape shape = context.getShape();
        Point p = null;
        if (!FeatureSupport.isLabelShape((PictogramElement)shape)) {
            ILocation postMoveLoc = Graphiti.getPeService().getLocationRelativeToDiagram(shape);
            p = GraphicsUtil.createPoint(postMoveLoc.getX() - this.preMoveLoc.getX(), postMoveLoc.getY() - this.preMoveLoc.getY());
            DIUtils.updateDIShape((PictogramElement)shape);
            FeatureSupport.updateLabel(this.getFeatureProvider(), (PictogramElement)shape, p);
        }
        if (shape instanceof ContainerShape && BusinessObjectUtil.containsElementOfType(pe = (PictogramElement)((ContainerShape)shape).eContainer(), SubProcess.class)) {
            this.layoutPictogramElement(pe);
        }
        FeatureSupport.updateConnections(this.getFeatureProvider(), (AnchorContainer)shape);
        for (Connection connection : this.getDiagram().getConnections()) {
            if (!GraphicsUtil.intersects(shape, connection) || Graphiti.getPeService().getProperty((PropertyContainer)connection, "ROUTING_NET_CONNECTION") == null) continue;
            FeatureSupport.updateConnection(this.getFeatureProvider(), connection);
        }
        FeatureSupport.updateCategoryValues(this.getFeatureProvider(), (PictogramElement)shape);
        for (Anchor a : shape.getAnchors()) {
            for (Connection c : a.getIncomingConnections()) {
                FeatureSupport.updateCategoryValues(this.getFeatureProvider(), (PictogramElement)c);
            }
            for (Connection c : a.getOutgoingConnections()) {
                FeatureSupport.updateCategoryValues(this.getFeatureProvider(), (PictogramElement)c);
            }
        }
    }
}

