/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.core.features;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.eclipse.bpmn2.Activity;
import org.eclipse.bpmn2.Association;
import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.BoundaryEvent;
import org.eclipse.bpmn2.Bpmn2Factory;
import org.eclipse.bpmn2.Collaboration;
import org.eclipse.bpmn2.ConversationLink;
import org.eclipse.bpmn2.Definitions;
import org.eclipse.bpmn2.FlowElement;
import org.eclipse.bpmn2.FlowElementsContainer;
import org.eclipse.bpmn2.FlowNode;
import org.eclipse.bpmn2.InteractionNode;
import org.eclipse.bpmn2.Lane;
import org.eclipse.bpmn2.LaneSet;
import org.eclipse.bpmn2.MessageFlow;
import org.eclipse.bpmn2.Participant;
import org.eclipse.bpmn2.Process;
import org.eclipse.bpmn2.SequenceFlow;
import org.eclipse.bpmn2.di.BPMNDiagram;
import org.eclipse.bpmn2.di.BPMNEdge;
import org.eclipse.bpmn2.di.BPMNShape;
import org.eclipse.bpmn2.modeler.core.di.DIUtils;
import org.eclipse.bpmn2.modeler.core.features.DefaultCopyBPMNElementFeature;
import org.eclipse.bpmn2.modeler.core.model.Bpmn2ModelerFactory;
import org.eclipse.bpmn2.modeler.core.utils.AnchorUtil;
import org.eclipse.bpmn2.modeler.core.utils.BusinessObjectUtil;
import org.eclipse.bpmn2.modeler.core.utils.FeatureSupport;
import org.eclipse.bpmn2.modeler.core.utils.GraphicsUtil;
import org.eclipse.bpmn2.modeler.core.utils.ModelUtil;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.graphiti.datatypes.IDimension;
import org.eclipse.graphiti.datatypes.ILocation;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.IUpdateFeature;
import org.eclipse.graphiti.features.context.IAddContext;
import org.eclipse.graphiti.features.context.IAreaContext;
import org.eclipse.graphiti.features.context.IPasteContext;
import org.eclipse.graphiti.features.context.IUpdateContext;
import org.eclipse.graphiti.features.context.impl.AddConnectionContext;
import org.eclipse.graphiti.features.context.impl.AddContext;
import org.eclipse.graphiti.features.context.impl.AreaContext;
import org.eclipse.graphiti.features.context.impl.UpdateContext;
import org.eclipse.graphiti.mm.algorithms.styles.Point;
import org.eclipse.graphiti.mm.pictograms.Anchor;
import org.eclipse.graphiti.mm.pictograms.AnchorContainer;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.FixPointAnchor;
import org.eclipse.graphiti.mm.pictograms.FreeFormConnection;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.ui.features.AbstractPasteFeature;

public class DefaultPasteBPMNElementFeature
extends AbstractPasteFeature {
    protected Resource resource;
    protected Definitions definitions;
    protected Hashtable<String, String> idMap;
    protected HashMap<ContainerShape, ContainerShape> shapeMap;
    protected HashMap<Connection, Connection> connectionMap;
    protected int xReference;
    protected int yReference;
    protected Diagram diagram;

    public DefaultPasteBPMNElementFeature(IFeatureProvider fp) {
        super(fp);
    }

    public boolean canPaste(IPasteContext context) {
        ContainerShape targetContainerShape = this.getTargetContainerShape(context);
        if (targetContainerShape == null) {
            return false;
        }
        BaseElement targetContainerObject = this.getContainerObject(targetContainerShape);
        if (targetContainerObject == null) {
            return false;
        }
        Object[] pasteObjects = context.getProperty((Object)"copy.from.context") != null ? context.getPictogramElements() : this.getFromClipboard();
        if (pasteObjects == null || pasteObjects.length == 0) {
            return false;
        }
        int count = 0;
        Object[] objectArray = pasteObjects;
        int n = pasteObjects.length;
        int n2 = 0;
        while (n2 < n) {
            PictogramElement pe;
            BaseElement be;
            PictogramElement object = objectArray[n2];
            if (!(!(object instanceof PictogramElement) || !((be = BusinessObjectUtil.getFirstBaseElement(pe = object)) instanceof FlowElement) && !(be instanceof Lane) && !(be instanceof Participant) || be instanceof BoundaryEvent || pe instanceof Shape && FeatureSupport.isLabelShape((PictogramElement)((Shape)pe)) || be instanceof Participant && !(targetContainerObject instanceof Collaboration))) {
                ++count;
            }
            ++n2;
        }
        return count != 0;
    }

    public void paste(IPasteContext context) {
        Object[] fromClipboard;
        ContainerShape targetContainerShape = this.getTargetContainerShape(context);
        BaseElement targetContainerObject = this.getContainerObject(targetContainerShape);
        this.diagram = this.getFeatureProvider().getDiagramTypeProvider().getDiagram();
        this.resource = targetContainerObject.eResource();
        this.definitions = ModelUtil.getDefinitions(this.resource);
        this.idMap = new Hashtable();
        this.shapeMap = new HashMap();
        this.connectionMap = new HashMap();
        this.xReference = 0;
        this.yReference = 0;
        int xMin = Integer.MAX_VALUE;
        int yMin = Integer.MAX_VALUE;
        Object[] objectArray = fromClipboard = this.getFromClipboard();
        int n = fromClipboard.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            if (object instanceof ContainerShape) {
                ILocation iLocation = Graphiti.getLayoutService().getLocationRelativeToDiagram((Shape)((ContainerShape)object));
                if (iLocation.getX() < xMin) {
                    xMin = iLocation.getX();
                }
                if (iLocation.getY() < yMin) {
                    yMin = iLocation.getY();
                }
            }
            ++n2;
        }
        if (xMin != Integer.MAX_VALUE) {
            this.xReference = xMin;
            this.yReference = yMin;
        }
        int x = context.getX();
        int y = context.getY();
        if (!(targetContainerShape instanceof Diagram)) {
            ILocation loc = Graphiti.getLayoutService().getLocationRelativeToDiagram((Shape)targetContainerShape);
            x -= loc.getX();
            y -= loc.getY();
        }
        Object object = fromClipboard;
        int n3 = fromClipboard.length;
        int n32 = 0;
        while (n32 < n3) {
            Object object2 = object[n32];
            if (object2 instanceof ContainerShape) {
                this.copyShape((ContainerShape)object2, targetContainerShape, x, y);
            }
            ++n32;
        }
        x = context.getX();
        y = context.getY();
        object = fromClipboard;
        int n4 = fromClipboard.length;
        n32 = 0;
        while (n32 < n4) {
            Object object3 = object[n32];
            if (object3 instanceof Connection) {
                this.copyConnection((Connection)object3, targetContainerShape, x, y);
            }
            ++n32;
        }
        for (Map.Entry<Connection, Connection> entry : this.connectionMap.entrySet()) {
            if (entry.getValue() != null) continue;
            this.copyConnection(entry.getKey(), targetContainerShape, x, y);
        }
        PictogramElement[] newPes = new PictogramElement[this.shapeMap.size()];
        int i = 0;
        for (Map.Entry entry : this.shapeMap.entrySet()) {
            newPes[i++] = (PictogramElement)entry.getValue();
        }
        this.getDiagramEditor().setPictogramElementsForSelection(newPes);
    }

    /*
     * WARNING - void declaration
     */
    protected Object[] getFromClipboard() {
        void var4_7;
        Object[] objects;
        ArrayList<Object> allObjects = new ArrayList<Object>();
        Object[] objectArray = objects = super.getFromClipboard();
        int n = objects.length;
        boolean n2 = false;
        while (var4_7 < n) {
            Object object = objectArray[var4_7];
            if (object instanceof EObject && ((EObject)object).eContainer() != null) {
                allObjects.add(object);
            }
            ++var4_7;
        }
        ArrayList filteredObjects = new ArrayList();
        for (Object e : allObjects) {
            Connection c;
            if (!(e instanceof EObject) || ((EObject)e).eContainer() == null) continue;
            if (e instanceof ContainerShape) {
                filteredObjects.add(e);
                continue;
            }
            if (!(e instanceof Connection) || (c = (Connection)e).getStart() == null || c.getEnd() == null || !allObjects.contains(c.getStart().getParent()) || !allObjects.contains(c.getEnd().getParent())) continue;
            filteredObjects.add(e);
        }
        return filteredObjects.toArray();
    }

    public <T extends EObject> T copyEObject(T eObject) {
        EcoreUtil.Copier copier = new EcoreUtil.Copier(){

            protected EObject createCopy(EObject eObject) {
                EClass eClass = this.getTarget(eObject.eClass());
                if (eClass.getEPackage().getEFactoryInstance() == Bpmn2Factory.eINSTANCE) {
                    return Bpmn2ModelerFactory.create(DefaultPasteBPMNElementFeature.this.resource, eClass);
                }
                return super.createCopy(eObject);
            }
        };
        EObject result = copier.copy(eObject);
        copier.copyReferences();
        EObject t = result;
        return (T)t;
    }

    private BaseElement createNewObject(BaseElement oldObject, BaseElement targetContainerObject) {
        Lane ln;
        Process process;
        Participant participant;
        Bpmn2ModelerFactory.setEnableModelExtensions(false);
        BaseElement newObject = this.copyEObject(oldObject);
        Bpmn2ModelerFactory.setEnableModelExtensions(true);
        if (targetContainerObject instanceof Participant) {
            participant = (Participant)targetContainerObject;
            if (participant.getProcessRef() == null) {
                process = Bpmn2ModelerFactory.create(this.resource, Process.class);
                participant.setProcessRef(process);
            }
            targetContainerObject = participant.getProcessRef();
        }
        if (newObject instanceof FlowElementsContainer) {
            ((FlowElementsContainer)newObject).getFlowElements().clear();
        }
        if (newObject instanceof Lane) {
            LaneSet ls;
            ((Lane)newObject).getFlowNodeRefs().clear();
            ((Lane)newObject).setChildLaneSet(null);
            if (targetContainerObject instanceof FlowElementsContainer) {
                FlowElementsContainer fc = (FlowElementsContainer)targetContainerObject;
                if (fc.getLaneSets().size() != 0) {
                    ((LaneSet)fc.getLaneSets().get(0)).getLanes().add((Lane)newObject);
                } else {
                    ls = Bpmn2ModelerFactory.create(this.resource, LaneSet.class);
                    fc.getLaneSets().add(ls);
                    ls.getLanes().add((Lane)newObject);
                }
            } else if (targetContainerObject instanceof Lane) {
                ln = (Lane)targetContainerObject;
                if (ln.getChildLaneSet() == null) {
                    ls = Bpmn2ModelerFactory.create(this.resource, LaneSet.class);
                    ln.setChildLaneSet(ls);
                }
                ln.getChildLaneSet().getLanes().add((Lane)newObject);
            }
        } else if (newObject instanceof FlowElement) {
            if (targetContainerObject instanceof Lane) {
                ln = (Lane)targetContainerObject;
                targetContainerObject = this.getFlowElementsContainer(ln);
                if (newObject instanceof FlowNode) {
                    ln.getFlowNodeRefs().add((FlowNode)newObject);
                }
            }
            if (targetContainerObject instanceof FlowElementsContainer) {
                ((FlowElementsContainer)targetContainerObject).getFlowElements().add((FlowElement)newObject);
            }
        } else if (newObject instanceof Participant) {
            participant = (Participant)newObject;
            if (((Participant)newObject).getProcessRef() != null) {
                process = Bpmn2ModelerFactory.create(this.resource, Process.class);
                participant.setProcessRef(process);
            }
            if (targetContainerObject instanceof Collaboration) {
                Collaboration collab = (Collaboration)targetContainerObject;
                collab.getParticipants().add((Participant)newObject);
            }
        }
        this.setId((EObject)newObject);
        TreeIterator iter = newObject.eAllContents();
        while (iter.hasNext()) {
            EObject newChild = (EObject)iter.next();
            this.setId(newChild);
        }
        for (EReference ref : newObject.eClass().getEAllReferences()) {
            EObject newRefObject;
            EObject oldRefObject;
            String oldId;
            Object oldValue;
            if (ref.isContainment() || !((oldValue = oldObject.eGet((EStructuralFeature)ref)) instanceof EObject) || (oldId = this.getId(oldRefObject = (EObject)oldValue)) == null) continue;
            String newId = this.idMap.get(oldId);
            if (newId != null) {
                newRefObject = this.findObjectById(newId);
                newObject.eSet((EStructuralFeature)ref, (Object)newRefObject);
                continue;
            }
            if (newObject.eGet((EStructuralFeature)ref) == null || (newId = this.getId(newRefObject = (EObject)newObject.eGet((EStructuralFeature)ref))) == null) continue;
            this.idMap.put(oldId, newId);
        }
        return newObject;
    }

    private String getId(EObject newObject) {
        EStructuralFeature feature = newObject.eClass().getEStructuralFeature("id");
        if (feature != null) {
            return (String)newObject.eGet(feature);
        }
        return null;
    }

    private String setId(EObject newObject) {
        String newId = null;
        String oldId = null;
        EStructuralFeature feature = newObject.eClass().getEStructuralFeature("id");
        if (feature != null) {
            oldId = (String)newObject.eGet(feature);
            if (this.idMap.contains(oldId)) {
                newId = this.idMap.get(oldId);
                newObject.eSet(feature, (Object)newId);
            } else {
                newObject.eUnset(feature);
                newId = ModelUtil.setID(newObject);
                this.idMap.put(oldId, newId);
            }
        }
        return oldId;
    }

    private boolean wasCopied(EObject object) {
        String id = this.getId(object);
        if (id != null) {
            return this.idMap.containsValue(id);
        }
        return false;
    }

    private EObject findObjectById(String id) {
        TreeIterator iter = this.definitions.eAllContents();
        while (iter.hasNext()) {
            String thisId;
            EObject o = (EObject)iter.next();
            EStructuralFeature feature = o.eClass().getEStructuralFeature("id");
            if (feature == null || (thisId = (String)o.eGet(feature)) == null || thisId.isEmpty() || !thisId.equals(id)) continue;
            return o;
        }
        return null;
    }

    private ContainerShape findShape(EObject object) {
        List pes = Graphiti.getLinkService().getPictogramElements(this.diagram, object);
        for (PictogramElement pe : pes) {
            if (!(pe instanceof ContainerShape)) continue;
            return (ContainerShape)pe;
        }
        return null;
    }

    private Connection findConnection(EObject object) {
        List pes = Graphiti.getLinkService().getPictogramElements(this.diagram, object);
        for (PictogramElement pe : pes) {
            if (!(pe instanceof Connection)) continue;
            return (Connection)pe;
        }
        return null;
    }

    private BaseElement copyShape(ContainerShape oldShape, ContainerShape targetContainerShape, int x, int y) {
        ContainerShape oldChildShape;
        if (this.shapeMap.get(oldShape) != null) {
            return null;
        }
        BaseElement targetContainerObject = this.getContainerObject(targetContainerShape);
        BaseElement oldObject = BusinessObjectUtil.getFirstBaseElement((PictogramElement)oldShape);
        BaseElement newObject = this.createNewObject(oldObject, targetContainerObject);
        AddContext ac = new AddContext((IAreaContext)new AreaContext(), (Object)newObject);
        ILocation loc = Graphiti.getLayoutService().getLocationRelativeToDiagram((Shape)oldShape);
        IDimension size = GraphicsUtil.calculateSize((PictogramElement)oldShape);
        int deltaX = 0;
        int deltaY = 0;
        if (oldObject instanceof FlowNode) {
            deltaX = loc.getX() - this.xReference + size.getWidth() / 2;
            deltaY = loc.getY() - this.yReference + size.getHeight() / 2;
        }
        ac.setLocation(x + deltaX, y + deltaY);
        ac.setSize(size.getWidth(), size.getHeight());
        ac.setTargetContainer(targetContainerShape);
        BPMNShape oldBpmnShape = null;
        if (oldObject instanceof BaseElement) {
            oldBpmnShape = DIUtils.findBPMNShape(oldObject);
            ac.putProperty((Object)"copied.bpmn.shape", (Object)oldBpmnShape);
        }
        ac.putProperty((Object)"copied.bpmn.object", (Object)oldObject);
        ContainerShape newShape = (ContainerShape)this.getFeatureProvider().addIfPossible((IAddContext)ac);
        this.shapeMap.put(oldShape, newShape);
        if (oldObject instanceof Participant) {
            oldObject = ((Participant)oldObject).getProcessRef();
        }
        if (oldObject instanceof FlowElementsContainer) {
            ArrayList<ContainerShape> childShapes = new ArrayList<ContainerShape>();
            ArrayList<Connection> childConnections = new ArrayList<Connection>();
            TreeIterator iter = oldObject.eAllContents();
            while (iter.hasNext()) {
                Connection oldChildConnection;
                EObject oldChildObject = (EObject)iter.next();
                if (oldChildObject instanceof BoundaryEvent || this.wasCopied(oldChildObject)) continue;
                oldChildShape = this.findShape(oldChildObject);
                if (oldChildShape != null) {
                    childShapes.add(oldChildShape);
                }
                if ((oldChildConnection = this.findConnection(oldChildObject)) == null) continue;
                childConnections.add(oldChildConnection);
            }
            for (ContainerShape oldChildShape2 : childShapes) {
                this.copyShape(oldChildShape2, newShape, 0, 0);
            }
            for (Connection oldChildConnection : childConnections) {
                this.copyConnection(oldChildConnection, newShape, x, y);
            }
        } else if (oldObject instanceof Lane) {
            ArrayList<PictogramElement> shapes = new ArrayList<PictogramElement>();
            Lane oldLane = (Lane)oldObject;
            if (oldLane.getChildLaneSet() != null) {
                for (Lane oldChildLaneObject : oldLane.getChildLaneSet().getLanes()) {
                    ContainerShape oldChildLaneShape = this.findShape((EObject)oldChildLaneObject);
                    if (oldChildLaneShape == null) continue;
                    this.copyShape(oldChildLaneShape, newShape, 0, 0);
                }
            }
            for (FlowNode oldChildObject : oldLane.getFlowNodeRefs()) {
                oldChildShape = this.findShape((EObject)oldChildObject);
                if (oldChildShape == null) continue;
                this.copyShape(oldChildShape, newShape, 0, 0);
                shapes.add((PictogramElement)oldChildShape);
            }
            List<Connection> connections = DefaultCopyBPMNElementFeature.findAllConnections(shapes);
            for (Connection oldChildConnection : connections) {
                this.copyConnection(oldChildConnection, newShape, x, y);
            }
        }
        if (oldBpmnShape != null) {
            BPMNShape newBpmnShape = DIUtils.findBPMNShape(newObject);
            newBpmnShape.setIsExpanded(oldBpmnShape.isIsExpanded());
            newBpmnShape.setIsHorizontal(oldBpmnShape.isIsHorizontal());
            newBpmnShape.setIsMarkerVisible(oldBpmnShape.isIsMarkerVisible());
            newBpmnShape.setIsMessageVisible(oldBpmnShape.isIsMessageVisible());
            newBpmnShape.setParticipantBandKind(oldBpmnShape.getParticipantBandKind());
        }
        UpdateContext uc = new UpdateContext((PictogramElement)newShape);
        IUpdateFeature uf = this.getFeatureProvider().getUpdateFeature((IUpdateContext)uc);
        uc.putProperty((Object)"force.update.all", (Object)Boolean.TRUE);
        uf.update((IUpdateContext)uc);
        if (newObject instanceof Activity) {
            TreeIterator i = this.definitions.eAllContents();
            while (i.hasNext()) {
                BoundaryEvent oldBeObject;
                EObject o = (EObject)i.next();
                if (!(o instanceof BoundaryEvent) || (oldBeObject = (BoundaryEvent)o).getAttachedToRef() != oldObject) continue;
                ContainerShape oldBeShape = this.findShape((EObject)oldBeObject);
                this.copyShape(oldBeShape, targetContainerShape, x, y);
            }
        }
        return newObject;
    }

    private BaseElement copyConnection(Connection oldConnection, ContainerShape targetContainerShape, int x, int y) {
        BPMNEdge oldBpmnEdge;
        FixPointAnchor newEnd;
        ILocation loc;
        FixPointAnchor newStart;
        Map<AnchorUtil.AnchorLocation, AnchorUtil.BoundaryAnchor> bas;
        AnchorUtil.AnchorLocation al;
        if (this.connectionMap.get(oldConnection) != null) {
            return null;
        }
        BaseElement targetContainerObject = this.getContainerObject(targetContainerShape);
        BaseElement oldObject = BusinessObjectUtil.getFirstBaseElement((PictogramElement)oldConnection);
        BaseElement newObject = this.createNewObject(oldObject, targetContainerObject);
        Anchor oldStart = oldConnection.getStart();
        Anchor oldEnd = oldConnection.getEnd();
        ContainerShape newSource = this.shapeMap.get(oldStart.getParent());
        ContainerShape newTarget = this.shapeMap.get(oldEnd.getParent());
        if (newSource == null || newTarget == null) {
            this.connectionMap.put(oldConnection, null);
            return null;
        }
        if (AnchorUtil.isBoundaryAnchor(oldStart)) {
            al = AnchorUtil.getBoundaryAnchorLocation(oldStart);
            bas = AnchorUtil.getBoundaryAnchors((AnchorContainer)newSource);
            newStart = bas.get((Object)((Object)al)).anchor;
        } else {
            loc = Graphiti.getLayoutService().getLocationRelativeToDiagram(oldStart);
            newStart = AnchorUtil.createAdHocAnchor((AnchorContainer)newSource, loc.getX(), loc.getY());
        }
        if (AnchorUtil.isBoundaryAnchor(oldEnd)) {
            al = AnchorUtil.getBoundaryAnchorLocation(oldEnd);
            bas = AnchorUtil.getBoundaryAnchors((AnchorContainer)newTarget);
            newEnd = bas.get((Object)((Object)al)).anchor;
        } else {
            loc = Graphiti.getLayoutService().getLocationRelativeToDiagram(oldEnd);
            newEnd = AnchorUtil.createAdHocAnchor((AnchorContainer)newTarget, loc.getX(), loc.getY());
        }
        BaseElement newSourceObject = BusinessObjectUtil.getFirstBaseElement((PictogramElement)newSource);
        BaseElement newTargetObject = BusinessObjectUtil.getFirstBaseElement((PictogramElement)newTarget);
        if (newObject instanceof SequenceFlow) {
            ((SequenceFlow)newObject).setSourceRef((FlowNode)newSourceObject);
            ((SequenceFlow)newObject).setTargetRef((FlowNode)newTargetObject);
        } else if (newObject instanceof Association) {
            ((Association)newObject).setSourceRef((BaseElement)((FlowNode)newSourceObject));
            ((Association)newObject).setTargetRef((BaseElement)((FlowNode)newTargetObject));
        } else if (newObject instanceof MessageFlow) {
            ((MessageFlow)newObject).setSourceRef((InteractionNode)newSourceObject);
            ((MessageFlow)newObject).setTargetRef((InteractionNode)newTargetObject);
        } else if (newObject instanceof ConversationLink) {
            ((ConversationLink)newObject).setSourceRef((InteractionNode)newSourceObject);
            ((ConversationLink)newObject).setTargetRef((InteractionNode)newTargetObject);
        }
        AddConnectionContext acc = new AddConnectionContext((Anchor)newStart, (Anchor)newEnd);
        acc.setNewObject((Object)newObject);
        Connection newConnection = (Connection)this.getFeatureProvider().addIfPossible((IAddContext)acc);
        this.connectionMap.put(oldConnection, newConnection);
        if (oldConnection instanceof FreeFormConnection && newConnection instanceof FreeFormConnection) {
            for (Point p : ((FreeFormConnection)oldConnection).getBendpoints()) {
                int deltaX = p.getX() - this.xReference;
                int deltaY = p.getY() - this.yReference;
                Point newPoint = GraphicsUtil.createPoint(x + deltaX, y + deltaY);
                ((FreeFormConnection)newConnection).getBendpoints().add((Object)newPoint);
            }
        }
        if (oldObject instanceof BaseElement && (oldBpmnEdge = DIUtils.findBPMNEdge((EObject)oldObject)) != null) {
            BPMNEdge newBpmnEdge = DIUtils.findBPMNEdge((EObject)newObject);
            newBpmnEdge.setMessageVisibleKind(oldBpmnEdge.getMessageVisibleKind());
        }
        FeatureSupport.updateConnection(this.getFeatureProvider(), newConnection);
        return newObject;
    }

    private ContainerShape getTargetContainerShape(IPasteContext context) {
        Point p;
        Diagram diagram = this.getFeatureProvider().getDiagramTypeProvider().getDiagram();
        Shape s = GraphicsUtil.findShapeAt((ContainerShape)diagram, p = GraphicsUtil.createPoint(context.getX(), context.getY()), new GraphicsUtil.IShapeFilter(){

            @Override
            public boolean matches(Shape shape) {
                if (shape instanceof ContainerShape) {
                    BaseElement be = DefaultPasteBPMNElementFeature.this.getContainerObject((ContainerShape)shape);
                    return be instanceof FlowElementsContainer || be instanceof Participant;
                }
                return false;
            }
        });
        if (s != null) {
            return (ContainerShape)s;
        }
        return diagram;
    }

    private BaseElement getContainerObject(ContainerShape targetContainerShape) {
        EObject bo = BusinessObjectUtil.getBusinessObjectForPictogramElement((PictogramElement)targetContainerShape);
        if (bo instanceof BPMNDiagram) {
            bo = ((BPMNDiagram)bo).getPlane().getBpmnElement();
        }
        if (bo instanceof Participant) {
            if (!FeatureSupport.isChoreographyParticipantBand((PictogramElement)targetContainerShape)) {
                return (Participant)bo;
            }
            bo = ((Participant)bo).getProcessRef();
        }
        if (bo instanceof FlowElementsContainer || bo instanceof Lane || bo instanceof Collaboration) {
            return (BaseElement)bo;
        }
        return null;
    }

    private FlowElementsContainer getFlowElementsContainer(Lane lane) {
        EObject container = lane.eContainer();
        while (!(container instanceof FlowElementsContainer) && container != null) {
            container = container.eContainer();
        }
        return (FlowElementsContainer)container;
    }
}

