/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.core.features;

import org.eclipse.bpmn2.modeler.core.LifecycleEvent;
import org.eclipse.bpmn2.modeler.core.di.DIUtils;
import org.eclipse.bpmn2.modeler.core.runtime.TargetRuntime;
import org.eclipse.bpmn2.modeler.core.utils.AnchorUtil;
import org.eclipse.bpmn2.modeler.core.utils.FeatureSupport;
import org.eclipse.bpmn2.modeler.core.utils.GraphicsUtil;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IContext;
import org.eclipse.graphiti.features.context.IResizeShapeContext;
import org.eclipse.graphiti.features.impl.DefaultResizeShapeFeature;
import org.eclipse.graphiti.mm.pictograms.Anchor;
import org.eclipse.graphiti.mm.pictograms.AnchorContainer;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;

public class DefaultResizeBPMNShapeFeature
extends DefaultResizeShapeFeature {
    public DefaultResizeBPMNShapeFeature(IFeatureProvider fp) {
        super(fp);
    }

    public boolean canResizeShape(IResizeShapeContext context) {
        if (FeatureSupport.isLabelShape(context.getPictogramElement())) {
            return false;
        }
        boolean doit = super.canResizeShape(context);
        LifecycleEvent event = new LifecycleEvent(LifecycleEvent.EventType.PICTOGRAMELEMENT_CAN_RESIZE, this.getFeatureProvider(), (IContext)context, context.getPictogramElement());
        event.doit = doit;
        TargetRuntime.getCurrentRuntime().notify(event);
        return event.doit;
    }

    protected void preResizeShape(IResizeShapeContext context) {
        TargetRuntime rt = TargetRuntime.getCurrentRuntime();
        rt.notify(new LifecycleEvent(LifecycleEvent.EventType.PICTOGRAMELEMENT_PRE_RESIZE, this.getFeatureProvider(), (IContext)context, context.getPictogramElement()));
    }

    protected void postResizeShape(IResizeShapeContext context) {
        TargetRuntime rt = TargetRuntime.getCurrentRuntime();
        rt.notify(new LifecycleEvent(LifecycleEvent.EventType.PICTOGRAMELEMENT_POST_RESIZE, this.getFeatureProvider(), (IContext)context, context.getPictogramElement()));
    }

    public void resizeShape(IResizeShapeContext context) {
        this.preResizeShape(context);
        this.internalResizeShape(context);
        this.postResizeShape(context);
    }

    protected void internalResizeShape(IResizeShapeContext context) {
        Shape shape = context.getShape();
        super.resizeShape(context);
        if (shape != null) {
            AnchorUtil.relocateFixPointAnchors(shape, context.getWidth(), context.getHeight());
        }
        DIUtils.updateDIShape(context.getPictogramElement());
        FeatureSupport.updateLabel(this.getFeatureProvider(), (PictogramElement)shape, null);
        FeatureSupport.updateConnections(this.getFeatureProvider(), (AnchorContainer)shape);
        for (Connection connection : this.getDiagram().getConnections()) {
            if (!GraphicsUtil.intersects(shape, connection)) continue;
            FeatureSupport.updateConnection(this.getFeatureProvider(), connection);
        }
        FeatureSupport.updateCategoryValues(this.getFeatureProvider(), (PictogramElement)shape);
        for (Anchor a : shape.getAnchors()) {
            for (Connection c : a.getIncomingConnections()) {
                FeatureSupport.updateCategoryValues(this.getFeatureProvider(), (PictogramElement)c);
            }
            for (Connection c : a.getOutgoingConnections()) {
                FeatureSupport.updateCategoryValues(this.getFeatureProvider(), (PictogramElement)c);
            }
        }
    }
}

