/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.core.features;

import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.DataAssociation;
import org.eclipse.bpmn2.di.BPMNEdge;
import org.eclipse.bpmn2.modeler.core.di.DIUtils;
import org.eclipse.bpmn2.modeler.core.features.AbstractBpmn2CreateConnectionFeature;
import org.eclipse.bpmn2.modeler.core.features.BendpointConnectionRouter;
import org.eclipse.bpmn2.modeler.core.utils.AnchorUtil;
import org.eclipse.bpmn2.modeler.core.utils.BusinessObjectUtil;
import org.eclipse.bpmn2.modeler.core.utils.FeatureSupport;
import org.eclipse.bpmn2.modeler.core.utils.Tuple;
import org.eclipse.dd.di.DiagramElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.graphiti.datatypes.ILocation;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IReconnectionContext;
import org.eclipse.graphiti.features.context.impl.ReconnectionContext;
import org.eclipse.graphiti.features.impl.DefaultReconnectionFeature;
import org.eclipse.graphiti.mm.PropertyContainer;
import org.eclipse.graphiti.mm.algorithms.styles.Point;
import org.eclipse.graphiti.mm.pictograms.Anchor;
import org.eclipse.graphiti.mm.pictograms.AnchorContainer;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.FixPointAnchor;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.services.IGaService;
import org.eclipse.graphiti.services.IPeService;

public class ReconnectBaseElementFeature
extends DefaultReconnectionFeature {
    protected boolean changesDone = false;

    public ReconnectBaseElementFeature(IFeatureProvider fp) {
        super(fp);
    }

    public boolean canReconnect(IReconnectionContext context) {
        AnchorContainer sourceContainer = null;
        AnchorContainer targetContainer = null;
        EObject businessObject = BusinessObjectUtil.getBusinessObjectForPictogramElement((PictogramElement)context.getConnection());
        if (context.getReconnectType().equals(ReconnectionContext.RECONNECT_TARGET)) {
            sourceContainer = context.getConnection().getStart().getParent();
            if (context.getTargetPictogramElement() instanceof AnchorContainer) {
                targetContainer = (AnchorContainer)context.getTargetPictogramElement();
            }
        } else {
            targetContainer = context.getConnection().getEnd().getParent();
            if (context.getTargetPictogramElement() instanceof AnchorContainer) {
                sourceContainer = (AnchorContainer)context.getTargetPictogramElement();
            }
        }
        if (!AbstractBpmn2CreateConnectionFeature.canCreateConnection(sourceContainer, targetContainer, businessObject.eClass(), context.getReconnectType())) {
            return false;
        }
        return super.canReconnect(context);
    }

    public void preReconnect(IReconnectionContext context) {
        IPeService peService = Graphiti.getPeService();
        IGaService gaService = Graphiti.getGaService();
        Connection connection = context.getConnection();
        FixPointAnchor newAnchor = null;
        AnchorContainer source = connection.getStart().getParent();
        AnchorContainer target = connection.getEnd().getParent();
        Tuple<FixPointAnchor, FixPointAnchor> anchors = null;
        if (context.getReconnectType().equals(ReconnectionContext.RECONNECT_TARGET)) {
            target = (AnchorContainer)context.getTargetPictogramElement();
            ILocation targetLoc = context.getTargetLocation();
            ILocation shapeLoc = peService.getLocationRelativeToDiagram((Shape)target);
            Point p = gaService.createPoint(targetLoc.getX() - shapeLoc.getX(), targetLoc.getY() - shapeLoc.getY());
            peService.setPropertyValue((PropertyContainer)connection, "connection.target.location", AnchorUtil.pointToString(p));
            BendpointConnectionRouter.setMovedBendpoint(connection, Integer.MAX_VALUE);
            peService.setPropertyValue((PropertyContainer)connection, "connection.source.location", "");
            anchors = AnchorUtil.getSourceAndTargetBoundaryAnchors(source, target, connection);
            newAnchor = anchors.getSecond();
        } else {
            source = (AnchorContainer)context.getTargetPictogramElement();
            ILocation sourceLoc = context.getTargetLocation();
            ILocation shapeLoc = peService.getLocationRelativeToDiagram((Shape)source);
            Point p = gaService.createPoint(sourceLoc.getX() - shapeLoc.getX(), sourceLoc.getY() - shapeLoc.getY());
            peService.setPropertyValue((PropertyContainer)connection, "connection.source.location", AnchorUtil.pointToString(p));
            BendpointConnectionRouter.setMovedBendpoint(connection, 0);
            peService.setPropertyValue((PropertyContainer)connection, "connection.target.location", "");
            anchors = AnchorUtil.getSourceAndTargetBoundaryAnchors(source, target, connection);
            newAnchor = anchors.getFirst();
        }
        if (newAnchor != null) {
            ((ReconnectionContext)context).setNewAnchor((Anchor)newAnchor);
        }
        super.preReconnect(context);
    }

    public void postReconnect(IReconnectionContext context) {
        super.postReconnect(context);
        BPMNEdge edge = BusinessObjectUtil.getFirstElementOfType((PictogramElement)context.getConnection(), BPMNEdge.class);
        DiagramElement de = BusinessObjectUtil.getFirstElementOfType(context.getTargetPictogramElement(), DiagramElement.class);
        if (context.getReconnectType().equals(ReconnectionContext.RECONNECT_TARGET)) {
            edge.setTargetElement(de);
        } else {
            edge.setSourceElement(de);
        }
        Connection connection = context.getConnection();
        BaseElement flow = BusinessObjectUtil.getFirstElementOfType((PictogramElement)connection, BaseElement.class);
        if (!(flow instanceof DataAssociation)) {
            BaseElement be = BusinessObjectUtil.getFirstElementOfType(context.getTargetPictogramElement(), BaseElement.class);
            if (context.getReconnectType().equals(ReconnectionContext.RECONNECT_TARGET)) {
                EStructuralFeature feature = flow.eClass().getEStructuralFeature("targetRef");
                if (feature != null) {
                    flow.eSet(feature, (Object)be);
                }
                AnchorUtil.deleteEmptyAdHocAnchors(connection.getEnd().getParent());
            } else {
                EStructuralFeature feature = flow.eClass().getEStructuralFeature("sourceRef");
                if (feature != null && !feature.isMany()) {
                    flow.eSet(feature, (Object)be);
                }
                AnchorUtil.deleteEmptyAdHocAnchors(connection.getStart().getParent());
            }
        }
        FeatureSupport.updateConnection(this.getFeatureProvider(), connection, true);
        DIUtils.updateDIEdge(context.getConnection());
        this.changesDone = true;
    }

    public boolean hasDoneChanges() {
        return this.changesDone;
    }
}

