/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.core.features.activity;

import org.eclipse.bpmn2.Activity;
import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.modeler.core.features.AbstractBpmn2AddFeature;
import org.eclipse.bpmn2.modeler.core.features.activity.UpdateActivityLoopAndMultiInstanceMarkerFeature;
import org.eclipse.bpmn2.modeler.core.features.label.AddShapeLabelFeature;
import org.eclipse.bpmn2.modeler.core.utils.AnchorUtil;
import org.eclipse.bpmn2.modeler.core.utils.FeatureSupport;
import org.eclipse.bpmn2.modeler.core.utils.ShapeDecoratorUtil;
import org.eclipse.graphiti.features.IAddFeature;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IAddContext;
import org.eclipse.graphiti.features.context.ITargetContext;
import org.eclipse.graphiti.features.context.impl.AddContext;
import org.eclipse.graphiti.mm.PropertyContainer;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.algorithms.Rectangle;
import org.eclipse.graphiti.mm.pictograms.AnchorContainer;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;

public abstract class AbstractAddActivityFeature<T extends Activity>
extends AbstractBpmn2AddFeature<T> {
    public AbstractAddActivityFeature(IFeatureProvider fp) {
        super(fp);
    }

    @Override
    public IAddFeature getAddLabelFeature(IFeatureProvider fp) {
        return new AddShapeLabelFeature(fp);
    }

    public boolean canAdd(IAddContext context) {
        return FeatureSupport.isValidFlowElementTarget((ITargetContext)context);
    }

    public PictogramElement add(IAddContext context) {
        Activity businessObject = (Activity)this.getBusinessObject(context);
        int width = this.getWidth(context);
        int height = this.getHeight(context);
        GraphicsAlgorithm targetAlgorithm = context.getTargetContainer().getGraphicsAlgorithm();
        if (targetAlgorithm != null) {
            width = Math.min(targetAlgorithm.getWidth(), width);
            height = Math.min(targetAlgorithm.getHeight(), height);
        }
        this.adjustLocation(context, width, height);
        int x = context.getX();
        int y = context.getY();
        ContainerShape containerShape = peService.createContainerShape(context.getTargetContainer(), true);
        Rectangle invisibleRect = gaService.createInvisibleRectangle((PictogramElement)containerShape);
        gaService.setLocationAndSize((GraphicsAlgorithm)invisibleRect, x, y, width, height);
        Shape rectShape = ShapeDecoratorUtil.createActivityBorder(containerShape, (BaseElement)businessObject);
        boolean isImport = context.getProperty((Object)"is.importing") != null;
        this.createDIShape((Shape)containerShape, (BaseElement)businessObject, !isImport);
        peService.setPropertyValue((PropertyContainer)containerShape, "marker.compensate", Boolean.toString(false));
        peService.setPropertyValue((PropertyContainer)containerShape, "marker.loop.or.multi", UpdateActivityLoopAndMultiInstanceMarkerFeature.LoopCharacteristicType.NULL.getName());
        ((AddContext)context).setWidth(width);
        ((AddContext)context).setHeight(height);
        this.decorateShape(context, containerShape, businessObject);
        peService.createChopboxAnchor((AnchorContainer)containerShape);
        AnchorUtil.addFixedPointAnchors((Shape)containerShape, rectShape.getGraphicsAlgorithm());
        this.splitConnection(context, containerShape);
        return containerShape;
    }

    protected int getMarkerContainerOffset() {
        return 0;
    }
}

