/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.core.features.artifact;

import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.TextAnnotation;
import org.eclipse.bpmn2.modeler.core.features.AbstractBpmn2AddFeature;
import org.eclipse.bpmn2.modeler.core.features.label.AddShapeLabelFeature;
import org.eclipse.bpmn2.modeler.core.utils.AnchorUtil;
import org.eclipse.bpmn2.modeler.core.utils.FeatureSupport;
import org.eclipse.bpmn2.modeler.core.utils.StyleUtil;
import org.eclipse.graphiti.features.IAddFeature;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IAddContext;
import org.eclipse.graphiti.features.context.ITargetContext;
import org.eclipse.graphiti.features.context.impl.AddContext;
import org.eclipse.graphiti.mm.GraphicsAlgorithmContainer;
import org.eclipse.graphiti.mm.algorithms.AbstractText;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.algorithms.Polyline;
import org.eclipse.graphiti.mm.algorithms.Rectangle;
import org.eclipse.graphiti.mm.algorithms.styles.Orientation;
import org.eclipse.graphiti.mm.pictograms.AnchorContainer;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.services.IPeCreateService;

public class AddTextAnnotationFeature
extends AbstractBpmn2AddFeature<TextAnnotation> {
    public AddTextAnnotationFeature(IFeatureProvider fp) {
        super(fp);
    }

    @Override
    public IAddFeature getAddLabelFeature(IFeatureProvider fp) {
        return new AddShapeLabelFeature(fp){

            @Override
            public void applyStyle(AbstractText text, BaseElement be) {
                super.applyStyle(text, be);
                text.setHorizontalAlignment(Orientation.ALIGNMENT_LEFT);
                text.setVerticalAlignment(Orientation.ALIGNMENT_TOP);
            }

            @Override
            public String getLabelString(BaseElement element) {
                if (element instanceof TextAnnotation) {
                    return ((TextAnnotation)element).getText();
                }
                return "";
            }
        };
    }

    public boolean canAdd(IAddContext context) {
        return FeatureSupport.isValidArtifactTarget((ITargetContext)context);
    }

    public PictogramElement add(IAddContext context) {
        TextAnnotation businessObject = (TextAnnotation)this.getBusinessObject(context);
        IPeCreateService peCreateService = Graphiti.getPeCreateService();
        ContainerShape containerShape = peCreateService.createContainerShape(context.getTargetContainer(), true);
        int width = this.getWidth(context);
        int height = this.getHeight(context);
        int commentEdge = 15;
        Rectangle rect = gaService.createInvisibleRectangle((PictogramElement)containerShape);
        gaService.setLocationAndSize((GraphicsAlgorithm)rect, context.getX(), context.getY(), width, height);
        Shape lineShape = peCreateService.createShape(containerShape, false);
        int[] nArray = new int[8];
        nArray[0] = commentEdge;
        nArray[5] = height;
        nArray[6] = commentEdge;
        nArray[7] = height;
        Polyline line = gaService.createPolyline((GraphicsAlgorithmContainer)lineShape, nArray);
        line.setStyle(StyleUtil.getStyleForClass(this.getDiagram()));
        line.setLineWidth(Integer.valueOf(2));
        gaService.setLocationAndSize((GraphicsAlgorithm)line, 0, 0, commentEdge, height);
        boolean isImport = context.getProperty((Object)"is.importing") != null;
        this.createDIShape((Shape)containerShape, (BaseElement)businessObject, !isImport);
        ((AddContext)context).setWidth(width);
        ((AddContext)context).setHeight(height);
        this.decorateShape(context, containerShape, businessObject);
        peCreateService.createChopboxAnchor((AnchorContainer)containerShape);
        AnchorUtil.addFixedPointAnchors((Shape)containerShape, (GraphicsAlgorithm)rect);
        return containerShape;
    }

    @Override
    public Class getBusinessObjectType() {
        return TextAnnotation.class;
    }
}

