/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.core.features.containers.lane;

import org.eclipse.bpmn2.Collaboration;
import org.eclipse.bpmn2.FlowNode;
import org.eclipse.bpmn2.Lane;
import org.eclipse.bpmn2.LaneSet;
import org.eclipse.bpmn2.Participant;
import org.eclipse.bpmn2.Process;
import org.eclipse.bpmn2.di.BPMNDiagram;
import org.eclipse.bpmn2.modeler.core.features.containers.MoveContainerFeature;
import org.eclipse.bpmn2.modeler.core.features.containers.lane.MoveFromDiagramToLaneFeature;
import org.eclipse.bpmn2.modeler.core.features.containers.lane.MoveFromDiagramToParticipantFeature;
import org.eclipse.bpmn2.modeler.core.features.containers.lane.MoveFromLaneToDiagramFeature;
import org.eclipse.bpmn2.modeler.core.features.containers.lane.MoveFromLaneToLaneFeature;
import org.eclipse.bpmn2.modeler.core.features.containers.lane.MoveFromLaneToParticipantFeature;
import org.eclipse.bpmn2.modeler.core.features.containers.lane.MoveFromParticipantToDiagramFeature;
import org.eclipse.bpmn2.modeler.core.features.containers.lane.MoveFromParticipantToLaneFeature;
import org.eclipse.bpmn2.modeler.core.features.containers.lane.MoveFromParticipantToParticipantFeature;
import org.eclipse.bpmn2.modeler.core.model.ModelHandler;
import org.eclipse.bpmn2.modeler.core.utils.BusinessObjectUtil;
import org.eclipse.bpmn2.modeler.core.utils.FeatureSupport;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IMoveShapeContext;
import org.eclipse.graphiti.features.context.ITargetContext;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;

public class MoveLaneFeature
extends MoveContainerFeature {
    private MoveLaneFeature moveStrategy;
    protected ModelHandler modelHandler = ModelHandler.getInstance((EObject)this.getDiagram());

    public MoveLaneFeature(IFeatureProvider fp) {
        super(fp);
    }

    @Override
    public boolean canMoveShape(IMoveShapeContext context) {
        if (context.getSourceContainer() == null) {
            return false;
        }
        this.moveStrategy = this.getStrategy(context);
        if (this.moveStrategy == null) {
            return super.canMoveShape(context);
        }
        return this.moveStrategy.canMoveShape(context);
    }

    protected void internalMove(IMoveShapeContext context) {
        super.internalMove(context);
        if (this.moveStrategy != null) {
            this.moveStrategy.internalMove(context);
        }
    }

    private MoveLaneFeature getStrategy(IMoveShapeContext context) {
        if (context.getSourceContainer().equals(this.getDiagram())) {
            if (FeatureSupport.isTargetLane((ITargetContext)context)) {
                return new MoveFromDiagramToLaneFeature(this.getFeatureProvider());
            }
            if (FeatureSupport.isTargetParticipant((ITargetContext)context)) {
                return new MoveFromDiagramToParticipantFeature(this.getFeatureProvider());
            }
        } else if (FeatureSupport.isLane((PictogramElement)context.getSourceContainer())) {
            if (context.getTargetContainer().equals(this.getDiagram())) {
                return new MoveFromLaneToDiagramFeature(this.getFeatureProvider());
            }
            if (FeatureSupport.isTargetLane((ITargetContext)context)) {
                return new MoveFromLaneToLaneFeature(this.getFeatureProvider());
            }
            if (FeatureSupport.isTargetParticipant((ITargetContext)context)) {
                return new MoveFromLaneToParticipantFeature(this.getFeatureProvider());
            }
        } else if (FeatureSupport.isParticipant((PictogramElement)context.getSourceContainer())) {
            if (context.getTargetContainer().equals(this.getDiagram())) {
                return new MoveFromParticipantToDiagramFeature(this.getFeatureProvider());
            }
            if (FeatureSupport.isTargetLane((ITargetContext)context)) {
                return new MoveFromParticipantToLaneFeature(this.getFeatureProvider());
            }
            if (FeatureSupport.isTargetParticipant((ITargetContext)context)) {
                return new MoveFromParticipantToParticipantFeature(this.getFeatureProvider());
            }
        }
        return null;
    }

    protected Lane getMovedLane(IMoveShapeContext context) {
        return (Lane)this.getBusinessObjectForPictogramElement((PictogramElement)context.getShape());
    }

    protected Process getProcess(Object object) {
        Participant participant;
        Process process = null;
        if (object instanceof PictogramElement) {
            object = BusinessObjectUtil.getBusinessObjectForPictogramElement((PictogramElement)object);
        }
        if (object instanceof BPMNDiagram) {
            object = ((BPMNDiagram)object).getPlane().getBpmnElement();
        }
        if (object instanceof Collaboration) {
            participant = null;
            Collaboration collaboration = (Collaboration)object;
            for (Participant p : collaboration.getParticipants()) {
                if (p.getProcessRef() != null) {
                    process = p.getProcessRef();
                    break;
                }
                if (participant != null) continue;
                participant = p;
            }
            if (process == null) {
                object = participant;
            }
        }
        if (object instanceof Participant && (process = (participant = (Participant)object).getProcessRef()) == null) {
            process = this.modelHandler.create(Process.class);
            this.modelHandler.getDefinitions().getRootElements().add(process);
            process.setName(String.valueOf(participant.getName()) + " Process");
            if (participant.eContainer() instanceof Collaboration) {
                process.setDefinitionalCollaborationRef((Collaboration)participant.eContainer());
            }
            participant.setProcessRef(process);
        }
        if (object instanceof Process) {
            process = (Process)object;
        }
        if (process == null && object instanceof EObject) {
            EObject o = (EObject)object;
            while (o.eContainer() != null) {
                if (o instanceof Process) {
                    process = (Process)o;
                    break;
                }
                o = o.eContainer();
            }
        }
        return process;
    }

    protected Lane getTargetLane(ITargetContext context) {
        ContainerShape targetContainer = context.getTargetContainer();
        return (Lane)this.getBusinessObjectForPictogramElement((PictogramElement)targetContainer);
    }

    protected Lane getSourceLane(IMoveShapeContext context) {
        ContainerShape sourceContainer = context.getSourceContainer();
        return (Lane)this.getBusinessObjectForPictogramElement((PictogramElement)sourceContainer);
    }

    protected LaneSet createLaneSet() {
        return this.modelHandler.create(LaneSet.class);
    }

    protected void moveLane(Lane movedLane, Process sourceProcess, Process targetProcess) {
        if (sourceProcess != targetProcess) {
            for (FlowNode node : movedLane.getFlowNodeRefs()) {
                this.modelHandler.moveFlowNode(node, sourceProcess, targetProcess);
            }
            if (movedLane.getChildLaneSet() != null && !movedLane.getChildLaneSet().getLanes().isEmpty()) {
                for (Lane lane : movedLane.getChildLaneSet().getLanes()) {
                    this.moveLane(lane, sourceProcess, targetProcess);
                }
            }
        }
    }
}

