/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.core.features.containers.participant;

import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.Participant;
import org.eclipse.bpmn2.di.BPMNShape;
import org.eclipse.bpmn2.modeler.core.features.AbstractBpmn2AddFeature;
import org.eclipse.bpmn2.modeler.core.features.label.AddShapeLabelFeature;
import org.eclipse.bpmn2.modeler.core.utils.AnchorUtil;
import org.eclipse.bpmn2.modeler.core.utils.FeatureSupport;
import org.eclipse.bpmn2.modeler.core.utils.StyleUtil;
import org.eclipse.graphiti.features.IAddFeature;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IAddContext;
import org.eclipse.graphiti.mm.GraphicsAlgorithmContainer;
import org.eclipse.graphiti.mm.PropertyContainer;
import org.eclipse.graphiti.mm.algorithms.AbstractText;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.algorithms.Polyline;
import org.eclipse.graphiti.mm.algorithms.Rectangle;
import org.eclipse.graphiti.mm.algorithms.styles.Orientation;
import org.eclipse.graphiti.mm.pictograms.AnchorContainer;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.services.IPeCreateService;

public class AddParticipantFeature
extends AbstractBpmn2AddFeature<Participant> {
    public AddParticipantFeature(IFeatureProvider fp) {
        super(fp);
    }

    @Override
    public IAddFeature getAddLabelFeature(IFeatureProvider fp) {
        return new AddShapeLabelFeature(fp){

            @Override
            protected AbstractText createText(Shape labelShape, String labelText) {
                return gaService.createText((GraphicsAlgorithmContainer)labelShape, labelText);
            }

            @Override
            public void applyStyle(AbstractText text, BaseElement be) {
                super.applyStyle(text, be);
                text.setHorizontalAlignment(Orientation.ALIGNMENT_CENTER);
                text.setVerticalAlignment(Orientation.ALIGNMENT_CENTER);
            }
        };
    }

    public boolean canAdd(IAddContext context) {
        boolean isParticipant = this.getBusinessObject(context) instanceof Participant;
        boolean addToDiagram = context.getTargetContainer() instanceof Diagram;
        return isParticipant && addToDiagram;
    }

    public PictogramElement add(IAddContext context) {
        Polyline line;
        Participant businessObject = (Participant)this.getBusinessObject(context);
        Diagram targetDiagram = (Diagram)context.getTargetContainer();
        IPeCreateService peCreateService = Graphiti.getPeCreateService();
        ContainerShape containerShape = peCreateService.createContainerShape((ContainerShape)targetDiagram, true);
        int width = this.getWidth(context);
        int height = this.getHeight(context);
        Rectangle rect = gaService.createRectangle((GraphicsAlgorithmContainer)containerShape);
        StyleUtil.applyStyle((GraphicsAlgorithm)rect, (BaseElement)businessObject);
        gaService.setLocationAndSize((GraphicsAlgorithm)rect, context.getX(), context.getY(), width, height);
        boolean isImport = context.getProperty((Object)"is.importing") != null;
        BPMNShape bpmnShape = this.createDIShape((Shape)containerShape, (BaseElement)businessObject, !isImport);
        boolean horz = bpmnShape.isIsHorizontal();
        Object copiedBpmnShape = context.getProperty((Object)"copied.bpmn.shape");
        if (copiedBpmnShape instanceof BPMNShape) {
            horz = ((BPMNShape)copiedBpmnShape).isIsHorizontal();
        }
        FeatureSupport.setHorizontal(containerShape, horz);
        Shape lineShape = peCreateService.createShape(containerShape, false);
        if (horz) {
            int[] nArray = new int[4];
            nArray[0] = 30;
            nArray[2] = 30;
            nArray[3] = height;
            line = gaService.createPolyline((GraphicsAlgorithmContainer)lineShape, nArray);
        } else {
            int[] nArray = new int[4];
            nArray[1] = 30;
            nArray[2] = width;
            nArray[3] = 30;
            line = gaService.createPolyline((GraphicsAlgorithmContainer)lineShape, nArray);
        }
        StyleUtil.applyStyle((GraphicsAlgorithm)line, (BaseElement)businessObject);
        peService.setPropertyValue((PropertyContainer)containerShape, "multiplicity", Boolean.toString(false));
        this.decorateShape(context, containerShape, businessObject);
        peCreateService.createChopboxAnchor((AnchorContainer)containerShape);
        AnchorUtil.addFixedPointAnchors((Shape)containerShape, (GraphicsAlgorithm)rect);
        return containerShape;
    }

    @Override
    protected void decorateShape(IAddContext context, ContainerShape containerShape, Participant businessObject) {
    }

    @Override
    public Class getBusinessObjectType() {
        return Participant.class;
    }
}

