/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.core.features.flow;

import java.util.Collection;
import java.util.List;
import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.EndEvent;
import org.eclipse.bpmn2.EventDefinition;
import org.eclipse.bpmn2.MessageEventDefinition;
import org.eclipse.bpmn2.modeler.core.di.DIImport;
import org.eclipse.bpmn2.modeler.core.features.AbstractBpmn2AddFeature;
import org.eclipse.bpmn2.modeler.core.features.label.AddConnectionLabelFeature;
import org.eclipse.bpmn2.modeler.core.utils.AnchorUtil;
import org.eclipse.bpmn2.modeler.core.utils.BusinessObjectUtil;
import org.eclipse.bpmn2.modeler.core.utils.StyleUtil;
import org.eclipse.bpmn2.modeler.core.utils.Tuple;
import org.eclipse.graphiti.features.IAddFeature;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IAddConnectionContext;
import org.eclipse.graphiti.features.context.IAddContext;
import org.eclipse.graphiti.features.context.IContext;
import org.eclipse.graphiti.mm.GraphicsAlgorithmContainer;
import org.eclipse.graphiti.mm.PropertyContainer;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.algorithms.Polyline;
import org.eclipse.graphiti.mm.algorithms.styles.Point;
import org.eclipse.graphiti.mm.pictograms.Anchor;
import org.eclipse.graphiti.mm.pictograms.AnchorContainer;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.FixPointAnchor;
import org.eclipse.graphiti.mm.pictograms.FreeFormConnection;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.services.Graphiti;

public abstract class AbstractAddFlowFeature<T extends BaseElement>
extends AbstractBpmn2AddFeature<T> {
    public AbstractAddFlowFeature(IFeatureProvider fp) {
        super(fp);
    }

    @Override
    public IAddFeature getAddLabelFeature(IFeatureProvider fp) {
        return new AddConnectionLabelFeature(fp);
    }

    public boolean canAdd(IAddContext context) {
        if (context instanceof IAddConnectionContext) {
            BaseElement obj;
            IAddConnectionContext acc = (IAddConnectionContext)context;
            if (acc.getSourceAnchor() != null && (obj = BusinessObjectUtil.getFirstElementOfType((PictogramElement)acc.getSourceAnchor().getParent(), BaseElement.class)) instanceof EndEvent) {
                List eventDefinitions = ((EndEvent)obj).getEventDefinitions();
                for (EventDefinition eventDefinition : eventDefinitions) {
                    if (!(eventDefinition instanceof MessageEventDefinition)) continue;
                    return true;
                }
                return false;
            }
            return this.getBusinessObjectType().isAssignableFrom(this.getBusinessObject(context).getClass());
        }
        return false;
    }

    public PictogramElement add(IAddContext context) {
        List bendpoints;
        Point p;
        boolean isImporting = DIImport.isImporting((IContext)context);
        Object businessObject = this.getBusinessObject(context);
        IAddConnectionContext addContext = (IAddConnectionContext)context;
        AnchorContainer sourceContainer = addContext.getSourceAnchor().getParent();
        AnchorContainer targetContainer = addContext.getTargetAnchor().getParent();
        FreeFormConnection connection = peService.createFreeFormConnection(this.getDiagram());
        if (AnchorUtil.useAdHocAnchors((PictogramElement)sourceContainer, (Connection)connection) && (p = (Point)addContext.getProperty((Object)"connection.source.location")) != null) {
            peService.setPropertyValue((PropertyContainer)connection, "connection.source.location", AnchorUtil.pointToString(p));
        }
        if (AnchorUtil.useAdHocAnchors((PictogramElement)targetContainer, (Connection)connection) && (p = (Point)addContext.getProperty((Object)"connection.target.location")) != null) {
            peService.setPropertyValue((PropertyContainer)connection, "connection.target.location", AnchorUtil.pointToString(p));
        }
        if (addContext.getProperty((Object)"connection.created") != null) {
            peService.setPropertyValue((PropertyContainer)connection, "connection.created", "true");
        }
        Anchor sourceAnchor = addContext.getSourceAnchor();
        Anchor targetAnchor = addContext.getTargetAnchor();
        if (isImporting) {
            connection.setStart(sourceAnchor);
            connection.setEnd(targetAnchor);
        } else {
            Tuple<FixPointAnchor, FixPointAnchor> anchors;
            if (sourceAnchor == null || targetAnchor == null) {
                anchors = AnchorUtil.getSourceAndTargetBoundaryAnchors(sourceContainer, targetContainer, null);
                sourceAnchor = (Anchor)anchors.getFirst();
                targetAnchor = (Anchor)anchors.getSecond();
            } else {
                anchors = AnchorUtil.getSourceAndTargetBoundaryAnchors(sourceContainer, targetContainer, (Connection)connection);
                sourceAnchor = (Anchor)anchors.getFirst();
                targetAnchor = (Anchor)anchors.getSecond();
            }
            connection.setStart(sourceAnchor);
            connection.setEnd(targetAnchor);
        }
        this.createDIEdge((Connection)connection, (BaseElement)businessObject);
        this.createConnectionLine((Connection)connection);
        if (isImporting && (bendpoints = (List)context.getProperty((Object)"connection.bendpoints")) != null && bendpoints.size() > 0) {
            connection.getBendpoints().addAll((Collection)bendpoints);
        }
        this.decorateConnection(addContext, (Connection)connection, businessObject);
        return connection;
    }

    protected Polyline createConnectionLine(Connection connection) {
        BaseElement be = BusinessObjectUtil.getFirstBaseElement((PictogramElement)connection);
        Polyline connectionLine = Graphiti.getGaService().createPolyline((GraphicsAlgorithmContainer)connection);
        StyleUtil.applyStyle((GraphicsAlgorithm)connectionLine, be);
        return connectionLine;
    }
}

