/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.core.features.gateway;

import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.Gateway;
import org.eclipse.bpmn2.modeler.core.features.AbstractBpmn2AddFeature;
import org.eclipse.bpmn2.modeler.core.features.label.AddShapeLabelFeature;
import org.eclipse.bpmn2.modeler.core.utils.AnchorUtil;
import org.eclipse.bpmn2.modeler.core.utils.FeatureSupport;
import org.eclipse.bpmn2.modeler.core.utils.ShapeDecoratorUtil;
import org.eclipse.bpmn2.modeler.core.utils.StyleUtil;
import org.eclipse.graphiti.features.IAddFeature;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IAddContext;
import org.eclipse.graphiti.features.context.ITargetContext;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.algorithms.Polygon;
import org.eclipse.graphiti.mm.algorithms.Rectangle;
import org.eclipse.graphiti.mm.pictograms.AnchorContainer;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;

public abstract class AddGatewayFeature<T extends Gateway>
extends AbstractBpmn2AddFeature<T> {
    public AddGatewayFeature(IFeatureProvider fp) {
        super(fp);
    }

    @Override
    public IAddFeature getAddLabelFeature(IFeatureProvider fp) {
        return new AddShapeLabelFeature(fp);
    }

    public boolean canAdd(IAddContext context) {
        return FeatureSupport.isValidFlowElementTarget((ITargetContext)context);
    }

    public PictogramElement add(IAddContext context) {
        int height;
        Gateway businessObject = (Gateway)this.getBusinessObject(context);
        int width = this.getWidth(context);
        if (width != (height = this.getHeight(context))) {
            width = height = Math.min(width, height);
        }
        this.adjustLocation(context, width, height);
        int x = context.getX();
        int y = context.getY();
        ContainerShape containerShape = peService.createContainerShape(context.getTargetContainer(), true);
        Rectangle gatewayRect = gaService.createInvisibleRectangle((PictogramElement)containerShape);
        gaService.setLocationAndSize((GraphicsAlgorithm)gatewayRect, x, y, width, height);
        Shape gatewayShape = peService.createShape(containerShape, false);
        Polygon gatewayPolygon = ShapeDecoratorUtil.createGateway(gatewayShape, width, height);
        StyleUtil.applyStyle((GraphicsAlgorithm)gatewayPolygon, (BaseElement)businessObject);
        gaService.setLocationAndSize((GraphicsAlgorithm)gatewayPolygon, 0, 0, width, height);
        boolean isImport = context.getProperty((Object)"is.importing") != null;
        this.createDIShape((Shape)containerShape, (BaseElement)businessObject, !isImport);
        this.decorateShape(context, containerShape, businessObject);
        peService.createChopboxAnchor((AnchorContainer)containerShape);
        AnchorUtil.addFixedPointAnchors((Shape)containerShape, (GraphicsAlgorithm)gatewayPolygon);
        this.splitConnection(context, containerShape);
        return containerShape;
    }
}

