/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.core.features.label;

import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.modeler.core.utils.FeatureSupport;
import org.eclipse.bpmn2.modeler.core.utils.ModelUtil;
import org.eclipse.bpmn2.modeler.core.utils.StyleUtil;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.IReason;
import org.eclipse.graphiti.features.context.IAddContext;
import org.eclipse.graphiti.features.context.IContext;
import org.eclipse.graphiti.features.context.IUpdateContext;
import org.eclipse.graphiti.features.context.impl.UpdateContext;
import org.eclipse.graphiti.features.impl.AbstractAddPictogramElementFeature;
import org.eclipse.graphiti.mm.GraphicsAlgorithmContainer;
import org.eclipse.graphiti.mm.PropertyContainer;
import org.eclipse.graphiti.mm.algorithms.AbstractText;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.algorithms.styles.Orientation;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.services.IGaService;
import org.eclipse.graphiti.services.IPeService;

public abstract class AbstractAddLabelFeature
extends AbstractAddPictogramElementFeature {
    protected static final IGaService gaService = Graphiti.getGaService();
    protected static final IPeService peService = Graphiti.getPeService();

    public AbstractAddLabelFeature(IFeatureProvider fp) {
        super(fp);
    }

    public boolean canAdd(IAddContext context) {
        return true;
    }

    public abstract PictogramElement add(IAddContext var1);

    protected AbstractText createText(PictogramElement labelOwner, Shape labelShape, BaseElement businessObject) {
        AbstractText text = this.createText(labelShape, "");
        this.applyStyle(text, businessObject);
        peService.setPropertyValue((PropertyContainer)labelShape, "label.shape", Boolean.toString(true));
        this.link((PictogramElement)labelShape, new Object[]{businessObject, labelOwner});
        this.link(labelOwner, new Object[]{labelShape});
        return text;
    }

    protected AbstractText createText(Shape labelShape, String labelText) {
        return gaService.createDefaultMultiText(this.getDiagram(), (GraphicsAlgorithmContainer)labelShape, labelText);
    }

    public String getLabelString(BaseElement element) {
        return ModelUtil.getName(element);
    }

    public void applyStyle(AbstractText text, BaseElement be) {
        StyleUtil.applyStyle((GraphicsAlgorithm)text, be);
        text.setHorizontalAlignment(Orientation.ALIGNMENT_CENTER);
        text.setVerticalAlignment(Orientation.ALIGNMENT_CENTER);
    }

    protected PictogramElement getLabelOwner(IAddContext context) {
        return FeatureSupport.getLabelOwner((IContext)context);
    }

    public IReason updatePictogramElement(IAddContext addContext, PictogramElement pe) {
        UpdateContext updateContext = new UpdateContext(pe);
        for (Object key : addContext.getPropertyKeys()) {
            Object value = addContext.getProperty(key);
            updateContext.putProperty(key, value);
        }
        return this.getFeatureProvider().updateIfPossible((IUpdateContext)updateContext);
    }
}

