/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.core.features.label;

import java.util.ArrayList;
import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.DataState;
import org.eclipse.bpmn2.ItemAwareElement;
import org.eclipse.bpmn2.di.BPMNEdge;
import org.eclipse.bpmn2.di.BPMNLabel;
import org.eclipse.bpmn2.di.BPMNShape;
import org.eclipse.bpmn2.modeler.core.di.DIUtils;
import org.eclipse.bpmn2.modeler.core.features.AbstractBpmn2UpdateFeature;
import org.eclipse.bpmn2.modeler.core.features.label.Messages;
import org.eclipse.bpmn2.modeler.core.preferences.ShapeStyle;
import org.eclipse.bpmn2.modeler.core.utils.BusinessObjectUtil;
import org.eclipse.bpmn2.modeler.core.utils.FeatureSupport;
import org.eclipse.bpmn2.modeler.core.utils.GraphicsUtil;
import org.eclipse.bpmn2.modeler.core.utils.ModelUtil;
import org.eclipse.dd.dc.Bounds;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.graphiti.datatypes.IDimension;
import org.eclipse.graphiti.datatypes.ILocation;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.IReason;
import org.eclipse.graphiti.features.context.IContext;
import org.eclipse.graphiti.features.context.IUpdateContext;
import org.eclipse.graphiti.features.impl.Reason;
import org.eclipse.graphiti.mm.PropertyContainer;
import org.eclipse.graphiti.mm.algorithms.AbstractText;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.algorithms.styles.Font;
import org.eclipse.graphiti.mm.algorithms.styles.Point;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.ui.services.GraphitiUi;

public class UpdateLabelFeature
extends AbstractBpmn2UpdateFeature {
    public UpdateLabelFeature(IFeatureProvider fp) {
        super(fp);
    }

    public boolean canUpdate(IUpdateContext context) {
        Object bo = this.getBusinessObjectForPictogramElement(context.getPictogramElement());
        if (bo instanceof BaseElement) {
            return this.hasLabel((BaseElement)bo);
        }
        return false;
    }

    @Override
    public IReason updateNeeded(IUpdateContext context) {
        IReason reason = super.updateNeeded(context);
        if (reason.toBoolean()) {
            return reason;
        }
        PictogramElement ownerPE = FeatureSupport.getLabelOwner((IContext)context);
        BaseElement element = BusinessObjectUtil.getFirstElementOfType(ownerPE, BaseElement.class);
        Shape labelShape = FeatureSupport.getLabelShape(ownerPE);
        if (labelShape != null) {
            AbstractText text;
            String oldLabel;
            if (Graphiti.getPeService().getPropertyValue((PropertyContainer)labelShape, "label.changed") != null) {
                return Reason.createTrueReason((String)Messages.UpdateLabelFeature_LabelChanged);
            }
            String newLabel = this.getLabelString(element);
            if (newLabel == null || newLabel.isEmpty()) {
                newLabel = "";
            }
            if ((oldLabel = (text = (AbstractText)labelShape.getGraphicsAlgorithm()).getValue()) == null || oldLabel.isEmpty()) {
                oldLabel = "";
            }
            if (!newLabel.equals(oldLabel)) {
                return Reason.createTrueReason((String)Messages.UpdateLabelFeature_TextChanged);
            }
        }
        return Reason.createFalseReason();
    }

    public boolean update(IUpdateContext context) {
        PictogramElement pe = FeatureSupport.getLabelOwner((IContext)context);
        Point offset = (Point)context.getProperty((Object)"label.offset");
        boolean isAdding = this.isAddingLabel((IContext)context);
        this.adjustLabelLocation(pe, isAdding, offset);
        return true;
    }

    protected boolean isAddingLabel(IContext context) {
        return context.getProperty((Object)"pictogram.elements") != null || context.getProperty((Object)"pictogram.element") != null || context.getProperty((Object)"is.importing") != null;
    }

    protected boolean hasLabel(BaseElement element) {
        return ModelUtil.hasName(element);
    }

    protected String getLabelString(BaseElement element) {
        DataState state;
        String label = ModelUtil.getName(element);
        if (element instanceof ItemAwareElement && (state = ((ItemAwareElement)element).getDataState()) != null && state.getName() != null) {
            return String.valueOf(label) + "\n[" + state.getName() + "]";
        }
        return label;
    }

    protected int getLabelWrapWidth(PictogramElement ownerPE) {
        int w = GraphicsUtil.calculateSize(ownerPE).getWidth();
        return w >= 80 ? w : 80;
    }

    protected int[] wrapText(AbstractText ga, String text, int wrapWidth) {
        Font font = ga.getFont();
        ArrayList<String> ss = new ArrayList<String>();
        int start = 0;
        int end = 0;
        while (end < text.length()) {
            char c = text.charAt(end);
            if (c == ' ') {
                ss.add(text.substring(start, end + 1));
                start = end + 1;
            } else if (c == '\n') {
                ss.add(text.substring(start, end + 1));
                start = end + 1;
            }
            ++end;
        }
        if (start < text.length()) {
            ss.add(text.substring(start));
        }
        String[] words = ss.toArray(new String[ss.size()]);
        IDimension dim = this.calculateTextSize(text, font);
        int totalHeight = dim.getHeight();
        int totalWidth = dim.getWidth();
        int height = totalHeight;
        int width = 0;
        String line = "";
        String nextword = "";
        int i = 0;
        while (i < words.length) {
            line = String.valueOf(line) + words[i];
            nextword = i < words.length - 1 ? words[i + 1] : "";
            dim = this.calculateTextSize(String.valueOf(line) + nextword, font);
            if (dim.getWidth() > wrapWidth) {
                height += dim.getHeight();
                dim = this.calculateTextSize(line, font);
                if (dim.getWidth() > width) {
                    width = dim.getWidth();
                }
                line = "";
            } else if (dim.getWidth() > width) {
                width = dim.getWidth();
            }
            ++i;
        }
        if (width == 0) {
            width = totalWidth;
        }
        return new int[]{height, width};
    }

    private IDimension calculateTextSize(String text, Font font) {
        IDimension dim = GraphitiUi.getUiLayoutService().calculateTextSize(text, font);
        if (text.endsWith("\n")) {
            dim.setHeight(2 * dim.getHeight());
        }
        return dim;
    }

    protected Rectangle getLabelBounds(PictogramElement pe, boolean isAddingLabel, Point offset) {
        PictogramElement ownerPE = FeatureSupport.getLabelOwner(pe);
        Shape labelShape = FeatureSupport.getLabelShape(pe);
        if (labelShape != null) {
            AbstractText labelGA = (AbstractText)labelShape.getGraphicsAlgorithm();
            BaseElement element = BusinessObjectUtil.getFirstElementOfType(ownerPE, BaseElement.class);
            String text = this.getLabelString(element);
            if (text == null) {
                text = "";
            }
            ILocation ownerLoc = ownerPE instanceof Connection ? Graphiti.getPeLayoutService().getConnectionMidpoint((Connection)ownerPE, 0.5) : Graphiti.getPeService().getLocationRelativeToDiagram((Shape)ownerPE);
            IDimension ownerSize = GraphicsUtil.calculateSize(ownerPE);
            ILocation labelLoc = Graphiti.getPeService().getLocationRelativeToDiagram(labelShape);
            int x = 0;
            int y = 0;
            int w = this.getLabelWidth(labelGA);
            int h = this.getLabelHeight(labelGA);
            int wrapWidth = this.getLabelWrapWidth(ownerPE);
            if (wrapWidth > 0 && w > wrapWidth) {
                int[] hw = this.wrapText(labelGA, text, wrapWidth);
                h = hw[0];
                w = hw[1];
            }
            ShapeStyle.LabelPosition hpos = this.getHorizontalLabelPosition(labelGA);
            ShapeStyle.LabelPosition vpos = this.getVerticalLabelPosition(labelGA);
            if (isAddingLabel) {
                Bounds bounds;
                BPMNLabel bpmnLabel = null;
                if (ownerPE instanceof Connection) {
                    BPMNEdge bpmnEdge = DIUtils.findBPMNEdge((EObject)element);
                    if (bpmnEdge != null) {
                        bpmnLabel = bpmnEdge.getLabel();
                    }
                } else {
                    BPMNShape bpmnShape = DIUtils.findBPMNShape(element);
                    if (bpmnShape != null) {
                        bpmnLabel = bpmnShape.getLabel();
                    }
                }
                Bounds bounds2 = bounds = bpmnLabel == null ? null : bpmnLabel.getBounds();
                if (bounds == null) {
                    isAddingLabel = false;
                    if (hpos == ShapeStyle.LabelPosition.MOVABLE) {
                        vpos = hpos = ShapeStyle.LabelPosition.SOUTH;
                    }
                } else {
                    int bw = (int)bounds.getWidth();
                    int bh = (int)bounds.getHeight();
                    if (bw < w || bh < h) {
                        isAddingLabel = false;
                    } else {
                        x = (int)bounds.getX();
                        y = (int)bounds.getY();
                        w = bw;
                        h = bh;
                    }
                }
            }
            if (!isAddingLabel && !text.isEmpty()) {
                switch (hpos) {
                    case SOUTH: 
                    case NORTH: 
                    case TOP: 
                    case CENTER: 
                    case BOTTOM: {
                        x = ownerLoc.getX() + (ownerSize.getWidth() - w) / 2;
                        break;
                    }
                    case WEST: {
                        x = ownerLoc.getX() - w - 6;
                        break;
                    }
                    case EAST: {
                        x = ownerLoc.getX() + ownerSize.getWidth() + 6;
                        break;
                    }
                    case LEFT: {
                        x = ownerLoc.getX() + 6;
                        break;
                    }
                    case RIGHT: {
                        x = ownerLoc.getX() + ownerSize.getWidth() - w - 6;
                        break;
                    }
                    case MOVABLE: {
                        x = labelLoc.getX();
                        y = labelLoc.getY();
                        if (offset == null) break;
                        x += offset.getX();
                        y += offset.getY();
                    }
                }
                switch (vpos) {
                    case NORTH: {
                        y = ownerLoc.getY() - h - 3;
                        break;
                    }
                    case SOUTH: {
                        y = ownerLoc.getY() + ownerSize.getHeight();
                        break;
                    }
                    case TOP: {
                        y = ownerLoc.getY() + 3;
                        break;
                    }
                    case CENTER: {
                        y = ownerLoc.getY() + (ownerSize.getHeight() - h) / 2;
                        break;
                    }
                    case BOTTOM: {
                        y = ownerLoc.getY() + ownerSize.getHeight() - h - 3;
                        break;
                    }
                    case WEST: 
                    case EAST: 
                    case LEFT: 
                    case RIGHT: {
                        y = ownerLoc.getY() + (ownerSize.getHeight() - h) / 2;
                        break;
                    }
                }
            }
            if (ownerPE instanceof Connection) {
                x -= ownerLoc.getX();
                y -= ownerLoc.getY();
            }
            return new Rectangle(x, y, w, h);
        }
        return null;
    }

    protected void adjustLabelLocation(PictogramElement pe, boolean isAddingLabel, Point offset) {
        PictogramElement ownerPE = FeatureSupport.getLabelOwner(pe);
        Shape labelShape = FeatureSupport.getLabelShape(pe);
        if (labelShape != null) {
            AbstractText labelGA = (AbstractText)labelShape.getGraphicsAlgorithm();
            BaseElement element = BusinessObjectUtil.getFirstElementOfType(pe, BaseElement.class);
            String text = this.getLabelString(element);
            if (text == null) {
                text = "";
            }
            if (!text.equals(labelGA.getValue())) {
                labelGA.setValue(text);
            }
            Rectangle bounds = this.getLabelBounds((PictogramElement)labelShape, isAddingLabel, offset);
            int x = bounds.x;
            int y = bounds.y;
            int w = bounds.width;
            int h = bounds.height;
            if (!(ownerPE instanceof Connection)) {
                ContainerShape container = this.getTargetContainer(ownerPE);
                if (labelShape.eContainer() != container) {
                    container.getChildren().add((Object)labelShape);
                }
            }
            GraphicsUtil.setLocationRelativeToDiagram((PictogramElement)labelShape, x, y);
            Graphiti.getGaService().setSize((GraphicsAlgorithm)labelGA, w, h);
            if (ownerPE instanceof Shape) {
                Graphiti.getPeService().sendToFront(labelShape);
            }
            ILocation absloc = Graphiti.getPeService().getLocationRelativeToDiagram(labelShape);
            DIUtils.updateDILabel(ownerPE, absloc.getX(), absloc.getY(), w, h);
            labelShape.setVisible(!text.isEmpty());
            Graphiti.getPeService().removeProperty((PropertyContainer)labelShape, "label.changed");
        }
    }

    protected ContainerShape getTargetContainer(PictogramElement ownerPE) {
        return (ContainerShape)ownerPE.eContainer();
    }

    protected int getLabelWidth(AbstractText text) {
        return this.getLabelSize((AbstractText)text).width;
    }

    protected int getLabelHeight(AbstractText text) {
        return this.getLabelSize((AbstractText)text).height;
    }

    protected Dimension getLabelSize(AbstractText text) {
        int width = 0;
        int height = 0;
        if (text.getValue() != null && !text.getValue().isEmpty()) {
            String[] strings;
            String[] stringArray = strings = text.getValue().split("\n");
            int n = strings.length;
            int n2 = 0;
            while (n2 < n) {
                String string = stringArray[n2];
                IDimension dim = GraphitiUi.getUiLayoutService().calculateTextSize(string, text.getFont());
                if (dim.getWidth() > width) {
                    width = dim.getWidth();
                }
                height += dim.getHeight();
                ++n2;
            }
        }
        return new Dimension(width, height);
    }

    protected ShapeStyle.LabelPosition getLabelPosition(AbstractText text) {
        PictogramElement pe = FeatureSupport.getLabelOwner((GraphicsAlgorithm)text);
        BaseElement element = BusinessObjectUtil.getFirstBaseElement(pe);
        ShapeStyle ss = ShapeStyle.getShapeStyle(element);
        return ss.getLabelPosition();
    }

    protected ShapeStyle.LabelPosition getHorizontalLabelPosition(AbstractText text) {
        return this.getLabelPosition(text);
    }

    protected ShapeStyle.LabelPosition getVerticalLabelPosition(AbstractText text) {
        return this.getLabelPosition(text);
    }
}

