/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.core.model;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Map;
import org.eclipse.bpmn2.modeler.core.Activator;
import org.eclipse.bpmn2.modeler.core.model.Bpmn2ModelerResourceFactoryImpl;
import org.eclipse.bpmn2.modeler.core.model.Messages;
import org.eclipse.bpmn2.modeler.core.preferences.Bpmn2Preferences;
import org.eclipse.bpmn2.modeler.core.runtime.TargetRuntime;
import org.eclipse.bpmn2.modeler.core.utils.ErrorDialog;
import org.eclipse.bpmn2.util.Bpmn2ResourceFactoryImpl;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.ResourceFactoryRegistryImpl;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IProgressService;
import org.eclipse.wst.wsdl.util.WSDLResourceFactoryRegistry;
import org.eclipse.xsd.util.XSDResourceFactoryImpl;

public class Bpmn2ModelerResourceSetImpl
extends ResourceSetImpl
implements IResourceChangeListener {
    public static final String BPMN2_CONTENT_TYPE = "org.eclipse.bpmn2.content-type.xml";
    public static final String OPTION_PROGRESS_MONITOR = "PROGRESS_MONITOR";
    private String connectionTimeout;
    private String readTimeout;
    public static final String SLIGHTLY_HACKED_KEY = "slightly.hacked.resource.set";

    public Bpmn2ModelerResourceSetImpl() {
        this.getLoadOptions().put("DISABLE_NOTIFY", true);
        this.getLoadOptions().put("DEFER_IDREF_RESOLUTION", true);
    }

    public EObject getEObject(URI uri, boolean loadOnDemand) {
        EObject o = null;
        if (uri != null) {
            String uriString = uri.toString();
            URI newUri = uriString == null ? uri : URI.createURI((String)uriString, (boolean)true);
            if (newUri.fragment() != null) {
                try {
                    try {
                        this.setDefaultTimeoutProperties();
                        o = super.getEObject(newUri, loadOnDemand);
                    }
                    catch (Exception e) {
                        Resource resource = this.getResource(uri.trimFragment(), loadOnDemand);
                        if (resource != null && resource.getContents().size() > 0) {
                            Activator.logError(e);
                        }
                        this.restoreTimeoutProperties();
                    }
                }
                finally {
                    this.restoreTimeoutProperties();
                }
            } else {
                newUri = newUri.appendFragment(uri.lastSegment());
                o = super.getEObject(newUri, loadOnDemand);
            }
        }
        return o;
    }

    private void saveTimeoutProperties() {
        if (this.connectionTimeout == null) {
            this.connectionTimeout = System.getProperty("sun.net.client.defaultConnectTimeout");
            if (this.connectionTimeout == null) {
                this.connectionTimeout = "";
            }
        }
        if (this.readTimeout == null) {
            this.readTimeout = System.getProperty("sun.net.client.defaultReadTimeout");
            if (this.readTimeout == null) {
                this.readTimeout = "";
            }
        }
    }

    private void restoreTimeoutProperties() {
        if (this.connectionTimeout != null) {
            System.setProperty("sun.net.client.defaultConnectTimeout", this.connectionTimeout);
            this.connectionTimeout = null;
        }
        if (this.readTimeout != null) {
            System.setProperty("sun.net.client.defaultReadTimeout", this.readTimeout);
            this.readTimeout = null;
        }
    }

    private void setDefaultTimeoutProperties() {
        this.saveTimeoutProperties();
        Resource resource = this.getResources().isEmpty() ? null : (Resource)this.getResources().get(0);
        Integer timeout = Bpmn2Preferences.getInstance(resource).getConnectionTimeout();
        System.setProperty("sun.net.client.defaultConnectTimeout", timeout.toString());
        System.setProperty("sun.net.client.defaultReadTimeout", timeout.toString());
    }

    public Resource getResource(URI uri, boolean loadOnDemand, String kind) {
        Resource resource;
        if (uri == null || uri.isEmpty()) {
            return null;
        }
        Map map = this.getURIResourceMap();
        if (map != null && (resource = (Resource)map.get(uri)) != null) {
            if (loadOnDemand && !resource.isLoaded()) {
                try {
                    this.demandLoadHelper(resource);
                }
                catch (Exception exception) {
                    resource.unload();
                }
            }
            return resource;
        }
        URIConverter theURIConverter = this.getURIConverter();
        URI normalizedURI = theURIConverter.normalize(uri);
        for (Resource resource2 : this.getResources()) {
            if (!theURIConverter.normalize(resource2.getURI()).equals(normalizedURI)) continue;
            if (loadOnDemand && !resource2.isLoaded()) {
                try {
                    this.demandLoadHelper(resource2);
                }
                catch (Exception exception) {
                    resource2.unload();
                    break;
                }
            }
            if (map != null) {
                map.put(uri, resource2);
            }
            return resource2;
        }
        if (loadOnDemand) {
            Resource resource2;
            resource2 = this.demandCreateResource(uri, kind);
            if (resource2 == null) {
                throw new RuntimeException("Cannot create a resource for '" + uri + "'; a registered resource factory is needed");
            }
            this.demandLoadHelper(resource2);
            if (map != null) {
                map.put(uri, resource2);
            }
            return resource2;
        }
        return null;
    }

    public Resource getResource(URI uri, boolean loadOnDemand) {
        Resource resource = super.getResource(uri, loadOnDemand);
        int index = this.resources.indexOf((Object)resource);
        if (index > 2 && !resource.isTrackingModification()) {
            resource.setTrackingModification(true);
        }
        return resource;
    }

    protected Resource demandCreateResource(URI uri, String kind) {
        return this.createResource(uri, kind);
    }

    public Resource.Factory.Registry getResourceFactoryRegistry() {
        if (this.resourceFactoryRegistry == null) {
            this.resourceFactoryRegistry = new ResourceFactoryRegistryImpl(){

                protected Resource.Factory delegatedGetFactory(URI uri, String contentTypeIdentifier) {
                    Map extensionToFactoryMap = Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap();
                    Object wsilFactory = extensionToFactoryMap.get("wsil");
                    Object wsdlFactory = extensionToFactoryMap.get("wsdl");
                    Object xsdFactory = extensionToFactoryMap.get("xsd");
                    Object bpmnFactory = extensionToFactoryMap.get("bpmn");
                    Map contentTypeToFactoryMap = Resource.Factory.Registry.INSTANCE.getContentTypeToFactoryMap();
                    if (wsilFactory != null) {
                        contentTypeToFactoryMap.put("wsil", wsilFactory);
                    }
                    if (wsdlFactory == null) {
                        wsdlFactory = WSDLResourceFactoryRegistry.INSTANCE.getExtensionToFactoryMap().get("wsdl");
                    }
                    contentTypeToFactoryMap.put("wsdl", wsdlFactory);
                    if (xsdFactory == null) {
                        xsdFactory = new XSDResourceFactoryImpl();
                    }
                    contentTypeToFactoryMap.put("xsd", xsdFactory);
                    if (bpmnFactory == null) {
                        bpmnFactory = new Bpmn2ResourceFactoryImpl();
                    }
                    contentTypeToFactoryMap.put("bpmn", bpmnFactory);
                    contentTypeToFactoryMap.put("bpmn2", bpmnFactory);
                    return 1.convert((Object)this.getFactory(uri, Resource.Factory.Registry.INSTANCE.getProtocolToFactoryMap(), extensionToFactoryMap, contentTypeToFactoryMap, contentTypeIdentifier, false));
                }

                protected URIConverter getURIConverter() {
                    return Bpmn2ModelerResourceSetImpl.this.getURIConverter();
                }

                protected Map<?, ?> getContentDescriptionOptions() {
                    return Bpmn2ModelerResourceSetImpl.this.getLoadOptions();
                }

                public Resource.Factory getFactory(URI uri, String contentType) {
                    Resource.Factory factory = 1.convert((Object)this.getFactory(uri, this.protocolToFactoryMap, this.extensionToFactoryMap, this.contentTypeIdentifierToFactoryMap, contentType, true));
                    if (factory instanceof Bpmn2ModelerResourceFactoryImpl && uri.isPlatformResource()) {
                        try {
                            String name = uri.segment(1);
                            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(name);
                            Bpmn2Preferences pref = Bpmn2Preferences.getInstance(project);
                            TargetRuntime rt = pref.getRuntime();
                            factory = rt.getModelDescriptor().getResourceFactory();
                        }
                        catch (Exception exception) {}
                    }
                    return factory;
                }
            };
        }
        return this.resourceFactoryRegistry;
    }

    protected void demandLoadHelper(final Resource resource) {
        try {
            this.setDefaultTimeoutProperties();
            Map options = resource.getResourceSet().getLoadOptions();
            Object o = options.get(OPTION_PROGRESS_MONITOR);
            if (o instanceof IProgressMonitor) {
                IProgressMonitor monitor = (IProgressMonitor)o;
                this.doLoad(resource, monitor);
            } else {
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            IProgressService ps = PlatformUI.getWorkbench().getProgressService();
                            ps.busyCursorWhile(new IRunnableWithProgress(){

                                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                                    Bpmn2ModelerResourceSetImpl.this.doLoad(resource, monitor);
                                }
                            });
                        }
                        catch (Exception exception) {}
                    }
                });
            }
        }
        finally {
            this.restoreTimeoutProperties();
        }
    }

    private void doLoad(Resource resource, IProgressMonitor monitor) {
        try {
            try {
                String taskName = NLS.bind((String)Messages.Bpmn2ModelerResourceSetImpl_Loading_Title, (Object)resource.getURI());
                monitor.beginTask(taskName, -1);
                resource.eSetDeliver(false);
                Bpmn2ModelerResourceSetImpl.super.demandLoadHelper(resource);
                if (!resource.isLoaded()) {
                    throw new Exception(Messages.Bpmn2ModelerResourceSetImpl_Loading_Resource_Not_Found);
                }
            }
            catch (Exception e) {
                Activator.logError(e);
                String msg = NLS.bind((String)Messages.Bpmn2ModelerResourceSetImpl_Loading_Error_Message, (Object)resource.getURI());
                ErrorDialog dlg = new ErrorDialog(Messages.Bpmn2ModelerResourceSetImpl_Loading_Error, msg, e);
                dlg.show();
                monitor.done();
            }
        }
        finally {
            monitor.done();
        }
    }

    public void resourceChanged(IResourceChangeEvent event) {
        IResourceDelta[] deltas = event.getDelta().getAffectedChildren(6, 1);
        this.processDeltas(deltas);
    }

    void processDeltas(IResourceDelta[] deltas) {
        IResourceDelta[] iResourceDeltaArray = deltas;
        int n = deltas.length;
        int n2 = 0;
        while (n2 < n) {
            IResourceDelta delta = iResourceDeltaArray[n2];
            this.processDeltas(delta.getAffectedChildren(6, 1));
            IResource resource = delta.getResource();
            if (resource.getType() == 1) {
                if (delta.getKind() == 2) {
                    this.resourceChanged((IFile)resource);
                } else if ((delta.getFlags() & 0x100) != 0 && !Bpmn2ModelerResourceSetImpl.isBPMN2File(resource)) {
                    this.resourceChanged((IFile)resource);
                }
            }
            ++n2;
        }
    }

    public void setLoadOptions(Map<Object, Object> options) {
        this.loadOptions = options;
    }

    public void resourceChanged(IFile file) {
        URI uri = URI.createPlatformResourceURI((String)file.getFullPath().toString());
        URIConverter theURIConverter = this.getURIConverter();
        URI normalizedURI = theURIConverter.normalize(uri);
        if (this.uriResourceMap != null) {
            this.uriResourceMap.remove(uri);
            this.uriResourceMap.remove(normalizedURI);
        }
        EList resourceList = this.getResources();
        if (this.resources.size() < 1) {
            return;
        }
        for (Resource r : new ArrayList(resourceList)) {
            if (!uri.equals(r.getURI()) && !normalizedURI.equals(r.getURI())) continue;
            this.resources.remove((Object)r);
        }
    }

    public static boolean isBPMN2File(IResource res) {
        try {
            IContentType type;
            IContentDescription desc;
            if (res.getType() == 1 && (desc = ((IFile)res).getContentDescription()) != null && (type = desc.getContentType()).getId().equals(BPMN2_CONTENT_TYPE)) {
                return true;
            }
        }
        catch (Exception exception) {}
        return false;
    }
}

