/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.core.preferences;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.bpmn2.Activity;
import org.eclipse.bpmn2.AdHocSubProcess;
import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.CallActivity;
import org.eclipse.bpmn2.CallChoreography;
import org.eclipse.bpmn2.CancelEventDefinition;
import org.eclipse.bpmn2.ChoreographyActivity;
import org.eclipse.bpmn2.Event;
import org.eclipse.bpmn2.EventDefinition;
import org.eclipse.bpmn2.ExclusiveGateway;
import org.eclipse.bpmn2.FlowElementsContainer;
import org.eclipse.bpmn2.Gateway;
import org.eclipse.bpmn2.InteractionNode;
import org.eclipse.bpmn2.ItemAwareElement;
import org.eclipse.bpmn2.Lane;
import org.eclipse.bpmn2.Message;
import org.eclipse.bpmn2.Participant;
import org.eclipse.bpmn2.SubChoreography;
import org.eclipse.bpmn2.SubProcess;
import org.eclipse.bpmn2.Task;
import org.eclipse.bpmn2.TerminateEventDefinition;
import org.eclipse.bpmn2.Transaction;
import org.eclipse.bpmn2.di.BPMNShape;
import org.eclipse.bpmn2.modeler.core.Activator;
import org.eclipse.bpmn2.modeler.core.adapters.ObjectPropertyProvider;
import org.eclipse.bpmn2.modeler.core.preferences.Messages;
import org.eclipse.bpmn2.modeler.core.preferences.ModelEnablements;
import org.eclipse.bpmn2.modeler.core.preferences.ShapeStyle;
import org.eclipse.bpmn2.modeler.core.runtime.ModelEnablementDescriptor;
import org.eclipse.bpmn2.modeler.core.runtime.TargetRuntime;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.views.navigator.ResourceNavigator;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class Bpmn2Preferences
implements IResourceChangeListener,
IPropertyChangeListener {
    public static final String PREF_TARGET_RUNTIME = "target.runtime";
    public static final String PREF_TARGET_RUNTIME_LABEL = Messages.Bpmn2Preferences_Target_Runtime;
    public static final String PREF_SHOW_ADVANCED_PROPERTIES = "show.advanced.properties";
    public static final String PREF_SHOW_ADVANCED_PROPERTIES_LABEL = Messages.Bpmn2Preferences_Show_Advanced_Properties;
    public static final String PREF_SHOW_DESCRIPTIONS = "show.descriptions";
    public static final String PREF_SHOW_DESCRIPTIONS_LABEL = Messages.Bpmn2Preferences_Show_Descriptions;
    public static final String PREF_TOOL_PALETTE = "tool.palette";
    public static final String PREF_TOOL_PROFILE = "tool.profile";
    public static final String PREF_MODEL_ENABLEMENT = "model.enablement";
    public static final String PREF_IS_HORIZONTAL = "is.horizontal";
    public static final String PREF_IS_HORIZONTAL_LABEL = Messages.Bpmn2Preferences_Horizontal;
    public static final String PREF_IS_EXPANDED = "is.expanded";
    public static final String PREF_IS_EXPANDED_LABEL = Messages.Bpmn2Preferences_Expand;
    public static final String PREF_IS_MESSAGE_VISIBLE = "is.message.visible";
    public static final String PREF_IS_MESSAGE_VISIBLE_LABEL = Messages.Bpmn2Preferences_Message_Visible;
    public static final String PREF_IS_MARKER_VISIBLE = "is.marker.visible";
    public static final String PREF_IS_MARKER_VISIBLE_LABEL = Messages.Bpmn2Preferences_Marker_Visible;
    public static final String PREF_SAVE_BPMNLABELS = "save.bpmnlabels";
    public static final String PREF_SAVE_BPMNLABELS_LABEL = Messages.Bpmn2Preferences_Save_BPMNLabels;
    public static final String PREF_SHAPE_STYLE = "shape.style";
    public static final String PREF_CONNECTION_TIMEOUT = "connection.timeout";
    public static final String PREF_CONNECTION_TIMEOUT_LABEL = Messages.Bpmn2Preferences_Timeout;
    public static final String PREF_USE_POPUP_DIALOG_FOR_LISTS = "popup.detail.dialog";
    public static final String PREF_USE_POPUP_DIALOG_FOR_LISTS_LABEL = Messages.Bpmn2Preferences_Use_Popup_Dialog_For_Lists;
    public static final String PREF_POPUP_CONFIG_DIALOG = "popup.config.dialog";
    public static final String PREF_POPUP_CONFIG_DIALOG_LABEL = Messages.Bpmn2Preferences_Config_Dialog;
    public static final String PREF_POPUP_CONFIG_DIALOG_FOR_ACTIVITIES = "popup.config.dialog.for.activities";
    public static final String PREF_POPUP_CONFIG_DIALOG_FOR_ACTIVITIES_LABEL = Messages.Bpmn2Preferences_Activities;
    public static final String PREF_POPUP_CONFIG_DIALOG_FOR_GATEWAYS = "popup.config.dialog.for.gateways";
    public static final String PREF_POPUP_CONFIG_DIALOG_FOR_GATEWAYS_LABEL = Messages.Bpmn2Preferences_Gateways;
    public static final String PREF_POPUP_CONFIG_DIALOG_FOR_EVENTS = "popup.config.dialog.for.events";
    public static final String PREF_POPUP_CONFIG_DIALOG_FOR_EVENTS_LABEL = Messages.Bpmn2Preferences_Events;
    public static final String PREF_POPUP_CONFIG_DIALOG_FOR_EVENT_DEFS = "popup.config.dialog.for.event.defs";
    public static final String PREF_POPUP_CONFIG_DIALOG_FOR_EVENT_DEFS_LABEL = Messages.Bpmn2Preferences_Event_Definitions;
    public static final String PREF_POPUP_CONFIG_DIALOG_FOR_DATA_DEFS = "popup.config.dialog.for.data.defs";
    public static final String PREF_POPUP_CONFIG_DIALOG_FOR_DATA_DEFS_LABEL = Messages.Bpmn2Preferences_Data_Items;
    public static final String PREF_POPUP_CONFIG_DIALOG_FOR_CONTAINERS = "popup.config.dialog.for.containers";
    public static final String PREF_POPUP_CONFIG_DIALOG_FOR_CONTAINERS_LABEL = Messages.Bpmn2Preferences_Containers;
    public static final String PREF_SHOW_ID_ATTRIBUTE = "show.id.attribute";
    public static final String PREF_SHOW_ID_ATTRIBUTE_LABEL = Messages.Bpmn2Preferences_Show_ID_Attribute;
    public static final String PREF_CHECK_PROJECT_NATURE = "check.project.nature";
    public static final String PREF_CHECK_PROJECT_NATURE_LABEL = Messages.Bpmn2Preferences_Check_Project_Nature;
    public static final String PREF_SIMPLIFY_LISTS = "simplify.lists";
    public static final String PREF_SIMPLIFY_LISTS_LABEL = Messages.Bpmn2Preferences_Simplify_Lists;
    public static final String PREF_DO_CORE_VALIDATION = "do.core.validation";
    public static final String PREF_DO_CORE_VALIDATION_LABEL = Messages.Bpmn2Preferences_Do_Core_Validation;
    public static final String PREF_PROPAGATE_GROUP_CATEGORIES = "propagate.group.categories";
    public static final String PREF_PROPAGATE_GROUP_CATEGORIES_LABEL = Messages.Bpmn2Preferences_Propagate_Group_Categories;
    public static final String PREF_ALLOW_MULTIPLE_CONNECTIONS = "allow.multiple.connections";
    public static final String PREF_ALLOW_MULTIPLE_CONNECTIONS_LABEL = Messages.Bpmn2Preferences_Allow_Mutliple_Connections;
    public static final String PREF_SERVICE_IMPLEMENTATIONS = "service.implementations";
    private static Hashtable<IProject, Bpmn2Preferences> projectPreferenceCacheMap = null;
    private static Bpmn2Preferences instancePreferenceCache = null;
    private static IProject activeProject;
    private static ListenerList preferenceChangeListeners;
    private static IPreferenceStore preferenceStore;
    private IProject project;
    private boolean useProjectPreferences;
    private IEclipsePreferences projectPreferences;
    private static IEclipsePreferences instancePreferences;
    private static IEclipsePreferences defaultPreferences;
    private boolean cached;
    private boolean dirty;
    private TargetRuntime targetRuntime;
    private boolean showAdvancedPropertiesTab;
    private boolean showDescriptions;
    private boolean showIdAttribute;
    private boolean checkProjectNature;
    private boolean simplifyLists;
    private boolean usePopupDialogForLists;
    private boolean doCoreValidation;
    private boolean propagateGroupCategories;
    private boolean allowMultipleConnections;
    private BPMNDIAttributeDefault isHorizontal;
    private BPMNDIAttributeDefault isExpanded;
    private BPMNDIAttributeDefault isMessageVisible;
    private BPMNDIAttributeDefault isMarkerVisible;
    private boolean saveBPMNLabels;
    private int connectionTimeout;
    private int popupConfigDialog;
    private boolean[] popupConfigDialogFor = new boolean[6];
    private HashMap<String, ShapeStyle> shapeStyles = new HashMap();
    static boolean enableConnectionRouting;

    static {
        enableConnectionRouting = true;
    }

    private Bpmn2Preferences(IProject project) {
        this.project = project;
        IPreferencesService preferenceService = Platform.getPreferencesService();
        if (preferenceStore == null) {
            preferenceStore = Activator.getDefault().getPreferenceStore();
        }
        if (instancePreferences == null) {
            instancePreferences = (IEclipsePreferences)preferenceService.getRootNode().node("instance").node("org.eclipse.bpmn2.modeler.core");
        }
        if (defaultPreferences == null) {
            defaultPreferences = (IEclipsePreferences)preferenceService.getRootNode().node("default").node("org.eclipse.bpmn2.modeler.core");
        }
        if (project != null) {
            this.projectPreferences = (IEclipsePreferences)preferenceService.getRootNode().node("project").node(project.getName()).node("org.eclipse.bpmn2.modeler.core");
            preferenceStore.addPropertyChangeListener((IPropertyChangeListener)this);
            try {
                this.projectPreferences.sync();
            }
            catch (Exception exception) {}
        }
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
        this.loadDefaults();
        this.cache();
    }

    public static Bpmn2Preferences getInstance() {
        return Bpmn2Preferences.getInstance(Bpmn2Preferences.getActiveProject());
    }

    public static Bpmn2Preferences getInstance(EObject object) {
        return Bpmn2Preferences.getInstance(ObjectPropertyProvider.getResource(object));
    }

    public static Bpmn2Preferences getInstance(Resource resource) {
        if (resource != null) {
            return Bpmn2Preferences.getInstance(resource.getURI());
        }
        return Bpmn2Preferences.getInstance();
    }

    public static Bpmn2Preferences getInstance(URI resourceURI) {
        String filename = resourceURI.trimFragment().toPlatformString(true);
        if (filename == null) {
            return Bpmn2Preferences.getInstance();
        }
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        if (root == null) {
            return Bpmn2Preferences.getInstance();
        }
        IResource res = ResourcesPlugin.getWorkspace().getRoot().findMember(filename);
        if (res == null) {
            return Bpmn2Preferences.getInstance();
        }
        IProject project = res.getProject();
        return Bpmn2Preferences.getInstance(project);
    }

    public static Bpmn2Preferences getInstance(IProject project) {
        Bpmn2Preferences pref = null;
        if (project == null) {
            if (instancePreferenceCache == null) {
                instancePreferenceCache = new Bpmn2Preferences(null);
            }
            pref = instancePreferenceCache;
        } else {
            if (projectPreferenceCacheMap == null) {
                projectPreferenceCacheMap = new Hashtable();
            }
            if ((pref = projectPreferenceCacheMap.get(project)) == null) {
                pref = new Bpmn2Preferences(project);
                pref.reload();
                projectPreferenceCacheMap.put(project, pref);
            }
        }
        return pref;
    }

    public static List<Bpmn2Preferences> getInstances(TargetRuntime rt) {
        Assert.isNotNull((Object)rt);
        String id = rt.getId();
        ArrayList<Bpmn2Preferences> prefs = new ArrayList<Bpmn2Preferences>();
        if (instancePreferenceCache != null && Bpmn2Preferences.instancePreferenceCache.targetRuntime.getId().equals(id)) {
            prefs.add(instancePreferenceCache);
        }
        if (projectPreferenceCacheMap != null) {
            for (Map.Entry<IProject, Bpmn2Preferences> entry : projectPreferenceCacheMap.entrySet()) {
                Bpmn2Preferences pref = entry.getValue();
                if (!pref.targetRuntime.getId().equals(id)) continue;
                prefs.add(pref);
            }
        }
        return prefs;
    }

    public void useProjectPreferences() {
        Assert.isNotNull((Object)this.projectPreferences);
        this.useProjectPreferences = true;
    }

    public void dispose() {
        if (this.project != null) {
            projectPreferenceCacheMap.remove(this.project);
        }
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        preferenceStore.removePropertyChangeListener((IPropertyChangeListener)this);
    }

    private void loadDefaults() {
        if (defaultPreferences.get(PREF_TARGET_RUNTIME, null) == null) {
            String rid = TargetRuntime.getFirstNonDefaultId();
            defaultPreferences.put(PREF_TARGET_RUNTIME, rid);
            defaultPreferences.putBoolean(PREF_SHOW_ADVANCED_PROPERTIES, false);
            defaultPreferences.putBoolean(PREF_CHECK_PROJECT_NATURE, true);
            defaultPreferences.putBoolean(PREF_SIMPLIFY_LISTS, true);
            defaultPreferences.putBoolean(PREF_USE_POPUP_DIALOG_FOR_LISTS, false);
            defaultPreferences.putBoolean(PREF_SHOW_DESCRIPTIONS, true);
            defaultPreferences.put(PREF_IS_HORIZONTAL, BPMNDIAttributeDefault.DEFAULT_TRUE.name());
            defaultPreferences.put(PREF_IS_EXPANDED, BPMNDIAttributeDefault.ALWAYS_TRUE.name());
            defaultPreferences.put(PREF_IS_MESSAGE_VISIBLE, BPMNDIAttributeDefault.ALWAYS_TRUE.name());
            defaultPreferences.put(PREF_IS_MARKER_VISIBLE, BPMNDIAttributeDefault.DEFAULT_TRUE.name());
            defaultPreferences.putBoolean(PREF_SAVE_BPMNLABELS, true);
            defaultPreferences.putInt(PREF_POPUP_CONFIG_DIALOG, 0);
            defaultPreferences.putBoolean(PREF_POPUP_CONFIG_DIALOG_FOR_ACTIVITIES, false);
            defaultPreferences.putBoolean(PREF_POPUP_CONFIG_DIALOG_FOR_GATEWAYS, false);
            defaultPreferences.putBoolean(PREF_POPUP_CONFIG_DIALOG_FOR_EVENTS, false);
            defaultPreferences.putBoolean(PREF_POPUP_CONFIG_DIALOG_FOR_EVENT_DEFS, false);
            defaultPreferences.putBoolean(PREF_POPUP_CONFIG_DIALOG_FOR_DATA_DEFS, false);
            defaultPreferences.putBoolean(PREF_POPUP_CONFIG_DIALOG_FOR_CONTAINERS, false);
            defaultPreferences.putBoolean(PREF_DO_CORE_VALIDATION, false);
            defaultPreferences.putBoolean(PREF_PROPAGATE_GROUP_CATEGORIES, true);
            defaultPreferences.putBoolean(PREF_ALLOW_MULTIPLE_CONNECTIONS, false);
            defaultPreferences.put(PREF_CONNECTION_TIMEOUT, "1000");
            this.loadDefaults(PREF_TOOL_PROFILE);
            this.loadDefaults(PREF_MODEL_ENABLEMENT);
            this.loadDefaults(PREF_SHAPE_STYLE);
        }
    }

    private void loadDefaults(String key) {
        block10: {
            block11: {
                block9: {
                    if (!key.equals(PREF_TOOL_PROFILE)) break block9;
                    for (TargetRuntime rt : TargetRuntime.createTargetRuntimes()) {
                        String defaultProfile = null;
                        for (ModelEnablementDescriptor med : rt.getModelEnablements()) {
                            String path = Bpmn2Preferences.getToolProfilePath(rt);
                            Preferences prefs = defaultPreferences.node(path);
                            if (defaultProfile == null) {
                                defaultProfile = med.getId();
                                prefs.putBoolean(defaultProfile, true);
                                continue;
                            }
                            prefs.putBoolean(med.getId(), false);
                        }
                    }
                    break block10;
                }
                if (!key.equals(PREF_MODEL_ENABLEMENT)) break block11;
                for (TargetRuntime rt : TargetRuntime.createTargetRuntimes()) {
                    for (ModelEnablementDescriptor med : rt.getModelEnablements()) {
                        String path = Bpmn2Preferences.getModelEnablementsPath(rt, med.getId());
                        Preferences prefs = defaultPreferences.node(path);
                        for (String s : med.getAllEnabled()) {
                            prefs.putBoolean(s, Boolean.TRUE.booleanValue());
                        }
                    }
                }
                break block10;
            }
            if (!key.equals(PREF_SHAPE_STYLE)) break block10;
            List<ShapeStyle> defaultShapeStyles = TargetRuntime.getDefaultRuntime().getShapeStyles();
            for (TargetRuntime rt : TargetRuntime.createTargetRuntimes()) {
                String value;
                String path = Bpmn2Preferences.getShapeStylePath(rt);
                Preferences prefs = defaultPreferences.node(path);
                for (ShapeStyle ss : rt.getShapeStyles()) {
                    value = ShapeStyle.encode(ss);
                    prefs.put(ss.getObject(), value);
                }
                if (rt == TargetRuntime.getDefaultRuntime()) continue;
                for (ShapeStyle ss : defaultShapeStyles) {
                    value = ShapeStyle.encode(ss);
                    prefs.put(ss.getObject(), value);
                }
            }
        }
    }

    private boolean shouldSaveToProjectPreference(String key) {
        if (this.projectPreferences != null) {
            if (this.useProjectPreferences) {
                this.projectPreferences.node(key);
                return true;
            }
            try {
                return this.projectPreferences.nodeExists(key);
            }
            catch (BackingStoreException e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    public void reload() {
        this.cached = false;
        this.cache();
    }

    private void cache() {
        if (!this.cached) {
            String id = this.get(PREF_TARGET_RUNTIME, TargetRuntime.getFirstNonDefaultId());
            if (id == null || id.isEmpty()) {
                id = TargetRuntime.getFirstNonDefaultId();
            }
            this.targetRuntime = TargetRuntime.getRuntime(id);
            this.showAdvancedPropertiesTab = this.getBoolean(PREF_SHOW_ADVANCED_PROPERTIES, false);
            this.showDescriptions = this.getBoolean(PREF_SHOW_DESCRIPTIONS, false);
            this.showIdAttribute = this.getBoolean(PREF_SHOW_ID_ATTRIBUTE, false);
            this.checkProjectNature = this.getBoolean(PREF_CHECK_PROJECT_NATURE, false);
            this.simplifyLists = this.getBoolean(PREF_SIMPLIFY_LISTS, true);
            this.usePopupDialogForLists = this.getBoolean(PREF_USE_POPUP_DIALOG_FOR_LISTS, false);
            this.isHorizontal = this.getBPMNDIAttributeDefault(PREF_IS_HORIZONTAL, BPMNDIAttributeDefault.USE_DI_VALUE);
            this.isExpanded = this.getBPMNDIAttributeDefault(PREF_IS_EXPANDED, BPMNDIAttributeDefault.USE_DI_VALUE);
            this.isMessageVisible = this.getBPMNDIAttributeDefault(PREF_IS_MESSAGE_VISIBLE, BPMNDIAttributeDefault.USE_DI_VALUE);
            this.isMarkerVisible = this.getBPMNDIAttributeDefault(PREF_IS_MARKER_VISIBLE, BPMNDIAttributeDefault.USE_DI_VALUE);
            this.saveBPMNLabels = this.getBoolean(PREF_SAVE_BPMNLABELS, true);
            this.connectionTimeout = this.getInt(PREF_CONNECTION_TIMEOUT, 60000);
            this.popupConfigDialog = this.getInt(PREF_POPUP_CONFIG_DIALOG, 0);
            this.popupConfigDialogFor[0] = this.getBoolean(PREF_POPUP_CONFIG_DIALOG_FOR_ACTIVITIES, false);
            this.popupConfigDialogFor[1] = this.getBoolean(PREF_POPUP_CONFIG_DIALOG_FOR_GATEWAYS, false);
            this.popupConfigDialogFor[2] = this.getBoolean(PREF_POPUP_CONFIG_DIALOG_FOR_EVENTS, false);
            this.popupConfigDialogFor[3] = this.getBoolean(PREF_POPUP_CONFIG_DIALOG_FOR_EVENT_DEFS, false);
            this.popupConfigDialogFor[4] = this.getBoolean(PREF_POPUP_CONFIG_DIALOG_FOR_DATA_DEFS, false);
            this.popupConfigDialogFor[5] = this.getBoolean(PREF_POPUP_CONFIG_DIALOG_FOR_CONTAINERS, false);
            this.doCoreValidation = this.getBoolean(PREF_DO_CORE_VALIDATION, false);
            this.propagateGroupCategories = this.getBoolean(PREF_PROPAGATE_GROUP_CATEGORIES, true);
            this.allowMultipleConnections = this.getBoolean(PREF_ALLOW_MULTIPLE_CONNECTIONS, false);
            this.cached = true;
        }
    }

    public synchronized void flush() throws BackingStoreException {
        if (this.dirty) {
            if (this.useProjectPreferences) {
                if (this.projectPreferences != null) {
                    this.projectPreferences.flush();
                }
            } else {
                this.put(PREF_TARGET_RUNTIME, this.getRuntime().getId());
                this.putBoolean(PREF_SHOW_ADVANCED_PROPERTIES, this.showAdvancedPropertiesTab);
                this.putBoolean(PREF_SHOW_DESCRIPTIONS, this.showDescriptions);
                this.putBoolean(PREF_SHOW_ID_ATTRIBUTE, this.showIdAttribute);
                this.putBoolean(PREF_CHECK_PROJECT_NATURE, this.checkProjectNature);
                this.putBoolean(PREF_SIMPLIFY_LISTS, this.simplifyLists);
                this.putBoolean(PREF_USE_POPUP_DIALOG_FOR_LISTS, this.usePopupDialogForLists);
                this.setBPMNDIAttributeDefault(PREF_IS_HORIZONTAL, this.isHorizontal);
                this.setBPMNDIAttributeDefault(PREF_IS_EXPANDED, this.isExpanded);
                this.setBPMNDIAttributeDefault(PREF_IS_MESSAGE_VISIBLE, this.isMessageVisible);
                this.setBPMNDIAttributeDefault(PREF_IS_MARKER_VISIBLE, this.isMarkerVisible);
                this.putBoolean(PREF_SAVE_BPMNLABELS, this.saveBPMNLabels);
                this.putInt(PREF_CONNECTION_TIMEOUT, this.connectionTimeout);
                this.putInt(PREF_POPUP_CONFIG_DIALOG, this.popupConfigDialog);
                this.putBoolean(PREF_POPUP_CONFIG_DIALOG_FOR_ACTIVITIES, this.popupConfigDialogFor[0]);
                this.putBoolean(PREF_POPUP_CONFIG_DIALOG_FOR_GATEWAYS, this.popupConfigDialogFor[1]);
                this.putBoolean(PREF_POPUP_CONFIG_DIALOG_FOR_EVENTS, this.popupConfigDialogFor[2]);
                this.putBoolean(PREF_POPUP_CONFIG_DIALOG_FOR_EVENT_DEFS, this.popupConfigDialogFor[3]);
                this.putBoolean(PREF_POPUP_CONFIG_DIALOG_FOR_DATA_DEFS, this.popupConfigDialogFor[4]);
                this.putBoolean(PREF_POPUP_CONFIG_DIALOG_FOR_CONTAINERS, this.popupConfigDialogFor[5]);
                this.putBoolean(PREF_DO_CORE_VALIDATION, this.doCoreValidation);
                this.putBoolean(PREF_PROPAGATE_GROUP_CATEGORIES, this.propagateGroupCategories);
                this.putBoolean(PREF_ALLOW_MULTIPLE_CONNECTIONS, this.allowMultipleConnections);
            }
        }
        HashMap<String, ShapeStyle> ssCache = new HashMap<String, ShapeStyle>();
        ssCache.putAll(this.shapeStyles);
        for (Map.Entry entry : ssCache.entrySet()) {
            ShapeStyle ss = (ShapeStyle)entry.getValue();
            if (!ss.isDirty()) continue;
            this.setShapeStyle((String)entry.getKey(), ss);
        }
        instancePreferences.flush();
        this.dirty = false;
    }

    public String getShapeStyleId(EObject object) {
        return Bpmn2Preferences.getShapeStyleId(this.getRuntime(), object);
    }

    public static String getShapeStyleId(TargetRuntime rt, EObject object) {
        try {
            Class<?> clazz = Class.forName(object.eClass().getInstanceClassName());
            return Bpmn2Preferences.getShapeStyleKey(rt, clazz);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return Bpmn2Preferences.getShapeStyleKey(rt, object.getClass());
        }
    }

    public static String getShapeStyleKey(TargetRuntime rt, Class clazz) {
        return Bpmn2Preferences.getShapeStyleKey(rt, clazz.getSimpleName());
    }

    public static String getShapeStyleKey(TargetRuntime rt, String name) {
        return String.valueOf(Bpmn2Preferences.getShapeStylePath(rt)) + "/" + name;
    }

    public static String getShapeStylePath(TargetRuntime rt) {
        return "shape.style/" + rt.getId();
    }

    public ShapeStyle getShapeStyle(EObject object) {
        try {
            Class<?> clazz = Class.forName(object.eClass().getInstanceClassName());
            return this.getShapeStyle(clazz);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return this.getShapeStyle(object.getClass());
        }
    }

    public ShapeStyle getShapeStyle(Class clazz) {
        return this.getShapeStyle(clazz.getSimpleName());
    }

    public ShapeStyle getShapeStyle(ShapeStyle.Category category) {
        return this.getShapeStyle(category.name());
    }

    public ShapeStyle getShapeStyle(String name) {
        ShapeStyle ss = this.shapeStyles.get(name);
        if (ss == null) {
            if (instancePreferenceCache != null) {
                if (Bpmn2Preferences.instancePreferenceCache.shapeStyles.containsKey(name)) {
                    ss = new ShapeStyle(Bpmn2Preferences.instancePreferenceCache.shapeStyles.get(name));
                } else {
                    String path = Bpmn2Preferences.getShapeStylePath(TargetRuntime.getDefaultRuntime());
                    Preferences prefs = instancePreferences.node(path);
                    String value = prefs.get(name, "");
                    if (!value.isEmpty()) {
                        ss = ShapeStyle.decode(value);
                        Bpmn2Preferences.instancePreferenceCache.shapeStyles.put(name, ss);
                    } else {
                        prefs = defaultPreferences.node(path);
                        value = prefs.get(name, "");
                        if (!value.isEmpty()) {
                            ss = ShapeStyle.decode(value);
                        }
                    }
                }
            }
            if (ss == null) {
                String key = Bpmn2Preferences.getShapeStyleKey(this.getRuntime(), name);
                String value = this.get(key, "");
                ss = value.isEmpty() ? new ShapeStyle() : ShapeStyle.decode(value);
            }
            ss.setObject(name);
            ss.setRuntime(this.targetRuntime);
            this.shapeStyles.put(name, ss);
        }
        return ss;
    }

    public void setShapeStyle(EObject object, ShapeStyle ss) {
        try {
            Class<?> clazz = Class.forName(object.eClass().getInstanceClassName());
            this.setShapeStyle(clazz, ss);
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.setShapeStyle(object.getClass(), ss);
        }
    }

    public void setShapeStyle(Class clazz, ShapeStyle style) {
        this.setShapeStyle(clazz.getSimpleName(), style);
    }

    public void setShapeStyle(String name, ShapeStyle style) {
        if (style.isDirty()) {
            this.shapeStyles.put(name, style);
            if (instancePreferenceCache != null) {
                Bpmn2Preferences.instancePreferenceCache.shapeStyles.put(name, style);
            }
            String key = Bpmn2Preferences.getShapeStyleKey(this.getRuntime(), name);
            String value = ShapeStyle.encode(style);
            this.put(key, value);
            style.setDirty(false);
        }
    }

    public static String getToolProfilePath(TargetRuntime rt) {
        return "tool.profile/" + rt.getId();
    }

    public String getDefaultToolProfile(TargetRuntime rt) {
        try {
            Preferences prefs = null;
            String path = Bpmn2Preferences.getToolProfilePath(rt);
            if (this.projectPreferences != null && this.projectPreferences.nodeExists(path)) {
                prefs = this.projectPreferences.node(path);
            } else if (instancePreferences.nodeExists(path)) {
                prefs = instancePreferences.node(path);
            } else if (defaultPreferences.nodeExists(path)) {
                prefs = defaultPreferences.node(path);
            }
            if (prefs != null) {
                String[] stringArray = prefs.keys();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String p = stringArray[n2];
                    if (prefs.getBoolean(p, false)) {
                        return p;
                    }
                    ++n2;
                }
            }
        }
        catch (BackingStoreException e) {
            e.printStackTrace();
        }
        return "";
    }

    public boolean setDefaultToolProfile(TargetRuntime rt, String profileId) {
        boolean result = false;
        if (profileId != null && !profileId.isEmpty()) {
            try {
                Preferences prefs = null;
                String path = Bpmn2Preferences.getToolProfilePath(rt);
                String[] keys = null;
                if (this.projectPreferences != null && this.useProjectPreferences) {
                    if (!this.projectPreferences.nodeExists(path)) {
                        keys = defaultPreferences.node(path).keys();
                    }
                    prefs = this.projectPreferences.node(path);
                } else {
                    if (!instancePreferences.nodeExists(path)) {
                        keys = defaultPreferences.node(path).keys();
                    }
                    prefs = instancePreferences.node(path);
                }
                if (keys == null) {
                    keys = prefs.keys();
                }
                String[] stringArray = keys;
                int n = keys.length;
                int n2 = 0;
                while (n2 < n) {
                    String p = stringArray[n2];
                    if (profileId.equals(p)) {
                        prefs.putBoolean(p, true);
                        result = true;
                    } else {
                        prefs.putBoolean(p, false);
                    }
                    ++n2;
                }
                this.firePreferenceEvent(prefs, path, null, profileId);
            }
            catch (BackingStoreException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public ModelEnablementDescriptor createToolProfile(TargetRuntime rt, String profileId, String profileName, String description) {
        ModelEnablementDescriptor med = null;
        boolean createNew = false;
        if (profileId != null && !profileId.isEmpty()) {
            try {
                Preferences prefs = null;
                String path = Bpmn2Preferences.getToolProfilePath(rt);
                String[] keys = null;
                boolean populate = false;
                if (this.projectPreferences != null && this.useProjectPreferences) {
                    if (!this.projectPreferences.nodeExists(path)) {
                        populate = true;
                        keys = defaultPreferences.node(path).keys();
                    }
                    prefs = this.projectPreferences.node(path);
                } else {
                    if (!instancePreferences.nodeExists(path)) {
                        keys = defaultPreferences.node(path).keys();
                        populate = true;
                    }
                    prefs = instancePreferences.node(path);
                }
                if (keys == null) {
                    keys = prefs.keys();
                }
                createNew = true;
                String[] stringArray = keys;
                int n = keys.length;
                int n2 = 0;
                while (n2 < n) {
                    String p = stringArray[n2];
                    if (profileId.equals(p) && rt.getModelEnablements(profileId) != null) {
                        createNew = false;
                    }
                    if (populate) {
                        prefs.putBoolean(p, false);
                    }
                    ++n2;
                }
                if (createNew) {
                    med = new ModelEnablementDescriptor(rt, profileId);
                    med.setProfileName(profileName);
                    med.setDescription(description);
                    rt.getModelEnablementDescriptors().add(med);
                    prefs.putBoolean(profileId, true);
                    this.firePreferenceEvent(prefs, path, null, profileId);
                }
            }
            catch (BackingStoreException e) {
                e.printStackTrace();
            }
        }
        return med;
    }

    public boolean deleteToolProfile(TargetRuntime rt, String profileId) {
        boolean result = false;
        if (profileId != null && !profileId.isEmpty()) {
            try {
                Preferences prefs = null;
                String path = Bpmn2Preferences.getToolProfilePath(rt);
                String[] keys = null;
                boolean populate = false;
                if (this.projectPreferences != null && this.useProjectPreferences) {
                    if (!this.projectPreferences.nodeExists(path)) {
                        keys = defaultPreferences.node(path).keys();
                        populate = true;
                    }
                    prefs = this.projectPreferences.node(path);
                } else {
                    if (!instancePreferences.nodeExists(path)) {
                        keys = defaultPreferences.node(path).keys();
                        populate = true;
                    }
                    prefs = instancePreferences.node(path);
                }
                if (keys == null) {
                    keys = prefs.keys();
                }
                String[] stringArray = keys;
                int n = keys.length;
                int n2 = 0;
                while (n2 < n) {
                    String p = stringArray[n2];
                    if (populate) {
                        prefs.putBoolean(p, false);
                    }
                    if (profileId.equals(p)) {
                        result = true;
                        prefs.remove(p);
                    }
                    ++n2;
                }
                if (result && prefs.keys().length > 0) {
                    prefs.putBoolean(prefs.keys()[0], true);
                    this.firePreferenceEvent(prefs, path, profileId, null);
                }
            }
            catch (BackingStoreException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public String[] getAllToolProfiles(TargetRuntime rt) {
        ArrayList<String> profiles = new ArrayList<String>();
        try {
            Preferences prefs = null;
            String path = Bpmn2Preferences.getToolProfilePath(rt);
            if (this.projectPreferences != null && this.projectPreferences.nodeExists(path)) {
                prefs = this.projectPreferences.node(path);
            } else if (instancePreferences.nodeExists(path)) {
                prefs = instancePreferences.node(path);
            } else if (defaultPreferences.nodeExists(path)) {
                prefs = defaultPreferences.node(path);
            }
            if (prefs != null) {
                String[] stringArray = prefs.keys();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String profileId = stringArray[n2];
                    profiles.add(profileId);
                    if (rt.getModelEnablements(profileId) == null) {
                        this.getModelEnablements(rt, profileId);
                    }
                    ++n2;
                }
                Collections.sort(profiles);
            }
        }
        catch (BackingStoreException e) {
            e.printStackTrace();
        }
        return profiles.toArray(new String[profiles.size()]);
    }

    public static String getModelEnablementsPath(TargetRuntime rt, String profileId) {
        return "model.enablement/" + rt.getId() + "/" + profileId;
    }

    public ModelEnablements getModelEnablements(String profileId) {
        return this.getModelEnablements(this.getRuntime(), profileId);
    }

    public ModelEnablements getModelEnablements(TargetRuntime rt, String profileId) {
        ModelEnablements me = new ModelEnablements(rt, profileId);
        if (profileId != null && !profileId.isEmpty()) {
            try {
                Preferences prefs = null;
                String path = Bpmn2Preferences.getModelEnablementsPath(rt, profileId);
                if (this.projectPreferences != null && this.projectPreferences.nodeExists(path)) {
                    prefs = this.projectPreferences.node(path);
                } else if (instancePreferences.nodeExists(path)) {
                    prefs = instancePreferences.node(path);
                } else if (defaultPreferences.nodeExists(path)) {
                    prefs = defaultPreferences.node(path);
                }
                if (prefs != null) {
                    boolean create = false;
                    ModelEnablementDescriptor med = rt.getModelEnablements(profileId);
                    if (med == null) {
                        String profileName = prefs.get("name", "Unnamed Profile");
                        String description = prefs.get("description", "");
                        med = this.createToolProfile(rt, profileId, profileName, description);
                        create = true;
                    }
                    me.setEnabledAll(false);
                    String[] stringArray = prefs.keys();
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String k = stringArray[n2];
                        if (prefs.getBoolean(k, false)) {
                            me.setEnabled(k, true);
                            if (create) {
                                med.setEnabled(k, true);
                            }
                        }
                        ++n2;
                    }
                }
            }
            catch (BackingStoreException e) {
                e.printStackTrace();
            }
        } else {
            me.setEnabledAll(true);
        }
        return me;
    }

    public boolean setModelEnablements(TargetRuntime rt, String profileId, ModelEnablements me) {
        if (me != null && me.size() > 0) {
            try {
                Preferences prefs = null;
                String path = Bpmn2Preferences.getModelEnablementsPath(rt, profileId);
                if (this.projectPreferences != null && this.useProjectPreferences) {
                    prefs = this.projectPreferences.node(path);
                    prefs.removeNode();
                    prefs = this.projectPreferences.node(path);
                } else {
                    prefs = instancePreferences.node(path);
                    prefs.removeNode();
                    prefs = instancePreferences.node(path);
                }
                ModelEnablementDescriptor med = rt.getModelEnablements(profileId);
                if (med != null) {
                    prefs.put("name", med.getProfileName());
                    prefs.put("description", med.getDescription());
                }
                for (String s : me.getAllEnabled()) {
                    prefs.putBoolean(s, true);
                }
                this.firePreferenceEvent(prefs, path, null, profileId);
                return true;
            }
            catch (BackingStoreException e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    public TargetRuntime getRuntime() {
        if (this.targetRuntime == null) {
            this.targetRuntime = TargetRuntime.getDefaultRuntime();
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    String id = Bpmn2Preferences.this.get(Bpmn2Preferences.PREF_TARGET_RUNTIME, TargetRuntime.getFirstNonDefaultId());
                    if (id == null || id.isEmpty()) {
                        id = TargetRuntime.getFirstNonDefaultId();
                    }
                    Bpmn2Preferences.this.targetRuntime = TargetRuntime.getDefaultRuntime();
                    MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)Messages.Bpmn2Preferences_No_Runtime_Plugin_Title, (String)NLS.bind((String)Messages.Bpmn2Preferences_No_Runtime_Plugin_Message, (Object)id, (Object)Bpmn2Preferences.this.targetRuntime.getDescription()));
                }
            });
        }
        return this.targetRuntime;
    }

    public void setRuntime(TargetRuntime rt) {
        Assert.isTrue((rt != null ? 1 : 0) != 0);
        this.put(PREF_TARGET_RUNTIME, rt.getId());
        this.targetRuntime = rt;
    }

    public boolean getShowAdvancedPropertiesTab() {
        return this.showAdvancedPropertiesTab;
    }

    public void setShowAdvancedPropertiesTab(boolean show) {
        this.putBoolean(PREF_SHOW_ADVANCED_PROPERTIES, show);
        this.showAdvancedPropertiesTab = show;
    }

    public boolean getShowDescriptions() {
        return this.showDescriptions;
    }

    public void setShowDescriptions(boolean show) {
        this.putBoolean(PREF_SHOW_DESCRIPTIONS, show);
        this.showDescriptions = show;
    }

    public boolean getShowIdAttribute() {
        return this.showIdAttribute;
    }

    public void setShowIdAttribute(boolean show) {
        this.putBoolean(PREF_SHOW_ID_ATTRIBUTE, show);
        this.showIdAttribute = show;
    }

    public boolean getCheckProjectNature() {
        return this.checkProjectNature;
    }

    public void setCheckProjectNature(boolean show) {
        this.putBoolean(PREF_CHECK_PROJECT_NATURE, show);
        this.checkProjectNature = show;
    }

    public boolean getSimplifyLists() {
        return this.simplifyLists;
    }

    public void setSimplifyLists(boolean simplify) {
        this.putBoolean(PREF_SIMPLIFY_LISTS, simplify);
        this.simplifyLists = simplify;
    }

    public boolean getUsePopupDialogForLists() {
        return this.usePopupDialogForLists;
    }

    public void setUsePopupDialogForLists(boolean enable) {
        this.putBoolean(PREF_USE_POPUP_DIALOG_FOR_LISTS, enable);
        this.usePopupDialogForLists = enable;
    }

    public boolean getShowPopupConfigDialog(Object context) {
        if (this.popupConfigDialog != 0) {
            if (context instanceof Task || context instanceof ChoreographyActivity) {
                return this.popupConfigDialogFor[0];
            }
            if (context instanceof Gateway) {
                return this.popupConfigDialogFor[1];
            }
            if (context instanceof Event) {
                return this.popupConfigDialogFor[2];
            }
            if (context instanceof EventDefinition) {
                if (context instanceof CancelEventDefinition || context instanceof TerminateEventDefinition) {
                    return false;
                }
                return this.popupConfigDialogFor[3];
            }
            if (context instanceof ItemAwareElement || context instanceof Message) {
                return this.popupConfigDialogFor[4];
            }
            if (context instanceof InteractionNode || context instanceof FlowElementsContainer) {
                return this.popupConfigDialogFor[5];
            }
        }
        return false;
    }

    public boolean hasPopupConfigDialog(Object context) {
        if (context instanceof Activity) {
            return true;
        }
        if (context instanceof Gateway) {
            return true;
        }
        if (context instanceof Event) {
            return true;
        }
        if (context instanceof EventDefinition) {
            return !(context instanceof CancelEventDefinition) && !(context instanceof TerminateEventDefinition);
        }
        if (context instanceof ItemAwareElement || context instanceof Message) {
            return true;
        }
        if (context instanceof InteractionNode || context instanceof FlowElementsContainer || context instanceof CallChoreography) {
            return true;
        }
        return true;
    }

    public void setShowPopupConfigDialog(Object context, boolean value) {
        this.putInt(PREF_POPUP_CONFIG_DIALOG, value ? 1 : 0);
        this.popupConfigDialog = value ? 1 : 0;
    }

    public boolean getDoCoreValidation() {
        return this.doCoreValidation;
    }

    public void setDoCoreValidation(boolean enable) {
        this.putBoolean(PREF_DO_CORE_VALIDATION, enable);
        this.doCoreValidation = enable;
    }

    public boolean getPropagateGroupCategories() {
        return this.propagateGroupCategories;
    }

    public void setPropagateGroupCategories(boolean enable) {
        this.putBoolean(PREF_PROPAGATE_GROUP_CATEGORIES, enable);
        this.propagateGroupCategories = enable;
    }

    public boolean getAllowMultipleConnections() {
        return this.allowMultipleConnections;
    }

    public void setAllowMultipleConnections(boolean enable) {
        this.putBoolean(PREF_ALLOW_MULTIPLE_CONNECTIONS, enable);
        this.allowMultipleConnections = enable;
    }

    public boolean isHorizontalDefault() {
        return this.isHorizontal == BPMNDIAttributeDefault.ALWAYS_TRUE || this.isHorizontal == BPMNDIAttributeDefault.DEFAULT_TRUE;
    }

    public BPMNDIAttributeDefault getIsHorizontal() {
        return this.isHorizontal;
    }

    public void setIsHorizontal(BPMNDIAttributeDefault value) {
        this.setBPMNDIAttributeDefault(PREF_IS_HORIZONTAL, value);
        this.isHorizontal = value;
    }

    public boolean isExpandedDefault() {
        return this.isExpanded == BPMNDIAttributeDefault.ALWAYS_TRUE || this.isExpanded == BPMNDIAttributeDefault.DEFAULT_TRUE;
    }

    public BPMNDIAttributeDefault getIsExpanded() {
        return this.isExpanded;
    }

    public void setIsExpanded(BPMNDIAttributeDefault value) {
        this.setBPMNDIAttributeDefault(PREF_IS_EXPANDED, value);
        this.isExpanded = value;
    }

    public BPMNDIAttributeDefault getIsMessageVisible() {
        return this.isMessageVisible;
    }

    public void setIsMessageVisible(BPMNDIAttributeDefault value) {
        this.setBPMNDIAttributeDefault(PREF_IS_MESSAGE_VISIBLE, value);
        this.isMessageVisible = value;
    }

    public BPMNDIAttributeDefault getIsMarkerVisible() {
        return this.isMarkerVisible;
    }

    public void setIsMarkerVisible(BPMNDIAttributeDefault value) {
        this.setBPMNDIAttributeDefault(PREF_IS_MARKER_VISIBLE, value);
        this.isMarkerVisible = value;
    }

    public boolean getSaveBPMNLabels() {
        return this.saveBPMNLabels;
    }

    public void setSaveBPMNLabels(boolean enable) {
        this.putBoolean(PREF_SAVE_BPMNLABELS, enable);
        this.saveBPMNLabels = enable;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(int value) {
        this.putInt(PREF_CONNECTION_TIMEOUT, value);
        this.connectionTimeout = value;
    }

    public boolean getEnableConnectionRouting() {
        return enableConnectionRouting;
    }

    public void setEnableConnectionRouting(boolean enable) {
        enableConnectionRouting = enable;
    }

    public static String[] getBPMNDIAttributeDefaultChoices() {
        BPMNDIAttributeDefault[] values = BPMNDIAttributeDefault.values();
        String[] choices = new String[values.length];
        int i = 0;
        BPMNDIAttributeDefault[] bPMNDIAttributeDefaultArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            BPMNDIAttributeDefault v = bPMNDIAttributeDefaultArray[n2];
            String text = Messages.Bpmn2Preferences_None;
            switch (v) {
                case USE_DI_VALUE: {
                    text = Messages.Bpmn2Preferences_False_if_not_set;
                    break;
                }
                case DEFAULT_TRUE: {
                    text = Messages.Bpmn2Preferences_True_if_not_set;
                    break;
                }
                case ALWAYS_TRUE: {
                    text = Messages.Bpmn2Preferences_Always_true;
                    break;
                }
                case ALWAYS_FALSE: {
                    text = Messages.Bpmn2Preferences_Always_False;
                }
            }
            choices[i++] = text;
            ++n2;
        }
        return choices;
    }

    public static String[][] getBPMNDIAttributeDefaultChoicesAndValues() {
        String[] choices = Bpmn2Preferences.getBPMNDIAttributeDefaultChoices();
        BPMNDIAttributeDefault[] values = BPMNDIAttributeDefault.values();
        String[][] choicesAndValues = new String[choices.length][2];
        int i = 0;
        BPMNDIAttributeDefault[] bPMNDIAttributeDefaultArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            BPMNDIAttributeDefault v = bPMNDIAttributeDefaultArray[n2];
            choicesAndValues[i][0] = choices[i];
            choicesAndValues[i][1] = v.name();
            ++i;
            ++n2;
        }
        return choicesAndValues;
    }

    public void applyBPMNDIDefaults(BPMNShape bpmnShape, Map<String, String> attribs) {
        BPMNDIAttributeDefault df;
        BPMNDIAttributeDefault df2;
        boolean isHorizontalSet = false;
        boolean isExpandedSet = false;
        boolean isMessageVisibleSet = false;
        boolean isMarkerVisibleSet = false;
        boolean choreographyActivityShapeSet = false;
        if (attribs != null) {
            for (Map.Entry<String, String> entry : attribs.entrySet()) {
                String name = entry.getKey();
                if ("isHorizontal".equals(name)) {
                    isHorizontalSet = true;
                }
                if ("isExpanded".equals(name)) {
                    isExpandedSet = true;
                }
                if ("isMessageVisible".equals(name)) {
                    isMessageVisibleSet = true;
                }
                if ("isMarkerVisible".equals(name)) {
                    isMarkerVisibleSet = true;
                }
                if (!"choreographyActivityShape".equals(name)) continue;
                choreographyActivityShapeSet = true;
            }
        }
        BaseElement be = bpmnShape.getBpmnElement();
        if (!isHorizontalSet) {
            if (be instanceof Participant && !choreographyActivityShapeSet || be instanceof Lane) {
                boolean horz = this.isHorizontalDefault();
                bpmnShape.setIsHorizontal(horz);
            }
        } else if (be instanceof Participant && !choreographyActivityShapeSet || be instanceof Lane) {
            df2 = this.getIsHorizontal();
            switch (df2) {
                case ALWAYS_TRUE: {
                    bpmnShape.setIsHorizontal(true);
                    break;
                }
                case ALWAYS_FALSE: {
                    bpmnShape.setIsHorizontal(false);
                }
            }
        }
        if (!isExpandedSet) {
            if (be instanceof SubProcess || be instanceof AdHocSubProcess || be instanceof Transaction || be instanceof SubChoreography || be instanceof CallActivity || be instanceof CallChoreography) {
                boolean value = false;
                df = this.getIsExpanded();
                switch (df) {
                    case DEFAULT_TRUE: 
                    case ALWAYS_TRUE: {
                        value = true;
                        break;
                    }
                    case USE_DI_VALUE: 
                    case ALWAYS_FALSE: {
                        value = false;
                    }
                }
                bpmnShape.setIsExpanded(value);
            }
        } else if (be instanceof SubProcess || be instanceof AdHocSubProcess || be instanceof Transaction || be instanceof SubChoreography || be instanceof CallActivity || be instanceof CallChoreography) {
            df2 = this.getIsExpanded();
            switch (df2) {
                case ALWAYS_TRUE: {
                    bpmnShape.setIsExpanded(true);
                    break;
                }
                case ALWAYS_FALSE: {
                    bpmnShape.setIsExpanded(false);
                }
            }
        }
        if (!isMessageVisibleSet) {
            if (be instanceof Participant && choreographyActivityShapeSet) {
                boolean value = false;
                df = this.getIsMessageVisible();
                switch (df) {
                    case DEFAULT_TRUE: 
                    case ALWAYS_TRUE: {
                        value = true;
                        break;
                    }
                    case USE_DI_VALUE: 
                    case ALWAYS_FALSE: {
                        value = false;
                    }
                }
                bpmnShape.setIsMessageVisible(value);
            }
        } else if (be instanceof Participant && choreographyActivityShapeSet) {
            BPMNDIAttributeDefault df3 = this.getIsMessageVisible();
            switch (df3) {
                case ALWAYS_TRUE: {
                    bpmnShape.setIsMessageVisible(true);
                    break;
                }
                case ALWAYS_FALSE: {
                    bpmnShape.setIsMessageVisible(false);
                }
            }
        }
        if (!isMarkerVisibleSet) {
            if (be instanceof ExclusiveGateway) {
                BPMNDIAttributeDefault df4 = this.getIsMarkerVisible();
                switch (df4) {
                    case DEFAULT_TRUE: 
                    case ALWAYS_TRUE: {
                        bpmnShape.setIsMarkerVisible(true);
                        break;
                    }
                    case USE_DI_VALUE: 
                    case ALWAYS_FALSE: {
                        bpmnShape.setIsMarkerVisible(false);
                    }
                    default: {
                        break;
                    }
                }
            }
        } else if (be instanceof ExclusiveGateway) {
            BPMNDIAttributeDefault df5 = this.getIsMarkerVisible();
            switch (df5) {
                case ALWAYS_TRUE: {
                    bpmnShape.setIsMarkerVisible(true);
                    break;
                }
                case ALWAYS_FALSE: {
                    bpmnShape.setIsMarkerVisible(false);
                }
            }
        }
    }

    public void setToDefault(String key) {
        try {
            if (key.startsWith(PREF_TOOL_PROFILE)) {
                Preferences prefs = instancePreferences.node(key);
                prefs.removeNode();
            } else if (key.startsWith(PREF_MODEL_ENABLEMENT)) {
                Preferences prefs = instancePreferences.node(key);
                prefs.removeNode();
            } else if (key.startsWith(PREF_SHAPE_STYLE)) {
                this.shapeStyles.clear();
                Preferences prefs = instancePreferences.node(key);
                instancePreferenceCache = null;
                prefs.removeNode();
            } else if (key.startsWith(PREF_TARGET_RUNTIME)) {
                if (this.shouldSaveToProjectPreference(PREF_TARGET_RUNTIME)) {
                    this.projectPreferences.put(PREF_TARGET_RUNTIME, "org.eclipse.bpmn2.modeler.runtime.none");
                }
            } else {
                if (this.projectPreferences != null) {
                    this.projectPreferences.remove(key);
                }
                instancePreferences.remove(key);
            }
        }
        catch (BackingStoreException e) {
            e.printStackTrace();
        }
    }

    public void resourceChanged(IResourceChangeEvent event) {
        int type = event.getType();
        if (type == 2) {
            try {
                this.flush();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.dispose();
        }
        if (type == 4) {
            this.dispose();
        }
    }

    public void addPreferenceChangeListener(IEclipsePreferences.IPreferenceChangeListener listener) {
        if (preferenceChangeListeners == null) {
            preferenceChangeListeners = new ListenerList();
        }
        preferenceChangeListeners.add((Object)listener);
    }

    public void removePreferenceChangeListener(IEclipsePreferences.IPreferenceChangeListener listener) {
        if (preferenceChangeListeners == null) {
            return;
        }
        preferenceChangeListeners.remove((Object)listener);
        if (preferenceChangeListeners.size() == 0) {
            preferenceChangeListeners = null;
        }
    }

    protected void firePreferenceEvent(Preferences node, String key, Object oldValue, Object newValue) {
        if (preferenceChangeListeners == null) {
            return;
        }
        if (oldValue == null ? newValue == null : oldValue.equals(newValue)) {
            return;
        }
        Object[] listeners = preferenceChangeListeners.getListeners();
        String absolutePath = String.valueOf(node.absolutePath()) + "/" + key;
        final IEclipsePreferences.PreferenceChangeEvent event = new IEclipsePreferences.PreferenceChangeEvent((Object)node, absolutePath, oldValue, newValue);
        int i = 0;
        while (i < listeners.length) {
            final IEclipsePreferences.IPreferenceChangeListener listener = (IEclipsePreferences.IPreferenceChangeListener)listeners[i];
            ISafeRunnable job = new ISafeRunnable(){

                public void handleException(Throwable exception) {
                }

                public void run() throws Exception {
                    listener.preferenceChange(event);
                }
            };
            SafeRunner.run((ISafeRunnable)job);
            ++i;
        }
    }

    public static IProject getActiveProject() {
        IWorkbenchPage page;
        if (activeProject != null) {
            return activeProject;
        }
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
        if (window != null && (page = window.getActivePage()) != null) {
            IViewPart[] parts = page.getViews();
            int i = 0;
            while (i < parts.length) {
                ResourceNavigator navigator;
                StructuredSelection sel;
                IResource resource;
                if (parts[i] instanceof ResourceNavigator && (resource = (IResource)(sel = (StructuredSelection)(navigator = (ResourceNavigator)parts[i]).getTreeViewer().getSelection()).getFirstElement()) != null) {
                    activeProject = resource.getProject();
                    break;
                }
                ++i;
            }
        }
        return activeProject;
    }

    public static void setActiveProject(IProject project) {
        activeProject = project;
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        PreferencesHelper helper = new PreferencesHelper(key, false);
        return helper.getBoolean(defaultValue);
    }

    public void putBoolean(String key, boolean value) {
        PreferencesHelper helper = new PreferencesHelper(key, true);
        helper.putBoolean(value);
    }

    public int getInt(String key, int defaultValue) {
        PreferencesHelper helper = new PreferencesHelper(key, false);
        return helper.getInt(defaultValue);
    }

    public void putInt(String key, int value) {
        PreferencesHelper helper = new PreferencesHelper(key, true);
        helper.putInt(value);
    }

    public String get(String key, String defaultValue) {
        PreferencesHelper helper = new PreferencesHelper(key, false);
        return helper.getString(defaultValue);
    }

    public void put(String key, String value) {
        PreferencesHelper helper = new PreferencesHelper(key, true);
        helper.put(value);
    }

    public Hashtable<String, String> getServiceImplementations() {
        String value = this.get(PREF_SERVICE_IMPLEMENTATIONS, "");
        Hashtable<String, String> impls = new Hashtable<String, String>();
        String[] stringArray = value.split("\t");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if (!s.isEmpty()) {
                String[] a = s.split(";");
                if (a.length > 1) {
                    impls.put(a[0], a[1]);
                } else {
                    impls.put(a[0], a[0]);
                }
            }
            ++n2;
        }
        return impls;
    }

    private void putServiceImplementations(Hashtable<String, String> impls) {
        String value = "";
        Iterator<Map.Entry<String, String>> iter = impls.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<String, String> entry = iter.next();
            if (entry.getKey().isEmpty()) continue;
            value = String.valueOf(value) + entry.getKey() + ";" + entry.getValue();
            if (!iter.hasNext()) continue;
            value = String.valueOf(value) + "\t";
        }
        this.put(PREF_SERVICE_IMPLEMENTATIONS, value);
    }

    public void addServiceImplementation(String name, String uri) {
        Hashtable<String, String> impls = this.getServiceImplementations();
        if (!impls.contains(name)) {
            impls.put(name, uri);
            this.putServiceImplementations(impls);
        }
    }

    public void removeServiceImplementation(String name) {
        Hashtable<String, String> impls = this.getServiceImplementations();
        if (impls.containsKey(name)) {
            impls.remove(name);
            this.putServiceImplementations(impls);
        }
    }

    public BPMNDIAttributeDefault getBPMNDIAttributeDefault(String key, BPMNDIAttributeDefault defaultValue) {
        PreferencesHelper helper = new PreferencesHelper(key, false);
        String str = helper.getString(defaultValue.name());
        return BPMNDIAttributeDefault.valueOf(str);
    }

    public void setBPMNDIAttributeDefault(String key, BPMNDIAttributeDefault value) {
        PreferencesHelper helper = new PreferencesHelper(key, true);
        helper.put(value.name());
    }

    public void propertyChange(PropertyChangeEvent event) {
        this.firePreferenceEvent((Preferences)instancePreferences, event.getProperty(), event.getOldValue(), event.getNewValue());
        if (projectPreferenceCacheMap != null) {
            for (Map.Entry<IProject, Bpmn2Preferences> entry : projectPreferenceCacheMap.entrySet()) {
                Bpmn2Preferences pref = entry.getValue();
                if (pref == this) continue;
                pref.firePreferenceEvent((Preferences)instancePreferences, event.getProperty(), event.getOldValue(), event.getNewValue());
            }
        }
    }

    public static enum BPMNDIAttributeDefault {
        USE_DI_VALUE,
        DEFAULT_TRUE,
        ALWAYS_TRUE,
        ALWAYS_FALSE;

    }

    private class PreferencesHelper {
        public IEclipsePreferences root;
        public Preferences node;
        public String key;
        public String path;
        private boolean set;

        public PreferencesHelper(String key, boolean set) {
            this.set = set;
            try {
                this.path = "";
                if (set) {
                    int i = key.lastIndexOf("/");
                    if (i > 0) {
                        this.path = key.substring(0, i);
                        this.key = key = key.substring(i + 1);
                        this.root = Bpmn2Preferences.this.shouldSaveToProjectPreference(key) ? Bpmn2Preferences.this.projectPreferences : instancePreferences;
                        this.node = this.root.node(this.path);
                    } else {
                        this.key = key;
                        if (Bpmn2Preferences.this.shouldSaveToProjectPreference(key)) {
                            this.root = Bpmn2Preferences.this.projectPreferences;
                            this.node = this.root;
                        } else {
                            this.root = instancePreferences;
                            this.node = this.root;
                        }
                    }
                } else {
                    int i = key.lastIndexOf("/");
                    if (i > 0) {
                        this.path = key.substring(0, i);
                        this.key = key = key.substring(i + 1);
                        if (Bpmn2Preferences.this.projectPreferences != null && Bpmn2Preferences.this.projectPreferences.nodeExists(this.path) && this.keyExists(Bpmn2Preferences.this.projectPreferences.node(this.path), key)) {
                            this.root = Bpmn2Preferences.this.projectPreferences;
                        } else if (instancePreferences.nodeExists(this.path) && this.keyExists(instancePreferences.node(this.path), key)) {
                            this.root = instancePreferences;
                        } else if (defaultPreferences.nodeExists(this.path) && this.keyExists(defaultPreferences.node(this.path), key)) {
                            this.root = defaultPreferences;
                        }
                        if (this.root != null) {
                            this.node = this.root.node(this.path);
                        }
                    } else {
                        this.key = key;
                        if (Bpmn2Preferences.this.projectPreferences != null && this.keyExists((Preferences)Bpmn2Preferences.this.projectPreferences, key)) {
                            this.root = Bpmn2Preferences.this.projectPreferences;
                            this.node = this.root;
                        } else if (this.keyExists((Preferences)instancePreferences, key)) {
                            this.root = instancePreferences;
                            this.node = this.root;
                        } else if (this.keyExists((Preferences)defaultPreferences, key)) {
                            this.root = defaultPreferences;
                            this.node = this.root;
                        }
                    }
                }
            }
            catch (BackingStoreException e) {
                e.printStackTrace();
            }
        }

        public Preferences unset() {
            this.node.remove(this.key);
            if (!this.path.isEmpty()) {
                this.node = this.root.node(String.valueOf(this.path) + "/" + this.key);
            }
            return this.node;
        }

        public String getString(String defaultValue) {
            Assert.isTrue((!this.set ? 1 : 0) != 0);
            if (this.node != null) {
                return this.node.get(this.key, defaultValue);
            }
            return defaultValue;
        }

        public void put(String value) {
            Assert.isTrue((this.set && this.node != null ? 1 : 0) != 0);
            String oldValue = this.node.get(this.key, null);
            this.node.put(this.key, value);
            Bpmn2Preferences.this.firePreferenceEvent(this.node, this.key, oldValue, value);
            Bpmn2Preferences.this.dirty = true;
        }

        public Boolean getBoolean(boolean defaultValue) {
            return Boolean.parseBoolean(this.getString("false"));
        }

        public void putBoolean(boolean value) {
            this.put(Boolean.toString(value));
        }

        public int getInt(int defaultValue) {
            return Integer.parseInt(this.getString("0"));
        }

        public void putInt(int value) {
            this.put(Integer.toString(value));
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private boolean keyExists(Preferences prefs, String key) {
            try {
                String[] stringArray = prefs.keys();
                int n = stringArray.length;
                int n2 = 0;
                while (true) {
                    if (n2 >= n) {
                        return false;
                    }
                    String k = stringArray[n2];
                    if (k.equals(key)) {
                        return true;
                    }
                    ++n2;
                }
            }
            catch (BackingStoreException e) {
                e.printStackTrace();
            }
            return false;
        }
    }
}

